/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.pldoc.ResourceLoader;

public class Settings {
    private static final String GET_METADATA_STATEMENT_DEFAULT = "BEGIN\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA. SESSION_TRANSFORM,'SQLTERMINATOR',true );\n  :1 := DBMS_METADATA.GET_DDL(\n       :2 ,\n       :3 ,\n       :4 ,\n       :5 ,\n       :6 ,\n       :7 )  \n;\nEND;";
    private static final String DRIVER_NAME_DEFAULT = "oracle.jdbc.OracleDriver";
    private String applicationName = "MyApplication";
    private File outputDirectory = new File("." + File.separator);
    private Collection inputFiles = new ArrayList();
    private String stylesheetfile = null;
    private File overviewfile = null;
    private Properties defines = null;
    private boolean ignoreInformalComments = false;
    private String defaultNamescase = "UPPER";
    private String defaultKeywordscase = "UPPER";
    private boolean namesDefaultcase = true;
    private boolean namesUppercase = false;
    private boolean namesLowercase = false;
    private boolean keywordsDefaultcase = true;
    private boolean keywordsUppercase = false;
    private boolean keywordsLowercase = false;
    private String inputEncoding = System.getProperty("file.encoding");
    private String outputEncoding = "UTF-8";
    private boolean exitOnError = false;
    private boolean verbose = false;
    private String driverName = "oracle.jdbc.OracleDriver";
    private String getMetadataStatement = "BEGIN\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA. SESSION_TRANSFORM,'SQLTERMINATOR',true );\n  :1 := DBMS_METADATA.GET_DDL(\n       :2 ,\n       :3 ,\n       :4 ,\n       :5 ,\n       :6 ,\n       :7 )  \n;\nEND;";
    private int returnType = 2005;
    private String dbUrl = null;
    private String dbUser = null;
    private String dbPassword = null;
    private Collection inputTypes = new ArrayList();
    private Collection inputObjects = new ArrayList();
    private boolean showSkippedPackages = false;
    private boolean plscope = false;
    private boolean saveSourceCode = false;
    private String sourcestylesheetfile = null;
    private static final String usage = "Arguments: [options] inputfile(s)\n-verbose                  Verbose - report each object processed \n-d <directory>            Destination directory for output files [default: current]\n-doctitle <text>          Application name [default: MyApplication]\n-overview <file>          Read overview documentation from HTML file [default: none]\n-defaultnamescase         Case of unquoted names [default upper] - {upper, lower, mixed}\n-defaultkeywordscase      Case of keywords [default upper] - {upper, lower}\n-namesdefaultcase         Convert all names to defaultcase [default true]\n-namesuppercase           Convert all names to uppercase\n-nameslowercase           Convert all names to lowercase\n-keywordsdefaultcase      Convert all names to defaultcase [default true]\n-keywordsuppercase        Convert all keywords to uppercase\n-keywordslowercase        Convert all keywords to lowercase\n-stylesheetfile <path>    File to change style of the generated document [default: defaultstylesheet.css]\n-definesfile <path>       File containing SQL*Plus-style variable substitutions [default: none], for example:\n                          &myvar1=123456\n                          &myvar2=abcdef\n-inputencoding <enc>      Encoding used in the input files [default: operation system default encoding]\n-exitonerror              Force program to exit when some input file cannot be processed\n                          [by default, the file is skipped and processing continues]\n-driver <JDBC class>      Name of JDBC driver class, for example oracle.jdbc.OracleDriver, com.edb.Driver, or org.postgresql.Driver [default: oracle.jdbc.OracleDriver].\n-getmetadata <String>     SQL 92 CallableStatement Statement that retrieves the object source (EnterpriseDB does not support Oracle BEGIN .. END statements) [default: Oracle DBMS_METADATA anonymous block ].\n                          \tStatement structure is (\"call\" and function are case sensitive} \"{ ? = call GET_SOURCE( ? ,  ? ,  ? ,  ? , ? , ? ) }\"  where GET_SOURCE(...) mimics \n                          \t\"{ <RESULT_SET> =  call DBMS_METADATA.GET_DDL( <object_type> ,  <object_name> ,  <schema_name> ,  'COMPATIBLE' , 'ORACLE' , 'DDL' ) }\" \n-returntype <java.sql.Types.?>  number corresponding to java.sql.Types.CLOB (2005) or java.sql.Types.VARCHAR (12) [default: java.sql.Types.CLOB].\n-url <database url>       Database URL, for example jdbc:oracle:thin:@HOST:PORT:SID, jdbc:oracle:thin:@HOST:PORT/SERVICE, jdbc:edb://HOST:PORT/DATABASE,\n                          or jdbc:postgresql://HOST:PORT/DATABASE [default: none].\n                          Required when generating from the Oracle dictionary.\n-user <db schema>         Schema name.\n                          Required when generating from the Oracle dictionary. The user name is\n                          case sensitive since Oracle stores user/schema names like \"My schema\" (name wit \n                          double quotes) as 'My schema' in the dictionary. Ordinary schema names\n                          like scott are stored as 'SCOTT' (upper case).\n-password <db password>   Password of the logon user.\n                          Required when generating from the Oracle dictionary.\n-types <object type(s)>   Comma separated list of object type(s) to generate documentation for.\n                          Defaults to all procedural types (PACKAGES, TYPES, FUNCTIONS PROCEDURES).\n-sql <object name(s)>     Comma separated list of object name(s) to generate documentation for.\n                          Required when generating from the Oracle dictionary.\n                          An object name is case sensitive (the same rules as described for schema\n                          names apply).\n                          An object name may be prepended by a schema name and may have SQL\n                          wildcards.\n                          When the object belongs to a different schema than the logon user (as specified by\n                          the -user parameter), the logon user must have been granted the SELECT_CATALOG_ROLE role or the SELECT ANY DICTIONARY system privilege.\n-ignoreinformalcomments   Ignore informal comments when generating documentation.\n-showSkippedPackages      Show the skipped packages in the summary of the documentation (generator.html)\n-plscope                  When extracting code from a database also extract PL/Scope call information and generate calling/called sections\n-saveSourceCode           Save/extract database source code whilst parsing it\n-sourceStylesheetfile <path>    File to change display style of the extracted source code [default: defaultstylesheet.css]\n";

    public void processCommandString(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println(usage);
            System.exit(0);
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        StringBuffer arguments = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                arguments.append(' ');
            }
            arguments.append(args[i]);
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(arguments.toString()));
        st.resetSyntax();
        st.whitespaceChars(9, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        while (st.nextToken() != -1) {
            switch (st.ttype) {
                case -3: 
                case 34: 
                case 39: {
                    argumentList.add(st.sval);
                }
            }
        }
        Iterator it = argumentList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equalsIgnoreCase("-doctitle")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.applicationName = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-d")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.outputDirectory = new File((String)it.next() + File.separator);
                if (!this.outputDirectory.isFile()) continue;
                this.processInvalidUsage("File name given instead of the output directory !");
                continue;
            }
            if (arg.equalsIgnoreCase("-overview")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.overviewfile = new File((String)it.next());
                if (this.overviewfile.exists()) continue;
                this.processInvalidUsage("The specified overview file " + this.overviewfile + " does not exist !");
                continue;
            }
            if (arg.equalsIgnoreCase("-stylesheetfile")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.stylesheetfile = (String)it.next();
                if (new File(this.stylesheetfile).exists()) continue;
                this.processInvalidUsage("The specified stylesheet file " + this.stylesheetfile + " does not exist !");
                continue;
            }
            if (arg.equalsIgnoreCase("-sourcestylesheetfile")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.sourcestylesheetfile = (String)it.next();
                if (new File(this.sourcestylesheetfile).exists()) continue;
                this.processInvalidUsage("The specified sourcestylesheet file " + this.sourcestylesheetfile + " does not exist !");
                continue;
            }
            if (arg.equalsIgnoreCase("-definesfile")) {
                File definesfile;
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                if (!(definesfile = new File((String)it.next())).exists()) {
                    this.processInvalidUsage("The specified defines file " + definesfile + " does not exist !");
                }
                this.defines = new Properties();
                this.defines.load(new FileInputStream(definesfile));
                continue;
            }
            if (arg.equalsIgnoreCase("-ignoreinformalcomments")) {
                this.ignoreInformalComments = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-namesdefaultcase")) {
                this.namesDefaultcase = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-namesuppercase")) {
                this.namesUppercase = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-nameslowercase")) {
                this.namesLowercase = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-defaultnamescase")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.defaultNamescase = (String)it.next();
                if (this.defaultNamescase.equalsIgnoreCase("upper") || this.defaultNamescase.equalsIgnoreCase("lower") || this.defaultNamescase.equalsIgnoreCase("mixed")) continue;
                this.processInvalidUsage("Option " + arg + " had incorrect value \"" + this.defaultNamescase + "\" - this option requires a value of \"upper\" or \"lower\" or \"mixed\" ");
                continue;
            }
            if (arg.equalsIgnoreCase("-defaultkeywordscase")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.defaultKeywordscase = (String)it.next();
                if (this.defaultKeywordscase.equalsIgnoreCase("upper") || this.defaultKeywordscase.equalsIgnoreCase("lower")) continue;
                this.processInvalidUsage("Option " + arg + " had incorrect value \"" + this.defaultKeywordscase + "\" - this option requires a value of \"upper\" or \"lower\" ");
                continue;
            }
            if (arg.equalsIgnoreCase("-keywordsdefaultcase")) {
                this.keywordsUppercase = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-keywordsuppercase")) {
                this.keywordsUppercase = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-keywordslowercase")) {
                this.keywordsLowercase = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-inputencoding")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.inputEncoding = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-exitonerror")) {
                this.exitOnError = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-returntype")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.returnType = Integer.parseInt((String)it.next());
                continue;
            }
            if (arg.equalsIgnoreCase("-driver")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.driverName = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-getmetadata")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.getMetadataStatement = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-url")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.dbUrl = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-user")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.dbUser = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-password")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.dbPassword = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-sql")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                String inputObjectsList = (String)it.next();
                this.inputObjects = Arrays.asList(inputObjectsList.split(","));
                continue;
            }
            if (arg.equalsIgnoreCase("-types")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                String inputTypesList = (String)it.next();
                this.inputTypes = Arrays.asList(inputTypesList.split(","));
                continue;
            }
            if (arg.equalsIgnoreCase("-showskippedpackages")) {
                this.showSkippedPackages = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-plscope")) {
                this.plscope = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-saveSourceCode")) {
                this.saveSourceCode = true;
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println("WARN - unknown parameter \"" + arg + "\"");
                this.processInvalidUsage("Unknown option " + arg);
                continue;
            }
            this.inputFiles.add(arg);
        }
        if (this.inputFiles.isEmpty() && this.inputObjects.isEmpty() || !this.inputFiles.isEmpty() && !this.inputObjects.isEmpty()) {
            this.processInvalidUsage("Either input file name(s) or object name(s) must be given!");
        }
        if (!(this.inputObjects.isEmpty() || this.dbUrl != null && this.dbUser != null && this.dbPassword != null)) {
            this.processInvalidUsage("Database url, db schema and db password are mandatory when object name(s) are supplied!");
        }
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setInputFiles(Collection inputFiles) {
        this.inputFiles = inputFiles;
    }

    public void setStylesheetfile(String stylesheetfile) {
        this.stylesheetfile = stylesheetfile;
    }

    public void setSourceStylesheetfile(String sourcestylesheetfile) {
        this.sourcestylesheetfile = sourcestylesheetfile;
    }

    public void setOverviewfile(File overviewfile) {
        this.overviewfile = overviewfile;
    }

    public void setDefines(Properties defines) {
        this.defines = defines;
    }

    public void setIgnoreInformalComments(boolean ignoreInformalComments) {
        this.ignoreInformalComments = ignoreInformalComments;
    }

    public void setNamesDefaultcase(boolean namesDefaultcase) {
        this.namesDefaultcase = namesDefaultcase;
    }

    public void setNamesUppercase(boolean namesUppercase) {
        this.namesUppercase = namesUppercase;
    }

    public void setNamesLowercase(boolean namesLowercase) {
        this.namesLowercase = namesLowercase;
    }

    public void setDefaultNamescase(String defaultNamescase) {
        this.defaultNamescase = defaultNamescase;
    }

    public void setDefaultKeywordscase(String defaultKeywordscase) {
        this.defaultKeywordscase = defaultKeywordscase;
    }

    public void setKeywordsDefaultcase(boolean keywordsDefaultcase) {
        this.keywordsDefaultcase = keywordsDefaultcase;
    }

    public void setKeywordsUppercase(boolean keywordsUppercase) {
        this.keywordsUppercase = keywordsUppercase;
    }

    public void setKeywordsLowercase(boolean keywordsLowercase) {
        this.keywordsLowercase = keywordsLowercase;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setGetMetadataStatement(String getMetadataStatement) {
        this.getMetadataStatement = getMetadataStatement;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setInputObjects(Collection inputObjects) {
        this.inputObjects = inputObjects;
    }

    public void setInputTypes(Collection inputTypes) {
        this.inputTypes = inputTypes;
    }

    public void setShowSkippedPackages(boolean showSkippedPackages) {
        this.showSkippedPackages = showSkippedPackages;
    }

    public void setPlscope(boolean plscope) {
        this.plscope = plscope;
    }

    public void setSaveSourceCode(boolean saveSourceCode) {
        this.saveSourceCode = saveSourceCode;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Collection getInputFiles() {
        return this.inputFiles;
    }

    public String getStylesheet() {
        return this.stylesheetfile;
    }

    public InputStream getStylesheetFile() throws IOException {
        if (this.stylesheetfile != null && this.stylesheetfile.length() > 0) {
            return new FileInputStream(this.stylesheetfile);
        }
        return new ResourceLoader().getResourceStream("defaultstylesheet.css");
    }

    public String getSourceStylesheet() {
        return this.sourcestylesheetfile;
    }

    public InputStream getSourceStylesheetFile() throws IOException {
        if (this.sourcestylesheetfile != null && this.sourcestylesheetfile.length() > 0) {
            return new FileInputStream(this.sourcestylesheetfile);
        }
        return new ResourceLoader().getResourceStream("defaultstylesheet.css");
    }

    public File getOverviewFile() {
        return this.overviewfile;
    }

    public Properties getDefines() {
        return this.defines;
    }

    public boolean isIgnoreInformalComments() {
        return this.ignoreInformalComments;
    }

    public boolean isNamesDefaultcase() {
        return this.namesDefaultcase;
    }

    public boolean isKeywordsDefaultcase() {
        return this.keywordsDefaultcase;
    }

    public boolean isNamesUppercase() {
        return this.namesUppercase;
    }

    public boolean isNamesLowercase() {
        return this.namesLowercase;
    }

    public String getDefaultNamescase() {
        return this.defaultNamescase;
    }

    public String getDefaultKeywordscase() {
        return this.defaultKeywordscase;
    }

    public boolean isKeywordsUppercase() {
        return this.keywordsUppercase;
    }

    public boolean isKeywordsLowercase() {
        return this.keywordsLowercase;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isExitOnError() {
        return this.exitOnError;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getGetMetadataStatement() {
        return this.getMetadataStatement;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public Collection getInputObjects() {
        return this.inputObjects;
    }

    public Collection getInputTypes() {
        return this.inputTypes;
    }

    public boolean isShowSkippedPackages() {
        return this.showSkippedPackages;
    }

    public boolean isPlscope() {
        return this.plscope;
    }

    public boolean isSaveSourceCode() {
        return this.saveSourceCode;
    }

    private void processInvalidUsage(String message) {
        System.out.println("Error: " + message);
        System.out.println(usage);
        System.exit(0);
    }
}

