/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.ConfigurationException;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.Launcher;
import org.codehaus.classworlds.NoSuchRealmException;

public class Configurator {
    public static final String MAIN_PREFIX = "main is";
    public static final String SET_PREFIX = "set";
    public static final String IMPORT_PREFIX = "import";
    public static final String LOAD_PREFIX = "load";
    public static final String OPTIONALLY_PREFIX = "optionally";
    private Launcher launcher;
    private ClassWorld world;
    private Map configuredRealms;

    public Configurator(Launcher launcher) {
        this.launcher = launcher;
        this.configuredRealms = new HashMap();
    }

    public Configurator(ClassWorld world) {
        this.setClassWorld(world);
    }

    public void setClassWorld(ClassWorld world) {
        this.world = world;
        this.configuredRealms = new HashMap();
    }

    public void configure(InputStream is) throws IOException, MalformedURLException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        if (this.world == null) {
            this.world = new ClassWorld();
        }
        ClassLoader foreignClassLoader = null;
        if (this.launcher != null) {
            foreignClassLoader = this.launcher.getSystemClassLoader();
        }
        ClassRealm curRealm = null;
        String line = null;
        int lineNo = 0;
        boolean mainSet = false;
        while ((line = reader.readLine()) != null) {
            ++lineNo;
            if (this.canIgnore(line = line.trim())) continue;
            if (line.startsWith(MAIN_PREFIX)) {
                if (mainSet) {
                    throw new ConfigurationException("Duplicate main configuration", lineNo, line);
                }
                String conf = line.substring(MAIN_PREFIX.length()).trim();
                int fromLoc = conf.indexOf("from");
                if (fromLoc < 0) {
                    throw new ConfigurationException("Missing from clause", lineNo, line);
                }
                String mainClassName = conf.substring(0, fromLoc).trim();
                String mainRealmName = conf.substring(fromLoc + 4).trim();
                if (this.launcher != null) {
                    this.launcher.setAppMain(mainClassName, mainRealmName);
                }
                mainSet = true;
                continue;
            }
            if (line.startsWith(SET_PREFIX)) {
                File propertiesFile;
                String value;
                String conf = line.substring(SET_PREFIX.length()).trim();
                int usingLoc = conf.indexOf(" using") + 1;
                String property2 = null;
                String propertiesFileName = null;
                if (usingLoc > 0) {
                    property2 = conf.substring(0, usingLoc).trim();
                    conf = propertiesFileName = this.filter(conf.substring(usingLoc + 5).trim());
                }
                String defaultValue = null;
                int defaultLoc = conf.indexOf(" default") + 1;
                if (defaultLoc > 0) {
                    defaultValue = conf.substring(defaultLoc + 7).trim();
                    if (property2 == null) {
                        property2 = conf.substring(0, defaultLoc).trim();
                    } else {
                        propertiesFileName = conf.substring(0, defaultLoc).trim();
                    }
                }
                if ((value = System.getProperty(property2)) != null) continue;
                if (propertiesFileName != null && (propertiesFile = new File(propertiesFileName)).exists()) {
                    Properties properties = new Properties();
                    try {
                        properties.load(new FileInputStream(propertiesFileName));
                        value = properties.getProperty(property2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (value == null && defaultValue != null) {
                    value = defaultValue;
                }
                if (value == null) continue;
                value = this.filter(value);
                System.setProperty(property2, value);
                continue;
            }
            if (line.startsWith("[")) {
                int rbrack = line.indexOf("]");
                if (rbrack < 0) {
                    throw new ConfigurationException("Invalid realm specifier", lineNo, line);
                }
                String realmName = line.substring(1, rbrack);
                curRealm = this.world.newRealm(realmName, foreignClassLoader);
                this.configuredRealms.put(realmName, curRealm);
                continue;
            }
            if (line.startsWith(IMPORT_PREFIX)) {
                if (curRealm == null) {
                    throw new ConfigurationException("Unhandled import", lineNo, line);
                }
                String conf = line.substring(IMPORT_PREFIX.length()).trim();
                int fromLoc = conf.indexOf("from");
                if (fromLoc < 0) {
                    throw new ConfigurationException("Missing from clause", lineNo, line);
                }
                String importSpec = conf.substring(0, fromLoc).trim();
                String relamName = conf.substring(fromLoc + 4).trim();
                curRealm.importFrom(relamName, importSpec);
                continue;
            }
            if (line.startsWith(LOAD_PREFIX)) {
                String constituent = line.substring(LOAD_PREFIX.length()).trim();
                if ((constituent = this.filter(constituent)).indexOf("*") >= 0) {
                    this.loadGlob(constituent, curRealm);
                    continue;
                }
                File file = new File(constituent);
                if (file.exists()) {
                    curRealm.addConstituent(file.toURL());
                    continue;
                }
                try {
                    curRealm.addConstituent(new URL(constituent));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new FileNotFoundException(constituent);
                }
            }
            if (line.startsWith(OPTIONALLY_PREFIX)) {
                String constituent = line.substring(OPTIONALLY_PREFIX.length()).trim();
                if ((constituent = this.filter(constituent)).indexOf("*") >= 0) {
                    this.loadGlob(constituent, curRealm, true);
                    continue;
                }
                File file = new File(constituent);
                if (file.exists()) {
                    curRealm.addConstituent(file.toURL());
                    continue;
                }
                try {
                    curRealm.addConstituent(new URL(constituent));
                }
                catch (MalformedURLException e) {}
                continue;
            }
            throw new ConfigurationException("Unhandled configuration", lineNo, line);
        }
        this.associateRealms();
        if (this.launcher != null) {
            this.launcher.setWorld(this.world);
        }
        reader.close();
    }

    protected void associateRealms() {
        ArrayList sortRealmNames = new ArrayList(this.configuredRealms.keySet());
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String g1 = (String)o1;
                String g2 = (String)o2;
                return g1.compareTo(g2);
            }
        };
        Collections.sort(sortRealmNames, comparator);
        Iterator i = sortRealmNames.iterator();
        while (i.hasNext()) {
            String parentRealmName;
            ClassRealm parentRealm;
            String realmName = (String)i.next();
            int j = realmName.lastIndexOf(46);
            if (j <= 0 || (parentRealm = (ClassRealm)this.configuredRealms.get(parentRealmName = realmName.substring(0, j))) == null) continue;
            ClassRealm realm = (ClassRealm)this.configuredRealms.get(realmName);
            realm.setParent(parentRealm);
        }
    }

    protected void loadGlob(String line, ClassRealm realm) throws MalformedURLException, FileNotFoundException {
        this.loadGlob(line, realm, false);
    }

    protected void loadGlob(String line, ClassRealm realm, boolean optionally) throws MalformedURLException, FileNotFoundException {
        File globFile = new File(line);
        File dir = globFile.getParentFile();
        if (!dir.exists()) {
            if (optionally) {
                return;
            }
            throw new FileNotFoundException(dir.toString());
        }
        String localName = globFile.getName();
        int starLoc = localName.indexOf("*");
        final String prefix = localName.substring(0, starLoc);
        final String suffix = localName.substring(starLoc + 1);
        File[] matches = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.startsWith(prefix)) {
                    return false;
                }
                return name.endsWith(suffix);
            }
        });
        for (int i = 0; i < matches.length; ++i) {
            realm.addConstituent(matches[i].toURL());
        }
    }

    protected String filter(String text) throws ConfigurationException {
        String result = "";
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        while (cur < textLen && (propStart = text.indexOf("${", cur)) >= 0) {
            result = result + text.substring(cur, propStart);
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            propValue = System.getProperty(propName);
            if (propValue == null) {
                throw new ConfigurationException("No such property: " + propName);
            }
            result = result + propValue;
            cur = propStop + 1;
        }
        result = result + text.substring(cur);
        return result;
    }

    private boolean canIgnore(String line) {
        return line.length() == 0 || line.startsWith("#");
    }
}

