/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public abstract class BuildFileTest
extends TestCase {
    protected Project project;
    private StringBuffer logBuffer;
    private StringBuffer fullLogBuffer;
    private StringBuffer outBuffer;
    private StringBuffer errBuffer;
    private BuildException buildException;

    public BuildFileTest() {
    }

    public BuildFileTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        if (this.project == null) {
            return;
        }
        String tearDown = "tearDown";
        if (this.project.getTargets().containsKey("tearDown")) {
            this.project.executeTarget("tearDown");
        }
    }

    public void expectBuildException(String target, String cause) {
        this.expectSpecificBuildException(target, cause, null);
    }

    public void expectLog(String target, String log) {
        this.executeTarget(target);
        String realLog = this.getLog();
        BuildFileTest.assertEquals(log, realLog);
    }

    public void assertLogContaining(String substring) {
        String realLog = this.getLog();
        BuildFileTest.assertTrue("expecting log to contain \"" + substring + "\" log was \"" + realLog + "\"", realLog.indexOf(substring) >= 0);
    }

    public void assertOutputContaining(String substring) {
        String realOutput = this.getOutput();
        BuildFileTest.assertTrue("expecting output to contain \"" + substring + "\" output was \"" + realOutput + "\"", realOutput.indexOf(substring) >= 0);
    }

    public void expectLogContaining(String target, String log) {
        this.executeTarget(target);
        this.assertLogContaining(log);
    }

    public String getLog() {
        return this.logBuffer.toString();
    }

    public void expectDebuglog(String target, String log) {
        this.executeTarget(target);
        String realLog = this.getFullLog();
        BuildFileTest.assertEquals(log, realLog);
    }

    public void assertDebuglogContaining(String substring) {
        String realLog = this.getFullLog();
        BuildFileTest.assertTrue("expecting debug log to contain \"" + substring + "\" log was \"" + realLog + "\"", realLog.indexOf(substring) >= 0);
    }

    public String getFullLog() {
        return this.fullLogBuffer.toString();
    }

    public void expectOutput(String target, String output) {
        this.executeTarget(target);
        String realOutput = this.getOutput();
        BuildFileTest.assertEquals(output, realOutput.trim());
    }

    public void expectOutputAndError(String target, String output, String error) {
        this.executeTarget(target);
        String realOutput = this.getOutput();
        BuildFileTest.assertEquals(output, realOutput);
        String realError = this.getError();
        BuildFileTest.assertEquals(error, realError);
    }

    public String getOutput() {
        return this.cleanBuffer(this.outBuffer);
    }

    public String getError() {
        return this.cleanBuffer(this.errBuffer);
    }

    public BuildException getBuildException() {
        return this.buildException;
    }

    private String cleanBuffer(StringBuffer buffer) {
        StringBuffer cleanedBuffer = new StringBuffer();
        boolean cr = false;
        for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            if (ch == '\r') {
                cr = true;
                continue;
            }
            if (!cr) {
                cleanedBuffer.append(ch);
                continue;
            }
            cleanedBuffer.append(ch);
        }
        return cleanedBuffer.toString();
    }

    public void configureProject(String filename) throws BuildException {
        this.configureProject(filename, 4);
    }

    public void configureProject(String filename, int logLevel) throws BuildException {
        this.logBuffer = new StringBuffer();
        this.fullLogBuffer = new StringBuffer();
        this.project = new Project();
        this.project.init();
        File antFile = new File(System.getProperty("root"), filename);
        this.project.setUserProperty("ant.file", antFile.getAbsolutePath());
        this.project.addBuildListener(new AntTestListener(logLevel));
        ProjectHelper.configureProject(this.project, antFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTarget(String targetName) {
        PrintStream sysOut = System.out;
        PrintStream sysErr = System.err;
        try {
            sysOut.flush();
            sysErr.flush();
            this.outBuffer = new StringBuffer();
            PrintStream out = new PrintStream(new AntOutputStream(this.outBuffer));
            System.setOut(out);
            this.errBuffer = new StringBuffer();
            PrintStream err = new PrintStream(new AntOutputStream(this.errBuffer));
            System.setErr(err);
            this.logBuffer = new StringBuffer();
            this.fullLogBuffer = new StringBuffer();
            this.buildException = null;
            this.project.executeTarget(targetName);
        }
        finally {
            System.setOut(sysOut);
            System.setErr(sysErr);
        }
    }

    public Project getProject() {
        return this.project;
    }

    public File getProjectDir() {
        return this.project.getBaseDir();
    }

    public void expectSpecificBuildException(String target, String cause, String msg) {
        try {
            this.executeTarget(target);
        }
        catch (BuildException ex) {
            this.buildException = ex;
            if (null != msg && !ex.getMessage().equals(msg)) {
                BuildFileTest.fail("Should throw BuildException because '" + cause + "' with message '" + msg + "' (actual message '" + ex.getMessage() + "' instead)");
            }
            return;
        }
        BuildFileTest.fail("Should throw BuildException because: " + cause);
    }

    public void expectBuildExceptionContaining(String target, String cause, String contains) {
        try {
            this.executeTarget(target);
        }
        catch (BuildException ex) {
            this.buildException = ex;
            if (null != contains && ex.getMessage().indexOf(contains) == -1) {
                BuildFileTest.fail("Should throw BuildException because '" + cause + "' with message containing '" + contains + "' (actual message '" + ex.getMessage() + "' instead)");
            }
            return;
        }
        BuildFileTest.fail("Should throw BuildException because: " + cause);
    }

    public void expectPropertySet(String target, String property2, String value) {
        this.executeTarget(target);
        this.assertPropertyEquals(property2, value);
    }

    public void assertPropertyEquals(String property2, String value) {
        String result = this.project.getProperty(property2);
        BuildFileTest.assertEquals("property " + property2, value, result);
    }

    public void assertPropertySet(String property2) {
        this.assertPropertyEquals(property2, "true");
    }

    public void assertPropertyUnset(String property2) {
        this.assertPropertyEquals(property2, null);
    }

    public void expectPropertySet(String target, String property2) {
        this.expectPropertySet(target, property2, "true");
    }

    public void expectPropertyUnset(String target, String property2) {
        this.expectPropertySet(target, property2, null);
    }

    public URL getResource(String resource) {
        URL url = this.getClass().getResource(resource);
        BuildFileTest.assertNotNull("Could not find resource :" + resource, url);
        return url;
    }

    private class AntTestListener
    implements BuildListener {
        private int logLevel;

        public AntTestListener(int logLevel) {
            this.logLevel = logLevel;
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() > this.logLevel) {
                return;
            }
            if (event.getPriority() == 2 || event.getPriority() == 1 || event.getPriority() == 0) {
                BuildFileTest.this.logBuffer.append(event.getMessage());
            }
            BuildFileTest.this.fullLogBuffer.append(event.getMessage());
        }
    }

    private static class AntOutputStream
    extends OutputStream {
        private StringBuffer buffer;

        public AntOutputStream(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public void write(int b) {
            this.buffer.append((char)b);
        }
    }
}

