/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.util.StringUtils;

public class SystemPropertyProfileActivator
extends DetectedProfileActivator {
    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && profile.getActivation().getProperty() != null;
    }

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        ActivationProperty property2 = activation.getProperty();
        if (property2 != null) {
            String name = property2.getName();
            boolean reverseName = false;
            if (name.startsWith("!")) {
                reverseName = true;
                name = name.substring(1);
            }
            String sysValue = System.getProperty(name);
            String propValue = property2.getValue();
            if (StringUtils.isNotEmpty(propValue)) {
                boolean reverseValue = false;
                if (propValue.startsWith("!")) {
                    reverseValue = true;
                    propValue = propValue.substring(1);
                }
                boolean result = propValue.equals(sysValue);
                if (reverseValue) {
                    return !result;
                }
                return result;
            }
            boolean result = StringUtils.isNotEmpty(sysValue);
            if (reverseName) {
                return !result;
            }
            return result;
        }
        return false;
    }
}

