/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.util.viewer.gui.ASTPanel;
import net.sourceforge.pmd.util.viewer.gui.ParseExceptionHandler;
import net.sourceforge.pmd.util.viewer.gui.SourceCodePanel;
import net.sourceforge.pmd.util.viewer.gui.XPathPanel;
import net.sourceforge.pmd.util.viewer.model.ViewerModel;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import net.sourceforge.pmd.util.viewer.util.NLS;

public class MainFrame
extends JFrame
implements ActionListener,
ViewerModelListener {
    private ViewerModel model;
    private SourceCodePanel sourcePanel;
    private XPathPanel xPathPanel;
    private JButton evalBtn;
    private JLabel statusLbl;
    private JRadioButtonMenuItem jdk13MenuItem;
    private JRadioButtonMenuItem jdk14MenuItem;
    private JRadioButtonMenuItem jdk15MenuItem;
    private JRadioButtonMenuItem jdk16MenuItem;
    private JRadioButtonMenuItem jdk17MenuItem;
    private JRadioButtonMenuItem plsqlMenuItem;

    public MainFrame() {
        super(NLS.nls("MAIN.FRAME.TITLE") + " (v " + PMD.VERSION + ')');
        this.init();
    }

    private void init() {
        this.model = new ViewerModel();
        this.model.addViewerModelListener(this);
        this.sourcePanel = new SourceCodePanel(this.model);
        ASTPanel astPanel = new ASTPanel(this.model);
        this.xPathPanel = new XPathPanel(this.model);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane editingPane = new JSplitPane(1, this.sourcePanel, astPanel);
        editingPane.setResizeWeight(0.5);
        JPanel interactionsPane = new JPanel(new BorderLayout());
        interactionsPane.add((Component)this.xPathPanel, "South");
        interactionsPane.add((Component)editingPane, "Center");
        this.getContentPane().add((Component)interactionsPane, "Center");
        JButton compileBtn = new JButton(NLS.nls("MAIN.FRAME.COMPILE_BUTTON.TITLE"));
        compileBtn.setActionCommand("Compile");
        compileBtn.addActionListener(this);
        this.evalBtn = new JButton(NLS.nls("MAIN.FRAME.EVALUATE_BUTTON.TITLE"));
        this.evalBtn.setActionCommand("Evaluate");
        this.evalBtn.addActionListener(this);
        this.evalBtn.setEnabled(false);
        this.statusLbl = new JLabel();
        this.statusLbl.setHorizontalAlignment(4);
        JPanel btnPane = new JPanel(new FlowLayout(0));
        btnPane.add(compileBtn);
        btnPane.add(this.evalBtn);
        btnPane.add(this.statusLbl);
        this.getContentPane().add((Component)btnPane, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Language");
        ButtonGroup group = new ButtonGroup();
        this.jdk13MenuItem = new JRadioButtonMenuItem("JDK 1.3");
        this.jdk13MenuItem.setSelected(false);
        group.add(this.jdk13MenuItem);
        menu.add(this.jdk13MenuItem);
        this.jdk14MenuItem = new JRadioButtonMenuItem("JDK 1.4");
        this.jdk14MenuItem.setSelected(true);
        group.add(this.jdk14MenuItem);
        menu.add(this.jdk14MenuItem);
        this.jdk15MenuItem = new JRadioButtonMenuItem("JDK 1.5");
        this.jdk15MenuItem.setSelected(false);
        group.add(this.jdk15MenuItem);
        menu.add(this.jdk15MenuItem);
        this.jdk16MenuItem = new JRadioButtonMenuItem("JDK 1.6");
        this.jdk16MenuItem.setSelected(false);
        group.add(this.jdk16MenuItem);
        menu.add(this.jdk16MenuItem);
        this.jdk17MenuItem = new JRadioButtonMenuItem("JDK 1.7");
        this.jdk17MenuItem.setSelected(false);
        group.add(this.jdk17MenuItem);
        menu.add(this.jdk17MenuItem);
        this.plsqlMenuItem = new JRadioButtonMenuItem("PLSQL");
        this.plsqlMenuItem.setSelected(false);
        group.add(this.plsqlMenuItem);
        menu.add(this.plsqlMenuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
    }

    private LanguageVersion getLanguageVersion() {
        if (this.jdk14MenuItem.isSelected()) {
            return LanguageVersion.JAVA_14;
        }
        if (this.jdk13MenuItem.isSelected()) {
            return LanguageVersion.JAVA_13;
        }
        if (this.jdk15MenuItem.isSelected()) {
            return LanguageVersion.JAVA_15;
        }
        if (this.jdk16MenuItem.isSelected()) {
            return LanguageVersion.JAVA_16;
        }
        if (this.jdk17MenuItem.isSelected()) {
            return LanguageVersion.JAVA_17;
        }
        if (this.plsqlMenuItem.isSelected()) {
            return LanguageVersion.PLSQL;
        }
        return LanguageVersion.JAVA_15;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Compile".equals(command)) {
            try {
                long t0 = System.currentTimeMillis();
                this.model.commitSource(this.sourcePanel.getSourceCode(), this.getLanguageVersion());
                long t1 = System.currentTimeMillis();
                this.setStatus(NLS.nls("MAIN.FRAME.COMPILATION.TOOK") + " " + (t1 - t0) + " ms");
            }
            catch (ParseException exc) {
                this.setStatus(NLS.nls("MAIN.FRAME.COMPILATION.PROBLEM") + " " + exc.toString());
                new ParseExceptionHandler(this, exc);
            }
        } else if ("Evaluate".equals(command)) {
            try {
                long t0 = System.currentTimeMillis();
                this.model.evaluateXPathExpression(this.xPathPanel.getXPathExpression(), this);
                long t1 = System.currentTimeMillis();
                this.setStatus(NLS.nls("MAIN.FRAME.EVALUATION.TOOK") + " " + (t1 - t0) + " ms");
            }
            catch (Exception exc) {
                this.setStatus(NLS.nls("MAIN.FRAME.EVALUATION.PROBLEM") + " " + exc.toString());
                new ParseExceptionHandler(this, exc);
            }
        }
    }

    private void setStatus(String string) {
        this.statusLbl.setText(string == null ? "" : string);
    }

    @Override
    public void viewerModelChanged(ViewerModelEvent e) {
        this.evalBtn.setEnabled(this.model.hasCompiledTree());
    }
}

