/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;

public class SummaryHTMLRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "summaryhtml";

    public SummaryHTMLRenderer() {
        super(NAME, "Summary HTML format.");
        this.definePropertyDescriptor(HTMLRenderer.LINK_PREFIX);
        this.definePropertyDescriptor(HTMLRenderer.LINE_PREFIX);
    }

    @Override
    public String defaultFileExtension() {
        return "html";
    }

    @Override
    public void end() throws IOException {
        this.writer.write("<html><head><title>PMD</title></head><body>" + PMD.EOL);
        this.renderSummary();
        this.writer.write("<h2><center>Detail</h2></center>");
        this.writer.write("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>" + PMD.EOL);
        HTMLRenderer htmlRenderer = new HTMLRenderer();
        htmlRenderer.setProperty(HTMLRenderer.LINK_PREFIX, this.getProperty(HTMLRenderer.LINK_PREFIX));
        htmlRenderer.setProperty(HTMLRenderer.LINE_PREFIX, this.getProperty(HTMLRenderer.LINE_PREFIX));
        htmlRenderer.renderBody(this.writer, this.report);
        this.writer.write("</table></body></html>" + PMD.EOL);
    }

    public void renderSummary() throws IOException {
        StringBuilder buf = new StringBuilder(500);
        buf.append("<h2><center>Summary</h2></center>");
        buf.append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\">");
        buf.append("<th>Rule name</th>");
        buf.append("<th>Number of violations</th>");
        this.writer.write(buf.toString());
        Map<String, Integer> summary = this.report.getSummary();
        for (Map.Entry<String, Integer> entry : summary.entrySet()) {
            String ruleName = entry.getKey();
            buf.setLength(0);
            buf.append("<tr>");
            buf.append("<td>" + ruleName + "</td>");
            buf.append("<td align=center>" + entry.getValue() + "</td>");
            buf.append("</tr>");
            this.writer.write(buf.toString());
        }
        this.writer.write("</table>");
    }
}

