/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.rule.basic;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vm.ast.ASTBlock;
import net.sourceforge.pmd.lang.vm.ast.ASTDirective;
import net.sourceforge.pmd.lang.vm.ast.ASTReference;
import net.sourceforge.pmd.lang.vm.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.vm.rule.AbstractVmRule;

public class UnusedMacroParameterRule
extends AbstractVmRule {
    @Override
    public Object visit(ASTDirective node, Object data) {
        if ("macro".equals(node.getDirectiveName())) {
            HashSet<String> paramNames = new HashSet<String>();
            List<ASTReference> params = node.findChildrenOfType(ASTReference.class);
            for (ASTReference param : params) {
                paramNames.add(param.literal());
            }
            ASTBlock macroBlock = node.getFirstChildOfType(ASTBlock.class);
            if (macroBlock != null) {
                for (ASTReference referenceInMacro : macroBlock.findDescendantsOfType(ASTReference.class)) {
                    this.checkForParameter(paramNames, referenceInMacro.literal());
                }
                for (ASTStringLiteral literalInMacro : macroBlock.findDescendantsOfType(ASTStringLiteral.class)) {
                    String text = literalInMacro.literal();
                    this.checkForParameter(paramNames, text);
                }
            }
            if (!paramNames.isEmpty()) {
                this.addViolation(data, (Node)node, ((Object)paramNames).toString());
            }
        }
        return super.visit(node, data);
    }

    private void checkForParameter(Set<String> paramNames, String nameToSearch) {
        HashSet<String> paramsContained = new HashSet<String>();
        for (String param : paramNames) {
            if (!this.containsAny(nameToSearch, this.formatNameVariations(param))) continue;
            paramsContained.add(param);
        }
        paramNames.removeAll(paramsContained);
    }

    private boolean containsAny(String text, String[] formatNameVariations) {
        for (String formattedName : formatNameVariations) {
            if (!text.contains(formattedName)) continue;
            return true;
        }
        return false;
    }

    private String[] formatNameVariations(String param) {
        String actualName = param.substring(1);
        return new String[]{param, "${" + actualName + "}", "${" + actualName + ".", "$!" + actualName, "$!{" + actualName + ".", "$!{" + actualName + "}"};
    }
}

