/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.rule.basic;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vm.ast.ASTBlock;
import net.sourceforge.pmd.lang.vm.ast.ASTElseIfStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTElseStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTText;
import net.sourceforge.pmd.lang.vm.ast.AbstractVmNode;
import net.sourceforge.pmd.lang.vm.rule.AbstractVmRule;
import org.apache.commons.lang3.StringUtils;

public class CollapsibleIfStatementsRule
extends AbstractVmRule {
    @Override
    public Object visit(ASTIfStatement node, Object data) {
        this.handleIfElseIf(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTElseIfStatement node, Object data) {
        if (node.jjtGetParent().findChildrenOfType(ASTElseIfStatement.class).size() == 1) {
            this.handleIfElseIf(node, data);
        }
        return super.visit(node, data);
    }

    private void handleIfElseIf(AbstractVmNode node, Object data) {
        if (node.getFirstChildOfType(ASTElseStatement.class) == null && node.getFirstChildOfType(ASTElseIfStatement.class) == null) {
            ASTBlock ifBlock = node.getFirstChildOfType(ASTBlock.class);
            boolean violationFound = false;
            int ifCounter = 0;
            for (int i = 0; i < ifBlock.jjtGetNumChildren(); ++i) {
                Node blockChild = ifBlock.jjtGetChild(i);
                if (blockChild instanceof ASTText) {
                    if (!StringUtils.isNotBlank(((ASTText)blockChild).getFirstToken().toString())) continue;
                    violationFound = false;
                    break;
                }
                if (blockChild instanceof ASTIfStatement) {
                    boolean bl = violationFound = !this.hasElseOrElseIf(blockChild);
                    if (!violationFound) break;
                    ++ifCounter;
                    continue;
                }
                if (blockChild instanceof ASTElseIfStatement) {
                    boolean bl = violationFound = !this.hasElseOrElseIf(blockChild);
                    if (!violationFound) break;
                    ++ifCounter;
                    continue;
                }
                violationFound = false;
                break;
            }
            if (violationFound && ifCounter == 1) {
                this.addViolation(data, node);
            }
        }
    }

    private boolean hasElseOrElseIf(Node parentIfNode) {
        return parentIfNode.getFirstChildOfType(ASTElseStatement.class) != null || parentIfNode.getFirstChildOfType(ASTElseIfStatement.class) != null;
    }
}

