/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractDelimitedProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;
import net.sourceforge.pmd.util.StringUtil;

public class StringMultiProperty
extends AbstractDelimitedProperty<String[]> {
    public static final char DEFAULT_DELIMITER = '|';
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<StringMultiProperty>(String[].class){

        public StringMultiProperty createWith(Map<String, String> valuesById) {
            char delimiter = 1.delimiterIn(valuesById);
            return new StringMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), StringUtil.substringsOf(this.defaultValueIn(valuesById), delimiter), 0.0f, delimiter);
        }
    };

    public StringMultiProperty(String theName, String theDescription, String[] theDefaults, float theUIOrder, char delimiter) {
        super(theName, theDescription, theDefaults, delimiter, theUIOrder);
        StringMultiProperty.checkDefaults(theDefaults, delimiter);
    }

    public StringMultiProperty(String theName, String theDescription, String theDefaults, Map<String, String> otherParams) {
        this(theName, theDescription, StringUtil.substringsOf(theDefaults, StringMultiProperty.delimiterIn(otherParams)), 0.0f, StringMultiProperty.delimiterIn(otherParams));
    }

    private static void checkDefaults(String[] defaultValue, char delim) {
        if (defaultValue == null) {
            return;
        }
        for (int i = 0; i < defaultValue.length; ++i) {
            if (defaultValue[i].indexOf(delim) < 0) continue;
            throw new IllegalArgumentException("Cannot include the delimiter in the set of defaults");
        }
    }

    @Override
    public Class<String[]> type() {
        return String[].class;
    }

    @Override
    public String[] valueFrom(String valueString) {
        return StringUtil.substringsOf(valueString, this.multiValueDelimiter());
    }

    private boolean containsDelimiter(String value) {
        return value.indexOf(this.multiValueDelimiter()) >= 0;
    }

    private final String illegalCharMsg() {
        return "Value cannot contain the '" + this.multiValueDelimiter() + "' character";
    }

    @Override
    protected String valueErrorFor(Object value) {
        if (value == null) {
            return "missing value";
        }
        String testValue = (String)value;
        if (this.containsDelimiter(testValue)) {
            return this.illegalCharMsg();
        }
        return null;
    }
}

