/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public class CharacterProperty
extends AbstractProperty<Character> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<CharacterProperty>(Character.class){

        public CharacterProperty createWith(Map<String, String> valuesById) {
            return new CharacterProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), new Character(this.defaultValueIn(valuesById).charAt(0)), 0.0f);
        }
    };

    public CharacterProperty(String theName, String theDescription, Character theDefault, float theUIOrder) {
        super(theName, theDescription, theDefault, theUIOrder);
    }

    public CharacterProperty(String theName, String theDescription, String defaultStr, float theUIOrder) {
        this(theName, theDescription, CharacterProperty.charFrom(defaultStr), theUIOrder);
    }

    public static Character charFrom(String charStr) {
        if (charStr == null || charStr.length() != 1) {
            throw new IllegalArgumentException("missing/invalid character value");
        }
        return Character.valueOf(charStr.charAt(0));
    }

    @Override
    public Class<Character> type() {
        return Character.class;
    }

    @Override
    public Character valueFrom(String valueString) throws IllegalArgumentException {
        return CharacterProperty.charFrom(valueString);
    }

    @Override
    protected String defaultAsString() {
        return Character.toString(((Character)this.defaultValue()).charValue());
    }
}

