/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.util.StringUtil;

public abstract class AbstractProperty<T>
implements PropertyDescriptor<T> {
    private final String name;
    private final String description;
    private final T defaultValue;
    private final boolean isRequired;
    private final float uiOrder;
    private static final char DELIMITER = '|';

    protected AbstractProperty(String theName, String theDescription, T theDefault, float theUIOrder) {
        this.name = AbstractProperty.checkNotEmpty(theName, "name");
        this.description = AbstractProperty.checkNotEmpty(theDescription, "description");
        this.defaultValue = theDefault;
        this.isRequired = false;
        this.uiOrder = AbstractProperty.checkPositive(theUIOrder, "UI order");
    }

    private static String checkNotEmpty(String arg, String argId) {
        if (StringUtil.isEmpty(arg)) {
            throw new IllegalArgumentException("Property attribute '" + argId + "' cannot be null or blank");
        }
        return arg;
    }

    private static float checkPositive(float arg, String argId) {
        if (arg < 0.0f) {
            throw new IllegalArgumentException("Property attribute " + argId + "' must be zero or positive");
        }
        return arg;
    }

    @Override
    public char multiValueDelimiter() {
        return '|';
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    protected boolean defaultHasNullValue() {
        if (this.defaultValue == null) {
            return true;
        }
        if (this.isMultiValue() && AbstractProperty.isArray(this.defaultValue)) {
            Object[] defaults;
            for (Object default1 : defaults = (Object[])this.defaultValue) {
                if (default1 != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMultiValue() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public float uiOrder() {
        return this.uiOrder;
    }

    protected String asString(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String asDelimitedString(T values) {
        return this.asDelimitedString(values, this.multiValueDelimiter());
    }

    public String asDelimitedString(T values, char delimiter) {
        if (values == null) {
            return "";
        }
        if (values instanceof Object[]) {
            Object[] valueSet = (Object[])values;
            if (valueSet.length == 0) {
                return "";
            }
            if (valueSet.length == 1) {
                return this.asString(valueSet[0]);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.asString(valueSet[0]));
            for (int i = 1; i < valueSet.length; ++i) {
                sb.append(delimiter);
                sb.append(this.asString(valueSet[i]));
            }
            return sb.toString();
        }
        return this.asString(values);
    }

    @Override
    public int compareTo(PropertyDescriptor<?> otherProperty) {
        float otherOrder = otherProperty.uiOrder();
        return (int)(otherOrder - this.uiOrder);
    }

    @Override
    public String errorFor(Object value) {
        String typeError = this.typeErrorFor(value);
        if (typeError != null) {
            return typeError;
        }
        return this.isMultiValue() ? this.valuesErrorFor(value) : this.valueErrorFor(value);
    }

    protected String valueErrorFor(Object value) {
        if (value == null) {
            if (this.defaultHasNullValue()) {
                return null;
            }
            return "missing value";
        }
        return null;
    }

    protected String valuesErrorFor(Object value) {
        if (!AbstractProperty.isArray(value)) {
            return "multiple values expected";
        }
        Object[] values = (Object[])value;
        String err = null;
        for (Object value2 : values) {
            err = this.valueErrorFor(value2);
            if (err == null) continue;
            return err;
        }
        return null;
    }

    protected static boolean isArray(Object value) {
        return value != null && value.getClass().getComponentType() != null;
    }

    protected String typeErrorFor(Object value) {
        if (value == null && !this.isRequired) {
            return null;
        }
        if (this.isMultiValue()) {
            if (!AbstractProperty.isArray(value)) {
                return "Value is not an array of type: " + this.type();
            }
            Class<?> arrayType = value.getClass().getComponentType();
            if (arrayType == null || !arrayType.isAssignableFrom(this.type().getComponentType())) {
                return "Value is not an array of type: " + this.type();
            }
            return null;
        }
        if (!this.type().isAssignableFrom(value.getClass())) {
            return value + " is not an instance of " + this.type();
        }
        return null;
    }

    @Override
    public String propertyErrorFor(Rule rule) {
        Object realValue = rule.getProperty(this);
        if (realValue == null && !this.isRequired()) {
            return null;
        }
        return this.errorFor(realValue);
    }

    @Override
    public Object[][] choices() {
        return null;
    }

    @Override
    public int preferredRowCount() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PropertyDescriptor) {
            return this.name.equals(((PropertyDescriptor)obj).name());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[PropertyDescriptor: name=" + this.name() + ", type=" + this.type() + ", value=" + this.defaultValue() + "]";
    }

    protected abstract String defaultAsString();

    public static final boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        return value.equals(otherValue);
    }

    @Override
    public Map<String, String> attributeValuesById() {
        HashMap<String, String> values = new HashMap<String, String>();
        this.addAttributesTo(values);
        return values;
    }

    protected void addAttributesTo(Map<String, String> attributes) {
        attributes.put("name", this.name);
        attributes.put("description", this.description);
        attributes.put("value", this.defaultAsString());
    }
}

