/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.Stack;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.plsql.ast.ASTBlock;
import net.sourceforge.pmd.lang.plsql.ast.ASTDeclarativeUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTForAllStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTForStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTID;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.ASTObjectDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTObjectNameDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageBody;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantDeclaratorId;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitorAdapter;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassScope;
import net.sourceforge.pmd.lang.plsql.symboltable.LocalScope;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodScope;
import net.sourceforge.pmd.lang.plsql.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.plsql.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ScopeAndDeclarationFinder
extends PLSQLParserVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(ScopeAndDeclarationFinder.class.getName());
    private Stack<Scope> scopes = new Stack();

    private void addScope(Scope newScope, PLSQLNode node) {
        newScope.setParent(this.scopes.peek());
        this.scopes.push(newScope);
        node.setScope(newScope);
    }

    private void createLocalScope(PLSQLNode node) {
        this.addScope(new LocalScope(), node);
    }

    private void createMethodScope(PLSQLNode node) {
        this.addScope(new MethodScope(node), node);
    }

    private void createClassScope(PLSQLNode node) {
        if (node instanceof ASTDeclarativeUnit) {
            this.addScope(new ClassScope(), node);
        } else {
            this.addScope(new ClassScope(node.getImage()), node);
        }
    }

    private void createSourceFileScope(ASTInput node) {
        AbstractNode n = null;
        SourceFileScope scope = n != null ? new SourceFileScope(n.jjtGetChild(0).getImage()) : new SourceFileScope();
        this.scopes.push(scope);
        node.setScope(scope);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        this.createSourceFileScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTPackageSpecification node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.jjtGetParent()).getScope();
        s.addDeclaration(new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTPackageBody node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.jjtGetParent()).getScope();
        s.addDeclaration(new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTypeSpecification node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.jjtGetParent()).getScope();
        s.addDeclaration(new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTriggerUnit node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.jjtGetParent()).getScope();
        s.addDeclaration(new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTriggerTimingPointSection node, Object data) {
        this.createMethodScope(node);
        node.getScope().getEnclosingScope(ClassScope.class).addDeclaration(new MethodNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTObjectDeclaration node, Object data) {
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTypeMethod node, Object data) {
        block2: {
            this.createMethodScope(node);
            ASTMethodDeclarator md = node.getFirstChildOfType(ASTMethodDeclarator.class);
            try {
                node.getScope().getEnclosingScope(ClassScope.class).addDeclaration(new MethodNameDeclaration(md));
            }
            catch (Exception e) {
                LOGGER.finest("ProgramUnit getEnclosingClassScope Exception string=\"" + e.getMessage() + "\"");
                if (!"getEnclosingClassScope() called on SourceFileScope".equals(e.getMessage())) break block2;
                LOGGER.finest("ClassScope skipped for Schema-level method: methodName=" + node.getMethodName() + "; Image=" + node.getImage());
                ASTObjectNameDeclaration on = md.getFirstChildOfType(ASTObjectNameDeclaration.class);
                if (1 >= on.jjtGetNumChildren()) break block2;
                ASTID schemaName = on.getFirstChildOfType(ASTID.class);
                LOGGER.finest("SchemaName for Schema-level method: methodName=" + node.getMethodName() + "; Image=" + node.getImage() + "is " + schemaName.getImage());
            }
        }
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTProgramUnit node, Object data) {
        block2: {
            this.createMethodScope(node);
            ASTMethodDeclarator md = node.getFirstChildOfType(ASTMethodDeclarator.class);
            try {
                node.getScope().getEnclosingScope(ClassScope.class).addDeclaration(new MethodNameDeclaration(md));
            }
            catch (Exception e) {
                LOGGER.finest("ProgramUnit getEnclosingClassScope Exception string=\"" + e.getMessage() + "\"");
                if (!"getEnclosingClassScope() called on SourceFileScope".equals(e.getMessage())) break block2;
                LOGGER.finest("ClassScope skipped for Schema-level method: methodName=" + node.getMethodName() + "; Image=" + node.getImage());
                ASTObjectNameDeclaration on = md.getFirstChildOfType(ASTObjectNameDeclaration.class);
                if (1 >= on.jjtGetNumChildren()) break block2;
                ASTID schemaName = on.getFirstChildOfType(ASTID.class);
                LOGGER.finest("SchemaName for Schema-level method: methodName=" + node.getMethodName() + "; Image=" + node.getImage() + "is " + schemaName.getImage());
            }
        }
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTForAllStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableOrConstantDeclaratorId node, Object data) {
        VariableNameDeclaration decl = new VariableNameDeclaration(node);
        node.getScope().addDeclaration(decl);
        node.setNameDeclaration(decl);
        return super.visit(node, data);
    }

    private void cont(PLSQLNode node) {
        super.visit(node, null);
        this.scopes.pop();
    }
}

