/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.AbstractPLSQLNode;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;

public class MethodNameDeclaration
extends AbstractNameDeclaration {
    private static final Logger LOGGER = Logger.getLogger(MethodNameDeclaration.class.getName());

    public MethodNameDeclaration(ASTMethodDeclarator node) {
        super(node);
    }

    public MethodNameDeclaration(ASTTriggerTimingPointSection node) {
        super(node);
    }

    public int getParameterCount() {
        return ((ASTMethodDeclarator)this.node).getParameterCount();
    }

    public boolean isVarargs() {
        ASTFormalParameters params = (ASTFormalParameters)this.node.jjtGetChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter aSTFormalParameter = (ASTFormalParameter)params.jjtGetChild(i);
        }
        return false;
    }

    public ASTMethodDeclarator getMethodNameDeclaratorNode() {
        return (ASTMethodDeclarator)this.node;
    }

    public String getParameterDisplaySignature() {
        StringBuilder sb = new StringBuilder("(");
        ASTFormalParameters params = (ASTFormalParameters)this.node.jjtGetChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter p = (ASTFormalParameter)params.jjtGetChild(i);
            sb.append(p.getTypeNode().getTypeImage());
            sb.append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodNameDeclaration)) {
            return false;
        }
        MethodNameDeclaration other = (MethodNameDeclaration)o;
        if (!other.node.getImage().equals(this.node.getImage())) {
            return false;
        }
        if (((ASTMethodDeclarator)other.node).getParameterCount() != ((ASTMethodDeclarator)this.node).getParameterCount()) {
            return false;
        }
        ASTFormalParameters myParams = this.node.getFirstDescendantOfType(ASTFormalParameters.class);
        ASTFormalParameters otherParams = other.node.getFirstDescendantOfType(ASTFormalParameters.class);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            String otherTypeImg;
            ASTFormalParameter myParam = (ASTFormalParameter)myParams.jjtGetChild(i);
            ASTFormalParameter otherParam = (ASTFormalParameter)otherParams.jjtGetChild(i);
            Node myTypeNode = myParam.getTypeNode().jjtGetChild(0);
            Node otherTypeNode = otherParam.getTypeNode().jjtGetChild(0);
            if (myTypeNode.getClass() != otherTypeNode.getClass()) {
                return false;
            }
            String myTypeImg = ((AbstractPLSQLNode)myTypeNode.jjtGetChild(0)).getImage();
            if (myTypeImg.equals(otherTypeImg = ((AbstractPLSQLNode)otherTypeNode.jjtGetChild(0)).getImage())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        try {
            return this.node.hashCode();
        }
        catch (Exception e) {
            LOGGER.finest("MethodNameDeclaration problem for " + this.node + " of class " + this.node.getClass().getCanonicalName() + " => " + this.node.getBeginLine() + "/" + this.node.getBeginColumn());
            return 0;
        }
    }

    public String toString() {
        return this.node.toString();
    }
}

