/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.ast;

import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParser;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserTreeConstants;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitor;
import net.sourceforge.pmd.lang.symboltable.Scope;

public abstract class AbstractPLSQLNode
extends AbstractNode
implements PLSQLNode {
    protected Object value;
    protected PLSQLParser parser;
    protected Scope scope;

    public AbstractPLSQLNode(int i) {
        super(i);
    }

    public AbstractPLSQLNode(PLSQLParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
        if (this.beginLine == -1 && this.parser.token.next != null) {
            this.beginLine = this.parser.token.next.beginLine;
            this.beginColumn = this.parser.token.next.beginColumn;
        }
    }

    @Override
    public void jjtClose() {
        if (this.beginLine == -1 && (this.children == null || this.children.length == 0)) {
            this.beginColumn = this.parser.token.beginColumn;
        }
        if (this.beginLine == -1) {
            this.beginLine = this.parser.token.beginLine;
        }
        this.endLine = this.parser.token.endLine;
        this.endColumn = this.parser.token.endColumn;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    @Override
    public Object jjtAccept(PLSQLParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object childrenAccept(PLSQLParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ((PLSQLNode)this.children[i]).jjtAccept(visitor, data);
            }
        }
        return data;
    }

    @Override
    public String toString() {
        return PLSQLParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                AbstractPLSQLNode n = (AbstractPLSQLNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public String getCanonicalImage() {
        return PLSQLParser.canonicalName(this.getImage());
    }

    public static String getCanonicalImage(String image) {
        return PLSQLParser.canonicalName(image);
    }

    @Override
    public Scope getScope() {
        if (this.scope == null) {
            return ((PLSQLNode)this.parent).getScope();
        }
        return this.scope;
    }

    @Override
    public void setScope(Scope scope) {
        this.scope = scope;
    }
}

