/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.jsp.ast;

import net.sourceforge.pmd.lang.jsp.ast.SyntaxErrorException;

public class StartAndEndTagMismatchException
extends SyntaxErrorException {
    public static final String START_END_TAG_MISMATCH_RULE_NAME = "Start and End Tags of an XML Element must match.";
    private int startLine;
    private int endLine;
    private int startColumn;
    private int endColumn;
    private String startTagName;
    private String endTagName;

    public StartAndEndTagMismatchException(int startLine, int startColumn, String startTagName, int endLine, int endColumn, String endTagName) {
        super(endLine, START_END_TAG_MISMATCH_RULE_NAME);
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.startTagName = startTagName;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.endTagName = endTagName;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public String getMessage() {
        return "The start-tag of element \"" + this.startTagName + "\" (line " + this.startLine + ", column " + this.startColumn + ") does not correspond to the end-tag found: \"" + this.endTagName + "\" (line " + this.endLine + ", column " + this.endColumn + ").";
    }
}

