/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class PMDASMVisitor
extends ClassVisitor {
    private Map<String, String> packages = new HashMap<String, String>();
    private AnnotationVisitor annotationVisitor = new PMDAnnotationVisitor(this);
    private FieldVisitor fieldVisitor = new PMDFieldVisitor(this);
    private SignatureVisitor sigVisitor = new PMDSignatureVisitor(this);
    private MethodVisitor methodVisitor = new PMDMethodVisitor(this);
    public List<String> innerClasses;

    public PMDASMVisitor() {
        super(262144);
    }

    public Map<String, String> getPackages() {
        return this.packages;
    }

    public List<String> getInnerClasses() {
        return this.innerClasses;
    }

    private String parseClassName(String name) {
        if (name == null) {
            return null;
        }
        String className = name;
        int n = name.lastIndexOf(47);
        if (n > -1) {
            className = name.substring(n + 1);
        }
        name = name.replace('/', '.');
        this.packages.put(className, name);
        n = className.indexOf(36);
        if (n > -1) {
            this.packages.put(className.substring(n + 1), name);
            this.packages.put(className.replace('$', '.'), name);
        }
        return name;
    }

    private void parseClassName(String[] names) {
        if (names != null) {
            for (String s : names) {
                this.parseClassName(s);
            }
        }
    }

    private void extractSignature(String sig) {
        if (sig != null) {
            new SignatureReader(sig).accept(this.sigVisitor);
        }
    }

    @Override
    public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
        this.parseClassName(name);
        this.parseClassName(interfaces);
        if (sig != null) {
            this.extractSignature(sig);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addType(Type.getType(desc));
        return this.annotationVisitor;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String sig, Object value) {
        if (sig != null) {
            this.extractSignature(sig);
        }
        this.addType(Type.getType(desc));
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.fieldVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        if (sig != null) {
            this.extractSignature(sig);
        }
        this.addMethodDesc(desc);
        this.parseClassName(exceptions);
        return this.methodVisitor;
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.innerClasses == null) {
            this.innerClasses = new ArrayList<String>();
        }
        if (!this.innerClasses.contains(name.replace('/', '.'))) {
            this.innerClasses.add(name.replace('/', '.'));
        }
        this.packages.put(innerName, name.replace('/', '.'));
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public void visitEnd() {
    }

    private void addMethodDesc(String desc) {
        this.addTypes(desc);
        this.addType(Type.getReturnType(desc));
    }

    private void addTypes(String desc) {
        Type[] types;
        for (Type type : types = Type.getArgumentTypes(desc)) {
            this.addType(type);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.parseClassName(t.getClassName().replace('.', '/'));
                break;
            }
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    private static class PMDMethodVisitor
    extends MethodVisitor {
        private PMDASMVisitor parent;

        public PMDMethodVisitor(PMDASMVisitor visitor) {
            super(262144);
            this.parent = visitor;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[') {
                this.parent.addType(Type.getType(desc));
            } else {
                this.parent.parseClassName(desc);
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.parent.parseClassName(owner);
            this.parent.addType(Type.getType(desc));
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.parent.parseClassName(owner);
            this.parent.addMethodDesc(desc);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                this.parent.addType((Type)cst);
            } else if (cst instanceof String) {
                this.parent.parseClassName((String)cst);
            }
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.parent.addType(Type.getType(desc));
        }

        @Override
        public void visitLocalVariable(String name, String desc, String sig, Label start, Label end, int index) {
            this.parent.extractSignature(sig);
        }

        @Override
        public void visitCode() {
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        @Override
        public void visitInsn(int opcode) {
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitIincInsn(int var, int increment) {
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.parent.parseClassName(type);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return this.parent.annotationVisitor;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }
    }

    private static class PMDSignatureVisitor
    extends SignatureVisitor {
        private PMDASMVisitor parent;

        public PMDSignatureVisitor(PMDASMVisitor visitor) {
            super(262144);
            this.parent = visitor;
        }

        @Override
        public void visitFormalTypeParameter(String name) {
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return this;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return this;
        }

        @Override
        public SignatureVisitor visitInterface() {
            return this;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            return this;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return this;
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            return this;
        }

        @Override
        public void visitBaseType(char descriptor) {
        }

        @Override
        public void visitTypeVariable(String name) {
        }

        @Override
        public SignatureVisitor visitArrayType() {
            return this;
        }

        @Override
        public void visitClassType(String name) {
            this.parent.parseClassName(name);
        }

        @Override
        public void visitInnerClassType(String name) {
            this.parent.parseClassName(name);
        }

        @Override
        public void visitTypeArgument() {
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        @Override
        public void visitEnd() {
        }
    }

    private static class PMDAnnotationVisitor
    extends AnnotationVisitor {
        private PMDASMVisitor parent;

        public PMDAnnotationVisitor(PMDASMVisitor visitor) {
            super(262144);
            this.parent = visitor;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.parent.addType(Type.getType(desc));
            return this;
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.parent.addType(Type.getType(desc));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.parent.addType((Type)value);
            }
        }
    }

    private static class PMDFieldVisitor
    extends FieldVisitor {
        private PMDASMVisitor parent;

        public PMDFieldVisitor(PMDASMVisitor visitor) {
            super(262144);
            this.parent = visitor;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }
    }
}

