/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;

public class MethodNameDeclaration
extends AbstractNameDeclaration {
    public MethodNameDeclaration(ASTMethodDeclarator node) {
        super(node);
    }

    public int getParameterCount() {
        return ((ASTMethodDeclarator)this.node).getParameterCount();
    }

    public boolean isVarargs() {
        ASTFormalParameters params = (ASTFormalParameters)this.node.jjtGetChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter p = (ASTFormalParameter)params.jjtGetChild(i);
            if (!p.isVarargs()) continue;
            return true;
        }
        return false;
    }

    public ASTMethodDeclarator getMethodNameDeclaratorNode() {
        return (ASTMethodDeclarator)this.node;
    }

    public String getParameterDisplaySignature() {
        StringBuilder sb = new StringBuilder("(");
        ASTFormalParameters params = (ASTFormalParameters)this.node.jjtGetChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter p = (ASTFormalParameter)params.jjtGetChild(i);
            sb.append(p.getTypeNode().getTypeImage());
            if (p.isVarargs()) {
                sb.append("...");
            }
            sb.append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodNameDeclaration)) {
            return false;
        }
        MethodNameDeclaration other = (MethodNameDeclaration)o;
        if (!other.node.getImage().equals(this.node.getImage())) {
            return false;
        }
        if (((ASTMethodDeclarator)other.node).getParameterCount() != ((ASTMethodDeclarator)this.node).getParameterCount()) {
            return false;
        }
        ASTFormalParameters myParams = (ASTFormalParameters)this.node.jjtGetChild(0);
        ASTFormalParameters otherParams = (ASTFormalParameters)other.node.jjtGetChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            String otherTypeImg;
            String myTypeImg;
            ASTFormalParameter myParam = (ASTFormalParameter)myParams.jjtGetChild(i);
            ASTFormalParameter otherParam = (ASTFormalParameter)otherParams.jjtGetChild(i);
            if (myParam.isVarargs() != otherParam.isVarargs()) {
                return false;
            }
            Node myTypeNode = myParam.getTypeNode().jjtGetChild(0);
            Node otherTypeNode = otherParam.getTypeNode().jjtGetChild(0);
            if (myTypeNode.getClass() != otherTypeNode.getClass()) {
                return false;
            }
            if (myTypeNode instanceof ASTPrimitiveType) {
                myTypeImg = myTypeNode.getImage();
                otherTypeImg = otherTypeNode.getImage();
            } else {
                myTypeImg = myTypeNode.jjtGetChild(0).getImage();
                otherTypeImg = otherTypeNode.jjtGetChild(0).getImage();
            }
            if (myTypeImg.equals(otherTypeImg)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.node.getImage().hashCode() + ((ASTMethodDeclarator)this.node).getParameterCount();
    }

    public String toString() {
        return "Method " + this.node.getImage() + ", line " + this.node.getBeginLine() + ", params = " + ((ASTMethodDeclarator)this.node).getParameterCount();
    }
}

