/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.strings;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;

public class InefficientStringBufferingRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTAdditiveExpression node, Object data) {
        ASTBlockStatement bs = node.getFirstParentOfType(ASTBlockStatement.class);
        if (bs == null) {
            return data;
        }
        int immediateLiterals = 0;
        int immediateStringLiterals = 0;
        List<ASTLiteral> nodes = node.findDescendantsOfType(ASTLiteral.class);
        for (ASTLiteral literal : nodes) {
            if (literal.getNthParent(3) instanceof ASTAdditiveExpression) {
                ++immediateLiterals;
                if (literal.isStringLiteral()) {
                    ++immediateStringLiterals;
                }
            }
            if (!literal.isIntLiteral() && !literal.isFloatLiteral()) continue;
            return data;
        }
        if (immediateLiterals > 1) {
            return data;
        }
        List<ASTName> nameNodes = node.findDescendantsOfType(ASTName.class);
        for (ASTName name : nameNodes) {
            VariableNameDeclaration vnd;
            AccessNode accessNodeParent;
            if (name.getNameDeclaration() == null || !(name.getNameDeclaration() instanceof VariableNameDeclaration) || !(accessNodeParent = (vnd = (VariableNameDeclaration)name.getNameDeclaration()).getAccessNodeParent()).isFinal() || !accessNodeParent.isStatic()) continue;
            return data;
        }
        boolean stringFound = false;
        for (ASTName name : nameNodes) {
            if (this.isPrimitiveType(name) || !this.isStringType(name)) continue;
            stringFound = true;
            break;
        }
        if (!stringFound && immediateStringLiterals == 0) {
            return data;
        }
        if (bs.isAllocation()) {
            ASTName name;
            Iterator<ASTName> iterator = nameNodes.iterator();
            while (iterator.hasNext() && (name = iterator.next()).getImage().endsWith("length")) {
                if (iterator.hasNext()) continue;
                return data;
            }
            if (this.isAllocatedStringBuffer(node)) {
                this.addViolation(data, node);
            }
        } else if (InefficientStringBufferingRule.isInStringBufferOperation(node, 6, "append")) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean isStringType(ASTName name) {
        ASTClassOrInterfaceType typeDeclaration;
        List<ASTClassOrInterfaceType> types;
        ASTType type = this.getTypeNode(name);
        return type != null && !(types = type.findDescendantsOfType(ASTClassOrInterfaceType.class)).isEmpty() && (String.class == (typeDeclaration = types.get(0)).getType() || "String".equals(typeDeclaration.getImage()));
    }

    private boolean isPrimitiveType(ASTName name) {
        ASTType type = this.getTypeNode(name);
        return type != null && !type.findChildrenOfType(ASTPrimitiveType.class).isEmpty();
    }

    private ASTType getTypeNode(ASTName name) {
        if (name.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration vnd = (VariableNameDeclaration)name.getNameDeclaration();
            if (vnd.getAccessNodeParent() instanceof ASTLocalVariableDeclaration) {
                ASTLocalVariableDeclaration l = (ASTLocalVariableDeclaration)vnd.getAccessNodeParent();
                return l.getTypeNode();
            }
            if (vnd.getAccessNodeParent() instanceof ASTFormalParameter) {
                ASTFormalParameter p = (ASTFormalParameter)vnd.getAccessNodeParent();
                return p.getTypeNode();
            }
        }
        return null;
    }

    protected static boolean isInStringBufferOperation(Node node, int length, String methodName) {
        if (!(node.getNthParent(length) instanceof ASTStatementExpression)) {
            return false;
        }
        ASTStatementExpression s = node.getFirstParentOfType(ASTStatementExpression.class);
        if (s == null) {
            return false;
        }
        ASTName n = s.getFirstDescendantOfType(ASTName.class);
        if (n == null || n.getImage().indexOf(methodName) == -1 || !(n.getNameDeclaration() instanceof TypedNameDeclaration)) {
            return false;
        }
        ASTArgumentList argList = s.getFirstDescendantOfType(ASTArgumentList.class);
        if (argList == null || argList.jjtGetNumChildren() > 1) {
            return false;
        }
        return TypeHelper.isEither((TypedNameDeclaration)((Object)n.getNameDeclaration()), StringBuffer.class, StringBuilder.class);
    }

    private boolean isAllocatedStringBuffer(ASTAdditiveExpression node) {
        ASTAllocationExpression ao = node.getFirstParentOfType(ASTAllocationExpression.class);
        if (ao == null) {
            return false;
        }
        ASTClassOrInterfaceType an = ao.getFirstChildOfType(ASTClassOrInterfaceType.class);
        return an != null && TypeHelper.isEither(an, StringBuffer.class, StringBuilder.class);
    }
}

