/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.strings;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.strings.InefficientStringBufferingRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ConsecutiveLiteralAppendsRule
extends AbstractJavaRule {
    private static final Set<Class<?>> BLOCK_PARENTS = new HashSet();
    private static final IntegerProperty THRESHOLD_DESCRIPTOR;
    private int threshold = 1;

    public ConsecutiveLiteralAppendsRule() {
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        Node lastBlock;
        if (!ConsecutiveLiteralAppendsRule.isStringBuffer(node)) {
            return data;
        }
        this.threshold = this.getProperty(THRESHOLD_DESCRIPTOR);
        int concurrentCount = this.checkConstructor(node, data);
        Node currentBlock = lastBlock = this.getFirstParentBlock(node);
        Map<VariableNameDeclaration, List<NameOccurrence>> decls = node.getScope().getDeclarations(VariableNameDeclaration.class);
        Node rootNode = null;
        if (concurrentCount >= 1) {
            rootNode = node;
        }
        for (List<NameOccurrence> decl : decls.values()) {
            for (NameOccurrence no : decl) {
                JavaNameOccurrence jno = (JavaNameOccurrence)no;
                JavaNode n = jno.getLocation();
                currentBlock = this.getFirstParentBlock(n);
                if (!InefficientStringBufferingRule.isInStringBufferOperation(n, 3, "append")) {
                    if (jno.isPartOfQualifiedName()) continue;
                    this.checkForViolation(rootNode, data, concurrentCount);
                    concurrentCount = 0;
                    continue;
                }
                ASTPrimaryExpression s = n.getFirstParentOfType(ASTPrimaryExpression.class);
                int numChildren = s.jjtGetNumChildren();
                for (int jx = 0; jx < numChildren; ++jx) {
                    Node sn = s.jjtGetChild(jx);
                    if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                    if (currentBlock != null && lastBlock != null && !currentBlock.equals(lastBlock) || currentBlock == null ^ lastBlock == null) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    }
                    if (concurrentCount == 0) {
                        rootNode = sn;
                    }
                    if (this.isAdditive(sn)) {
                        if ((concurrentCount = this.processAdditive(data, concurrentCount, sn, rootNode)) != 0) {
                            rootNode = sn;
                        }
                    } else if (!this.isAppendingStringLiteral(sn)) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    } else {
                        ++concurrentCount;
                    }
                    lastBlock = currentBlock;
                }
            }
        }
        this.checkForViolation(rootNode, data, concurrentCount);
        return data;
    }

    private int checkConstructor(ASTVariableDeclaratorId node, Object data) {
        ASTArgumentList list;
        Node parent = node.jjtGetParent();
        if (parent.jjtGetNumChildren() >= 2 && (list = parent.jjtGetChild(1).getFirstDescendantOfType(ASTArgumentList.class)) != null) {
            ASTLiteral literal = list.getFirstDescendantOfType(ASTLiteral.class);
            if (!this.isAdditive(list) && literal != null && literal.isStringLiteral()) {
                return 1;
            }
            return this.processAdditive(data, 0, list, node);
        }
        return 0;
    }

    private int processAdditive(Object data, int concurrentCount, Node sn, Node rootNode) {
        ASTAdditiveExpression additive = sn.getFirstDescendantOfType(ASTAdditiveExpression.class);
        if (additive == null || additive.getType() != null && !TypeHelper.isA(additive, String.class)) {
            return 0;
        }
        int count = concurrentCount;
        boolean found = false;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            Node childNode = additive.jjtGetChild(ix);
            if (childNode.jjtGetNumChildren() != 1 || childNode.hasDescendantOfType(ASTName.class)) {
                if (!found) {
                    this.checkForViolation(rootNode, data, count);
                    found = true;
                }
                count = 0;
                continue;
            }
            ++count;
        }
        if (!found) {
            count = 1;
        }
        return count;
    }

    private boolean isAdditive(Node n) {
        List<ASTAdditiveExpression> lstAdditive = n.findDescendantsOfType(ASTAdditiveExpression.class);
        if (lstAdditive.isEmpty()) {
            return false;
        }
        for (int ix = 0; ix < lstAdditive.size(); ++ix) {
            ASTAdditiveExpression expr = lstAdditive.get(ix);
            if (expr.getParentsOfType(ASTArgumentList.class).size() == 1) continue;
            return false;
        }
        return true;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !BLOCK_PARENTS.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode instanceof ASTIfStatement) {
            parentNode = lastNode;
        } else if (parentNode instanceof ASTSwitchStatement) {
            parentNode = this.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            if (n instanceof ASTSwitchLabel) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    private void checkForViolation(Node node, Object data, int concurrentCount) {
        if (concurrentCount > this.threshold) {
            Object[] param = new String[]{String.valueOf(concurrentCount)};
            this.addViolation(data, node, param);
        }
    }

    private boolean isAppendingStringLiteral(Node node) {
        Node n = node;
        while (n.jjtGetNumChildren() != 0 && !(n instanceof ASTLiteral)) {
            n = n.jjtGetChild(0);
        }
        return n instanceof ASTLiteral;
    }

    private static boolean isStringBuffer(ASTVariableDeclaratorId node) {
        if (node.getType() != null) {
            return TypeHelper.isEither(node, StringBuffer.class, StringBuilder.class);
        }
        Node nn = node.getTypeNameNode();
        if (nn == null || nn.jjtGetNumChildren() == 0) {
            return false;
        }
        return TypeHelper.isEither((TypeNode)((Object)nn.jjtGetChild(0)), StringBuffer.class, StringBuilder.class);
    }

    static {
        BLOCK_PARENTS.add(ASTForStatement.class);
        BLOCK_PARENTS.add(ASTWhileStatement.class);
        BLOCK_PARENTS.add(ASTDoStatement.class);
        BLOCK_PARENTS.add(ASTIfStatement.class);
        BLOCK_PARENTS.add(ASTSwitchStatement.class);
        BLOCK_PARENTS.add(ASTMethodDeclaration.class);
        THRESHOLD_DESCRIPTOR = new IntegerProperty("threshold", "Max consecutive appends", 1, 10, 1, 1.0f);
    }
}

