/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.JavaRuleViolation;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.util.StringUtil;

public class GodClassRule
extends AbstractJavaRule {
    private static final int WMC_VERY_HIGH = 47;
    private static final int FEW_THRESHOLD = 5;
    private static final double ONE_THIRD_THRESHOLD = 0.3333333333333333;
    private int wmcCounter;
    private int atfdCounter;
    private Map<String, Set<String>> methodAttributeAccess;
    private String currentMethodName;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.wmcCounter = 0;
        this.atfdCounter = 0;
        this.methodAttributeAccess = new HashMap<String, Set<String>>();
        Object result = super.visit(node, data);
        double tcc = this.calculateTcc();
        if (this.wmcCounter >= 47 && this.atfdCounter > 5 && tcc < 0.3333333333333333) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getMessage());
            sb.append(" (").append("WMC=").append(this.wmcCounter).append(", ").append("ATFD=").append(this.atfdCounter).append(", ").append("TCC=").append(tcc).append(')');
            RuleContext ctx = (RuleContext)data;
            ctx.getReport().addRuleViolation(new JavaRuleViolation((Rule)this, ctx, node, sb.toString()));
        }
        return result;
    }

    private double calculateTcc() {
        double tcc = 0.0;
        int methodPairs = this.determineMethodPairs();
        double totalMethodPairs = this.calculateTotalMethodPairs();
        if (totalMethodPairs > 0.0) {
            tcc = (double)methodPairs / totalMethodPairs;
        }
        return tcc;
    }

    private double calculateTotalMethodPairs() {
        int methodCount = this.methodAttributeAccess.size();
        int n = methodCount - 1;
        double totalMethodPairs = (double)(n * (n + 1)) / 2.0;
        return totalMethodPairs;
    }

    private int determineMethodPairs() {
        ArrayList<String> methods = new ArrayList<String>(this.methodAttributeAccess.keySet());
        int methodCount = methods.size();
        int pairs = 0;
        if (methodCount > 1) {
            for (int i = 0; i < methodCount; ++i) {
                for (int j = i + 1; j < methodCount; ++j) {
                    String firstMethodName = (String)methods.get(i);
                    String secondMethodName = (String)methods.get(j);
                    Set<String> accessesOfFirstMethod = this.methodAttributeAccess.get(firstMethodName);
                    Set<String> accessesOfSecondMethod = this.methodAttributeAccess.get(secondMethodName);
                    HashSet<String> combinedAccesses = new HashSet<String>();
                    combinedAccesses.addAll(accessesOfFirstMethod);
                    combinedAccesses.addAll(accessesOfSecondMethod);
                    if (combinedAccesses.size() >= accessesOfFirstMethod.size() + accessesOfSecondMethod.size()) continue;
                    ++pairs;
                }
            }
        }
        return pairs;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        if (this.isForeignAttributeOrMethod(node)) {
            if (this.isAttributeAccess(node) || this.isMethodCall(node) && this.isForeignGetterSetterCall(node)) {
                ++this.atfdCounter;
            }
        } else if (this.currentMethodName != null) {
            Set<String> methodAccess = this.methodAttributeAccess.get(this.currentMethodName);
            String variableName = this.getVariableName(node);
            VariableNameDeclaration variableDeclaration = this.findVariableDeclaration(variableName, node.getScope().getEnclosingScope(ClassScope.class));
            if (variableDeclaration != null) {
                methodAccess.add(variableName);
            }
        }
        return super.visit(node, data);
    }

    private boolean isForeignGetterSetterCall(ASTPrimaryExpression node) {
        String methodOrAttributeName = this.getMethodOrAttributeName(node);
        return methodOrAttributeName != null && StringUtil.startsWithAny(methodOrAttributeName, "get", "is", "set");
    }

    private boolean isMethodCall(ASTPrimaryExpression node) {
        boolean result = false;
        List<ASTPrimarySuffix> suffixes = node.findDescendantsOfType(ASTPrimarySuffix.class);
        if (suffixes.size() == 1) {
            result = suffixes.get(0).isArguments();
        }
        return result;
    }

    private boolean isForeignAttributeOrMethod(ASTPrimaryExpression node) {
        boolean result = false;
        String nameImage = this.getNameImage(node);
        result = nameImage != null && (!nameImage.contains(".") || nameImage.startsWith("this.")) ? false : (nameImage == null && node.getFirstDescendantOfType(ASTPrimaryPrefix.class).usesThisModifier() ? false : nameImage != null || !node.hasDecendantOfAnyType(ASTLiteral.class, ASTAllocationExpression.class));
        return result;
    }

    private String getNameImage(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix = node.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        ASTName name = prefix.getFirstDescendantOfType(ASTName.class);
        String image = null;
        if (name != null) {
            image = name.getImage();
        }
        return image;
    }

    private String getVariableName(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix = node.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        ASTName name = prefix.getFirstDescendantOfType(ASTName.class);
        String variableName = null;
        if (name != null) {
            int dotIndex = name.getImage().indexOf(".");
            variableName = dotIndex == -1 ? name.getImage() : name.getImage().substring(0, dotIndex);
        }
        return variableName;
    }

    private String getMethodOrAttributeName(ASTPrimaryExpression node) {
        int dotIndex;
        ASTPrimaryPrefix prefix = node.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        ASTName name = prefix.getFirstDescendantOfType(ASTName.class);
        String methodOrAttributeName = null;
        if (name != null && (dotIndex = name.getImage().indexOf(".")) > -1) {
            methodOrAttributeName = name.getImage().substring(dotIndex + 1);
        }
        return methodOrAttributeName;
    }

    private VariableNameDeclaration findVariableDeclaration(String variableName, Scope scope) {
        VariableNameDeclaration result = null;
        for (VariableNameDeclaration declaration : scope.getDeclarations(VariableNameDeclaration.class).keySet()) {
            if (!declaration.getImage().equals(variableName)) continue;
            result = declaration;
            break;
        }
        if (result == null && scope.getParent() != null && !(scope.getParent() instanceof SourceFileScope)) {
            result = this.findVariableDeclaration(variableName, scope.getParent());
        }
        return result;
    }

    private boolean isAttributeAccess(ASTPrimaryExpression node) {
        return node.findDescendantsOfType(ASTPrimarySuffix.class).isEmpty();
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        ++this.wmcCounter;
        this.currentMethodName = node.getFirstChildOfType(ASTMethodDeclarator.class).getImage();
        this.methodAttributeAccess.put(this.currentMethodName, new HashSet());
        Object result = super.visit(node, data);
        this.currentMethodName = null;
        return result;
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalAndExpression node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTSwitchLabel node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTCatchStatement node, Object data) {
        ++this.wmcCounter;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            ++this.wmcCounter;
        }
        return super.visit(node, data);
    }
}

