/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.comments;

import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.rule.comments.AbstractCommentRule;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;

public class HeaderCommentsRule
extends AbstractCommentRule {
    private static final String[] requiredWords = new String[]{"copyright"};
    private static final String[] requiredTags = new String[]{"author", "version"};
    public static final StringMultiProperty REQUIRED_TERMS_DESCRIPTOR = new StringMultiProperty("requiredTerms", "Expected terms or phrases in the code header", requiredWords, 1.0f, '|');
    public static final StringMultiProperty REQUIRED_TAGS_DESCRIPTOR = new StringMultiProperty("requiredTags", "Expected tags in the header", requiredTags, 2.0f, '|');
    public static final EnumeratedProperty<RequiredHeaderPlacement> HEADER_PLACEMENT_DESCRIPTOR = new EnumeratedProperty<RequiredHeaderPlacement>("headerPlacement", "Placement of the header comment", RequiredHeaderPlacement.labels(), RequiredHeaderPlacement.values(), 0, 3.0f);

    public HeaderCommentsRule() {
        this.definePropertyDescriptor(REQUIRED_TERMS_DESCRIPTOR);
        this.definePropertyDescriptor(REQUIRED_TAGS_DESCRIPTOR);
        this.definePropertyDescriptor(HEADER_PLACEMENT_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        return super.visit(cUnit, data);
    }

    static enum RequiredHeaderPlacement {
        BeforePackageDeclaration("Before package"),
        BeforeImportStatements("Before imports"),
        BeforeTypeDeclaration("Before types"),
        Anywhere("Anywhere");

        private final String label;

        private RequiredHeaderPlacement(String theLabel) {
            this.label = theLabel;
        }

        public static String[] labels() {
            String[] labels = new String[RequiredHeaderPlacement.values().length];
            int i = 0;
            for (RequiredHeaderPlacement placement : RequiredHeaderPlacement.values()) {
                labels[i++] = placement.label;
            }
            return labels;
        }
    }
}

