/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codesize;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.util.NumericConstants;

public class TooManyFieldsRule
extends AbstractJavaRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private Map<String, Integer> stats;
    private Map<String, ASTClassOrInterfaceDeclaration> nodes;
    private static final IntegerProperty MAX_FIELDS_DESCRIPTOR = new IntegerProperty("maxfields", "Max allowable fields", 1, 300, 15, 1.0f);

    public TooManyFieldsRule() {
        this.definePropertyDescriptor(MAX_FIELDS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        int maxFields = this.getProperty(MAX_FIELDS_DESCRIPTOR);
        this.stats = new HashMap<String, Integer>(5);
        this.nodes = new HashMap<String, ASTClassOrInterfaceDeclaration>(5);
        List<ASTFieldDeclaration> l = node.findDescendantsOfType(ASTFieldDeclaration.class);
        for (ASTFieldDeclaration fd : l) {
            ASTClassOrInterfaceDeclaration clazz;
            if (fd.isFinal() && fd.isStatic() || (clazz = fd.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) == null || clazz.isInterface()) continue;
            this.bumpCounterFor(clazz);
        }
        for (String k : this.stats.keySet()) {
            int val = this.stats.get(k);
            Node n = this.nodes.get(k);
            if (val <= maxFields) continue;
            this.addViolation(data, n);
        }
        return data;
    }

    private void bumpCounterFor(ASTClassOrInterfaceDeclaration clazz) {
        String key = clazz.getImage();
        if (!this.stats.containsKey(key)) {
            this.stats.put(key, NumericConstants.ZERO);
            this.nodes.put(key, clazz);
        }
        Integer i = this.stats.get(key) + 1;
        this.stats.put(key, i);
    }
}

