/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptParserVisitor;
import net.sourceforge.pmd.lang.ecmascript.ast.SourceCodePositioner;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;

public abstract class AbstractEcmascriptNode<T extends AstNode>
extends AbstractNode
implements EcmascriptNode<T> {
    protected final T node;

    public AbstractEcmascriptNode(T node) {
        super(((Node)node).getType());
        this.node = node;
    }

    void calculateLineNumbers(SourceCodePositioner positioner) {
        int startOffset = ((AstNode)this.node).getAbsolutePosition();
        int endOffset = startOffset + ((AstNode)this.node).getLength();
        this.beginLine = positioner.lineNumberFromOffset(startOffset);
        this.beginColumn = positioner.columnFromOffset(startOffset);
        this.endLine = positioner.lineNumberFromOffset(endOffset);
        this.endColumn = positioner.columnFromOffset(endOffset) - 1;
        if (this.endColumn < 0) {
            this.endColumn = 0;
        }
    }

    @Override
    public Object jjtAccept(EcmascriptParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object childrenAccept(EcmascriptParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                EcmascriptNode ecmascriptNode = (EcmascriptNode)this.children[i];
                ecmascriptNode.jjtAccept(visitor, data);
            }
        }
        return data;
    }

    @Override
    public T getNode() {
        return this.node;
    }

    @Override
    public String getJsDoc() {
        return ((Node)this.node).getJsDoc();
    }

    @Override
    public boolean hasSideEffects() {
        return ((AstNode)this.node).hasSideEffects();
    }

    @Override
    public String toString() {
        return ((AstNode)this.node).shortName();
    }
}

