/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.HashMap;
import java.util.Map;

public class NodeType {
    public static final int IF_EXPR = 1;
    public static final int IF_LAST_STATEMENT = 2;
    public static final int IF_LAST_STATEMENT_WITHOUT_ELSE = 3;
    public static final int ELSE_LAST_STATEMENT = 4;
    public static final int WHILE_EXPR = 10;
    public static final int WHILE_LAST_STATEMENT = 11;
    public static final int SWITCH_START = 20;
    public static final int CASE_LAST_STATEMENT = 21;
    public static final int SWITCH_LAST_DEFAULT_STATEMENT = 22;
    public static final int SWITCH_END = 23;
    public static final int FOR_INIT = 30;
    public static final int FOR_EXPR = 31;
    public static final int FOR_UPDATE = 32;
    public static final int FOR_BEFORE_FIRST_STATEMENT = 33;
    public static final int FOR_END = 34;
    public static final int DO_BEFORE_FIRST_STATEMENT = 40;
    public static final int DO_EXPR = 41;
    public static final int RETURN_STATEMENT = 50;
    public static final int BREAK_STATEMENT = 51;
    public static final int CONTINUE_STATEMENT = 52;
    public static final int LABEL_STATEMENT = 60;
    public static final int LABEL_LAST_STATEMENT = 61;
    public static final int THROW_STATEMENT = 70;
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public static Map<Integer, String> getTypeMap() {
        return typeMap;
    }

    public static String stringFromType(int intype) {
        if (-1 == intype) {
            return "<ROOT>";
        }
        if (!typeMap.containsKey(intype)) {
            throw new RuntimeException("Couldn't find NodeType type id " + intype);
        }
        return typeMap.get(intype);
    }

    static {
        typeMap.put(1, "IF_EXPR");
        typeMap.put(2, "IF_LAST_STATEMENT");
        typeMap.put(3, "IF_LAST_STATEMENT_WITHOUT_ELSE");
        typeMap.put(4, "ELSE_LAST_STATEMENT");
        typeMap.put(11, "WHILE_LAST_STATEMENT");
        typeMap.put(10, "WHILE_EXPR");
        typeMap.put(20, "SWITCH_START");
        typeMap.put(21, "CASE_LAST_STATEMENT");
        typeMap.put(22, "SWITCH_LAST_DEFAULT_STATEMENT");
        typeMap.put(23, "SWITCH_END");
        typeMap.put(30, "FOR_INIT");
        typeMap.put(31, "FOR_EXPR");
        typeMap.put(32, "FOR_UPDATE");
        typeMap.put(33, "FOR_BEFORE_FIRST_STATEMENT");
        typeMap.put(34, "FOR_END");
        typeMap.put(40, "DO_BEFORE_FIRST_STATEMENT");
        typeMap.put(41, "DO_EXPR");
        typeMap.put(50, "RETURN_STATEMENT");
        typeMap.put(51, "BREAK_STATEMENT");
        typeMap.put(52, "CONTINUE_STATEMENT");
        typeMap.put(60, "LABEL_STATEMENT");
        typeMap.put(61, "LABEL_END");
        typeMap.put(70, "THROW_STATEMENT");
    }
}

