/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.NodeType;
import net.sourceforge.pmd.lang.dfa.VariableAccess;

public abstract class AbstractDataFlowNode
implements DataFlowNode {
    protected Node node;
    protected List<DataFlowNode> parents = new ArrayList<DataFlowNode>();
    protected List<DataFlowNode> children = new ArrayList<DataFlowNode>();
    protected BitSet type = new BitSet();
    protected List<VariableAccess> variableAccess = new ArrayList<VariableAccess>();
    protected List<DataFlowNode> dataFlow;
    protected int line;

    public AbstractDataFlowNode(List<DataFlowNode> dataFlow) {
        this.dataFlow = dataFlow;
        if (!this.dataFlow.isEmpty()) {
            DataFlowNode parent = this.dataFlow.get(this.dataFlow.size() - 1);
            parent.addPathToChild(this);
        }
        this.dataFlow.add(this);
    }

    public AbstractDataFlowNode(List<DataFlowNode> dataFlow, Node node) {
        this(dataFlow);
        this.node = node;
        node.setDataFlowNode(this);
        this.line = node.getBeginLine();
    }

    @Override
    public void addPathToChild(DataFlowNode child) {
        DataFlowNode thisChild = child;
        if (!this.children.contains(thisChild) || this.equals(thisChild)) {
            this.children.add(thisChild);
            thisChild.getParents().add(this);
        }
    }

    @Override
    public boolean removePathToChild(DataFlowNode child) {
        DataFlowNode thisChild = child;
        thisChild.getParents().remove(this);
        return this.children.remove(thisChild);
    }

    @Override
    public void reverseParentPathsTo(DataFlowNode destination) {
        while (!this.parents.isEmpty()) {
            DataFlowNode parent = this.parents.get(0);
            parent.removePathToChild(this);
            parent.addPathToChild(destination);
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setType(int type) {
        this.type.set(type);
    }

    @Override
    public boolean isType(int intype) {
        try {
            return this.type.get(intype);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public List<DataFlowNode> getChildren() {
        return this.children;
    }

    @Override
    public List<DataFlowNode> getParents() {
        return this.parents;
    }

    @Override
    public List<DataFlowNode> getFlow() {
        return this.dataFlow;
    }

    @Override
    public int getIndex() {
        return this.dataFlow.indexOf(this);
    }

    @Override
    public void setVariableAccess(List<VariableAccess> variableAccess) {
        if (this.variableAccess.isEmpty()) {
            this.variableAccess = variableAccess;
        } else {
            this.variableAccess.addAll(variableAccess);
        }
    }

    @Override
    public List<VariableAccess> getVariableAccess() {
        return this.variableAccess;
    }

    public String toString() {
        String res = "DataFlowNode: line " + this.getLine() + ", ";
        String tmp = this.type.toString();
        String newTmp = "";
        for (char c : tmp.toCharArray()) {
            if (c == '{' || c == '}' || c == ' ') continue;
            newTmp = newTmp + c;
        }
        StringTokenizer st = new StringTokenizer(newTmp, ",");
        while (st.hasMoreTokens()) {
            int newTmpInt = Integer.parseInt(st.nextToken());
            res = res + "(" + this.stringFromType(newTmpInt) + ")";
        }
        res = res + ", " + this.node.getClass().getName().substring(this.node.getClass().getName().lastIndexOf(46) + 1);
        res = res + (this.node.getImage() == null ? "" : "(" + this.node.getImage() + ")");
        return res;
    }

    private String stringFromType(int intype) {
        return NodeType.stringFromType(intype);
    }
}

