/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.TokenEntry;

public class Match
implements Comparable<Match> {
    private int tokenCount;
    private int lineCount;
    private Set<TokenEntry> markSet = new TreeSet<TokenEntry>();
    private String code;
    private String label;
    public static final Comparator<Match> MATCHES_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getMarkCount() - ma.getMarkCount();
        }
    };
    public static final Comparator<Match> LINES_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getLineCount() - ma.getLineCount();
        }
    };
    public static final Comparator<Match> LABEL_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            if (ma.getLabel() == null) {
                return 1;
            }
            if (mb.getLabel() == null) {
                return -1;
            }
            return mb.getLabel().compareTo(ma.getLabel());
        }
    };
    public static final Comparator<Match> LENGTH_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getLineCount() - ma.getLineCount();
        }
    };

    public Match(int tokenCount, TokenEntry first, TokenEntry second) {
        this.markSet.add(first);
        this.markSet.add(second);
        this.tokenCount = tokenCount;
    }

    public int getMarkCount() {
        return this.markSet.size();
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getSourceCodeSlice() {
        return this.code;
    }

    public void setSourceCodeSlice(String code) {
        this.code = code;
    }

    public Iterator<TokenEntry> iterator() {
        return this.markSet.iterator();
    }

    @Override
    public int compareTo(Match other) {
        int diff = other.getTokenCount() - this.getTokenCount();
        if (diff != 0) {
            return diff;
        }
        return this.getFirstMark().getIndex() - other.getFirstMark().getIndex();
    }

    public TokenEntry getFirstMark() {
        return this.getMark(0);
    }

    public TokenEntry getSecondMark() {
        return this.getMark(1);
    }

    public String toString() {
        return "Match: " + PMD.EOL + "tokenCount = " + this.tokenCount + PMD.EOL + "marks = " + this.markSet.size();
    }

    public Set<TokenEntry> getMarkSet() {
        return this.markSet;
    }

    public int getEndIndex() {
        return this.getMark(0).getIndex() + this.getTokenCount() - 1;
    }

    public void setMarkSet(Set<TokenEntry> markSet) {
        this.markSet = markSet;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void addTokenEntry(TokenEntry entry) {
        this.markSet.add(entry);
    }

    private TokenEntry getMark(int index) {
        TokenEntry result = null;
        Iterator<TokenEntry> it = this.markSet.iterator();
        for (int i = 0; it.hasNext() && i < index + 1; ++i) {
            result = it.next();
        }
        return result;
    }
}

