/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.java.ast.Token;

public class JavaTokenizer
implements Tokenizer {
    public static final String IGNORE_LITERALS = "ignore_literals";
    public static final String IGNORE_IDENTIFIERS = "ignore_identifiers";
    public static final String IGNORE_ANNOTATIONS = "ignore_annotations";
    public static final String CPD_START = "\"CPD-START\"";
    public static final String CPD_END = "\"CPD-END\"";
    private boolean ignoreAnnotations;
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;

    public void setProperties(Properties properties) {
        this.ignoreAnnotations = Boolean.parseBoolean(properties.getProperty(IGNORE_ANNOTATIONS, "false"));
        this.ignoreLiterals = Boolean.parseBoolean(properties.getProperty(IGNORE_LITERALS, "false"));
        this.ignoreIdentifiers = Boolean.parseBoolean(properties.getProperty(IGNORE_IDENTIFIERS, "false"));
    }

    @Override
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder stringBuilder = sourceCode.getCodeBuffer();
        LanguageVersionHandler languageVersionHandler = LanguageVersion.JAVA_14.getLanguageVersionHandler();
        String fileName = sourceCode.getFileName();
        TokenManager tokenMgr = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions()).getTokenManager(fileName, new StringReader(stringBuilder.toString()));
        Token currentToken = (Token)tokenMgr.getNextToken();
        TokenDiscarder discarder = new TokenDiscarder(this.ignoreAnnotations);
        while (currentToken.image.length() > 0) {
            discarder.updateState(currentToken);
            if (discarder.isDiscarding()) {
                currentToken = (Token)tokenMgr.getNextToken();
                continue;
            }
            this.processToken(tokenEntries, fileName, currentToken);
            currentToken = (Token)tokenMgr.getNextToken();
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    private void processToken(Tokens tokenEntries, String fileName, Token currentToken) {
        String image = currentToken.image;
        if (this.ignoreLiterals && (currentToken.kind == 72 || currentToken.kind == 71 || currentToken.kind == 64 || currentToken.kind == 68)) {
            image = String.valueOf(currentToken.kind);
        }
        if (this.ignoreIdentifiers && currentToken.kind == 73) {
            image = String.valueOf(currentToken.kind);
        }
        tokenEntries.add(new TokenEntry(image, fileName, currentToken.beginLine));
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    private static class TokenDiscarder {
        private boolean isAnnotation = false;
        private boolean nextTokenEndsAnnotation = false;
        private int annotationStack = 0;
        private boolean discardingSemicolon = false;
        private boolean discardingKeywords = false;
        private boolean discardingSuppressing = false;
        private boolean discardingAnnotations = false;
        private boolean ignoreAnnotations = false;

        public TokenDiscarder(boolean ignoreAnnotations) {
            this.ignoreAnnotations = ignoreAnnotations;
        }

        public void updateState(Token currentToken) {
            this.detectAnnotations(currentToken);
            this.skipSemicolon(currentToken);
            this.skipPackageAndImport(currentToken);
            this.skipCPDSuppression(currentToken);
            if (this.ignoreAnnotations) {
                this.skipAnnotations();
            }
        }

        public void skipPackageAndImport(Token currentToken) {
            if (currentToken.kind == 43 || currentToken.kind == 35) {
                this.discardingKeywords = true;
            } else if (this.discardingKeywords && currentToken.kind == 82) {
                this.discardingKeywords = false;
            }
        }

        public void skipSemicolon(Token currentToken) {
            if (currentToken.kind == 82) {
                this.discardingSemicolon = true;
            } else if (this.discardingSemicolon && currentToken.kind != 82) {
                this.discardingSemicolon = false;
            }
        }

        public void skipCPDSuppression(Token currentToken) {
            if (this.isAnnotation) {
                if (!this.discardingSuppressing && currentToken.kind == 72 && JavaTokenizer.CPD_START.equals(currentToken.image)) {
                    this.discardingSuppressing = true;
                } else if (this.discardingSuppressing && currentToken.kind == 72 && JavaTokenizer.CPD_END.equals(currentToken.image)) {
                    this.discardingSuppressing = false;
                }
            }
        }

        public void skipAnnotations() {
            if (!this.discardingAnnotations && this.isAnnotation) {
                this.discardingAnnotations = true;
            } else if (this.discardingAnnotations && !this.isAnnotation) {
                this.discardingAnnotations = false;
            }
        }

        public boolean isDiscarding() {
            boolean result = this.discardingSemicolon || this.discardingKeywords || this.discardingAnnotations || this.discardingSuppressing;
            return result;
        }

        public void detectAnnotations(Token currentToken) {
            if (this.isAnnotation && this.nextTokenEndsAnnotation) {
                this.isAnnotation = false;
                this.nextTokenEndsAnnotation = false;
            }
            if (this.isAnnotation) {
                if (currentToken.kind == 76) {
                    ++this.annotationStack;
                } else if (currentToken.kind == 77) {
                    --this.annotationStack;
                    if (this.annotationStack == 0) {
                        this.nextTokenEndsAnnotation = true;
                    }
                } else if (this.annotationStack == 0 && currentToken.kind != 73 && currentToken.kind != 76) {
                    this.isAnnotation = false;
                }
            }
            if (currentToken.kind == 85) {
                this.isAnnotation = true;
            }
        }
    }
}

