/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.apache.commons.io.IOUtils;

public class CsTokenizer
implements Tokenizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        BufferedReader reader = new BufferedReader(new CharArrayReader(sourceCode.getCodeBuffer().toString().toCharArray()));
        try {
            int ic = reader.read();
            int line = 1;
            block20: while (ic != -1) {
                StringBuilder b;
                char c = (char)ic;
                switch (c) {
                    case '\n': {
                        ++line;
                        ic = reader.read();
                        continue block20;
                    }
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        ic = reader.read();
                        continue block20;
                    }
                    case ';': {
                        ic = reader.read();
                        continue block20;
                    }
                    case '<': 
                    case '>': {
                        ic = reader.read();
                        if (ic == 61) {
                            tokenEntries.add(new TokenEntry(String.valueOf(c) + "=", sourceCode.getFileName(), line));
                            ic = reader.read();
                            continue block20;
                        }
                        if (ic == c) {
                            ic = reader.read();
                            if (ic == 61) {
                                tokenEntries.add(new TokenEntry(String.valueOf(c) + String.valueOf(c) + "=", sourceCode.getFileName(), line));
                                ic = reader.read();
                                continue block20;
                            }
                            tokenEntries.add(new TokenEntry(String.valueOf(c) + String.valueOf(c), sourceCode.getFileName(), line));
                            continue block20;
                        }
                        tokenEntries.add(new TokenEntry(String.valueOf(c), sourceCode.getFileName(), line));
                        continue block20;
                    }
                    case '&': 
                    case '+': 
                    case '-': 
                    case '=': 
                    case '|': {
                        ic = reader.read();
                        if (ic == 61 || ic == c) {
                            tokenEntries.add(new TokenEntry(String.valueOf(c) + String.valueOf((char)ic), sourceCode.getFileName(), line));
                            ic = reader.read();
                            continue block20;
                        }
                        tokenEntries.add(new TokenEntry(String.valueOf(c), sourceCode.getFileName(), line));
                        continue block20;
                    }
                    case '!': 
                    case '%': 
                    case '*': 
                    case '^': 
                    case '~': {
                        ic = reader.read();
                        if (ic == 61) {
                            tokenEntries.add(new TokenEntry(String.valueOf(c) + "=", sourceCode.getFileName(), line));
                            ic = reader.read();
                            continue block20;
                        }
                        tokenEntries.add(new TokenEntry(String.valueOf(c), sourceCode.getFileName(), line));
                        continue block20;
                    }
                    case '\"': 
                    case '\'': {
                        b = new StringBuilder();
                        b.append(c);
                        while ((ic = reader.read()) != c && ic != -1) {
                            int next;
                            b.append((char)ic);
                            if (ic != 92 || (next = reader.read()) == -1) continue;
                            b.append((char)next);
                        }
                        if (ic != -1) {
                            b.append((char)ic);
                        }
                        tokenEntries.add(new TokenEntry(b.toString(), sourceCode.getFileName(), line));
                        ic = reader.read();
                        continue block20;
                    }
                    case '/': {
                        ic = reader.read();
                        c = (char)ic;
                        block12 : switch (c) {
                            case '*': {
                                int state = 1;
                                b = new StringBuilder();
                                b.append("/*");
                                while ((ic = reader.read()) != -1) {
                                    c = (char)ic;
                                    b.append(c);
                                    if (state == 1) {
                                        if (c != '*') continue;
                                        state = 2;
                                        continue;
                                    }
                                    if (c == '/') {
                                        ic = reader.read();
                                        break block12;
                                    }
                                    if (c == '*') continue;
                                    state = 1;
                                }
                                continue block20;
                            }
                            case '/': {
                                b = new StringBuilder();
                                b.append("//");
                                while ((ic = reader.read()) != 10) {
                                    if (ic == -1) break block12;
                                    b.append((char)ic);
                                }
                                continue block20;
                            }
                            case '=': {
                                tokenEntries.add(new TokenEntry("/=", sourceCode.getFileName(), line));
                                ic = reader.read();
                                break;
                            }
                            default: {
                                tokenEntries.add(new TokenEntry("/", sourceCode.getFileName(), line));
                            }
                        }
                        continue block20;
                    }
                }
                if (Character.isJavaIdentifierStart(c)) {
                    b = new StringBuilder();
                    do {
                        b.append(c);
                    } while (Character.isJavaIdentifierPart(c = (char)(ic = reader.read())));
                    tokenEntries.add(new TokenEntry(b.toString(), sourceCode.getFileName(), line));
                    continue;
                }
                if (Character.isDigit(c) || c == '.') {
                    b = new StringBuilder();
                    do {
                        b.append(c);
                        if (c != 'e' && c != 'E') continue;
                        ic = reader.read();
                        c = (char)ic;
                        if ("1234567890-".indexOf(c) == -1) break;
                        b.append(c);
                    } while ("1234567890.iIlLfFdDsSuUeExX".indexOf(c = (char)(ic = reader.read())) != -1);
                    tokenEntries.add(new TokenEntry(b.toString(), sourceCode.getFileName(), line));
                    continue;
                }
                tokenEntries.add(new TokenEntry(String.valueOf(c), sourceCode.getFileName(), line));
                ic = reader.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(reader);
            tokenEntries.add(TokenEntry.getEOF());
        }
    }
}

