/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.Properties;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.cli.PMDParameters;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;

public class PMDCommandLineInterface {
    public static final String PROG_NAME = "pmd";
    public static final String NO_EXIT_AFTER_RUN = "net.sourceforge.pmd.cli.noExit";
    public static final String STATUS_CODE_PROPERTY = "net.sourceforge.pmd.cli.status";
    public static final int ERROR_STATUS = 1;

    public static PMDParameters extractParameters(PMDParameters arguments, String[] args, String progName) {
        JCommander jcommander = new JCommander(arguments);
        jcommander.setProgramName(progName);
        try {
            jcommander.parse(args);
            if (arguments.isHelp()) {
                jcommander.usage();
                System.out.println(PMDCommandLineInterface.buildUsageText(jcommander));
                PMDCommandLineInterface.setStatusCodeOrExit(0);
            }
        }
        catch (ParameterException e) {
            jcommander.usage();
            System.out.println(PMDCommandLineInterface.buildUsageText(jcommander));
            System.out.println(e.getMessage());
            PMDCommandLineInterface.setStatusCodeOrExit(1);
        }
        return arguments;
    }

    public static String buildUsageText() {
        return PMDCommandLineInterface.buildUsageText(null);
    }

    public static String buildUsageText(JCommander jcommander) {
        StringBuilder usage = new StringBuilder();
        String allCommandsDescription = null;
        if (jcommander != null && jcommander.getCommands() != null) {
            for (String command : jcommander.getCommands().keySet()) {
                allCommandsDescription = allCommandsDescription + jcommander.getCommandDescription(command) + PMD.EOL;
            }
        }
        String fullText = PMD.EOL + "Mandatory arguments:" + PMD.EOL + "1) A java source code filename or directory" + PMD.EOL + "2) A report format " + PMD.EOL + "3) A ruleset filename or a comma-delimited string of ruleset filenames" + PMD.EOL + PMD.EOL + "For example: " + PMD.EOL + PMDCommandLineInterface.getWindowsLaunchCmd() + " -d c:\\my\\source\\code -f html -R java-unusedcode" + PMD.EOL + PMD.EOL;
        fullText = fullText + PMDCommandLineInterface.supportedVersions() + PMD.EOL;
        if (allCommandsDescription != null) {
            fullText = fullText + "Optional arguments that may be put before or after the mandatory arguments: " + PMD.EOL + allCommandsDescription + PMD.EOL;
        }
        fullText = fullText + "Available report formats and their configuration properties are:" + PMD.EOL + PMDCommandLineInterface.getReports() + PMD.EOL + PMDCommandLineInterface.getExamples() + PMD.EOL + PMD.EOL + PMD.EOL;
        fullText = fullText + usage.toString();
        return fullText;
    }

    private static String getExamples() {
        return PMDCommandLineInterface.getWindowsExample() + PMDCommandLineInterface.getUnixExample();
    }

    private static String getWindowsLaunchCmd() {
        String WINDOWS_PROMPT = "C:\\>";
        String launchCmd = "pmd-bin-" + PMD.VERSION + "\\bin\\pmd.bat";
        return "C:\\>" + launchCmd;
    }

    private static String getWindowsExample() {
        String launchCmd = PMDCommandLineInterface.getWindowsLaunchCmd();
        String WINDOWS_PATH_TO_CODE = "c:\\my\\source\\code ";
        return "For example on windows: " + PMD.EOL + launchCmd + " -dir " + "c:\\my\\source\\code " + "-format text -R java-unusedcode,java-imports -version 1.5 -language java -debug" + PMD.EOL + launchCmd + " -dir " + "c:\\my\\source\\code " + "-f xml -rulesets java-basic,java-design -encoding UTF-8" + PMD.EOL + launchCmd + " -d " + "c:\\my\\source\\code " + "-rulesets java-typeresolution -auxclasspath commons-collections.jar;derby.jar" + PMD.EOL + launchCmd + " -d " + "c:\\my\\source\\code " + "-f html -R java-typeresolution -auxclasspath file:///C:/my/classpathfile" + PMD.EOL + PMD.EOL;
    }

    private static String getUnixExample() {
        String UNIX_PROMPT = "$ ";
        String launchCmd = "pmd-bin-" + PMD.VERSION + "/bin/run.sh pmd";
        return "For example on *nix: " + PMD.EOL + "$ " + launchCmd + " -dir /home/workspace/src/main/java/code -f html -rulesets java-basic,java-design" + PMD.EOL + "$ " + launchCmd + " -d ./src/main/java/code -f xslt -R java-basic,java-design -property xsltFilename=my-own.xsl" + PMD.EOL + "$ " + launchCmd + " -d ./src/main/java/code -f html -R java-typeresolution -auxclasspath commons-collections.jar:derby.jar" + PMD.EOL;
    }

    private static String supportedVersions() {
        return "Languages and version suported:" + PMD.EOL + Language.commaSeparatedTerseNames(Language.findWithRuleSupport()) + PMD.EOL + "Note that some language are not supported by PMD - only by CPD" + PMD.EOL;
    }

    public static void main(String[] args) {
        System.out.println(PMDCommandLineInterface.buildUsageText());
    }

    public static String jarName() {
        return "pmd-" + PMD.VERSION + ".jar";
    }

    private static String getReports() {
        StringBuilder buf = new StringBuilder();
        for (String reportName : RendererFactory.REPORT_FORMAT_TO_RENDERER.keySet()) {
            Renderer renderer = RendererFactory.createRenderer(reportName, new Properties());
            buf.append("   ").append(reportName).append(": ");
            if (!reportName.equals(renderer.getName())) {
                buf.append(" Deprecated alias for '" + renderer.getName()).append(PMD.EOL);
                continue;
            }
            buf.append(renderer.getDescription()).append(PMD.EOL);
            for (PropertyDescriptor<?> property2 : renderer.getPropertyDescriptors()) {
                buf.append("        ").append(property2.name()).append(" - ");
                buf.append(property2.description());
                Object deflt = property2.defaultValue();
                if (deflt != null) {
                    buf.append("   default: ").append(deflt);
                }
                buf.append(PMD.EOL);
            }
        }
        return buf.toString();
    }

    public static void run(String[] args) {
        PMDCommandLineInterface.setStatusCodeOrExit(PMD.run(args));
    }

    public static void setStatusCodeOrExit(int status) {
        if (PMDCommandLineInterface.isExitAfterRunSet()) {
            System.exit(status);
        } else {
            PMDCommandLineInterface.setStatusCode(status);
        }
    }

    private static boolean isExitAfterRunSet() {
        return System.getenv(NO_EXIT_AFTER_RUN) != null;
    }

    private static void setStatusCode(int statusCode) {
        System.setProperty(STATUS_CODE_PROPERTY, Integer.toString(statusCode));
    }
}

