/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.pldoc.CommentParser;
import net.sourceforge.pldoc.XMLWriter;
import net.sourceforge.pldoc.parser.JavaCharStreamAdapter;
import net.sourceforge.pldoc.parser.PLSQLParserConstants;
import net.sourceforge.pldoc.parser.PLSQLParserTokenManager;
import net.sourceforge.pldoc.parser.ParseException;
import net.sourceforge.pldoc.parser.SimpleCharStream;
import net.sourceforge.pldoc.parser.Token;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserTokenManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.co.anyware.html.HTMLEscaper;

public class PLSQLParser
implements PLSQLParserConstants {
    static final String[] RESERVED_TAGS = new String[]{"param", "return", "throws"};
    private XMLWriter m_out;
    private boolean ignoreInformalComments = false;
    private String defaultKeywordscase = "upper";
    private String defaultNamescase = "upper";
    private boolean namesDefaultcase = true;
    private boolean namesUppercase = false;
    private boolean namesLowercase = false;
    private boolean keywordsDefaultcase = true;
    private boolean keywordsUppercase = false;
    private boolean keywordsLowercase = false;
    private String schemaName = "";
    private String globalPackageName = "_GLOBAL";
    public PLSQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[492];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private final JJCalls[] jj_2_rtns = new JJCalls[98];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setXMLWriter(XMLWriter out) {
        this.m_out = out;
    }

    public void setIgnoreInformalComments(boolean ignoreInformalComments) {
        this.ignoreInformalComments = ignoreInformalComments;
    }

    public void setNamesDefaultcase(boolean namesUppercase) {
        this.namesDefaultcase = this.namesDefaultcase;
    }

    public void setNamesUppercase(boolean namesUppercase) {
        this.namesUppercase = namesUppercase;
    }

    public void setNamesLowercase(boolean namesLowercase) {
        this.namesLowercase = namesLowercase;
    }

    public void setDefaultNamescase(String defaultNamescase) {
        this.defaultNamescase = defaultNamescase;
    }

    public void setDefaultKeywordscase(String defaultKeywordscase) {
        this.defaultKeywordscase = defaultKeywordscase;
    }

    public void setKeywordsDefaultcase(boolean keywordsDefaultcase) {
        this.keywordsDefaultcase = keywordsDefaultcase;
    }

    public void setKeywordsUppercase(boolean keywordsUppercase) {
        this.keywordsUppercase = keywordsUppercase;
    }

    public void setKeywordsLowercase(boolean keywordsLowercase) {
        this.keywordsLowercase = keywordsLowercase;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setGlobalPackageName(String globalPackageName) {
        this.globalPackageName = globalPackageName;
    }

    void printSummary(String parsedObject, int baseLine, Token startToken, Token endToken) throws SAXException {
        if (baseLine > 0) {
            --baseLine;
        }
        if (null != this.m_out) {
            this.m_out.pushAttribute("START_LINE", Integer.toString(startToken.beginLine - baseLine));
            this.m_out.pushAttribute("START_COLUMN", Integer.toString(startToken.beginColumn));
            this.m_out.pushAttribute("END_LINE", Integer.toString(endToken.beginLine - baseLine));
            this.m_out.pushAttribute("END_COLUMN", Integer.toString(endToken.beginColumn));
            this.m_out.pushAttribute("LINES", Integer.toString(endToken.beginLine - startToken.beginLine + 1));
            this.m_out.startElement("SUMMARY");
            this.m_out.endElement("SUMMARY");
        }
    }

    private void processPackageComment(Token token) throws SAXException {
        Hashtable packageCommentTags = new Hashtable();
        String packageComment = null;
        while (token != null && token.specialToken != null) {
            CommentParser commentParser;
            token = token.specialToken;
            int kind = token.kind;
            String comment = token.toString();
            if (comment != null && kind == 31) continue;
            if (comment == null || kind != 32 || (packageComment = (commentParser = new CommentParser(comment)).getPackageComment()) == null) break;
            packageCommentTags.putAll(commentParser.getTags());
            break;
        }
        this.printPackageComment(packageComment, packageCommentTags);
    }

    private void stringWalk(Token token) throws SAXException {
        while (token != null) {
            System.err.println("stringWalk: [[" + token.toString() + "]]");
            token = token.specialToken;
        }
    }

    private Hashtable processMemberComment(Token token, String elementName, String memberName) throws SAXException {
        return this.processMemberComment(token, elementName, memberName, null);
    }

    private Hashtable processMemberComment(Token token, String elementName, String memberName, Hashtable attributes) throws SAXException {
        String purifiedElementName;
        String commentFirstLine = null;
        String commentAll = null;
        String packageComment = null;
        Object returnComment = null;
        Hashtable tags = new Hashtable();
        Hashtable packageCommentTags = new Hashtable();
        while (token.specialToken != null) {
            token = token.specialToken;
            int kind = token.kind;
            String comment = token.toString();
            if (comment != null && kind == 31 || comment == null || kind != 32 && this.ignoreInformalComments) continue;
            CommentParser commentParser = new CommentParser(comment);
            packageComment = commentParser.getPackageComment();
            if (packageComment != null) {
                packageCommentTags.putAll(commentParser.getTags());
            } else {
                tags.putAll(commentParser.getTags());
            }
            if (commentFirstLine == null) {
                commentFirstLine = commentParser.getMainSentence();
                if (kind != 32) {
                    commentFirstLine = this.ignoreInformalComments ? "" : HTMLEscaper.escape(commentFirstLine);
                }
            }
            if (commentAll != null) continue;
            commentAll = commentParser.getText();
            if (kind == 32) continue;
            if (this.ignoreInformalComments) {
                commentAll = "";
                continue;
            }
            commentAll = HTMLEscaper.escape(commentAll);
        }
        this.printPackageComment(packageComment, packageCommentTags);
        if (null != elementName && null != (purifiedElementName = this.purifyKeyword(elementName)) && !"".equals(purifiedElementName)) {
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(memberName));
            this.printAttributes(attributes);
            this.m_out.startElement(this.purifyKeyword(elementName));
        }
        if (commentFirstLine != null) {
            this.m_out.startElement("COMMENT_FIRST_LINE");
            this.m_out.cdata(commentFirstLine);
            this.m_out.endElement("COMMENT_FIRST_LINE");
        }
        if (commentAll != null) {
            this.m_out.startElement("COMMENT");
            this.m_out.cdata(commentAll);
            this.m_out.endElement("COMMENT");
        }
        return tags;
    }

    private void printPackageComment(String packageComment, Hashtable packageCommentTags) throws SAXException {
        if (packageComment != null) {
            this.m_out.startElement("COMMENT");
            this.m_out.cdata(packageComment);
            this.m_out.endElement("COMMENT");
            this.printCustomTags(packageCommentTags);
        }
    }

    private String getParamComment(String paramName, Hashtable tags) {
        String paramComment = null;
        Collection tagValues = (Collection)tags.get("@param");
        if (tagValues != null) {
            for (String value : tagValues) {
                String extractedParamName = null;
                StringTokenizer st = new StringTokenizer(value);
                if (st.hasMoreTokens()) {
                    extractedParamName = st.nextToken();
                }
                if (extractedParamName == null || !extractedParamName.equalsIgnoreCase(paramName)) continue;
                int paramCommentStart = value.indexOf(extractedParamName) + extractedParamName.length() + 1;
                if (paramCommentStart >= value.length()) break;
                paramComment = value.substring(paramCommentStart).trim();
                break;
            }
        }
        return paramComment;
    }

    private String purifyIdentifier(String name) {
        if (null != name && name.length() > 2 && '\'' == name.charAt(0) && '\'' == name.charAt(name.length() - 1) || null != name && name.length() > 3 && 'Q' == name.toUpperCase().charAt(0) && '\'' == name.charAt(1) && '\'' == name.charAt(name.length() - 1)) {
            return name;
        }
        if (this.namesDefaultcase && -1 == name.indexOf(34) && !this.defaultNamescase.equalsIgnoreCase("mixed")) {
            String string = name = this.defaultNamescase.equalsIgnoreCase("upper") ? name.toUpperCase() : name.toLowerCase();
        }
        if (this.namesUppercase) {
            name = name.toUpperCase();
        }
        if (this.namesLowercase) {
            name = name.toLowerCase();
        }
        StringBuffer s = new StringBuffer(name.trim());
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\"') continue;
            s.deleteCharAt(i);
            --i;
        }
        return s.toString();
    }

    private String purifyKeyword(String keyword) {
        if (this.keywordsDefaultcase) {
            String string = keyword = this.defaultKeywordscase.equalsIgnoreCase("upper") ? keyword.toUpperCase() : keyword.toLowerCase();
        }
        if (this.keywordsUppercase) {
            keyword = keyword.toUpperCase();
        }
        if (this.keywordsLowercase) {
            keyword = keyword.toLowerCase();
        }
        return keyword.trim();
    }

    private void printCustomTags(Map pTags) throws SAXException {
        for (String key : pTags.keySet()) {
            Collection tagValues = (Collection)pTags.get(key);
            if (tagValues == null || this.isReservedTag(key)) continue;
            for (String comment : tagValues) {
                this.printTag(key, comment);
            }
        }
    }

    private void printAttributes(Map attributes) throws SAXException {
        if (null != attributes) {
            for (String key : attributes.keySet()) {
                String value = (String)attributes.get(key);
                this.m_out.pushAttribute(key, this.purifyIdentifier(value));
            }
        }
    }

    private boolean isReservedTag(String pTag) {
        boolean result = false;
        for (int index = 0; index < RESERVED_TAGS.length; ++index) {
            result = result || RESERVED_TAGS[index].equalsIgnoreCase(pTag);
        }
        return result;
    }

    private void printTag(String pTagName, String pComment) throws SAXException {
        this.m_out.pushAttribute("TYPE", this.purifyIdentifier(pTagName));
        this.m_out.startElement("TAG");
        if (pComment != null) {
            this.m_out.startElement("COMMENT");
            this.m_out.cdata(pComment);
            this.m_out.endElement("COMMENT");
        }
        this.m_out.endElement("TAG");
    }

    public static void main(String[] args) throws ParseException, SAXException {
        PLSQLParser parser = new PLSQLParser(System.in);
        parser.input();
        String s = "qwerty";
        s = "\"qwerty\"";
        s = "\"qwerty\".uiop";
        s = "\"qwerty\".\"uiop\"";
    }

    private ASTCompilationUnit fromDelegatedJavaParser() throws ParseException {
        JavaCharStreamAdapter a = new JavaCharStreamAdapter(this.jj_input_stream);
        JavaParserTokenManager tm = new JavaParserTokenManager(a);
        JavaParser jp = new JavaParser(tm);
        jp.setJdkVersion(5);
        ASTCompilationUnit cu = null;
        try {
            cu = jp.CompilationUnit();
            this.jj_input_stream.backup(1);
        }
        catch (net.sourceforge.pmd.lang.java.ast.ParseException javaParseException) {
            String message = javaParseException.getMessage();
            if (message.startsWith("Encountered \" \"/\" \"/ \"\" at line ") || message.contains("Was expecting one of:") || message.contains("<EOF>")) {
                this.jj_input_stream.backup(1);
            }
            ParseException plsqlParseException = new ParseException("Error reported by Java parser: " + message);
            throw (ParseException)plsqlParseException.initCause(javaParseException);
        }
        return cu;
    }

    public final void input() throws ParseException, SAXException {
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 21: 
                case 46: 
                case 56: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 82: 
                case 89: 
                case 92: 
                case 98: 
                case 110: 
                case 112: 
                case 124: 
                case 128: 
                case 142: 
                case 152: 
                case 157: 
                case 163: 
                case 206: 
                case 218: 
                case 220: 
                case 230: 
                case 237: 
                case 238: 
                case 245: 
                case 247: 
                case 250: 
                case 258: 
                case 279: 
                case 281: 
                case 291: 
                case 292: 
                case 294: 
                case 315: 
                case 341: 
                case 342: 
                case 343: 
                case 347: 
                case 348: 
                case 354: 
                case 362: 
                case 374: 
                case 376: 
                case 377: 
                case 378: 
                case 379: 
                case 380: 
                case 381: 
                case 382: 
                case 383: 
                case 384: 
                case 385: 
                case 423: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block21;
                }
            }
            if (this.jj_2_1(8)) {
                this.javaSpec();
            } else if (this.jj_2_2(7)) {
                this.packageSpec();
            } else if (this.jj_2_3(7)) {
                this.packageBody();
            } else if (this.jj_2_4(6)) {
                this.typeSpec();
            } else if (this.jj_2_5(6)) {
                this.table();
            } else if (this.jj_2_6(6)) {
                this.view();
            } else if (this.jj_2_7(6)) {
                this.triggerUnit();
            } else if (this.jj_2_8(6)) {
                this.alterTrigger();
            } else if (this.jj_2_9(6)) {
                this.Synonym();
            } else if (this.jj_2_10(6)) {
                this.Directory();
            } else if (this.jj_2_11(6)) {
                this.DatabaseLink();
            } else if (this.jj_2_12(6)) {
                this.global();
            } else if (this.jj_2_13(4)) {
                this.programUnit(true, null);
            } else if (this.jj_2_14(6)) {
                this.DDLCommand();
            } else if (this.jj_2_15(6)) {
                this.sqlPlusCommand();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: 
                    case 92: 
                    case 142: 
                    case 157: 
                    case 163: 
                    case 238: 
                    case 245: 
                    case 247: 
                    case 294: 
                    case 315: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 247: {
                                this.jj_consume_token(247);
                                break;
                            }
                            case 294: {
                                this.jj_consume_token(294);
                                break;
                            }
                            case 142: {
                                this.jj_consume_token(142);
                                break;
                            }
                            case 92: {
                                this.jj_consume_token(92);
                                break;
                            }
                            case 75: {
                                this.jj_consume_token(75);
                                break;
                            }
                            case 238: {
                                this.jj_consume_token(238);
                                break;
                            }
                            case 245: {
                                this.jj_consume_token(245);
                                break;
                            }
                            case 157: {
                                this.jj_consume_token(157);
                                this.jj_consume_token(268);
                                break;
                            }
                            case 163: {
                                this.jj_consume_token(163);
                                break;
                            }
                            case 315: {
                                this.jj_consume_token(315);
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.skipPastNextTokenOccurrence(436);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        continue block21;
                    }
                }
                this.jj_consume_token(1);
            }
            break;
        }
        this.jj_consume_token(0);
    }

    public final void DDLCommand() throws ParseException {
        this.DDLEvent();
        this.skipPastNextTokenOccurrence(436);
    }

    public final void sqlPlusCommand() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 374: {
                this.jj_consume_token(374);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 376: {
                this.jj_consume_token(376);
                break;
            }
            case 377: {
                this.jj_consume_token(377);
                break;
            }
            case 378: {
                this.jj_consume_token(378);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 379: {
                this.jj_consume_token(379);
                break;
            }
            case 380: {
                this.jj_consume_token(380);
                break;
            }
            case 218: {
                this.jj_consume_token(218);
                break;
            }
            case 381: {
                this.jj_consume_token(381);
                break;
            }
            case 382: {
                this.jj_consume_token(382);
                break;
            }
            case 250: {
                this.jj_consume_token(250);
                break;
            }
            case 291: {
                this.jj_consume_token(291);
                break;
            }
            case 292: {
                this.jj_consume_token(292);
                break;
            }
            case 258: {
                this.jj_consume_token(258);
                break;
            }
            case 383: {
                this.jj_consume_token(383);
                break;
            }
            case 384: {
                this.jj_consume_token(384);
                break;
            }
            case 385: {
                this.jj_consume_token(385);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 237: {
                this.jj_consume_token(237);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 423: {
                this.jj_consume_token(423);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                this.jj_consume_token(386);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.skip2NextTokenOccurrence(31);
    }

    public final void global() throws ParseException, SAXException {
        Object name = null;
        if (this.m_out != null) {
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(this.globalPackageName));
            this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(this.schemaName));
            this.m_out.startElement("PACKAGE");
        }
        this.globalBlock(this.token);
        if (this.m_out != null) {
            this.m_out.endElement("PACKAGE");
        }
    }

    public final void globalBlock(Token objectStart) throws ParseException, SAXException {
        Object name = null;
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block15;
                }
            }
            this.label();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: {
                this.jj_consume_token(89);
                this.declarativeSection(false, objectStart);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(56);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 9: 
                case 18: 
                case 21: 
                case 35: 
                case 36: 
                case 37: 
                case 42: 
                case 43: 
                case 44: 
                case 49: 
                case 52: 
                case 53: 
                case 54: 
                case 56: 
                case 59: 
                case 61: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 79: 
                case 80: 
                case 81: 
                case 83: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 92: 
                case 95: 
                case 99: 
                case 100: 
                case 103: 
                case 105: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 120: 
                case 121: 
                case 122: 
                case 124: 
                case 125: 
                case 126: 
                case 129: 
                case 131: 
                case 132: 
                case 134: 
                case 135: 
                case 138: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 147: 
                case 149: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 157: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 171: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 180: 
                case 181: 
                case 183: 
                case 184: 
                case 191: 
                case 194: 
                case 196: 
                case 197: 
                case 198: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 208: 
                case 210: 
                case 215: 
                case 216: 
                case 219: 
                case 220: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 232: 
                case 234: 
                case 235: 
                case 236: 
                case 238: 
                case 239: 
                case 240: 
                case 241: 
                case 242: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 250: 
                case 254: 
                case 255: 
                case 256: 
                case 257: 
                case 259: 
                case 261: 
                case 262: 
                case 263: 
                case 266: 
                case 267: 
                case 269: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 280: 
                case 281: 
                case 283: 
                case 285: 
                case 289: 
                case 290: 
                case 291: 
                case 293: 
                case 294: 
                case 297: 
                case 298: 
                case 299: 
                case 300: 
                case 301: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 323: 
                case 324: 
                case 327: 
                case 332: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 347: 
                case 348: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 357: 
                case 358: 
                case 359: 
                case 360: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 366: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 376: 
                case 377: 
                case 378: 
                case 379: 
                case 380: 
                case 381: 
                case 382: 
                case 383: 
                case 384: 
                case 385: 
                case 386: 
                case 387: 
                case 388: 
                case 389: 
                case 390: 
                case 391: 
                case 392: 
                case 393: 
                case 394: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 415: 
                case 423: 
                case 424: 
                case 428: 
                case 429: 
                case 431: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block16;
                }
            }
            this.statement();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: {
                this.exceptionHandler();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this.jj_consume_token(104);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 423: {
                this.jj_consume_token(423);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        this.jj_consume_token(4);
    }

    public final void javaSpec() throws ParseException, SAXException {
        ASTCompilationUnit javaCompilationUnit = null;
        Token schema = null;
        Token name = null;
        Token tokenCreate = null;
        Token tokenPackage = null;
        Token tokenJavaType = null;
        Token tokenIsAs = null;
        Object lastToken = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                tokenCreate = this.jj_consume_token(82);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 200: {
                        this.jj_consume_token(200);
                        this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        this.jj_consume_token(47);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 410: {
                                this.jj_consume_token(410);
                                break block0;
                            }
                            case 411: {
                                this.jj_consume_token(411);
                                break block0;
                            }
                        }
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        tokenPackage = this.jj_consume_token(152);
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 231: 
            case 414: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 414: {
                        tokenJavaType = this.jj_consume_token(414);
                        break;
                    }
                    case 231: {
                        tokenJavaType = this.jj_consume_token(231);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(413);
                if (this.jj_2_16(2)) {
                    schema = this.ID();
                    this.jj_consume_token(3);
                }
                name = this.ID();
                break;
            }
            case 415: {
                tokenJavaType = this.jj_consume_token(415);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 355: {
                        this.jj_consume_token(355);
                        schema = this.ID();
                        break block13;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.m_out != null) {
            String schemaString = this.schemaName;
            if (schema != null) {
                schemaString = schema.toString();
            }
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(null == name ? "Unnamed" : name.toString()));
            this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString.toString()));
            this.m_out.pushAttribute("TYPE", this.purifyIdentifier(tokenJavaType.toString()));
            this.m_out.startElement("JAVA");
        }
        if (null != tokenCreate) {
            this.processPackageComment(tokenCreate);
        }
        this.processPackageComment(tokenPackage);
        block24 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                tokenIsAs = this.jj_consume_token(54);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: {
                        this.jj_consume_token(37);
                        break block24;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        break block24;
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.processPackageComment(tokenIsAs);
        tokenIsAs = this.jj_consume_token(375);
        this.jj_consume_token(62);
        this.jj_consume_token(5);
        block31 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: 
            case 206: 
            case 220: 
            case 279: 
            case 281: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 124: {
                        this.jj_consume_token(124);
                        break block31;
                    }
                    case 220: {
                        this.jj_consume_token(220);
                        break block31;
                    }
                    case 206: {
                        this.jj_consume_token(206);
                        break block31;
                    }
                    case 279: {
                        this.jj_consume_token(279);
                        break block31;
                    }
                    case 281: {
                        this.jj_consume_token(281);
                        break block31;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.qualifiedName();
        block90: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block90;
                }
            }
            this.jj_consume_token(6);
            block44 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 124: 
                case 206: 
                case 220: 
                case 279: 
                case 281: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 124: {
                            this.jj_consume_token(124);
                            break block44;
                        }
                        case 220: {
                            this.jj_consume_token(220);
                            break block44;
                        }
                        case 206: {
                            this.jj_consume_token(206);
                            break block44;
                        }
                        case 279: {
                            this.jj_consume_token(279);
                            break block44;
                        }
                        case 281: {
                            this.jj_consume_token(281);
                            break block44;
                        }
                    }
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            this.qualifiedName();
        }
        this.jj_consume_token(7);
        this.processPackageComment(tokenIsAs);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 412: {
                tokenIsAs = this.jj_consume_token(412);
                this.jj_consume_token(5);
                block91: while (true) {
                    this.jj_consume_token(5);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            this.jj_consume_token(8);
                            break;
                        }
                        case 431: {
                            this.jj_consume_token(431);
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            this.jj_consume_token(6);
                            break;
                        }
                        default: {
                            this.jj_la1[25] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: {
                            this.jj_consume_token(9);
                            break;
                        }
                        case 35: 
                        case 36: 
                        case 37: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 59: 
                        case 61: 
                        case 63: 
                        case 64: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 88: 
                        case 95: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 118: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 129: 
                        case 131: 
                        case 132: 
                        case 135: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 147: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 155: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 172: 
                        case 174: 
                        case 177: 
                        case 180: 
                        case 184: 
                        case 191: 
                        case 194: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 216: 
                        case 219: 
                        case 220: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 248: 
                        case 250: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 259: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 266: 
                        case 267: 
                        case 269: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 283: 
                        case 285: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 431: {
                            this.unqualifiedID();
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(7);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            continue block91;
                        }
                    }
                    break;
                }
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        this.processPackageComment(tokenIsAs);
        block71 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 285: {
                tokenIsAs = this.jj_consume_token(285);
                this.processPackageComment(tokenIsAs);
                if (this.jj_2_17(Integer.MAX_VALUE)) {
                    this.jj_consume_token(309);
                    this.jj_consume_token(5);
                    this.unqualifiedID();
                    this.jj_consume_token(6);
                    this.StringLiteral();
                    this.jj_consume_token(7);
                    break;
                }
                if (this.jj_2_18(Integer.MAX_VALUE)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 311: {
                            this.jj_consume_token(311);
                            break;
                        }
                        case 310: {
                            this.jj_consume_token(310);
                            break;
                        }
                        case 309: {
                            this.jj_consume_token(309);
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.sqlStatement(null, ";");
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: {
                            this.jj_consume_token(4);
                            break block71;
                        }
                    }
                    this.jj_la1[30] = this.jj_gen;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 429: {
                        this.StringLiteral();
                        break block71;
                    }
                }
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 50: 
            case 150: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 150: {
                        tokenIsAs = this.jj_consume_token(150);
                        break;
                    }
                    case 50: {
                        tokenIsAs = this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.processPackageComment(tokenIsAs);
                javaCompilationUnit = this.fromDelegatedJavaParser();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.m_out != null) {
            this.m_out.endElement("JAVA");
        }
    }

    public final void packageSpec() throws ParseException, SAXException {
        Token schema = null;
        Token name = null;
        Token tokenCreate = null;
        Token tokenPackage = null;
        Token tokenIsAs = null;
        Object lastToken = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                tokenCreate = this.jj_consume_token(82);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 200: {
                        this.jj_consume_token(200);
                        this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 99: 
                    case 180: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 99: {
                                this.jj_consume_token(99);
                                break block0;
                            }
                            case 180: {
                                this.jj_consume_token(180);
                                break block0;
                            }
                        }
                        this.jj_la1[35] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        tokenPackage = this.jj_consume_token(206);
        if (this.jj_2_19(2)) {
            schema = this.ID();
            this.jj_consume_token(3);
        }
        name = this.ID();
        if (this.m_out != null) {
            String schemaString = this.schemaName;
            if (schema != null) {
                schemaString = schema.toString();
            }
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(name.toString()));
            this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString.toString()));
            this.m_out.startElement("PACKAGE");
        }
        if (null != tokenCreate) {
            this.processPackageComment(tokenCreate);
        }
        this.processPackageComment(tokenPackage);
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                tokenIsAs = this.jj_consume_token(54);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: {
                        this.jj_consume_token(37);
                        break block13;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        break block13;
                    }
                }
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        this.processPackageComment(tokenIsAs);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 375: {
                tokenIsAs = this.jj_consume_token(375);
                this.jj_consume_token(62);
                this.jj_consume_token(5);
                block23 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 124: 
                    case 206: 
                    case 220: 
                    case 279: 
                    case 281: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 124: {
                                this.jj_consume_token(124);
                                break block23;
                            }
                            case 220: {
                                this.jj_consume_token(220);
                                break block23;
                            }
                            case 206: {
                                this.jj_consume_token(206);
                                break block23;
                            }
                            case 279: {
                                this.jj_consume_token(279);
                                break block23;
                            }
                            case 281: {
                                this.jj_consume_token(281);
                                break block23;
                            }
                        }
                        this.jj_la1[40] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                    }
                }
                this.qualifiedName();
                block57: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block57;
                        }
                    }
                    this.jj_consume_token(6);
                    block36 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 124: 
                        case 206: 
                        case 220: 
                        case 279: 
                        case 281: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 124: {
                                    this.jj_consume_token(124);
                                    break block36;
                                }
                                case 220: {
                                    this.jj_consume_token(220);
                                    break block36;
                                }
                                case 206: {
                                    this.jj_consume_token(206);
                                    break block36;
                                }
                                case 279: {
                                    this.jj_consume_token(279);
                                    break block36;
                                }
                                case 281: {
                                    this.jj_consume_token(281);
                                    break block36;
                                }
                            }
                            this.jj_la1[43] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                        }
                    }
                    this.qualifiedName();
                }
                this.jj_consume_token(7);
                this.processPackageComment(tokenIsAs);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 363: {
                this.wrappedObject();
                break;
            }
            case 50: 
            case 150: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 150: {
                        tokenIsAs = this.jj_consume_token(150);
                        break;
                    }
                    case 50: {
                        tokenIsAs = this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.processPackageComment(tokenIsAs);
                this.declarativeSection(true, name);
                this.jj_consume_token(104);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 258: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: 
                    case 432: 
                    case 433: 
                    case 434: 
                    case 435: {
                        this.ID();
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                this.jj_consume_token(4);
                this.printSummary("Package Specification", name.beginLine, name, this.token);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.m_out != null) {
            this.m_out.endElement("PACKAGE");
        }
    }

    public final void packageBody() throws ParseException, SAXException {
        Token schema = null;
        Token name = null;
        Token tokenCreate = null;
        Token tokenModuleType = null;
        Token tokenIsAs = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                tokenCreate = this.jj_consume_token(82);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 200: {
                        this.jj_consume_token(200);
                        this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 99: 
                    case 180: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 99: {
                                this.jj_consume_token(99);
                                break block0;
                            }
                            case 180: {
                                this.jj_consume_token(180);
                                break block0;
                            }
                        }
                        this.jj_la1[50] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[51] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: {
                tokenModuleType = this.jj_consume_token(206);
                break;
            }
            case 281: {
                tokenModuleType = this.jj_consume_token(281);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(59);
        if (this.jj_2_20(2)) {
            schema = this.ID();
            this.jj_consume_token(3);
        }
        name = this.ID();
        if (this.m_out != null) {
            String schemaString = this.schemaName;
            if (schema != null) {
                schemaString = schema.toString();
            }
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(name.toString()));
            this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString.toString()));
            this.m_out.startElement(tokenModuleType.image.toUpperCase().equals("PACKAGE") ? "PACKAGE_BODY" : "OBJECT_BODY");
        }
        if (null != tokenCreate) {
            this.processPackageComment(tokenCreate);
        }
        this.processPackageComment(tokenModuleType);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 363: {
                this.wrappedObject();
                break;
            }
            case 50: 
            case 150: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 150: {
                        tokenIsAs = this.jj_consume_token(150);
                        break;
                    }
                    case 50: {
                        tokenIsAs = this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.processPackageComment(tokenIsAs);
                this.declarativeSection(true, name);
                block25 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        block37: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[55] = this.jj_gen;
                                    break block37;
                                }
                            }
                            this.statement();
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 107: {
                                this.exceptionHandler();
                                break block25;
                            }
                        }
                        this.jj_la1[56] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                    }
                }
                this.jj_consume_token(104);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 258: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: 
                    case 432: 
                    case 433: 
                    case 434: 
                    case 435: {
                        this.ID();
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                this.jj_consume_token(4);
                this.printSummary(tokenModuleType.image.toUpperCase().equals("PACKAGE") ? "Package Body" : "Object Type Body", name.beginLine, name, this.token);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.m_out != null) {
            this.m_out.endElement(tokenModuleType.image.toUpperCase().equals("PACKAGE") ? "PACKAGE_BODY" : "OBJECT_BODY");
        }
    }

    public final void declarativeUnit(boolean isPackageLevel, Token objectStart) throws ParseException, SAXException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 215: {
                this.pragma(isPackageLevel);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                if (this.jj_2_21(2)) {
                    this.exceptionDeclaration(isPackageLevel);
                    break;
                }
                if (this.jj_2_22(Integer.MAX_VALUE)) {
                    this.subtype_definition(isPackageLevel);
                    break;
                }
                if (this.jj_2_23(Integer.MAX_VALUE)) {
                    this.programUnit(isPackageLevel, objectStart);
                    break;
                }
                if (this.jj_2_24(4)) {
                    this.variableOrConstantDeclaration(isPackageLevel);
                    break;
                }
                if (this.jj_2_25(2)) {
                    this.cursorSpec(isPackageLevel);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 85: {
                        this.cursorBody(isPackageLevel);
                        break block0;
                    }
                    case 423: {
                        this.collectionDeclaration(isPackageLevel);
                        break block0;
                    }
                    case 82: 
                    case 124: 
                    case 220: {
                        this.programUnit(isPackageLevel, objectStart);
                        break block0;
                    }
                    case 79: 
                    case 118: 
                    case 143: 
                    case 160: 
                    case 162: 
                    case 181: 
                    case 201: 
                    case 205: 
                    case 259: {
                        this.typeMethod(isPackageLevel, 1, null, objectStart);
                        break block0;
                    }
                    case 327: {
                        this.CompilationDeclarationFragment(isPackageLevel, objectStart);
                        break block0;
                    }
                }
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void declarativeSection(boolean isPackageLevel, Token objectStart) throws ParseException, SAXException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 176: 
                case 177: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 232: 
                case 234: 
                case 235: 
                case 236: 
                case 238: 
                case 239: 
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 260: 
                case 261: 
                case 262: 
                case 263: 
                case 264: 
                case 265: 
                case 266: 
                case 267: 
                case 268: 
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 277: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 289: 
                case 290: 
                case 291: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 323: 
                case 324: 
                case 327: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 347: 
                case 348: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 357: 
                case 358: 
                case 359: 
                case 360: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 366: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 376: 
                case 377: 
                case 378: 
                case 379: 
                case 380: 
                case 381: 
                case 382: 
                case 383: 
                case 384: 
                case 385: 
                case 386: 
                case 387: 
                case 388: 
                case 389: 
                case 390: 
                case 391: 
                case 392: 
                case 393: 
                case 394: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 415: 
                case 423: 
                case 431: 
                case 432: 
                case 433: 
                case 434: 
                case 435: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block3;
                }
            }
            this.declarativeUnit(isPackageLevel, objectStart);
        }
    }

    public final void CompilationDeclarationFragment(boolean isPackageLevel, Token objectStart) throws ParseException, SAXException {
        block34: {
            block33: {
                block32: {
                    this.jj_consume_token(327);
                    this.ConditionalOrExpression();
                    this.jj_consume_token(328);
                    block27: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 332: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                                break block32;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                this.declarativeUnit(isPackageLevel, objectStart);
                                continue block27;
                            }
                            case 332: {
                                this.jj_consume_token(332);
                                this.Expression();
                                this.jj_consume_token(331);
                                continue block27;
                            }
                        }
                        break;
                    }
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 330: {
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            break block33;
                        }
                    }
                    this.jj_consume_token(330);
                    this.ConditionalOrExpression();
                    this.jj_consume_token(328);
                    block29: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 332: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                break;
                            }
                            default: {
                                this.jj_la1[66] = this.jj_gen;
                                continue block28;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                this.declarativeUnit(isPackageLevel, objectStart);
                                continue block29;
                            }
                            case 332: {
                                this.jj_consume_token(332);
                                this.Expression();
                                this.jj_consume_token(331);
                                continue block29;
                            }
                        }
                        break;
                    }
                    break;
                }
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block30: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 329: {
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                        break block34;
                    }
                }
                this.jj_consume_token(329);
                block31: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 173: 
                        case 174: 
                        case 176: 
                        case 177: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 209: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 258: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 270: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 327: 
                        case 332: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 431: 
                        case 432: 
                        case 433: 
                        case 434: 
                        case 435: {
                            break;
                        }
                        default: {
                            this.jj_la1[69] = this.jj_gen;
                            continue block30;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 173: 
                        case 174: 
                        case 176: 
                        case 177: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 209: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 258: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 270: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 327: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 431: 
                        case 432: 
                        case 433: 
                        case 434: 
                        case 435: {
                            this.declarativeUnit(isPackageLevel, objectStart);
                            continue block31;
                        }
                        case 332: {
                            this.jj_consume_token(332);
                            this.Expression();
                            this.jj_consume_token(331);
                            continue block31;
                        }
                    }
                    break;
                }
                break;
            }
            this.jj_la1[70] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(331);
    }

    /*
     * Unable to fully structure code
     */
    public final void programUnit(boolean isPackageLevel, Token objectStart) throws ParseException, SAXException {
        schema = null;
        globalStart = null;
        startToken = null;
        tokenODCIAggregateType = null;
        tokenIsAs = null;
        memberName = null;
        type = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                globalStart = this.jj_consume_token(82);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 200: {
                        this.jj_consume_token(200);
                        this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 99: 
                    case 180: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 99: {
                                this.jj_consume_token(99);
                                break block0;
                            }
                            case 180: {
                                this.jj_consume_token(180);
                                break block0;
                            }
                        }
                        this.jj_la1[72] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[73] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: {
                start = this.jj_consume_token(124);
                break;
            }
            case 220: {
                start = this.jj_consume_token(220);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_26(2)) {
            schema = this.ID();
            this.jj_consume_token(3);
        }
        name = this.ID();
        if (this.m_out != null && isPackageLevel) {
            if (null == objectStart) {
                packageString = this.globalPackageName;
                schemaString = this.schemaName;
                if (null != schema) {
                    schemaString = schema.toString();
                    packageString = "_" + schemaString;
                }
                this.m_out.pushAttribute("NAME", this.purifyIdentifier(packageString));
                this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString));
                this.m_out.startElement("PACKAGE");
            }
            memberName = this.purifyKeyword(start.toString());
            if (globalStart == null) {
                tags = this.processMemberComment(start, memberName, name.toString());
                tags.putAll(this.processMemberComment(name, null, null));
            } else {
                tags = this.processMemberComment(globalStart, memberName, name.toString());
                tags.putAll(this.processMemberComment(start, null, null));
                tags.putAll(this.processMemberComment(name, null, null));
            }
        } else {
            tags = new Hashtable();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 363: {
                this.wrappedObject();
                break;
            }
            case 4: 
            case 5: 
            case 44: 
            case 50: 
            case 54: 
            case 94: 
            case 150: 
            case 207: 
            case 211: 
            case 233: 
            case 234: 
            case 375: {
                block131: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            break block131;
                        }
                    }
                    this.jj_consume_token(5);
                    tags.putAll(this.processMemberComment(this.token, null, null));
                    this.parameterDeclaration(tags, isPackageLevel);
                    block132: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                break;
                            }
                            default: {
                                this.jj_la1[77] = this.jj_gen;
                                break block132;
                            }
                        }
                        this.jj_consume_token(6);
                        this.parameterDeclaration(tags, isPackageLevel);
                    }
                    this.jj_consume_token(7);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 234: {
                        this.jj_consume_token(234);
                        tags.putAll(this.processMemberComment(this.token, null, null));
                        type = this.datatype();
                        if (this.m_out == null || !isPackageLevel) break;
                        returnComment = null;
                        tagValues = (Collection)tags.get("@return");
                        if (tagValues != null) {
                            for (String returnComment : tagValues) {
                            }
                        }
                        this.m_out.pushAttribute("TYPE", this.purifyIdentifier(type.toString()));
                        this.m_out.startElement("RETURN");
                        if (returnComment != null) {
                            this.m_out.startElement("COMMENT");
                            this.m_out.cdata(returnComment);
                            this.m_out.endElement("COMMENT");
                        }
                        this.m_out.endElement("RETURN");
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                    }
                }
                if (this.m_out != null && isPackageLevel) {
                    throwsComment = null;
                    exceptionName = null;
                    tagValues = (Collection)tags.get("@throws");
                    if (tagValues != null) {
                        for (String throwsComment : tagValues) {
                            st = new StringTokenizer(throwsComment);
                            if (st.hasMoreTokens()) {
                                exceptionName = st.nextToken();
                            }
                            if (exceptionName == null) continue;
                            this.m_out.pushAttribute("NAME", this.purifyIdentifier(exceptionName));
                            this.m_out.startElement("THROWS");
                            if (throwsComment != null) {
                                this.m_out.startElement("COMMENT");
                                this.m_out.cdata(throwsComment.substring(exceptionName.length()));
                                this.m_out.endElement("COMMENT");
                            }
                            this.m_out.endElement("THROWS");
                        }
                    }
                }
                if (this.m_out != null && isPackageLevel) {
                    this.printCustomTags(tags);
                }
                block135: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 54: 
                        case 94: 
                        case 207: 
                        case 211: 
                        case 233: 
                        case 375: {
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                            ** GOTO lbl402
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 54: {
                            this.jj_consume_token(54);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 37: {
                                    this.jj_consume_token(37);
                                    continue block135;
                                }
                                case 36: {
                                    this.jj_consume_token(36);
                                    continue block135;
                                }
                            }
                            this.jj_la1[80] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        case 375: {
                            this.jj_consume_token(375);
                            this.jj_consume_token(62);
                            this.jj_consume_token(5);
                            block45 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 124: 
                                case 206: 
                                case 220: 
                                case 279: 
                                case 281: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 124: {
                                            this.jj_consume_token(124);
                                            break block45;
                                        }
                                        case 220: {
                                            this.jj_consume_token(220);
                                            break block45;
                                        }
                                        case 206: {
                                            this.jj_consume_token(206);
                                            break block45;
                                        }
                                        case 279: {
                                            this.jj_consume_token(279);
                                            break block45;
                                        }
                                        case 281: {
                                            this.jj_consume_token(281);
                                            break block45;
                                        }
                                    }
                                    this.jj_la1[81] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                                default: {
                                    this.jj_la1[82] = this.jj_gen;
                                }
                            }
                            this.qualifiedName();
                            block136: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 6: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[83] = this.jj_gen;
                                        break block136;
                                    }
                                }
                                this.jj_consume_token(6);
                                block58 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 124: 
                                    case 206: 
                                    case 220: 
                                    case 279: 
                                    case 281: {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 124: {
                                                this.jj_consume_token(124);
                                                break block58;
                                            }
                                            case 220: {
                                                this.jj_consume_token(220);
                                                break block58;
                                            }
                                            case 206: {
                                                this.jj_consume_token(206);
                                                break block58;
                                            }
                                            case 279: {
                                                this.jj_consume_token(279);
                                                break block58;
                                            }
                                            case 281: {
                                                this.jj_consume_token(281);
                                                break block58;
                                            }
                                        }
                                        this.jj_la1[84] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                    default: {
                                        this.jj_la1[85] = this.jj_gen;
                                    }
                                }
                                this.qualifiedName();
                            }
                            this.jj_consume_token(7);
                            continue block135;
                        }
                        case 94: {
                            this.jj_consume_token(94);
                            continue block135;
                        }
                        case 207: {
                            this.jj_consume_token(207);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: {
                                    this.parallel_clause();
                                    break;
                                }
                                default: {
                                    this.jj_la1[86] = this.jj_gen;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 285: {
                                    this.jj_consume_token(285);
                                    this.ID();
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 3: {
                                            this.jj_consume_token(3);
                                            this.ID();
                                            continue block135;
                                        }
                                    }
                                    this.jj_la1[87] = this.jj_gen;
                                    continue block135;
                                }
                            }
                            this.jj_la1[88] = this.jj_gen;
                            continue block135;
                        }
                        case 211: {
                            this.jj_consume_token(211);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 70: 
                                case 201: 
                                case 285: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 285: {
                                            this.jj_consume_token(285);
                                            this.ID();
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 3: {
                                                    this.jj_consume_token(3);
                                                    this.ID();
                                                    continue block135;
                                                }
                                            }
                                            this.jj_la1[89] = this.jj_gen;
                                            continue block135;
                                        }
                                        case 70: 
                                        case 201: {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 201: {
                                                    this.jj_consume_token(201);
                                                    break;
                                                }
                                                case 70: {
                                                    this.jj_consume_token(70);
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[90] = this.jj_gen;
                                                    this.jj_consume_token(-1);
                                                    throw new ParseException();
                                                }
                                            }
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 35: 
                                                case 36: 
                                                case 37: 
                                                case 38: 
                                                case 39: 
                                                case 40: 
                                                case 41: 
                                                case 42: 
                                                case 43: 
                                                case 44: 
                                                case 45: 
                                                case 46: 
                                                case 47: 
                                                case 48: 
                                                case 49: 
                                                case 50: 
                                                case 51: 
                                                case 52: 
                                                case 53: 
                                                case 54: 
                                                case 55: 
                                                case 57: 
                                                case 58: 
                                                case 59: 
                                                case 60: 
                                                case 61: 
                                                case 62: 
                                                case 63: 
                                                case 64: 
                                                case 65: 
                                                case 66: 
                                                case 67: 
                                                case 68: 
                                                case 69: 
                                                case 70: 
                                                case 71: 
                                                case 72: 
                                                case 73: 
                                                case 74: 
                                                case 75: 
                                                case 76: 
                                                case 77: 
                                                case 78: 
                                                case 79: 
                                                case 80: 
                                                case 81: 
                                                case 82: 
                                                case 83: 
                                                case 84: 
                                                case 85: 
                                                case 86: 
                                                case 87: 
                                                case 88: 
                                                case 89: 
                                                case 90: 
                                                case 91: 
                                                case 92: 
                                                case 93: 
                                                case 95: 
                                                case 96: 
                                                case 97: 
                                                case 98: 
                                                case 99: 
                                                case 100: 
                                                case 101: 
                                                case 102: 
                                                case 103: 
                                                case 105: 
                                                case 106: 
                                                case 107: 
                                                case 108: 
                                                case 109: 
                                                case 110: 
                                                case 111: 
                                                case 112: 
                                                case 113: 
                                                case 114: 
                                                case 115: 
                                                case 116: 
                                                case 117: 
                                                case 118: 
                                                case 119: 
                                                case 120: 
                                                case 121: 
                                                case 122: 
                                                case 123: 
                                                case 124: 
                                                case 125: 
                                                case 126: 
                                                case 127: 
                                                case 129: 
                                                case 130: 
                                                case 131: 
                                                case 132: 
                                                case 134: 
                                                case 135: 
                                                case 136: 
                                                case 137: 
                                                case 138: 
                                                case 140: 
                                                case 141: 
                                                case 142: 
                                                case 143: 
                                                case 144: 
                                                case 145: 
                                                case 146: 
                                                case 147: 
                                                case 148: 
                                                case 149: 
                                                case 150: 
                                                case 151: 
                                                case 152: 
                                                case 153: 
                                                case 154: 
                                                case 155: 
                                                case 156: 
                                                case 157: 
                                                case 158: 
                                                case 159: 
                                                case 160: 
                                                case 161: 
                                                case 162: 
                                                case 163: 
                                                case 164: 
                                                case 165: 
                                                case 166: 
                                                case 167: 
                                                case 168: 
                                                case 169: 
                                                case 170: 
                                                case 171: 
                                                case 172: 
                                                case 173: 
                                                case 174: 
                                                case 176: 
                                                case 177: 
                                                case 179: 
                                                case 180: 
                                                case 181: 
                                                case 182: 
                                                case 183: 
                                                case 184: 
                                                case 185: 
                                                case 186: 
                                                case 187: 
                                                case 188: 
                                                case 189: 
                                                case 190: 
                                                case 191: 
                                                case 192: 
                                                case 193: 
                                                case 194: 
                                                case 195: 
                                                case 196: 
                                                case 197: 
                                                case 198: 
                                                case 199: 
                                                case 200: 
                                                case 201: 
                                                case 202: 
                                                case 203: 
                                                case 204: 
                                                case 205: 
                                                case 206: 
                                                case 208: 
                                                case 209: 
                                                case 212: 
                                                case 213: 
                                                case 214: 
                                                case 216: 
                                                case 217: 
                                                case 218: 
                                                case 219: 
                                                case 220: 
                                                case 221: 
                                                case 222: 
                                                case 223: 
                                                case 224: 
                                                case 225: 
                                                case 226: 
                                                case 227: 
                                                case 228: 
                                                case 229: 
                                                case 230: 
                                                case 232: 
                                                case 234: 
                                                case 235: 
                                                case 236: 
                                                case 238: 
                                                case 239: 
                                                case 240: 
                                                case 241: 
                                                case 242: 
                                                case 243: 
                                                case 244: 
                                                case 245: 
                                                case 246: 
                                                case 247: 
                                                case 248: 
                                                case 249: 
                                                case 250: 
                                                case 252: 
                                                case 253: 
                                                case 254: 
                                                case 255: 
                                                case 256: 
                                                case 257: 
                                                case 258: 
                                                case 259: 
                                                case 260: 
                                                case 261: 
                                                case 262: 
                                                case 263: 
                                                case 264: 
                                                case 265: 
                                                case 266: 
                                                case 267: 
                                                case 268: 
                                                case 269: 
                                                case 270: 
                                                case 271: 
                                                case 272: 
                                                case 273: 
                                                case 274: 
                                                case 275: 
                                                case 276: 
                                                case 277: 
                                                case 278: 
                                                case 279: 
                                                case 280: 
                                                case 281: 
                                                case 282: 
                                                case 283: 
                                                case 285: 
                                                case 289: 
                                                case 290: 
                                                case 291: 
                                                case 293: 
                                                case 294: 
                                                case 295: 
                                                case 296: 
                                                case 297: 
                                                case 298: 
                                                case 299: 
                                                case 300: 
                                                case 301: 
                                                case 302: 
                                                case 303: 
                                                case 304: 
                                                case 305: 
                                                case 306: 
                                                case 307: 
                                                case 308: 
                                                case 309: 
                                                case 310: 
                                                case 311: 
                                                case 312: 
                                                case 313: 
                                                case 314: 
                                                case 315: 
                                                case 316: 
                                                case 317: 
                                                case 318: 
                                                case 319: 
                                                case 323: 
                                                case 324: 
                                                case 341: 
                                                case 342: 
                                                case 343: 
                                                case 344: 
                                                case 345: 
                                                case 346: 
                                                case 347: 
                                                case 348: 
                                                case 349: 
                                                case 350: 
                                                case 351: 
                                                case 352: 
                                                case 353: 
                                                case 354: 
                                                case 355: 
                                                case 356: 
                                                case 357: 
                                                case 358: 
                                                case 359: 
                                                case 360: 
                                                case 361: 
                                                case 362: 
                                                case 363: 
                                                case 364: 
                                                case 365: 
                                                case 366: 
                                                case 367: 
                                                case 368: 
                                                case 369: 
                                                case 370: 
                                                case 371: 
                                                case 372: 
                                                case 373: 
                                                case 374: 
                                                case 375: 
                                                case 376: 
                                                case 377: 
                                                case 378: 
                                                case 379: 
                                                case 380: 
                                                case 381: 
                                                case 382: 
                                                case 383: 
                                                case 384: 
                                                case 385: 
                                                case 386: 
                                                case 387: 
                                                case 388: 
                                                case 389: 
                                                case 390: 
                                                case 391: 
                                                case 392: 
                                                case 393: 
                                                case 394: 
                                                case 395: 
                                                case 396: 
                                                case 397: 
                                                case 398: 
                                                case 399: 
                                                case 403: 
                                                case 404: 
                                                case 405: 
                                                case 406: 
                                                case 407: 
                                                case 408: 
                                                case 409: 
                                                case 410: 
                                                case 411: 
                                                case 412: 
                                                case 413: 
                                                case 414: 
                                                case 415: 
                                                case 423: 
                                                case 431: 
                                                case 432: 
                                                case 433: 
                                                case 434: 
                                                case 435: {
                                                    this.ID();
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[91] = this.jj_gen;
                                                }
                                            }
                                            this.jj_consume_token(62);
                                            this.jj_consume_token(5);
                                            this.ID();
                                            block137: while (true) {
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 6: {
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[92] = this.jj_gen;
                                                        break block137;
                                                    }
                                                }
                                                this.jj_consume_token(6);
                                                this.ID();
                                            }
                                            this.jj_consume_token(7);
                                            continue block135;
                                        }
                                    }
                                    this.jj_la1[93] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_la1[94] = this.jj_gen;
                            continue block135;
                        }
                        case 233: {
                            this.jj_consume_token(233);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 229: {
                                    this.jj_consume_token(229);
                                    this.jj_consume_token(5);
                                    this.ID();
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 3: {
                                            this.jj_consume_token(3);
                                            this.ID();
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[95] = this.jj_gen;
                                        }
                                    }
                                    block138: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[96] = this.jj_gen;
                                                break block138;
                                            }
                                        }
                                        this.jj_consume_token(6);
                                        this.ID();
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 3: {
                                                this.jj_consume_token(3);
                                                this.ID();
                                                continue block138;
                                            }
                                        }
                                        this.jj_la1[97] = this.jj_gen;
                                    }
                                    this.jj_consume_token(7);
                                    continue block135;
                                }
                            }
                            this.jj_la1[98] = this.jj_gen;
                            continue block135;
                        }
                    }
                    break;
                }
                this.jj_la1[99] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
lbl402:
                // 1 sources

                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 44: {
                        this.jj_consume_token(44);
                        this.jj_consume_token(285);
                        tokenODCIAggregateType = this.ID();
                        break;
                    }
                    default: {
                        this.jj_la1[100] = this.jj_gen;
                    }
                }
                block112 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: 
                    case 150: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 150: {
                                tokenIsAs = this.jj_consume_token(150);
                                break;
                            }
                            case 50: {
                                tokenIsAs = this.jj_consume_token(50);
                                break;
                            }
                            default: {
                                this.jj_la1[101] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (this.m_out != null && isPackageLevel) {
                            if (memberName.toUpperCase().equals("PACKAGE")) {
                                this.processPackageComment(tokenIsAs);
                            } else {
                                tags = this.processMemberComment(tokenIsAs, null, null);
                            }
                        }
                        if (this.jj_2_27(2)) {
                            this.callSpecTail(isPackageLevel);
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                this.declarativeSection(false, objectStart);
                                this.jj_consume_token(56);
                                block139: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 5: 
                                        case 9: 
                                        case 18: 
                                        case 21: 
                                        case 35: 
                                        case 36: 
                                        case 37: 
                                        case 42: 
                                        case 43: 
                                        case 44: 
                                        case 49: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 56: 
                                        case 59: 
                                        case 61: 
                                        case 63: 
                                        case 64: 
                                        case 65: 
                                        case 69: 
                                        case 71: 
                                        case 72: 
                                        case 73: 
                                        case 74: 
                                        case 75: 
                                        case 79: 
                                        case 80: 
                                        case 81: 
                                        case 83: 
                                        case 85: 
                                        case 86: 
                                        case 87: 
                                        case 88: 
                                        case 89: 
                                        case 92: 
                                        case 95: 
                                        case 99: 
                                        case 100: 
                                        case 103: 
                                        case 105: 
                                        case 106: 
                                        case 108: 
                                        case 110: 
                                        case 112: 
                                        case 113: 
                                        case 114: 
                                        case 115: 
                                        case 116: 
                                        case 117: 
                                        case 118: 
                                        case 120: 
                                        case 121: 
                                        case 122: 
                                        case 124: 
                                        case 125: 
                                        case 126: 
                                        case 129: 
                                        case 131: 
                                        case 132: 
                                        case 134: 
                                        case 135: 
                                        case 138: 
                                        case 140: 
                                        case 141: 
                                        case 142: 
                                        case 143: 
                                        case 147: 
                                        case 149: 
                                        case 151: 
                                        case 152: 
                                        case 153: 
                                        case 155: 
                                        case 157: 
                                        case 159: 
                                        case 160: 
                                        case 161: 
                                        case 162: 
                                        case 163: 
                                        case 164: 
                                        case 166: 
                                        case 167: 
                                        case 168: 
                                        case 169: 
                                        case 171: 
                                        case 172: 
                                        case 174: 
                                        case 175: 
                                        case 177: 
                                        case 180: 
                                        case 181: 
                                        case 183: 
                                        case 184: 
                                        case 191: 
                                        case 194: 
                                        case 196: 
                                        case 197: 
                                        case 198: 
                                        case 202: 
                                        case 203: 
                                        case 205: 
                                        case 206: 
                                        case 208: 
                                        case 210: 
                                        case 215: 
                                        case 216: 
                                        case 219: 
                                        case 220: 
                                        case 222: 
                                        case 223: 
                                        case 224: 
                                        case 225: 
                                        case 226: 
                                        case 227: 
                                        case 228: 
                                        case 229: 
                                        case 230: 
                                        case 232: 
                                        case 234: 
                                        case 235: 
                                        case 236: 
                                        case 238: 
                                        case 239: 
                                        case 240: 
                                        case 241: 
                                        case 242: 
                                        case 244: 
                                        case 245: 
                                        case 246: 
                                        case 247: 
                                        case 248: 
                                        case 250: 
                                        case 254: 
                                        case 255: 
                                        case 256: 
                                        case 257: 
                                        case 259: 
                                        case 261: 
                                        case 262: 
                                        case 263: 
                                        case 266: 
                                        case 267: 
                                        case 269: 
                                        case 271: 
                                        case 272: 
                                        case 273: 
                                        case 274: 
                                        case 275: 
                                        case 276: 
                                        case 278: 
                                        case 280: 
                                        case 281: 
                                        case 283: 
                                        case 285: 
                                        case 289: 
                                        case 290: 
                                        case 291: 
                                        case 293: 
                                        case 294: 
                                        case 297: 
                                        case 298: 
                                        case 299: 
                                        case 300: 
                                        case 301: 
                                        case 303: 
                                        case 304: 
                                        case 305: 
                                        case 306: 
                                        case 307: 
                                        case 308: 
                                        case 309: 
                                        case 310: 
                                        case 311: 
                                        case 312: 
                                        case 313: 
                                        case 314: 
                                        case 315: 
                                        case 316: 
                                        case 317: 
                                        case 318: 
                                        case 319: 
                                        case 323: 
                                        case 324: 
                                        case 327: 
                                        case 332: 
                                        case 341: 
                                        case 342: 
                                        case 343: 
                                        case 344: 
                                        case 345: 
                                        case 346: 
                                        case 347: 
                                        case 348: 
                                        case 349: 
                                        case 350: 
                                        case 351: 
                                        case 352: 
                                        case 353: 
                                        case 354: 
                                        case 355: 
                                        case 356: 
                                        case 357: 
                                        case 358: 
                                        case 359: 
                                        case 360: 
                                        case 361: 
                                        case 362: 
                                        case 363: 
                                        case 364: 
                                        case 365: 
                                        case 366: 
                                        case 367: 
                                        case 368: 
                                        case 369: 
                                        case 370: 
                                        case 371: 
                                        case 372: 
                                        case 373: 
                                        case 374: 
                                        case 375: 
                                        case 376: 
                                        case 377: 
                                        case 378: 
                                        case 379: 
                                        case 380: 
                                        case 381: 
                                        case 382: 
                                        case 383: 
                                        case 384: 
                                        case 385: 
                                        case 386: 
                                        case 387: 
                                        case 388: 
                                        case 389: 
                                        case 390: 
                                        case 391: 
                                        case 392: 
                                        case 393: 
                                        case 394: 
                                        case 395: 
                                        case 396: 
                                        case 397: 
                                        case 398: 
                                        case 399: 
                                        case 403: 
                                        case 404: 
                                        case 405: 
                                        case 406: 
                                        case 407: 
                                        case 408: 
                                        case 409: 
                                        case 410: 
                                        case 411: 
                                        case 412: 
                                        case 413: 
                                        case 414: 
                                        case 415: 
                                        case 423: 
                                        case 424: 
                                        case 428: 
                                        case 429: 
                                        case 431: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[102] = this.jj_gen;
                                            break block139;
                                        }
                                    }
                                    this.statement();
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 107: {
                                        this.exceptionHandler();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[103] = this.jj_gen;
                                    }
                                }
                                this.jj_consume_token(104);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 38: 
                                    case 39: 
                                    case 40: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 45: 
                                    case 46: 
                                    case 47: 
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 57: 
                                    case 58: 
                                    case 59: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 82: 
                                    case 83: 
                                    case 84: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 90: 
                                    case 91: 
                                    case 92: 
                                    case 93: 
                                    case 95: 
                                    case 96: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: 
                                    case 103: 
                                    case 105: 
                                    case 106: 
                                    case 107: 
                                    case 108: 
                                    case 109: 
                                    case 110: 
                                    case 111: 
                                    case 112: 
                                    case 113: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 119: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 123: 
                                    case 124: 
                                    case 125: 
                                    case 126: 
                                    case 127: 
                                    case 129: 
                                    case 130: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 135: 
                                    case 136: 
                                    case 137: 
                                    case 138: 
                                    case 140: 
                                    case 141: 
                                    case 142: 
                                    case 143: 
                                    case 144: 
                                    case 145: 
                                    case 146: 
                                    case 147: 
                                    case 148: 
                                    case 149: 
                                    case 150: 
                                    case 151: 
                                    case 152: 
                                    case 153: 
                                    case 154: 
                                    case 155: 
                                    case 156: 
                                    case 157: 
                                    case 158: 
                                    case 159: 
                                    case 160: 
                                    case 161: 
                                    case 162: 
                                    case 163: 
                                    case 164: 
                                    case 165: 
                                    case 166: 
                                    case 167: 
                                    case 168: 
                                    case 169: 
                                    case 170: 
                                    case 171: 
                                    case 172: 
                                    case 173: 
                                    case 174: 
                                    case 176: 
                                    case 177: 
                                    case 179: 
                                    case 180: 
                                    case 181: 
                                    case 182: 
                                    case 183: 
                                    case 184: 
                                    case 185: 
                                    case 186: 
                                    case 187: 
                                    case 188: 
                                    case 189: 
                                    case 190: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 209: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 232: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 249: 
                                    case 250: 
                                    case 252: 
                                    case 253: 
                                    case 254: 
                                    case 255: 
                                    case 256: 
                                    case 257: 
                                    case 258: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 270: 
                                    case 271: 
                                    case 272: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 285: 
                                    case 289: 
                                    case 290: 
                                    case 291: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 323: 
                                    case 324: 
                                    case 341: 
                                    case 342: 
                                    case 343: 
                                    case 344: 
                                    case 345: 
                                    case 346: 
                                    case 347: 
                                    case 348: 
                                    case 349: 
                                    case 350: 
                                    case 351: 
                                    case 352: 
                                    case 353: 
                                    case 354: 
                                    case 355: 
                                    case 356: 
                                    case 357: 
                                    case 358: 
                                    case 359: 
                                    case 360: 
                                    case 361: 
                                    case 362: 
                                    case 363: 
                                    case 364: 
                                    case 365: 
                                    case 366: 
                                    case 367: 
                                    case 368: 
                                    case 369: 
                                    case 370: 
                                    case 371: 
                                    case 372: 
                                    case 373: 
                                    case 374: 
                                    case 375: 
                                    case 376: 
                                    case 377: 
                                    case 378: 
                                    case 379: 
                                    case 380: 
                                    case 381: 
                                    case 382: 
                                    case 383: 
                                    case 384: 
                                    case 385: 
                                    case 386: 
                                    case 387: 
                                    case 388: 
                                    case 389: 
                                    case 390: 
                                    case 391: 
                                    case 392: 
                                    case 393: 
                                    case 394: 
                                    case 395: 
                                    case 396: 
                                    case 397: 
                                    case 398: 
                                    case 399: 
                                    case 403: 
                                    case 404: 
                                    case 405: 
                                    case 406: 
                                    case 407: 
                                    case 408: 
                                    case 409: 
                                    case 410: 
                                    case 411: 
                                    case 412: 
                                    case 413: 
                                    case 414: 
                                    case 415: 
                                    case 423: 
                                    case 431: 
                                    case 432: 
                                    case 433: 
                                    case 434: 
                                    case 435: {
                                        this.ID();
                                        break block112;
                                    }
                                }
                                this.jj_la1[104] = this.jj_gen;
                                break block112;
                            }
                        }
                        this.jj_la1[105] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[106] = this.jj_gen;
                    }
                }
                this.jj_consume_token(4);
                if (!isPackageLevel) break;
                this.printSummary("Program Unit", isPackageLevel != false && null != objectStart ? objectStart.beginLine : name.beginLine, name, this.token);
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.m_out != null && isPackageLevel) {
            this.m_out.endElement(this.purifyKeyword(start.toString()));
            if (null == objectStart) {
                this.m_out.endElement(this.purifyKeyword("PACKAGE"));
            }
        }
    }

    public final void parameterDeclaration(Hashtable tags, boolean isPackageLevel) throws ParseException, SAXException {
        String paramType;
        Token parameterType = null;
        String defaultValue = null;
        String paramMode = "IN";
        Token name = this.ID();
        if (this.jj_2_30(2)) {
            if (this.jj_2_29(2)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 204: {
                        this.jj_consume_token(204);
                        paramMode = "OUT";
                        break;
                    }
                    case 136: {
                        this.jj_consume_token(136);
                        this.jj_consume_token(204);
                        paramMode = "IN OUT";
                        break;
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.jj_2_28(2)) {
                    this.jj_consume_token(179);
                    paramMode = paramMode + " NOCOPY";
                }
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 136: {
                        this.jj_consume_token(136);
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                parameterType = this.jj_consume_token(10);
                paramType = "...";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 177: 
            case 180: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 248: 
            case 250: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 327: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 431: {
                paramType = this.datatype();
                break;
            }
            default: {
                this.jj_la1[110] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        parameterType = this.token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 91: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        this.jj_consume_token(12);
                        break;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        break;
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                defaultValue = this.Expression();
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
            }
        }
        if (this.m_out != null && isPackageLevel) {
            String paramName = name.toString();
            String paramComment = this.getParamComment(paramName, tags);
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(paramName));
            this.m_out.pushAttribute("MODE", paramMode);
            this.m_out.pushAttribute("TYPE", this.purifyIdentifier(paramType));
            if (null != defaultValue) {
                this.m_out.pushAttribute("DEFAULT", this.purifyIdentifier(defaultValue));
            }
            this.m_out.startElement("ARGUMENT");
            if (paramComment != null) {
                this.m_out.startElement("COMMENT");
                this.m_out.cdata(paramComment);
                this.m_out.endElement("COMMENT");
            }
            this.m_out.endElement("ARGUMENT");
        }
    }

    public final String datatype() throws ParseException {
        String name = null;
        String dblink = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 327: {
                name = this.CompilationDataType();
                break;
            }
            default: {
                this.jj_la1[116] = this.jj_gen;
                if (this.jj_2_32(2)) {
                    name = this.scalar_datatype_name();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 95: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 129: 
                    case 131: 
                    case 132: 
                    case 135: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 172: 
                    case 174: 
                    case 177: 
                    case 180: 
                    case 184: 
                    case 191: 
                    case 194: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 216: 
                    case 219: 
                    case 220: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 259: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 266: 
                    case 267: 
                    case 269: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 283: 
                    case 285: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: {
                        if (this.jj_2_31(2)) {
                            this.jj_consume_token(227);
                        }
                        name = this.qualifiedName();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 2: {
                                this.jj_consume_token(2);
                                dblink = this.qualifiedName();
                                name = name + "@" + dblink;
                                break;
                            }
                            default: {
                                this.jj_la1[113] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 13: {
                                this.jj_consume_token(13);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 281: {
                                        this.jj_consume_token(281);
                                        name = name + "%TYPE";
                                        break block0;
                                    }
                                    case 243: {
                                        this.jj_consume_token(243);
                                        name = name + "%ROWTYPE";
                                        break block0;
                                    }
                                }
                                this.jj_la1[114] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[115] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[117] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return name;
    }

    public final String CompilationDataType() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        this.jj_consume_token(327);
        sb.append(" ");
        sb.append(this.token.image);
        string = this.ConditionalOrExpression();
        sb.append(" ");
        sb.append(string);
        this.jj_consume_token(328);
        sb.append(" ");
        sb.append(this.token.image);
        string = this.datatype();
        sb.append(" ");
        sb.append(string);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 330: {
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(330);
            sb.append(" ");
            sb.append(this.token.image);
            string = this.ConditionalOrExpression();
            sb.append(" ");
            sb.append(string);
            this.jj_consume_token(328);
            sb.append(" ");
            sb.append(this.token.image);
            string = this.datatype();
            sb.append(" ");
            sb.append(string);
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 329: {
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(329);
            sb.append(" ");
            sb.append(this.token.image);
            string = this.datatype();
            sb.append(" ");
            sb.append(string);
        }
        this.jj_consume_token(331);
        sb.append(" ");
        sb.append(this.token.image);
        return sb.toString();
    }

    public final String collection_type_name() throws ParseException {
        Token size = null;
        Token precision = null;
        String name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 268: {
                this.jj_consume_token(268);
                break;
            }
            case 307: {
                this.jj_consume_token(307);
                break;
            }
            case 308: {
                this.jj_consume_token(308);
                this.jj_consume_token(49);
                name = "VARYING ARRAY";
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (name == null) {
            name = this.token.toString();
        }
        if (this.jj_2_33(2)) {
            this.jj_consume_token(5);
            size = this.numericLiteral();
            name = name + "(" + size;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    this.jj_consume_token(6);
                    precision = this.numericLiteral();
                    name = name + "," + precision;
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    name = name + " CHAR";
                    break;
                }
                default: {
                    this.jj_la1[122] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    this.jj_consume_token(63);
                    name = name + " BYTE";
                    break;
                }
                default: {
                    this.jj_la1[123] = this.jj_gen;
                }
            }
            this.jj_consume_token(7);
            name = name + ")";
        }
        return name;
    }

    public final String scalar_datatype_name() throws ParseException {
        Token size = null;
        Token precision = null;
        String name = null;
        String precisionString = null;
        String string = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 186: {
                this.jj_consume_token(186);
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 298: {
                this.jj_consume_token(298);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 297: {
                this.jj_consume_token(297);
                this.jj_consume_token(299);
                name = "DOUBLE PRECISION";
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 300: {
                this.jj_consume_token(300);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                break;
            }
            case 172: {
                this.jj_consume_token(172);
                break;
            }
            case 173: {
                this.jj_consume_token(173);
                break;
            }
            case 185: {
                this.jj_consume_token(185);
                break;
            }
            case 301: {
                this.jj_consume_token(301);
                break;
            }
            case 212: {
                this.jj_consume_token(212);
                break;
            }
            case 213: {
                this.jj_consume_token(213);
                break;
            }
            case 214: {
                this.jj_consume_token(214);
                break;
            }
            case 225: {
                this.jj_consume_token(225);
                break;
            }
            case 302: {
                this.jj_consume_token(302);
                break;
            }
            case 253: {
                this.jj_consume_token(253);
                break;
            }
            case 66: 
            case 158: 
            case 224: 
            case 241: 
            case 295: 
            case 296: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 311: 
            case 312: 
            case 317: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break block0;
                    }
                    case 317: {
                        this.jj_consume_token(317);
                        break block0;
                    }
                }
                this.jj_la1[124] = this.jj_gen;
                if (this.jj_2_34(2)) {
                    this.jj_consume_token(158);
                    this.jj_consume_token(224);
                    name = "LONG RAW";
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 158: {
                        this.jj_consume_token(158);
                        break block0;
                    }
                    case 303: {
                        this.jj_consume_token(303);
                        break block0;
                    }
                    case 304: {
                        this.jj_consume_token(304);
                        break block0;
                    }
                    case 224: {
                        this.jj_consume_token(224);
                        break block0;
                    }
                    case 241: {
                        this.jj_consume_token(241);
                        break block0;
                    }
                    case 305: {
                        this.jj_consume_token(305);
                        break block0;
                    }
                    case 306: {
                        this.jj_consume_token(306);
                        break block0;
                    }
                    case 295: {
                        this.jj_consume_token(295);
                        break block0;
                    }
                    case 296: {
                        this.jj_consume_token(296);
                        break block0;
                    }
                    case 311: {
                        this.jj_consume_token(311);
                        break block0;
                    }
                    case 312: {
                        this.jj_consume_token(312);
                        break block0;
                    }
                }
                this.jj_la1[125] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 309: {
                this.jj_consume_token(309);
                break;
            }
            case 310: {
                this.jj_consume_token(310);
                break;
            }
            case 267: {
                this.jj_consume_token(267);
                break;
            }
            case 227: {
                this.jj_consume_token(227);
                this.jj_consume_token(85);
                name = "REF CURSOR";
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            default: {
                this.jj_la1[126] = this.jj_gen;
                if (this.jj_2_35(2)) {
                    this.jj_consume_token(147);
                    this.jj_consume_token(313);
                    name = "INTERVAL YEAR";
                    break;
                }
                if (this.jj_2_36(2)) {
                    this.jj_consume_token(147);
                    this.jj_consume_token(88);
                    name = "INTERVAL DAY";
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 271: {
                        this.jj_consume_token(271);
                        break block0;
                    }
                    case 272: {
                        this.jj_consume_token(272);
                        break block0;
                    }
                    case 248: {
                        this.jj_consume_token(248);
                        this.jj_consume_token(50);
                        this.jj_consume_token(232);
                        name = "SELF AS RESULT";
                        break block0;
                    }
                }
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (name == null) {
            name = this.token.toString();
        }
        if (this.jj_2_37(2)) {
            this.jj_consume_token(5);
            size = this.numericLiteral();
            name = name + "(" + size;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    this.jj_consume_token(6);
                    precisionString = this.UnaryExpression(true);
                    name = name + "," + precisionString;
                    break;
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    name = name + " CHAR";
                    break;
                }
                default: {
                    this.jj_la1[129] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    this.jj_consume_token(63);
                    name = name + " BYTE";
                    break;
                }
                default: {
                    this.jj_la1[130] = this.jj_gen;
                }
            }
            this.jj_consume_token(7);
            name = name + ")";
        }
        block63 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 277: 
            case 315: 
            case 317: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 317: {
                        this.jj_consume_token(317);
                        this.jj_consume_token(250);
                        string = this.Name();
                        name = name + " CHARACTER SET " + string;
                        break block63;
                    }
                }
                this.jj_la1[131] = this.jj_gen;
                if (this.jj_2_39(4)) {
                    this.jj_consume_token(315);
                    this.jj_consume_token(314);
                    this.jj_consume_token(271);
                    this.jj_consume_token(316);
                    name = name + " WITH LOCAL TIME ZONE";
                    break;
                }
                if (this.jj_2_40(3)) {
                    this.jj_consume_token(315);
                    this.jj_consume_token(271);
                    this.jj_consume_token(316);
                    name = name + " WITH TIME ZONE";
                    break;
                }
                if (this.jj_2_41(2)) {
                    this.jj_consume_token(277);
                    this.jj_consume_token(171);
                    name = name + " TO MONTH";
                    break;
                }
                if (this.jj_2_42(2)) {
                    this.jj_consume_token(277);
                    this.jj_consume_token(246);
                    name = name + " TO SECOND";
                    if (!this.jj_2_38(2)) break;
                    this.jj_consume_token(5);
                    precision = this.numericLiteral();
                    name = name + "(" + precision;
                    this.jj_consume_token(7);
                    name = name + ")";
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
            }
        }
        return name;
    }

    public final String DateTimeLiteral() throws ParseException {
        Object literal_type = null;
        Token type1 = null;
        Token type2 = null;
        Token size = null;
        String literal_string = null;
        StringBuffer sb = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 147: {
                this.jj_consume_token(147);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 272: {
                this.jj_consume_token(272);
                break;
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        sb.append(this.token.toString());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 428: {
                this.jj_consume_token(428);
                sb.append(" ");
                sb.append(this.token.toString());
                break;
            }
            case 429: {
                literal_string = this.StringLiteral();
                sb.append(" ");
                sb.append(literal_string);
                break;
            }
            default: {
                this.jj_la1[134] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 132: 
            case 166: 
            case 171: 
            case 246: 
            case 313: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 313: {
                        type1 = this.jj_consume_token(313);
                        break block9;
                    }
                    case 171: {
                        type1 = this.jj_consume_token(171);
                        break block9;
                    }
                    case 88: {
                        type1 = this.jj_consume_token(88);
                        break block9;
                    }
                    case 132: {
                        type1 = this.jj_consume_token(132);
                        break block9;
                    }
                    case 166: {
                        type1 = this.jj_consume_token(166);
                        break block9;
                    }
                    case 246: {
                        type1 = this.jj_consume_token(246);
                        break block9;
                    }
                }
                this.jj_la1[135] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
            }
        }
        if (type1 != null) {
            sb.append(" ");
            sb.append(type1.toString());
        }
        if (this.jj_2_43(2)) {
            this.jj_consume_token(5);
            size = this.numericLiteral();
            sb.append("(");
            sb.append(size);
            this.jj_consume_token(7);
            sb.append(")");
        }
        block20 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 277: 
            case 315: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 315: {
                        this.jj_consume_token(315);
                        sb.append(" ");
                        sb.append(this.token.toString());
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 314: {
                                this.jj_consume_token(314);
                                sb.append(" ");
                                sb.append(this.token.toString());
                                break;
                            }
                            default: {
                                this.jj_la1[137] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(271);
                        this.jj_consume_token(316);
                        sb.append(" TIME ZONE");
                        break block20;
                    }
                    case 277: {
                        this.jj_consume_token(277);
                        sb.append(" ");
                        sb.append(this.token.toString());
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 313: {
                                type2 = this.jj_consume_token(313);
                                break;
                            }
                            case 171: {
                                type2 = this.jj_consume_token(171);
                                break;
                            }
                            case 88: {
                                type2 = this.jj_consume_token(88);
                                break;
                            }
                            case 132: {
                                type2 = this.jj_consume_token(132);
                                break;
                            }
                            case 166: {
                                type2 = this.jj_consume_token(166);
                                break;
                            }
                            case 246: {
                                type2 = this.jj_consume_token(246);
                                break;
                            }
                            default: {
                                this.jj_la1[138] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        sb.append(" ");
                        sb.append(type2.toString());
                        if (!this.jj_2_44(2)) break block20;
                        this.jj_consume_token(5);
                        size = this.numericLiteral();
                        sb.append("(");
                        sb.append(size);
                        this.jj_consume_token(7);
                        sb.append(")");
                        break block20;
                    }
                    default: {
                        this.jj_la1[139] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[140] = this.jj_gen;
            }
        }
        return sb.toString();
    }

    public final void exceptionHandler() throws ParseException, SAXException {
        this.jj_consume_token(107);
        while (this.jj_2_45(2)) {
            this.jj_consume_token(287);
            this.qualifiedName();
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 200: {
                        break;
                    }
                    default: {
                        this.jj_la1[141] = this.jj_gen;
                        break block13;
                    }
                }
                this.jj_consume_token(200);
                this.qualifiedName();
            }
            this.jj_consume_token(270);
            block14: while (true) {
                this.statement();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 9: 
                    case 18: 
                    case 21: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 92: 
                    case 95: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 129: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 135: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 157: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 180: 
                    case 181: 
                    case 183: 
                    case 184: 
                    case 191: 
                    case 194: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 210: 
                    case 215: 
                    case 216: 
                    case 219: 
                    case 220: 
                    case 222: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 250: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 259: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 266: 
                    case 267: 
                    case 269: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 283: 
                    case 285: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 327: 
                    case 332: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 424: 
                    case 428: 
                    case 429: 
                    case 431: {
                        continue block14;
                    }
                }
                break;
            }
            this.jj_la1[142] = this.jj_gen;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 287: {
                this.jj_consume_token(287);
                this.jj_consume_token(203);
                this.jj_consume_token(270);
                block15: while (true) {
                    this.statement();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 9: 
                        case 18: 
                        case 21: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 56: 
                        case 59: 
                        case 61: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 92: 
                        case 95: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 110: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 129: 
                        case 131: 
                        case 132: 
                        case 134: 
                        case 135: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 147: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 155: 
                        case 157: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 180: 
                        case 181: 
                        case 183: 
                        case 184: 
                        case 191: 
                        case 194: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 210: 
                        case 215: 
                        case 216: 
                        case 219: 
                        case 220: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 259: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 266: 
                        case 267: 
                        case 269: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 283: 
                        case 285: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 294: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 327: 
                        case 332: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 424: 
                        case 428: 
                        case 429: 
                        case 431: {
                            continue block15;
                        }
                    }
                    break;
                }
                this.jj_la1[143] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
            }
        }
    }

    public final void skip2NextTerminator(String initiator, String terminator) throws ParseException {
        int count;
        Token t = this.getToken(1);
        int n = count = initiator == null ? 0 : 1;
        if (t.image.equals(initiator)) {
            ++count;
        }
        while (count > 0 || !t.image.equals(terminator)) {
            t = this.getNextToken();
            t = this.getToken(1);
            if (t.image.equals(initiator)) {
                ++count;
            }
            if (!t.image.equals(terminator)) continue;
            --count;
        }
    }

    public final void skip2NextOccurrence(String target) throws ParseException {
        Token nextToken = this.getToken(1);
        while (!(nextToken.image.equals(target) || null != nextToken.specialToken && nextToken.specialToken.image.equals(target) || nextToken.kind == 0)) {
            nextToken = this.getNextToken();
            nextToken = this.getToken(1);
        }
    }

    public final void skipPastNextOccurrence(String target) throws ParseException {
        Token t = null;
        this.skip2NextOccurrence(target);
        t = this.getNextToken();
    }

    public final void skip2NextTokenOccurrence(int target) throws ParseException {
        Token nextToken = this.getToken(1);
        Token specToken = null;
        while (nextToken.kind != target && (null == nextToken.specialToken || nextToken.specialToken.kind != target) && nextToken.kind != 0) {
            specToken = nextToken.specialToken;
            if (null != specToken) {
                while (specToken != null && specToken.kind != target) {
                    specToken = specToken.specialToken;
                }
                if (null != specToken && specToken.kind == target) break;
            }
            nextToken = this.getNextToken();
            nextToken = this.getToken(1);
        }
    }

    public final void skipPastNextTokenOccurrence(int target) throws ParseException {
        Token t = null;
        this.skip2NextTokenOccurrence(target);
        t = this.getNextToken();
    }

    public final String read2NextOccurrence(String target) throws ParseException {
        StringBuffer sb = new StringBuffer();
        Token nextToken = this.getToken(1);
        while (!nextToken.image.equals(target) && nextToken.kind != 0) {
            nextToken = this.getNextToken();
            sb.append(nextToken.image);
            nextToken = this.getToken(1);
        }
        return sb.toString();
    }

    public final String readPastNextOccurrence(String target) throws ParseException {
        StringBuffer sb = new StringBuffer();
        Token t = null;
        sb.append(this.read2NextOccurrence(target));
        t = this.getNextToken();
        sb.append(t.image);
        return sb.toString();
    }

    public final void sqlStatement(String initiator, String terminator) throws ParseException, SAXException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 247: {
                this.jj_consume_token(247);
                break;
            }
            case 294: {
                this.jj_consume_token(294);
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 238: {
                this.jj_consume_token(238);
                break;
            }
            case 245: {
                this.jj_consume_token(245);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 250: {
                this.jj_consume_token(250);
                this.jj_consume_token(278);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                this.jj_consume_token(268);
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                break;
            }
            case 315: {
                this.jj_consume_token(315);
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.skip2NextTerminator(initiator, terminator);
    }

    public final void wrappedObject() throws ParseException, SAXException {
        this.jj_consume_token(363);
        Token nextToken = this.getToken(1);
        while (null != nextToken && nextToken.kind != 0) {
            nextToken = this.getNextToken();
            nextToken = this.getToken(1);
        }
    }

    public final void statement() throws ParseException, SAXException {
        if (this.jj_2_46(Integer.MAX_VALUE)) {
            this.sqlStatement(null, ";");
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                    break;
                }
            }
        } else if (this.jj_2_47(3)) {
            this.jj_consume_token(80);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 423: {
                    this.jj_consume_token(423);
                    break;
                }
                default: {
                    this.jj_la1[147] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 287: {
                    this.jj_consume_token(287);
                    this.Expression();
                    break;
                }
                default: {
                    this.jj_la1[148] = this.jj_gen;
                }
            }
            this.jj_consume_token(4);
        } else {
            block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    this.jj_consume_token(65);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 9: 
                        case 18: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 59: 
                        case 61: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 95: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 118: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 129: 
                        case 131: 
                        case 132: 
                        case 135: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 147: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 155: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 180: 
                        case 181: 
                        case 183: 
                        case 184: 
                        case 191: 
                        case 194: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 216: 
                        case 219: 
                        case 220: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 259: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 266: 
                        case 267: 
                        case 269: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 283: 
                        case 285: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 327: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 424: 
                        case 428: 
                        case 429: 
                        case 431: {
                            this.Expression();
                            break;
                        }
                        default: {
                            this.jj_la1[149] = this.jj_gen;
                        }
                    }
                    block210: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 287: {
                                break;
                            }
                            default: {
                                this.jj_la1[150] = this.jj_gen;
                                break block210;
                            }
                        }
                        this.jj_consume_token(287);
                        this.Expression();
                        this.jj_consume_token(270);
                        block211: while (true) {
                            this.statement();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    continue block211;
                                }
                            }
                            break;
                        }
                        this.jj_la1[151] = this.jj_gen;
                    }
                    block212: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 101: {
                                break;
                            }
                            default: {
                                this.jj_la1[152] = this.jj_gen;
                                break block212;
                            }
                        }
                        this.jj_consume_token(101);
                        block213: while (true) {
                            this.statement();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    continue block213;
                                }
                            }
                            break;
                        }
                        this.jj_la1[153] = this.jj_gen;
                    }
                    this.jj_consume_token(104);
                    this.jj_consume_token(65);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 423: {
                            this.jj_consume_token(423);
                            break;
                        }
                        default: {
                            this.jj_la1[154] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(4);
                    break;
                }
                case 134: {
                    this.jj_consume_token(134);
                    this.Expression();
                    this.jj_consume_token(270);
                    block214: while (true) {
                        this.statement();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 9: 
                            case 18: 
                            case 21: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 49: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 56: 
                            case 59: 
                            case 61: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 69: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 83: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 92: 
                            case 95: 
                            case 99: 
                            case 100: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 108: 
                            case 110: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 129: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 147: 
                            case 149: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 155: 
                            case 157: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 171: 
                            case 172: 
                            case 174: 
                            case 175: 
                            case 177: 
                            case 180: 
                            case 181: 
                            case 183: 
                            case 184: 
                            case 191: 
                            case 194: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 202: 
                            case 203: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 210: 
                            case 215: 
                            case 216: 
                            case 219: 
                            case 220: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 250: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 259: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 266: 
                            case 267: 
                            case 269: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 280: 
                            case 281: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 332: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 424: 
                            case 428: 
                            case 429: 
                            case 431: {
                                continue block214;
                            }
                        }
                        break;
                    }
                    this.jj_la1[155] = this.jj_gen;
                    block215: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 102: {
                                break;
                            }
                            default: {
                                this.jj_la1[156] = this.jj_gen;
                                break block215;
                            }
                        }
                        this.jj_consume_token(102);
                        this.Expression();
                        this.jj_consume_token(270);
                        block216: while (true) {
                            this.statement();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    continue block216;
                                }
                            }
                            break;
                        }
                        this.jj_la1[157] = this.jj_gen;
                    }
                    block217: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 101: {
                                break;
                            }
                            default: {
                                this.jj_la1[158] = this.jj_gen;
                                break block217;
                            }
                        }
                        this.jj_consume_token(101);
                        block218: while (true) {
                            this.statement();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    continue block218;
                                }
                            }
                            break;
                        }
                        this.jj_la1[159] = this.jj_gen;
                    }
                    this.jj_consume_token(104);
                    this.jj_consume_token(134);
                    this.jj_consume_token(4);
                    break;
                }
                case 120: {
                    this.jj_consume_token(120);
                    this.ID();
                    this.jj_consume_token(136);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 236: {
                            this.jj_consume_token(236);
                            break;
                        }
                        default: {
                            this.jj_la1[160] = this.jj_gen;
                        }
                    }
                    this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: {
                            this.jj_consume_token(14);
                            this.Expression();
                            break;
                        }
                        default: {
                            this.jj_la1[161] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(159);
                    block219: while (true) {
                        this.statement();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 9: 
                            case 18: 
                            case 21: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 49: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 56: 
                            case 59: 
                            case 61: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 69: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 83: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 92: 
                            case 95: 
                            case 99: 
                            case 100: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 108: 
                            case 110: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 129: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 147: 
                            case 149: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 155: 
                            case 157: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 171: 
                            case 172: 
                            case 174: 
                            case 175: 
                            case 177: 
                            case 180: 
                            case 181: 
                            case 183: 
                            case 184: 
                            case 191: 
                            case 194: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 202: 
                            case 203: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 210: 
                            case 215: 
                            case 216: 
                            case 219: 
                            case 220: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 250: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 259: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 266: 
                            case 267: 
                            case 269: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 280: 
                            case 281: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 332: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 424: 
                            case 428: 
                            case 429: 
                            case 431: {
                                continue block219;
                            }
                        }
                        break;
                    }
                    this.jj_la1[162] = this.jj_gen;
                    this.jj_consume_token(104);
                    this.jj_consume_token(159);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 423: {
                            this.jj_consume_token(423);
                            break;
                        }
                        default: {
                            this.jj_la1[163] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(4);
                    break;
                }
                case 121: {
                    this.jj_consume_token(121);
                    this.ID();
                    this.jj_consume_token(136);
                    block60 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 138: 
                        case 286: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 138: {
                                    this.jj_consume_token(138);
                                    break;
                                }
                                case 286: {
                                    this.jj_consume_token(286);
                                    break;
                                }
                                default: {
                                    this.jj_la1[164] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_consume_token(193);
                            this.Expression();
                            break;
                        }
                        case 5: 
                        case 9: 
                        case 18: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 59: 
                        case 61: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 95: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 118: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 129: 
                        case 131: 
                        case 132: 
                        case 135: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 147: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 155: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 180: 
                        case 181: 
                        case 183: 
                        case 184: 
                        case 191: 
                        case 194: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 216: 
                        case 219: 
                        case 220: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 259: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 266: 
                        case 267: 
                        case 269: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 283: 
                        case 285: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 327: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 424: 
                        case 428: 
                        case 429: 
                        case 431: {
                            this.Expression();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 14: {
                                    this.jj_consume_token(14);
                                    this.Expression();
                                    break block60;
                                }
                            }
                            this.jj_la1[165] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[166] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 244: {
                            this.jj_consume_token(244);
                            this.jj_consume_token(108);
                            break;
                        }
                        default: {
                            this.jj_la1[167] = this.jj_gen;
                        }
                    }
                    this.sqlStatement(null, ";");
                    this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[206] = this.jj_gen;
                    if (this.jj_2_48(2)) {
                        this.jj_consume_token(159);
                        block220: while (true) {
                            this.statement();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    continue block220;
                                }
                            }
                            break;
                        }
                        this.jj_la1[168] = this.jj_gen;
                        this.jj_consume_token(104);
                        this.jj_consume_token(159);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 423: {
                                this.jj_consume_token(423);
                                break;
                            }
                            default: {
                                this.jj_la1[169] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(4);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 289: {
                            this.jj_consume_token(289);
                            this.Expression();
                            this.jj_consume_token(159);
                            block221: while (true) {
                                this.statement();
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 5: 
                                    case 9: 
                                    case 18: 
                                    case 21: 
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 49: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 56: 
                                    case 59: 
                                    case 61: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 69: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 83: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 92: 
                                    case 95: 
                                    case 99: 
                                    case 100: 
                                    case 103: 
                                    case 105: 
                                    case 106: 
                                    case 108: 
                                    case 110: 
                                    case 112: 
                                    case 113: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 124: 
                                    case 125: 
                                    case 126: 
                                    case 129: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 135: 
                                    case 138: 
                                    case 140: 
                                    case 141: 
                                    case 142: 
                                    case 143: 
                                    case 147: 
                                    case 149: 
                                    case 151: 
                                    case 152: 
                                    case 153: 
                                    case 155: 
                                    case 157: 
                                    case 159: 
                                    case 160: 
                                    case 161: 
                                    case 162: 
                                    case 163: 
                                    case 164: 
                                    case 166: 
                                    case 167: 
                                    case 168: 
                                    case 169: 
                                    case 171: 
                                    case 172: 
                                    case 174: 
                                    case 175: 
                                    case 177: 
                                    case 180: 
                                    case 181: 
                                    case 183: 
                                    case 184: 
                                    case 191: 
                                    case 194: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 202: 
                                    case 203: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 210: 
                                    case 215: 
                                    case 216: 
                                    case 219: 
                                    case 220: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 232: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 250: 
                                    case 254: 
                                    case 255: 
                                    case 256: 
                                    case 257: 
                                    case 259: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 266: 
                                    case 267: 
                                    case 269: 
                                    case 271: 
                                    case 272: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 278: 
                                    case 280: 
                                    case 281: 
                                    case 283: 
                                    case 285: 
                                    case 289: 
                                    case 290: 
                                    case 291: 
                                    case 293: 
                                    case 294: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 323: 
                                    case 324: 
                                    case 327: 
                                    case 332: 
                                    case 341: 
                                    case 342: 
                                    case 343: 
                                    case 344: 
                                    case 345: 
                                    case 346: 
                                    case 347: 
                                    case 348: 
                                    case 349: 
                                    case 350: 
                                    case 351: 
                                    case 352: 
                                    case 353: 
                                    case 354: 
                                    case 355: 
                                    case 356: 
                                    case 357: 
                                    case 358: 
                                    case 359: 
                                    case 360: 
                                    case 361: 
                                    case 362: 
                                    case 363: 
                                    case 364: 
                                    case 365: 
                                    case 366: 
                                    case 367: 
                                    case 368: 
                                    case 369: 
                                    case 370: 
                                    case 371: 
                                    case 372: 
                                    case 373: 
                                    case 374: 
                                    case 375: 
                                    case 376: 
                                    case 377: 
                                    case 378: 
                                    case 379: 
                                    case 380: 
                                    case 381: 
                                    case 382: 
                                    case 383: 
                                    case 384: 
                                    case 385: 
                                    case 386: 
                                    case 387: 
                                    case 388: 
                                    case 389: 
                                    case 390: 
                                    case 391: 
                                    case 392: 
                                    case 393: 
                                    case 394: 
                                    case 395: 
                                    case 396: 
                                    case 397: 
                                    case 398: 
                                    case 399: 
                                    case 403: 
                                    case 404: 
                                    case 405: 
                                    case 406: 
                                    case 407: 
                                    case 408: 
                                    case 409: 
                                    case 410: 
                                    case 411: 
                                    case 412: 
                                    case 413: 
                                    case 414: 
                                    case 415: 
                                    case 423: 
                                    case 424: 
                                    case 428: 
                                    case 429: 
                                    case 431: {
                                        continue block221;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[170] = this.jj_gen;
                            this.jj_consume_token(104);
                            this.jj_consume_token(159);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 423: {
                                    this.jj_consume_token(423);
                                    break;
                                }
                                default: {
                                    this.jj_la1[171] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 126: {
                            this.jj_consume_token(126);
                            this.qualifiedName();
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 234: {
                            this.jj_consume_token(234);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 118: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    this.Expression();
                                    break;
                                }
                                default: {
                                    this.jj_la1[172] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 112: {
                            this.jj_consume_token(112);
                            block107 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 287: 
                                case 423: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 287: {
                                            this.jj_consume_token(287);
                                            this.Expression();
                                            break block107;
                                        }
                                        case 423: {
                                            this.jj_consume_token(423);
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 287: {
                                                    this.jj_consume_token(287);
                                                    this.Expression();
                                                    break block107;
                                                }
                                            }
                                            this.jj_la1[173] = this.jj_gen;
                                            break block107;
                                        }
                                    }
                                    this.jj_la1[174] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                                default: {
                                    this.jj_la1[175] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 222: {
                            this.jj_consume_token(222);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 88: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 118: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 177: 
                                case 180: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 431: {
                                    this.qualifiedName();
                                    break;
                                }
                                default: {
                                    this.jj_la1[176] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 69: {
                            this.jj_consume_token(69);
                            this.qualifiedName();
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 197: {
                            this.jj_consume_token(197);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 118: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    this.Expression();
                                    break;
                                }
                                default: {
                                    this.jj_la1[177] = this.jj_gen;
                                }
                            }
                            block123 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 120: {
                                    this.jj_consume_token(120);
                                    this.Expression();
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 285: {
                                            this.jj_consume_token(285);
                                            this.Expression();
                                            while (true) {
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 6: {
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[178] = this.jj_gen;
                                                        break block123;
                                                    }
                                                }
                                                this.jj_consume_token(6);
                                                this.Expression();
                                            }
                                        }
                                    }
                                    this.jj_la1[179] = this.jj_gen;
                                    break;
                                }
                                default: {
                                    this.jj_la1[180] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 117: {
                            this.jj_consume_token(117);
                            this.qualifiedName();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 61: {
                                    this.jj_consume_token(61);
                                    this.jj_consume_token(72);
                                    break;
                                }
                                default: {
                                    this.jj_la1[181] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(148);
                            this.Expression();
                            block223: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 6: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[182] = this.jj_gen;
                                        break block223;
                                    }
                                }
                                this.jj_consume_token(6);
                                this.Expression();
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 155: {
                                    this.jj_consume_token(155);
                                    this.Expression();
                                    break;
                                }
                                default: {
                                    this.jj_la1[183] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 21: {
                            this.label();
                            this.statement();
                            break block9;
                        }
                        case 56: 
                        case 89: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 89: {
                                    this.jj_consume_token(89);
                                    this.declarativeSection(false, this.token);
                                    break;
                                }
                                default: {
                                    this.jj_la1[184] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(56);
                            block224: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 5: 
                                    case 9: 
                                    case 18: 
                                    case 21: 
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 49: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 56: 
                                    case 59: 
                                    case 61: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 69: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 83: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 92: 
                                    case 95: 
                                    case 99: 
                                    case 100: 
                                    case 103: 
                                    case 105: 
                                    case 106: 
                                    case 108: 
                                    case 110: 
                                    case 112: 
                                    case 113: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 124: 
                                    case 125: 
                                    case 126: 
                                    case 129: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 135: 
                                    case 138: 
                                    case 140: 
                                    case 141: 
                                    case 142: 
                                    case 143: 
                                    case 147: 
                                    case 149: 
                                    case 151: 
                                    case 152: 
                                    case 153: 
                                    case 155: 
                                    case 157: 
                                    case 159: 
                                    case 160: 
                                    case 161: 
                                    case 162: 
                                    case 163: 
                                    case 164: 
                                    case 166: 
                                    case 167: 
                                    case 168: 
                                    case 169: 
                                    case 171: 
                                    case 172: 
                                    case 174: 
                                    case 175: 
                                    case 177: 
                                    case 180: 
                                    case 181: 
                                    case 183: 
                                    case 184: 
                                    case 191: 
                                    case 194: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 202: 
                                    case 203: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 210: 
                                    case 215: 
                                    case 216: 
                                    case 219: 
                                    case 220: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 232: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 250: 
                                    case 254: 
                                    case 255: 
                                    case 256: 
                                    case 257: 
                                    case 259: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 266: 
                                    case 267: 
                                    case 269: 
                                    case 271: 
                                    case 272: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 278: 
                                    case 280: 
                                    case 281: 
                                    case 283: 
                                    case 285: 
                                    case 289: 
                                    case 290: 
                                    case 291: 
                                    case 293: 
                                    case 294: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 323: 
                                    case 324: 
                                    case 327: 
                                    case 332: 
                                    case 341: 
                                    case 342: 
                                    case 343: 
                                    case 344: 
                                    case 345: 
                                    case 346: 
                                    case 347: 
                                    case 348: 
                                    case 349: 
                                    case 350: 
                                    case 351: 
                                    case 352: 
                                    case 353: 
                                    case 354: 
                                    case 355: 
                                    case 356: 
                                    case 357: 
                                    case 358: 
                                    case 359: 
                                    case 360: 
                                    case 361: 
                                    case 362: 
                                    case 363: 
                                    case 364: 
                                    case 365: 
                                    case 366: 
                                    case 367: 
                                    case 368: 
                                    case 369: 
                                    case 370: 
                                    case 371: 
                                    case 372: 
                                    case 373: 
                                    case 374: 
                                    case 375: 
                                    case 376: 
                                    case 377: 
                                    case 378: 
                                    case 379: 
                                    case 380: 
                                    case 381: 
                                    case 382: 
                                    case 383: 
                                    case 384: 
                                    case 385: 
                                    case 386: 
                                    case 387: 
                                    case 388: 
                                    case 389: 
                                    case 390: 
                                    case 391: 
                                    case 392: 
                                    case 393: 
                                    case 394: 
                                    case 395: 
                                    case 396: 
                                    case 397: 
                                    case 398: 
                                    case 399: 
                                    case 403: 
                                    case 404: 
                                    case 405: 
                                    case 406: 
                                    case 407: 
                                    case 408: 
                                    case 409: 
                                    case 410: 
                                    case 411: 
                                    case 412: 
                                    case 413: 
                                    case 414: 
                                    case 415: 
                                    case 423: 
                                    case 424: 
                                    case 428: 
                                    case 429: 
                                    case 431: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[185] = this.jj_gen;
                                        break block224;
                                    }
                                }
                                this.statement();
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 107: {
                                    this.exceptionHandler();
                                    break;
                                }
                                default: {
                                    this.jj_la1[186] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(104);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 423: {
                                    this.jj_consume_token(423);
                                    break;
                                }
                                default: {
                                    this.jj_la1[187] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 110: {
                            this.jj_consume_token(110);
                            this.jj_consume_token(135);
                            this.Expression();
                            block153 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 148: {
                                    this.jj_consume_token(148);
                                    this.Name();
                                    while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[188] = this.jj_gen;
                                                break block153;
                                            }
                                        }
                                        this.jj_consume_token(6);
                                        this.Name();
                                    }
                                }
                                default: {
                                    this.jj_la1[189] = this.jj_gen;
                                }
                            }
                            block159 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 285: {
                                    this.jj_consume_token(285);
                                    block162 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 136: 
                                        case 204: {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 136: {
                                                    this.jj_consume_token(136);
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 204: {
                                                            this.jj_consume_token(204);
                                                            break block162;
                                                        }
                                                    }
                                                    this.jj_la1[190] = this.jj_gen;
                                                    break block162;
                                                }
                                                case 204: {
                                                    this.jj_consume_token(204);
                                                    break block162;
                                                }
                                            }
                                            this.jj_la1[191] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                        default: {
                                            this.jj_la1[192] = this.jj_gen;
                                        }
                                    }
                                    this.Expression();
                                    while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[193] = this.jj_gen;
                                                break block159;
                                            }
                                        }
                                        this.jj_consume_token(6);
                                        block175 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 136: 
                                            case 204: {
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 136: {
                                                        this.jj_consume_token(136);
                                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                            case 204: {
                                                                this.jj_consume_token(204);
                                                                break block175;
                                                            }
                                                        }
                                                        this.jj_la1[194] = this.jj_gen;
                                                        break block175;
                                                    }
                                                    case 204: {
                                                        this.jj_consume_token(204);
                                                        break block175;
                                                    }
                                                }
                                                this.jj_la1[195] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                            default: {
                                                this.jj_la1[196] = this.jj_gen;
                                            }
                                        }
                                        this.Expression();
                                    }
                                }
                                default: {
                                    this.jj_la1[197] = this.jj_gen;
                                }
                            }
                            block185 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 234: 
                                case 235: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 234: {
                                            this.jj_consume_token(234);
                                            break;
                                        }
                                        case 235: {
                                            this.jj_consume_token(235);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[198] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    this.jj_consume_token(148);
                                    this.Expression();
                                    while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[199] = this.jj_gen;
                                                break block185;
                                            }
                                        }
                                        this.jj_consume_token(6);
                                        this.Expression();
                                    }
                                }
                                default: {
                                    this.jj_la1[200] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 210: {
                            this.jj_consume_token(210);
                            this.jj_consume_token(239);
                            this.Expression();
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 327: {
                            this.jj_consume_token(327);
                            this.ConditionalOrExpression();
                            this.jj_consume_token(328);
                            block228: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 5: 
                                    case 9: 
                                    case 18: 
                                    case 21: 
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 49: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 56: 
                                    case 59: 
                                    case 61: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 69: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 83: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 92: 
                                    case 95: 
                                    case 99: 
                                    case 100: 
                                    case 103: 
                                    case 105: 
                                    case 106: 
                                    case 108: 
                                    case 110: 
                                    case 112: 
                                    case 113: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 124: 
                                    case 125: 
                                    case 126: 
                                    case 129: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 135: 
                                    case 138: 
                                    case 140: 
                                    case 141: 
                                    case 142: 
                                    case 143: 
                                    case 147: 
                                    case 149: 
                                    case 151: 
                                    case 152: 
                                    case 153: 
                                    case 155: 
                                    case 157: 
                                    case 159: 
                                    case 160: 
                                    case 161: 
                                    case 162: 
                                    case 163: 
                                    case 164: 
                                    case 166: 
                                    case 167: 
                                    case 168: 
                                    case 169: 
                                    case 171: 
                                    case 172: 
                                    case 174: 
                                    case 175: 
                                    case 177: 
                                    case 180: 
                                    case 181: 
                                    case 183: 
                                    case 184: 
                                    case 191: 
                                    case 194: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 202: 
                                    case 203: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 210: 
                                    case 215: 
                                    case 216: 
                                    case 219: 
                                    case 220: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 232: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 250: 
                                    case 254: 
                                    case 255: 
                                    case 256: 
                                    case 257: 
                                    case 259: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 266: 
                                    case 267: 
                                    case 269: 
                                    case 271: 
                                    case 272: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 278: 
                                    case 280: 
                                    case 281: 
                                    case 283: 
                                    case 285: 
                                    case 289: 
                                    case 290: 
                                    case 291: 
                                    case 293: 
                                    case 294: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 323: 
                                    case 324: 
                                    case 327: 
                                    case 332: 
                                    case 341: 
                                    case 342: 
                                    case 343: 
                                    case 344: 
                                    case 345: 
                                    case 346: 
                                    case 347: 
                                    case 348: 
                                    case 349: 
                                    case 350: 
                                    case 351: 
                                    case 352: 
                                    case 353: 
                                    case 354: 
                                    case 355: 
                                    case 356: 
                                    case 357: 
                                    case 358: 
                                    case 359: 
                                    case 360: 
                                    case 361: 
                                    case 362: 
                                    case 363: 
                                    case 364: 
                                    case 365: 
                                    case 366: 
                                    case 367: 
                                    case 368: 
                                    case 369: 
                                    case 370: 
                                    case 371: 
                                    case 372: 
                                    case 373: 
                                    case 374: 
                                    case 375: 
                                    case 376: 
                                    case 377: 
                                    case 378: 
                                    case 379: 
                                    case 380: 
                                    case 381: 
                                    case 382: 
                                    case 383: 
                                    case 384: 
                                    case 385: 
                                    case 386: 
                                    case 387: 
                                    case 388: 
                                    case 389: 
                                    case 390: 
                                    case 391: 
                                    case 392: 
                                    case 393: 
                                    case 394: 
                                    case 395: 
                                    case 396: 
                                    case 397: 
                                    case 398: 
                                    case 399: 
                                    case 403: 
                                    case 404: 
                                    case 405: 
                                    case 406: 
                                    case 407: 
                                    case 408: 
                                    case 409: 
                                    case 410: 
                                    case 411: 
                                    case 412: 
                                    case 413: 
                                    case 414: 
                                    case 415: 
                                    case 423: 
                                    case 424: 
                                    case 428: 
                                    case 429: 
                                    case 431: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[201] = this.jj_gen;
                                        break block228;
                                    }
                                }
                                this.statement();
                            }
                            block229: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 330: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[202] = this.jj_gen;
                                        break block229;
                                    }
                                }
                                this.jj_consume_token(330);
                                this.ConditionalOrExpression();
                                this.jj_consume_token(328);
                                block230: while (true) {
                                    this.statement();
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 5: 
                                        case 9: 
                                        case 18: 
                                        case 21: 
                                        case 35: 
                                        case 36: 
                                        case 37: 
                                        case 42: 
                                        case 43: 
                                        case 44: 
                                        case 49: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 56: 
                                        case 59: 
                                        case 61: 
                                        case 63: 
                                        case 64: 
                                        case 65: 
                                        case 69: 
                                        case 71: 
                                        case 72: 
                                        case 73: 
                                        case 74: 
                                        case 75: 
                                        case 79: 
                                        case 80: 
                                        case 81: 
                                        case 83: 
                                        case 85: 
                                        case 86: 
                                        case 87: 
                                        case 88: 
                                        case 89: 
                                        case 92: 
                                        case 95: 
                                        case 99: 
                                        case 100: 
                                        case 103: 
                                        case 105: 
                                        case 106: 
                                        case 108: 
                                        case 110: 
                                        case 112: 
                                        case 113: 
                                        case 114: 
                                        case 115: 
                                        case 116: 
                                        case 117: 
                                        case 118: 
                                        case 120: 
                                        case 121: 
                                        case 122: 
                                        case 124: 
                                        case 125: 
                                        case 126: 
                                        case 129: 
                                        case 131: 
                                        case 132: 
                                        case 134: 
                                        case 135: 
                                        case 138: 
                                        case 140: 
                                        case 141: 
                                        case 142: 
                                        case 143: 
                                        case 147: 
                                        case 149: 
                                        case 151: 
                                        case 152: 
                                        case 153: 
                                        case 155: 
                                        case 157: 
                                        case 159: 
                                        case 160: 
                                        case 161: 
                                        case 162: 
                                        case 163: 
                                        case 164: 
                                        case 166: 
                                        case 167: 
                                        case 168: 
                                        case 169: 
                                        case 171: 
                                        case 172: 
                                        case 174: 
                                        case 175: 
                                        case 177: 
                                        case 180: 
                                        case 181: 
                                        case 183: 
                                        case 184: 
                                        case 191: 
                                        case 194: 
                                        case 196: 
                                        case 197: 
                                        case 198: 
                                        case 202: 
                                        case 203: 
                                        case 205: 
                                        case 206: 
                                        case 208: 
                                        case 210: 
                                        case 215: 
                                        case 216: 
                                        case 219: 
                                        case 220: 
                                        case 222: 
                                        case 223: 
                                        case 224: 
                                        case 225: 
                                        case 226: 
                                        case 227: 
                                        case 228: 
                                        case 229: 
                                        case 230: 
                                        case 232: 
                                        case 234: 
                                        case 235: 
                                        case 236: 
                                        case 238: 
                                        case 239: 
                                        case 240: 
                                        case 241: 
                                        case 242: 
                                        case 244: 
                                        case 245: 
                                        case 246: 
                                        case 247: 
                                        case 248: 
                                        case 250: 
                                        case 254: 
                                        case 255: 
                                        case 256: 
                                        case 257: 
                                        case 259: 
                                        case 261: 
                                        case 262: 
                                        case 263: 
                                        case 266: 
                                        case 267: 
                                        case 269: 
                                        case 271: 
                                        case 272: 
                                        case 273: 
                                        case 274: 
                                        case 275: 
                                        case 276: 
                                        case 278: 
                                        case 280: 
                                        case 281: 
                                        case 283: 
                                        case 285: 
                                        case 289: 
                                        case 290: 
                                        case 291: 
                                        case 293: 
                                        case 294: 
                                        case 297: 
                                        case 298: 
                                        case 299: 
                                        case 300: 
                                        case 301: 
                                        case 303: 
                                        case 304: 
                                        case 305: 
                                        case 306: 
                                        case 307: 
                                        case 308: 
                                        case 309: 
                                        case 310: 
                                        case 311: 
                                        case 312: 
                                        case 313: 
                                        case 314: 
                                        case 315: 
                                        case 316: 
                                        case 317: 
                                        case 318: 
                                        case 319: 
                                        case 323: 
                                        case 324: 
                                        case 327: 
                                        case 332: 
                                        case 341: 
                                        case 342: 
                                        case 343: 
                                        case 344: 
                                        case 345: 
                                        case 346: 
                                        case 347: 
                                        case 348: 
                                        case 349: 
                                        case 350: 
                                        case 351: 
                                        case 352: 
                                        case 353: 
                                        case 354: 
                                        case 355: 
                                        case 356: 
                                        case 357: 
                                        case 358: 
                                        case 359: 
                                        case 360: 
                                        case 361: 
                                        case 362: 
                                        case 363: 
                                        case 364: 
                                        case 365: 
                                        case 366: 
                                        case 367: 
                                        case 368: 
                                        case 369: 
                                        case 370: 
                                        case 371: 
                                        case 372: 
                                        case 373: 
                                        case 374: 
                                        case 375: 
                                        case 376: 
                                        case 377: 
                                        case 378: 
                                        case 379: 
                                        case 380: 
                                        case 381: 
                                        case 382: 
                                        case 383: 
                                        case 384: 
                                        case 385: 
                                        case 386: 
                                        case 387: 
                                        case 388: 
                                        case 389: 
                                        case 390: 
                                        case 391: 
                                        case 392: 
                                        case 393: 
                                        case 394: 
                                        case 395: 
                                        case 396: 
                                        case 397: 
                                        case 398: 
                                        case 399: 
                                        case 403: 
                                        case 404: 
                                        case 405: 
                                        case 406: 
                                        case 407: 
                                        case 408: 
                                        case 409: 
                                        case 410: 
                                        case 411: 
                                        case 412: 
                                        case 413: 
                                        case 414: 
                                        case 415: 
                                        case 423: 
                                        case 424: 
                                        case 428: 
                                        case 429: 
                                        case 431: {
                                            continue block230;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[203] = this.jj_gen;
                            }
                            block231: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 329: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[204] = this.jj_gen;
                                        break block231;
                                    }
                                }
                                this.jj_consume_token(329);
                                block232: while (true) {
                                    this.statement();
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 5: 
                                        case 9: 
                                        case 18: 
                                        case 21: 
                                        case 35: 
                                        case 36: 
                                        case 37: 
                                        case 42: 
                                        case 43: 
                                        case 44: 
                                        case 49: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 56: 
                                        case 59: 
                                        case 61: 
                                        case 63: 
                                        case 64: 
                                        case 65: 
                                        case 69: 
                                        case 71: 
                                        case 72: 
                                        case 73: 
                                        case 74: 
                                        case 75: 
                                        case 79: 
                                        case 80: 
                                        case 81: 
                                        case 83: 
                                        case 85: 
                                        case 86: 
                                        case 87: 
                                        case 88: 
                                        case 89: 
                                        case 92: 
                                        case 95: 
                                        case 99: 
                                        case 100: 
                                        case 103: 
                                        case 105: 
                                        case 106: 
                                        case 108: 
                                        case 110: 
                                        case 112: 
                                        case 113: 
                                        case 114: 
                                        case 115: 
                                        case 116: 
                                        case 117: 
                                        case 118: 
                                        case 120: 
                                        case 121: 
                                        case 122: 
                                        case 124: 
                                        case 125: 
                                        case 126: 
                                        case 129: 
                                        case 131: 
                                        case 132: 
                                        case 134: 
                                        case 135: 
                                        case 138: 
                                        case 140: 
                                        case 141: 
                                        case 142: 
                                        case 143: 
                                        case 147: 
                                        case 149: 
                                        case 151: 
                                        case 152: 
                                        case 153: 
                                        case 155: 
                                        case 157: 
                                        case 159: 
                                        case 160: 
                                        case 161: 
                                        case 162: 
                                        case 163: 
                                        case 164: 
                                        case 166: 
                                        case 167: 
                                        case 168: 
                                        case 169: 
                                        case 171: 
                                        case 172: 
                                        case 174: 
                                        case 175: 
                                        case 177: 
                                        case 180: 
                                        case 181: 
                                        case 183: 
                                        case 184: 
                                        case 191: 
                                        case 194: 
                                        case 196: 
                                        case 197: 
                                        case 198: 
                                        case 202: 
                                        case 203: 
                                        case 205: 
                                        case 206: 
                                        case 208: 
                                        case 210: 
                                        case 215: 
                                        case 216: 
                                        case 219: 
                                        case 220: 
                                        case 222: 
                                        case 223: 
                                        case 224: 
                                        case 225: 
                                        case 226: 
                                        case 227: 
                                        case 228: 
                                        case 229: 
                                        case 230: 
                                        case 232: 
                                        case 234: 
                                        case 235: 
                                        case 236: 
                                        case 238: 
                                        case 239: 
                                        case 240: 
                                        case 241: 
                                        case 242: 
                                        case 244: 
                                        case 245: 
                                        case 246: 
                                        case 247: 
                                        case 248: 
                                        case 250: 
                                        case 254: 
                                        case 255: 
                                        case 256: 
                                        case 257: 
                                        case 259: 
                                        case 261: 
                                        case 262: 
                                        case 263: 
                                        case 266: 
                                        case 267: 
                                        case 269: 
                                        case 271: 
                                        case 272: 
                                        case 273: 
                                        case 274: 
                                        case 275: 
                                        case 276: 
                                        case 278: 
                                        case 280: 
                                        case 281: 
                                        case 283: 
                                        case 285: 
                                        case 289: 
                                        case 290: 
                                        case 291: 
                                        case 293: 
                                        case 294: 
                                        case 297: 
                                        case 298: 
                                        case 299: 
                                        case 300: 
                                        case 301: 
                                        case 303: 
                                        case 304: 
                                        case 305: 
                                        case 306: 
                                        case 307: 
                                        case 308: 
                                        case 309: 
                                        case 310: 
                                        case 311: 
                                        case 312: 
                                        case 313: 
                                        case 314: 
                                        case 315: 
                                        case 316: 
                                        case 317: 
                                        case 318: 
                                        case 319: 
                                        case 323: 
                                        case 324: 
                                        case 327: 
                                        case 332: 
                                        case 341: 
                                        case 342: 
                                        case 343: 
                                        case 344: 
                                        case 345: 
                                        case 346: 
                                        case 347: 
                                        case 348: 
                                        case 349: 
                                        case 350: 
                                        case 351: 
                                        case 352: 
                                        case 353: 
                                        case 354: 
                                        case 355: 
                                        case 356: 
                                        case 357: 
                                        case 358: 
                                        case 359: 
                                        case 360: 
                                        case 361: 
                                        case 362: 
                                        case 363: 
                                        case 364: 
                                        case 365: 
                                        case 366: 
                                        case 367: 
                                        case 368: 
                                        case 369: 
                                        case 370: 
                                        case 371: 
                                        case 372: 
                                        case 373: 
                                        case 374: 
                                        case 375: 
                                        case 376: 
                                        case 377: 
                                        case 378: 
                                        case 379: 
                                        case 380: 
                                        case 381: 
                                        case 382: 
                                        case 383: 
                                        case 384: 
                                        case 385: 
                                        case 386: 
                                        case 387: 
                                        case 388: 
                                        case 389: 
                                        case 390: 
                                        case 391: 
                                        case 392: 
                                        case 393: 
                                        case 394: 
                                        case 395: 
                                        case 396: 
                                        case 397: 
                                        case 398: 
                                        case 399: 
                                        case 403: 
                                        case 404: 
                                        case 405: 
                                        case 406: 
                                        case 407: 
                                        case 408: 
                                        case 409: 
                                        case 410: 
                                        case 411: 
                                        case 412: 
                                        case 413: 
                                        case 414: 
                                        case 415: 
                                        case 423: 
                                        case 424: 
                                        case 428: 
                                        case 429: 
                                        case 431: {
                                            continue block232;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[205] = this.jj_gen;
                            }
                            this.jj_consume_token(331);
                            break block9;
                        }
                        case 332: {
                            this.jj_consume_token(332);
                            this.Expression();
                            this.jj_consume_token(331);
                            break block9;
                        }
                        case 215: {
                            this.jj_consume_token(215);
                            this.Expression();
                            this.jj_consume_token(4);
                            break block9;
                        }
                        case 5: 
                        case 9: 
                        case 18: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 59: 
                        case 61: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 95: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 118: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 129: 
                        case 131: 
                        case 132: 
                        case 135: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 147: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 155: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 180: 
                        case 181: 
                        case 183: 
                        case 184: 
                        case 191: 
                        case 194: 
                        case 196: 
                        case 198: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 216: 
                        case 219: 
                        case 220: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 259: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 266: 
                        case 267: 
                        case 269: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 283: 
                        case 285: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 424: 
                        case 428: 
                        case 429: 
                        case 431: {
                            this.Expression();
                            this.jj_consume_token(4);
                            break block9;
                        }
                    }
                    this.jj_la1[207] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void subtype_definition(boolean isPackageLevel) throws ParseException, SAXException {
        Token subtype_name = null;
        Token constraint = null;
        Token base_type = null;
        Token collection = null;
        Token collection2 = null;
        Token notNullable = null;
        String startElement = null;
        String endElement = null;
        String baseType = null;
        String returnType = null;
        String indexBy = null;
        String string = null;
        Hashtable tags = null;
        boolean lastField = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 261: {
                Token start = this.jj_consume_token(261);
                subtype_name = this.qualifiedID();
                if (this.m_out != null && isPackageLevel) {
                    tags = this.processMemberComment(start, "TYPE", subtype_name.toString());
                }
                this.jj_consume_token(150);
                returnType = baseType = this.datatype();
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 223: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                this.jj_consume_token(5);
                                constraint = this.jj_consume_token(423);
                                this.jj_consume_token(7);
                                if (constraint == null) break block4;
                                returnType = returnType + "(" + constraint + ")";
                                break block4;
                            }
                            case 223: {
                                constraint = this.jj_consume_token(223);
                                startElement = this.UnaryExpression(true);
                                this.jj_consume_token(14);
                                endElement = this.UnaryExpression(true);
                                if (constraint == null) break block4;
                                returnType = returnType + " RANGE " + startElement + ".." + endElement;
                                break block4;
                            }
                            default: {
                                this.jj_la1[208] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[209] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        this.jj_consume_token(183);
                        returnType = returnType + " NOT NULL";
                        break block0;
                    }
                }
                this.jj_la1[210] = this.jj_gen;
                break;
            }
            case 281: {
                Token start = this.jj_consume_token(281);
                subtype_name = this.qualifiedID();
                if (this.m_out != null && isPackageLevel) {
                    tags = this.processMemberComment(start, "TYPE", subtype_name.toString());
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 150: {
                        this.jj_consume_token(150);
                        break;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[211] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.jj_2_49(2)) {
                    this.jj_consume_token(174);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 67: {
                            base_type = this.jj_consume_token(67);
                            break;
                        }
                        case 189: {
                            base_type = this.jj_consume_token(189);
                            break;
                        }
                        case 188: {
                            base_type = this.jj_consume_token(188);
                            break;
                        }
                        case 187: {
                            base_type = this.jj_consume_token(187);
                            break;
                        }
                        case 186: {
                            base_type = this.jj_consume_token(186);
                            break;
                        }
                        case 190: {
                            base_type = this.jj_consume_token(190);
                            break;
                        }
                        default: {
                            this.jj_la1[212] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    returnType = "NEW " + base_type.toString().toUpperCase();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 191: {
                        this.jj_consume_token(191);
                        baseType = "OBJECT";
                        this.jj_consume_token(5);
                        this.fieldDeclaration(isPackageLevel, tags);
                        block60: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[213] = this.jj_gen;
                                    break block60;
                                }
                            }
                            this.jj_consume_token(6);
                            this.fieldDeclaration(isPackageLevel, tags);
                        }
                        this.jj_consume_token(7);
                        returnType = "OBJECT";
                        break block0;
                    }
                    case 226: {
                        this.jj_consume_token(226);
                        baseType = "RECORD";
                        this.jj_consume_token(5);
                        this.fieldDeclaration(isPackageLevel, tags);
                        block61: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[214] = this.jj_gen;
                                    break block61;
                                }
                            }
                            this.jj_consume_token(6);
                            this.fieldDeclaration(isPackageLevel, tags);
                        }
                        this.jj_consume_token(7);
                        returnType = "RECORD";
                        break block0;
                    }
                    case 268: 
                    case 307: 
                    case 308: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 268: {
                                collection = this.jj_consume_token(268);
                                break;
                            }
                            case 307: {
                                collection = this.jj_consume_token(307);
                                break;
                            }
                            case 308: {
                                collection = this.jj_consume_token(308);
                                collection2 = this.jj_consume_token(49);
                                break;
                            }
                            default: {
                                this.jj_la1[215] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                this.jj_consume_token(5);
                                constraint = this.numericLiteral();
                                this.jj_consume_token(7);
                                break;
                            }
                            default: {
                                this.jj_la1[216] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(193);
                        baseType = this.datatype();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 181: {
                                notNullable = this.jj_consume_token(181);
                                this.jj_consume_token(183);
                                break;
                            }
                            default: {
                                this.jj_la1[217] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 137: {
                                this.jj_consume_token(137);
                                this.jj_consume_token(62);
                                indexBy = this.datatype();
                                break;
                            }
                            default: {
                                this.jj_la1[218] = this.jj_gen;
                            }
                        }
                        returnType = collection.toString();
                        if (collection2 != null) {
                            returnType = returnType + " " + collection2;
                        }
                        if (constraint != null) {
                            returnType = returnType + "(" + constraint + ")";
                        }
                        returnType = returnType + " OF " + baseType;
                        if (notNullable != null) {
                            returnType = returnType + " NOT NULL";
                        }
                        if (indexBy == null) break block0;
                        returnType = returnType + " INDEX BY " + indexBy;
                        break block0;
                    }
                    case 227: {
                        this.jj_consume_token(227);
                        this.jj_consume_token(85);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 234: {
                                this.jj_consume_token(234);
                                baseType = this.datatype();
                                break;
                            }
                            default: {
                                this.jj_la1[219] = this.jj_gen;
                            }
                        }
                        returnType = "REF CURSOR";
                        if (baseType == null) break block0;
                        returnType = returnType + " RETURN " + baseType;
                        break block0;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        string = this.Expression();
                        returnType = "(" + string;
                        block62: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[220] = this.jj_gen;
                                    break block62;
                                }
                            }
                            this.jj_consume_token(6);
                            string = this.Expression();
                            returnType = returnType + "," + string;
                        }
                        this.jj_consume_token(7);
                        returnType = returnType + ")";
                        break block0;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 90: 
                    case 95: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 129: 
                    case 131: 
                    case 132: 
                    case 135: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 177: 
                    case 180: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 194: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 219: 
                    case 220: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 259: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 266: 
                    case 267: 
                    case 269: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 283: 
                    case 285: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 327: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: {
                        returnType = this.datatype();
                        break block0;
                    }
                    default: {
                        this.jj_la1[221] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[222] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(4);
        if (this.m_out != null && isPackageLevel) {
            if (returnType != null) {
                this.m_out.pushAttribute("TYPE", returnType);
                this.m_out.element("RETURN");
            }
            this.m_out.endElement("TYPE");
        }
    }

    public final void fieldDeclaration(boolean isPackageLevel, Hashtable tags) throws ParseException, SAXException {
        String defaultValue = null;
        Token name = this.ID();
        String dataType = this.datatype();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: 
            case 183: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        break;
                    }
                    default: {
                        this.jj_la1[223] = this.jj_gen;
                    }
                }
                this.jj_consume_token(183);
                break;
            }
            default: {
                this.jj_la1[224] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 91: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        this.jj_consume_token(12);
                        break;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        break;
                    }
                    default: {
                        this.jj_la1[225] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                defaultValue = this.Expression();
                break;
            }
            default: {
                this.jj_la1[226] = this.jj_gen;
            }
        }
        if (this.m_out != null && isPackageLevel) {
            String paramName = name.toString();
            String paramComment = this.getParamComment(paramName, tags);
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(paramName));
            this.m_out.pushAttribute("TYPE", this.purifyIdentifier(dataType));
            if (null != defaultValue) {
                this.m_out.pushAttribute("DEFAULT", this.purifyIdentifier(defaultValue));
            }
            this.m_out.startElement("FIELD");
            if (paramComment != null) {
                this.m_out.startElement("COMMENT");
                this.m_out.cdata(paramComment);
                this.m_out.endElement("COMMENT");
            }
            this.m_out.endElement("FIELD");
        }
    }

    public final void collection_type_definition() throws ParseException {
        this.jj_consume_token(423);
    }

    public final void collectionDeclaration(boolean isPackageLevel) throws ParseException {
        this.jj_consume_token(423);
    }

    public final void objectDeclaration() throws ParseException {
        this.jj_consume_token(423);
    }

    public final void callSpecTail(boolean isPackageLevel) throws ParseException {
        block36: {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: {
                    this.jj_consume_token(113);
                    break;
                }
                case 42: {
                    this.jj_consume_token(42);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 423: {
                            this.jj_consume_token(423);
                            break block0;
                        }
                        case 152: {
                            this.jj_consume_token(152);
                            break block0;
                        }
                    }
                    this.jj_la1[227] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[228] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block35: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 315: 
                    case 364: 
                    case 365: 
                    case 368: {
                        break;
                    }
                    default: {
                        this.jj_la1[229] = this.jj_gen;
                        break block36;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 364: {
                        this.jj_consume_token(364);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 423: {
                                this.jj_consume_token(423);
                                break;
                            }
                            case 431: {
                                this.jj_consume_token(431);
                                break;
                            }
                            case 429: {
                                this.StringLiteral();
                                break;
                            }
                            default: {
                                this.jj_la1[230] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 3: {
                                this.jj_consume_token(3);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 423: {
                                        this.jj_consume_token(423);
                                        continue block35;
                                    }
                                    case 431: {
                                        this.jj_consume_token(431);
                                        continue block35;
                                    }
                                    case 429: {
                                        this.StringLiteral();
                                        continue block35;
                                    }
                                }
                                this.jj_la1[231] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[232] = this.jj_gen;
                        continue block35;
                    }
                    case 365: {
                        this.jj_consume_token(365);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 423: {
                                this.jj_consume_token(423);
                                continue block35;
                            }
                            case 431: {
                                this.jj_consume_token(431);
                                continue block35;
                            }
                            case 429: {
                                this.StringLiteral();
                                continue block35;
                            }
                        }
                        this.jj_la1[233] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 315: {
                        this.jj_consume_token(315);
                        this.jj_consume_token(367);
                        continue block35;
                    }
                    case 368: {
                        this.jj_consume_token(368);
                        this.skipPastNextOccurrence(")");
                        continue block35;
                    }
                }
                break;
            }
            this.jj_la1[234] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void cursorUnit(boolean isPackageLevel) throws ParseException, SAXException {
        Hashtable tags = new Hashtable();
        Token start = this.jj_consume_token(85);
        Token name = this.ID();
        tags = this.m_out != null && isPackageLevel ? this.processMemberComment(start, this.purifyKeyword(start.toString()), name.toString()) : new Hashtable();
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[235] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(5);
            this.parameterDeclaration(tags, isPackageLevel);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[236] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(6);
                this.parameterDeclaration(tags, isPackageLevel);
            }
            this.jj_consume_token(7);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 234: {
                this.jj_consume_token(234);
                String type = this.datatype();
                if (this.m_out == null || !isPackageLevel) break;
                String returnComment2 = null;
                Collection tagValues = (Collection)tags.get("@return");
                if (tagValues != null) {
                    for (String returnComment2 : tagValues) {
                    }
                }
                this.m_out.pushAttribute("TYPE", this.purifyIdentifier(type.toString()));
                this.m_out.startElement("RETURN");
                if (returnComment2 != null) {
                    this.m_out.startElement("COMMENT");
                    this.m_out.cdata(returnComment2);
                    this.m_out.endElement("COMMENT");
                }
                this.m_out.endElement("RETURN");
                break;
            }
            default: {
                this.jj_la1[237] = this.jj_gen;
            }
        }
        if (this.m_out != null && isPackageLevel) {
            this.m_out.endElement(this.purifyKeyword(start.toString()));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 150: {
                this.jj_consume_token(150);
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[238] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.jj_consume_token(5);
                }
                this.sqlStatement(null, ";");
                break;
            }
            default: {
                this.jj_la1[239] = this.jj_gen;
            }
        }
        this.jj_consume_token(4);
    }

    public final void cursorSpec(boolean isPackageLevel) throws ParseException, SAXException {
        this.cursorUnit(isPackageLevel);
    }

    public final void cursorBody(boolean isPackageLevel) throws ParseException, SAXException {
        this.cursorUnit(isPackageLevel);
    }

    public final String Expression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        if (this.jj_2_50(Integer.MAX_VALUE)) {
            string = this.Assignment();
            sb.append(string);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 9: 
                case 18: 
                case 35: 
                case 36: 
                case 37: 
                case 42: 
                case 43: 
                case 44: 
                case 49: 
                case 52: 
                case 53: 
                case 54: 
                case 59: 
                case 61: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 79: 
                case 80: 
                case 81: 
                case 83: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 95: 
                case 99: 
                case 100: 
                case 103: 
                case 105: 
                case 106: 
                case 108: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 118: 
                case 122: 
                case 124: 
                case 125: 
                case 129: 
                case 131: 
                case 132: 
                case 135: 
                case 138: 
                case 140: 
                case 141: 
                case 143: 
                case 147: 
                case 149: 
                case 151: 
                case 152: 
                case 153: 
                case 155: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 171: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 180: 
                case 181: 
                case 183: 
                case 184: 
                case 191: 
                case 194: 
                case 196: 
                case 197: 
                case 198: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 208: 
                case 216: 
                case 219: 
                case 220: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 232: 
                case 234: 
                case 235: 
                case 236: 
                case 238: 
                case 239: 
                case 240: 
                case 241: 
                case 242: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 250: 
                case 254: 
                case 255: 
                case 256: 
                case 257: 
                case 259: 
                case 261: 
                case 262: 
                case 263: 
                case 266: 
                case 267: 
                case 269: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 278: 
                case 280: 
                case 281: 
                case 283: 
                case 285: 
                case 290: 
                case 291: 
                case 293: 
                case 297: 
                case 298: 
                case 299: 
                case 300: 
                case 301: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 323: 
                case 324: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 347: 
                case 348: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 357: 
                case 358: 
                case 359: 
                case 360: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 366: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 376: 
                case 377: 
                case 378: 
                case 379: 
                case 380: 
                case 381: 
                case 382: 
                case 383: 
                case 384: 
                case 385: 
                case 386: 
                case 387: 
                case 388: 
                case 389: 
                case 390: 
                case 391: 
                case 392: 
                case 393: 
                case 394: 
                case 395: 
                case 396: 
                case 397: 
                case 398: 
                case 399: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 415: 
                case 423: 
                case 424: 
                case 428: 
                case 429: 
                case 431: {
                    string = this.ConditionalOrExpression();
                    sb.append(string);
                    break;
                }
                case 327: {
                    string = this.CompilationExpression();
                    sb.append(string);
                    break;
                }
                default: {
                    this.jj_la1[240] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return sb.toString();
    }

    public final String CompilationExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        this.jj_consume_token(327);
        sb.append(" ");
        sb.append(this.token.image);
        string = this.ConditionalOrExpression();
        sb.append(" ");
        sb.append(string);
        this.jj_consume_token(328);
        sb.append(" ");
        sb.append(this.token.image);
        string = this.Expression();
        sb.append(" ");
        sb.append(string);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 330: {
                    break;
                }
                default: {
                    this.jj_la1[241] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(330);
            sb.append(" ");
            sb.append(this.token.image);
            string = this.ConditionalOrExpression();
            sb.append(" ");
            sb.append(string);
            this.jj_consume_token(328);
            sb.append(" ");
            sb.append(this.token.image);
            string = this.Expression();
            sb.append(" ");
            sb.append(string);
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 329: {
                    break;
                }
                default: {
                    this.jj_la1[242] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(329);
            sb.append(" ");
            sb.append(this.token.image);
            string = this.Expression();
            sb.append(" ");
            sb.append(string);
        }
        this.jj_consume_token(331);
        sb.append(" ");
        sb.append(this.token.image);
        return sb.toString();
    }

    public final String Assignment() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.PrimaryExpression();
        sb.append(string);
        this.jj_consume_token(11);
        this.jj_consume_token(12);
        sb.append(" := ");
        string = this.Expression();
        sb.append(string);
        return sb.toString();
    }

    public final String CaseExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        Token thisToken = this.jj_consume_token(65);
        sb.append(thisToken.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 9: 
            case 18: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 181: 
            case 183: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 327: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 424: 
            case 428: 
            case 429: 
            case 431: {
                string = this.Expression();
                sb.append(" ");
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[243] = this.jj_gen;
            }
        }
        block9: while (true) {
            thisToken = this.jj_consume_token(287);
            sb.append("  ");
            sb.append(thisToken.image);
            string = this.Expression();
            sb.append(" ");
            sb.append(string);
            thisToken = this.jj_consume_token(270);
            sb.append(" ");
            sb.append(thisToken.image);
            string = this.Expression();
            sb.append(" ");
            sb.append(string);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 287: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[244] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                thisToken = this.jj_consume_token(101);
                sb.append(" ");
                sb.append(thisToken.image);
                this.Expression();
                sb.append(" ");
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[245] = this.jj_gen;
            }
        }
        thisToken = this.jj_consume_token(104);
        sb.append(" ");
        sb.append(thisToken.image);
        return sb.toString();
    }

    public final String LikeExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.PrimaryExpression();
        sb.append(" ");
        sb.append(string);
        Token thisToken = this.jj_consume_token(154);
        sb.append(thisToken.image);
        string = this.StringExpression();
        sb.append(" ");
        sb.append(string);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                sb.append(" ESCAPE ");
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 428: {
                        this.jj_consume_token(428);
                        sb.append(" ");
                        sb.append(this.token.toString());
                        break block0;
                    }
                    case 429: {
                        string = this.StringLiteral();
                        sb.append(" ");
                        sb.append(string);
                        break block0;
                    }
                }
                this.jj_la1[246] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[247] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[248] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(3);
            string = this.Expression();
            sb.append(".");
            sb.append(string);
        }
        return sb.toString();
    }

    public final String TrimExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        Token thisToken = this.jj_consume_token(389);
        sb.append(thisToken.image);
        this.jj_consume_token(5);
        sb.append("(");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: 
            case 396: 
            case 397: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 396: {
                        this.jj_consume_token(396);
                        break;
                    }
                    case 397: {
                        this.jj_consume_token(397);
                        break;
                    }
                    case 392: {
                        this.jj_consume_token(392);
                        break;
                    }
                    default: {
                        this.jj_la1[249] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                sb.append(" ");
                sb.append(this.token.toString());
                break;
            }
            default: {
                this.jj_la1[250] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 183: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 424: 
            case 428: 
            case 429: 
            case 431: {
                string = this.StringExpression();
                sb.append(" ");
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[251] = this.jj_gen;
            }
        }
        this.jj_consume_token(123);
        sb.append(thisToken.image);
        string = this.StringExpression();
        sb.append(" ");
        sb.append(string);
        this.jj_consume_token(7);
        sb.append(")");
        return sb.toString();
    }

    public final String ObjectExpression() throws ParseException {
        Token thisToken;
        String string = null;
        StringBuffer sb = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 387: {
                thisToken = this.jj_consume_token(387);
                break;
            }
            case 388: {
                thisToken = this.jj_consume_token(388);
                break;
            }
            default: {
                this.jj_la1[252] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        sb.append(thisToken.image);
        this.jj_consume_token(5);
        sb.append("(");
        string = this.Expression();
        sb.append(" ");
        sb.append(string);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(271);
                this.jj_consume_token(316);
                string = this.PrimaryExpression();
                sb.append(" AT TIME ZONE ");
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[253] = this.jj_gen;
            }
        }
        this.jj_consume_token(50);
        sb.append(" AS ");
        string = this.datatype();
        sb.append(" ");
        sb.append(string);
        this.jj_consume_token(7);
        sb.append(")");
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[254] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(3);
            this.Expression();
        }
        return sb.toString();
    }

    public final String ConditionalOrExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.ConditionalAndExpression();
        sb.append(string);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 200: {
                    break;
                }
                default: {
                    this.jj_la1[255] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(200);
            sb.append(" OR ");
            string = this.ConditionalAndExpression();
            sb.append(string);
        }
        return sb.toString();
    }

    public final String ConditionalAndExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.EqualityExpression();
        sb.append(string);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    break;
                }
                default: {
                    this.jj_la1[256] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(47);
            sb.append(" AND ");
            string = this.EqualityExpression();
            sb.append(string);
        }
        return sb.toString();
    }

    public final String EqualityExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.RelationalExpression();
        sb.append(string);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 15: 
                case 150: {
                    break;
                }
                default: {
                    this.jj_la1[257] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    this.jj_consume_token(12);
                    sb.append(" = ");
                    break;
                }
                case 15: {
                    this.jj_consume_token(15);
                    this.jj_consume_token(12);
                    sb.append(" != ");
                    break;
                }
                case 150: {
                    this.jj_consume_token(150);
                    sb.append(" IS ");
                    break;
                }
                default: {
                    this.jj_la1[258] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            string = this.RelationalExpression();
            sb.append(string);
        }
        return sb.toString();
    }

    public final String RelationalExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.AdditiveExpression();
        sb.append(string);
        block54: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 17: 
                case 57: 
                case 123: 
                case 136: 
                case 154: 
                case 162: 
                case 181: 
                case 394: 
                case 395: {
                    break;
                }
                default: {
                    this.jj_la1[259] = this.jj_gen;
                    break block54;
                }
            }
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 17: {
                    block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 16: {
                            this.jj_consume_token(16);
                            sb.append("<");
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 17: {
                                    this.jj_consume_token(17);
                                    sb.append(">");
                                    break block8;
                                }
                            }
                            this.jj_la1[260] = this.jj_gen;
                            break;
                        }
                        case 17: {
                            this.jj_consume_token(17);
                            sb.append(">");
                            break;
                        }
                        default: {
                            this.jj_la1[261] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            this.jj_consume_token(12);
                            sb.append("=");
                            break;
                        }
                        default: {
                            this.jj_la1[262] = this.jj_gen;
                        }
                    }
                    sb.append(" ");
                    break;
                }
                case 57: 
                case 123: 
                case 136: 
                case 154: 
                case 162: 
                case 181: 
                case 395: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 181: {
                            this.jj_consume_token(181);
                            sb.append(" NOT ");
                            break;
                        }
                        default: {
                            this.jj_la1[263] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 136: {
                            this.jj_consume_token(136);
                            sb.append(" IN ");
                            break block3;
                        }
                        case 57: {
                            this.jj_consume_token(57);
                            sb.append(" BETWEEN ");
                            break block3;
                        }
                        case 154: {
                            this.jj_consume_token(154);
                            sb.append(" LIKE ");
                            break block3;
                        }
                        case 123: {
                            this.jj_consume_token(123);
                            sb.append(" FROM ");
                            break block3;
                        }
                        case 162: 
                        case 395: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 162: {
                                    this.jj_consume_token(162);
                                    sb.append(" MEMBER ");
                                    break;
                                }
                                case 395: {
                                    this.jj_consume_token(395);
                                    sb.append(" SUBMULTISET ");
                                    break;
                                }
                                default: {
                                    this.jj_la1[264] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 193: {
                                    this.jj_consume_token(193);
                                    sb.append(" OF ");
                                    break block3;
                                }
                            }
                            this.jj_la1[265] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_la1[266] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 394: {
                    this.jj_consume_token(394);
                    sb.append(" MULTISET ");
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 106: {
                            this.jj_consume_token(106);
                            sb.append(" EXCEPT ");
                            break;
                        }
                        case 146: {
                            this.jj_consume_token(146);
                            sb.append(" INTERSECT ");
                            break;
                        }
                        case 326: {
                            this.jj_consume_token(326);
                            sb.append(" UNION ");
                            break;
                        }
                        default: {
                            this.jj_la1[267] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 45: 
                        case 96: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 96: {
                                    this.jj_consume_token(96);
                                    sb.append(" DISTINCT ");
                                    break block3;
                                }
                                case 45: {
                                    this.jj_consume_token(45);
                                    sb.append(" ALL ");
                                    break block3;
                                }
                            }
                            this.jj_la1[268] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[269] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[270] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            string = this.AdditiveExpression();
            sb.append(string);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 105: {
                    this.jj_consume_token(105);
                    sb.append(" ESCAPE ");
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 428: {
                            this.jj_consume_token(428);
                            sb.append(" ");
                            sb.append(this.token.toString());
                            continue block54;
                        }
                        case 429: {
                            string = this.StringLiteral();
                            sb.append(" ");
                            sb.append(string);
                            continue block54;
                        }
                    }
                    this.jj_la1[271] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_la1[272] = this.jj_gen;
        }
        return sb.toString();
    }

    public final String AdditiveExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.MultiplicativeExpression();
        sb.append(string);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[273] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    this.jj_consume_token(18);
                    sb.append(" + ");
                    break;
                }
                case 9: {
                    this.jj_consume_token(9);
                    sb.append(" - ");
                    break;
                }
                case 19: {
                    this.jj_consume_token(19);
                    sb.append(" || ");
                    break;
                }
                default: {
                    this.jj_la1[274] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            string = this.MultiplicativeExpression();
            sb.append(string);
        }
        return sb.toString();
    }

    public final String StringExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.PrimaryExpression();
        sb.append(string);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[275] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(19);
            sb.append(" || ");
            string = this.PrimaryExpression();
            sb.append(string);
        }
        return sb.toString();
    }

    public final String MultiplicativeExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        string = this.UnaryExpression(true);
        sb.append(string);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 8: 
                case 20: 
                case 169: {
                    break;
                }
                default: {
                    this.jj_la1[276] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    this.jj_consume_token(20);
                    sb.append(" ** ");
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    sb.append(" * ");
                    break;
                }
                case 1: {
                    this.jj_consume_token(1);
                    sb.append(" / ");
                    break;
                }
                case 169: {
                    this.jj_consume_token(169);
                    sb.append(" MOD ");
                    break;
                }
                default: {
                    this.jj_la1[277] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            string = this.UnaryExpression(true);
            sb.append(string);
        }
        return sb.toString();
    }

    public final String UnaryExpression(boolean isUnarySign) throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 18: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        sb.append(isUnarySign ? " +" : " + ");
                        break;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        sb.append(isUnarySign ? " -" : " - ");
                        break;
                    }
                    default: {
                        this.jj_la1[278] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                string = this.UnaryExpression(false);
                sb.append(string);
                break;
            }
            case 5: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 181: 
            case 183: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 424: 
            case 428: 
            case 429: 
            case 431: {
                string = this.UnaryExpressionNotPlusMinus();
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[279] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sb.toString();
    }

    public final String UnaryExpressionNotPlusMinus() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: {
                this.jj_consume_token(181);
                sb.append(" NOT ");
                string = this.UnaryExpression(false);
                sb.append(string);
                break;
            }
            case 5: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 183: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 424: 
            case 428: 
            case 429: 
            case 431: {
                string = this.PrimaryExpression();
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[280] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sb.toString();
    }

    public final String PrimaryExpression() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 175: {
                this.jj_consume_token(175);
                Token thisToken = this.qualifiedID();
                sb.append(" NEW.");
                sb.append(thisToken.toString());
                break;
            }
            case 5: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 177: 
            case 180: 
            case 183: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 424: 
            case 428: 
            case 429: 
            case 431: {
                if (this.jj_2_51(Integer.MAX_VALUE)) {
                    this.jj_consume_token(174);
                    sb.append(" NEW ");
                    string = this.PrimaryPrefix();
                    sb.append(string);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 49: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 59: 
                        case 61: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 95: 
                        case 99: 
                        case 100: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 118: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 129: 
                        case 131: 
                        case 132: 
                        case 135: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 147: 
                        case 149: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 155: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 171: 
                        case 172: 
                        case 174: 
                        case 177: 
                        case 180: 
                        case 183: 
                        case 184: 
                        case 191: 
                        case 194: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 216: 
                        case 219: 
                        case 220: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 259: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 266: 
                        case 267: 
                        case 269: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 283: 
                        case 285: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 424: 
                        case 428: 
                        case 429: 
                        case 431: {
                            string = this.PrimaryPrefix();
                            sb.append(string);
                            break;
                        }
                        default: {
                            this.jj_la1[281] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                while (this.jj_2_52(2)) {
                    string = this.PrimarySuffix();
                    sb.append(string);
                }
                break;
            }
            default: {
                this.jj_la1[282] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sb.toString();
    }

    public final String PrimaryPrefix() throws ParseException {
        String string = null;
        StringBuffer sb = new StringBuffer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: 
            case 116: 
            case 147: 
            case 183: 
            case 272: 
            case 280: 
            case 424: 
            case 428: 
            case 429: {
                string = this.Literal();
                sb.append(string);
                break;
            }
            default: {
                this.jj_la1[284] = this.jj_gen;
                if (this.jj_2_53(Integer.MAX_VALUE)) {
                    string = this.MultiSetCondition();
                    break;
                }
                if (this.jj_2_54(Integer.MAX_VALUE)) {
                    string = this.TrimExpression();
                    break;
                }
                if (this.jj_2_55(Integer.MAX_VALUE)) {
                    string = this.CaseExpression();
                    sb.append(string);
                    break;
                }
                if (this.jj_2_56(Integer.MAX_VALUE)) {
                    string = this.ObjectExpression();
                    sb.append(string);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 95: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 129: 
                    case 131: 
                    case 132: 
                    case 135: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 172: 
                    case 174: 
                    case 177: 
                    case 180: 
                    case 184: 
                    case 191: 
                    case 194: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 216: 
                    case 219: 
                    case 220: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 259: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 266: 
                    case 267: 
                    case 269: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 283: 
                    case 285: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: {
                        string = this.Name();
                        sb.append(string);
                        break block0;
                    }
                }
                this.jj_la1[285] = this.jj_gen;
                if (this.jj_2_57(Integer.MAX_VALUE)) {
                    this.jj_consume_token(247);
                    sb.append("SELECT ...");
                    this.skip2NextTerminator(null, ";");
                    break;
                }
                if (this.jj_2_58(Integer.MAX_VALUE)) {
                    this.jj_consume_token(5);
                    sb.append("(SELECT ...");
                    this.skip2NextTerminator("(", ")");
                    this.jj_consume_token(7);
                    break;
                }
                if (this.jj_2_59(Integer.MAX_VALUE)) {
                    this.jj_consume_token(315);
                    sb.append("WITH ...");
                    this.skip2NextTerminator(null, ";");
                    break;
                }
                if (this.jj_2_60(Integer.MAX_VALUE)) {
                    this.jj_consume_token(5);
                    sb.append("(WITH ...");
                    this.skip2NextTerminator("(", ")");
                    this.jj_consume_token(7);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        sb.append("(");
                        string = this.Expression();
                        sb.append(string);
                        block12: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[283] = this.jj_gen;
                                    break block12;
                                }
                            }
                            this.jj_consume_token(6);
                            sb.append(", ");
                            string = this.Expression();
                            sb.append(string);
                        }
                        this.jj_consume_token(7);
                        sb.append(")");
                        break block0;
                    }
                }
                this.jj_la1[286] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sb.toString();
    }

    public final String PrimarySuffix() throws ParseException {
        Token suffixToken = null;
        String timeZoneExpression = null;
        String arguments = null;
        StringBuffer sb = new StringBuffer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                sb.append(".");
                suffixToken = this.qualifiedID();
                sb.append(suffixToken.toString());
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                sb.append("@");
                suffixToken = this.qualifiedID();
                sb.append(suffixToken.toString());
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                sb.append(" ");
                sb.append(this.token.image.toUpperCase());
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 314: {
                        this.jj_consume_token(314);
                        sb.append(" ");
                        sb.append(this.token.image.toUpperCase());
                        break block0;
                    }
                    case 271: {
                        this.jj_consume_token(271);
                        this.jj_consume_token(316);
                        sb.append(" TIME ZONE");
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 403: {
                                this.jj_consume_token(403);
                                sb.append(" ");
                                sb.append(this.token.image.toUpperCase());
                                break;
                            }
                            case 404: {
                                this.jj_consume_token(404);
                                sb.append(" ");
                                sb.append(this.token.image.toUpperCase());
                                break;
                            }
                            case 429: {
                                timeZoneExpression = this.StringLiteral();
                                sb.append(" ");
                                sb.append(timeZoneExpression);
                                break;
                            }
                            case 5: 
                            case 9: 
                            case 18: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 49: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 59: 
                            case 61: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 69: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 83: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 95: 
                            case 99: 
                            case 100: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 108: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 118: 
                            case 122: 
                            case 124: 
                            case 125: 
                            case 129: 
                            case 131: 
                            case 132: 
                            case 135: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 143: 
                            case 147: 
                            case 149: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 155: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 171: 
                            case 172: 
                            case 174: 
                            case 175: 
                            case 177: 
                            case 180: 
                            case 181: 
                            case 183: 
                            case 184: 
                            case 191: 
                            case 194: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 202: 
                            case 203: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 216: 
                            case 219: 
                            case 220: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 250: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 259: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 266: 
                            case 267: 
                            case 269: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 280: 
                            case 281: 
                            case 283: 
                            case 285: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 327: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 424: 
                            case 428: 
                            case 431: {
                                timeZoneExpression = this.Expression();
                                break;
                            }
                            default: {
                                this.jj_la1[287] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        sb.append(" ");
                        sb.append(timeZoneExpression);
                        break block0;
                    }
                }
                this.jj_la1[288] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: {
                arguments = this.Arguments();
                sb.append(arguments);
                break;
            }
            default: {
                this.jj_la1[289] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sb.toString();
    }

    public final String Literal() throws ParseException {
        Token literalToken = null;
        String literal = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 424: {
                literalToken = this.numericLiteral();
                literal = literalToken.toString();
                break;
            }
            case 428: {
                this.jj_consume_token(428);
                literal = this.token.toString();
                break;
            }
            case 429: {
                literal = this.StringLiteral();
                break;
            }
            case 116: 
            case 280: {
                literal = this.BooleanLiteral();
                break;
            }
            case 183: {
                literal = this.NullLiteral();
                break;
            }
            case 87: 
            case 147: 
            case 272: {
                literal = this.DateTimeLiteral();
                break;
            }
            default: {
                this.jj_la1[290] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return literal;
    }

    public final String StringLiteral() throws ParseException {
        Token thisToken = null;
        StringBuffer literal = new StringBuffer();
        String terminator = null;
        thisToken = this.jj_consume_token(429);
        literal.append(thisToken.image);
        if (thisToken.image.toUpperCase().startsWith("Q'") && thisToken.image.length() > 2) {
            char endDelimiter;
            char startDelimiter = thisToken.image.charAt(2);
            switch (startDelimiter) {
                case '<': {
                    endDelimiter = '>';
                    break;
                }
                case '{': {
                    endDelimiter = '}';
                    break;
                }
                case '(': {
                    endDelimiter = ')';
                    break;
                }
                case '[': {
                    endDelimiter = ']';
                    break;
                }
                default: {
                    endDelimiter = startDelimiter;
                }
            }
            terminator = new String(endDelimiter + "'");
            if (!thisToken.image.endsWith(terminator)) {
                literal.append(this.readPastNextOccurrence(terminator));
            }
        }
        return literal.toString();
    }

    public final String BooleanLiteral() throws ParseException {
        String literal = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 280: {
                this.jj_consume_token(280);
                literal = " TRUE ";
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                literal = " FALSE ";
                break;
            }
            default: {
                this.jj_la1[291] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return literal;
    }

    public final String NullLiteral() throws ParseException {
        String literal = null;
        this.jj_consume_token(183);
        literal = " NULL ";
        return literal;
    }

    public final String MultiSetCondition() throws ParseException {
        String literal = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 293: {
                this.jj_consume_token(293);
                this.jj_consume_token(250);
                literal = " A SET ";
                break;
            }
            case 393: {
                this.jj_consume_token(393);
                literal = " EMPTY ";
                break;
            }
            default: {
                this.jj_la1[292] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return literal;
    }

    public final Token numericLiteral() throws ParseException {
        Token main = null;
        main = this.jj_consume_token(424);
        return main;
    }

    public final String label() throws ParseException {
        Token labelID = null;
        StringBuffer sb = new StringBuffer();
        this.jj_consume_token(21);
        labelID = this.unqualifiedID();
        this.jj_consume_token(22);
        sb.append("<<");
        sb.append(labelID);
        sb.append(">>");
        return sb.toString();
    }

    public final String Name() throws ParseException {
        Token thisToken = null;
        Object separatorToken = null;
        StringBuffer sb = new StringBuffer();
        thisToken = this.unqualifiedID();
        sb.append(thisToken);
        while (this.jj_2_61(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.jj_consume_token(3);
                    sb.append(".");
                    break;
                }
                case 13: {
                    this.jj_consume_token(13);
                    sb.append("%");
                    break;
                }
                default: {
                    this.jj_la1[293] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            thisToken = this.qualifiedID();
            sb.append(thisToken);
        }
        return sb.toString();
    }

    public final String qualifiedName() throws ParseException {
        Token thisToken = null;
        StringBuffer sb = new StringBuffer();
        thisToken = this.unqualifiedID();
        sb.append(thisToken);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[294] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
            thisToken = this.qualifiedID();
            sb.append(".");
            sb.append(thisToken);
        }
        return sb.toString();
    }

    public final String Arguments() throws ParseException {
        String argumentList = null;
        StringBuffer sb = new StringBuffer();
        this.jj_consume_token(5);
        sb.append("(");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 9: 
            case 18: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 181: 
            case 183: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 327: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 424: 
            case 428: 
            case 429: 
            case 431: {
                argumentList = this.ArgumentList();
                sb.append(argumentList);
                break;
            }
            default: {
                this.jj_la1[295] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        sb.append(")");
        return sb.toString();
    }

    public final String ArgumentList() throws ParseException {
        String argument = null;
        Object thisToken = null;
        StringBuffer sb = new StringBuffer();
        argument = this.Argument();
        sb.append(argument);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[296] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            sb.append(", ");
            argument = this.Argument();
            sb.append(argument);
        }
        return sb.toString();
    }

    public final String Argument() throws ParseException {
        Token thisToken = null;
        String string = null;
        StringBuffer sb = new StringBuffer();
        if (this.jj_2_62(2)) {
            thisToken = this.unqualifiedID();
            sb.append(thisToken);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                case 50: {
                    this.jj_consume_token(50);
                    break;
                }
                default: {
                    this.jj_la1[297] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            sb.append(" ");
            sb.append(this.token.image.toUpperCase());
            sb.append(" ");
        }
        string = this.Expression();
        sb.append(string);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 285: {
                this.jj_consume_token(285);
                sb.append(" ");
                sb.append(this.token.image.toUpperCase());
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 398: {
                        this.jj_consume_token(398);
                        break;
                    }
                    case 399: {
                        this.jj_consume_token(399);
                        break;
                    }
                    default: {
                        this.jj_la1[298] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                sb.append(" ");
                sb.append(this.token.image.toUpperCase());
                break;
            }
            default: {
                this.jj_la1[299] = this.jj_gen;
            }
        }
        return sb.toString();
    }

    public final void variableOrConstantDeclaration(boolean isPackageLevel) throws ParseException, SAXException {
        Token name = null;
        Hashtable tags = null;
        String elementName = "VARIABLE";
        String defaultValue = null;
        Hashtable<String, String> variableAttributes = new Hashtable<String, String>();
        name = this.ID();
        if (this.jj_2_63(2)) {
            this.jj_consume_token(78);
            elementName = "CONSTANT";
        }
        String type = this.datatype();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: 
            case 183: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        break;
                    }
                    default: {
                        this.jj_la1[300] = this.jj_gen;
                    }
                }
                this.jj_consume_token(183);
                break;
            }
            default: {
                this.jj_la1[301] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 91: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        this.jj_consume_token(12);
                        break;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        break;
                    }
                    default: {
                        this.jj_la1[302] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                defaultValue = this.Expression();
                break;
            }
            default: {
                this.jj_la1[303] = this.jj_gen;
            }
        }
        this.jj_consume_token(4);
        if (this.m_out != null && isPackageLevel) {
            if (null != defaultValue) {
                variableAttributes.put("DEFAULT", defaultValue.startsWith("'") || defaultValue.toUpperCase().startsWith("Q'") ? HTMLEscaper.escape(defaultValue) : this.purifyIdentifier(defaultValue));
            }
            tags = this.processMemberComment(name, elementName, name.toString(), variableAttributes);
            this.m_out.pushAttribute("TYPE", this.purifyIdentifier(type));
            this.m_out.startElement("RETURN");
            this.m_out.endElement("RETURN");
            this.m_out.endElement(elementName);
        }
    }

    public final void datatypeDeclaration() throws ParseException {
        this.jj_consume_token(423);
    }

    public final void pragma(boolean isPackageLevel) throws ParseException, SAXException {
        Token name = null;
        Hashtable tags = null;
        String string = null;
        Token start = this.jj_consume_token(215);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                name = this.jj_consume_token(38);
                break;
            }
            case 41: {
                name = this.jj_consume_token(41);
                break;
            }
            case 272: {
                name = this.jj_consume_token(272);
                this.jj_consume_token(5);
                this.StringLiteral();
                this.jj_consume_token(7);
                break;
            }
            case 39: {
                name = this.jj_consume_token(39);
                this.jj_consume_token(5);
                Token functionName = this.ID();
                block26: while (true) {
                    this.jj_consume_token(6);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 173: 
                        case 174: 
                        case 176: 
                        case 177: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 209: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 258: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 270: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 431: 
                        case 432: 
                        case 433: 
                        case 434: 
                        case 435: {
                            this.ID();
                            break;
                        }
                        case 429: {
                            this.StringLiteral();
                            break;
                        }
                        default: {
                            this.jj_la1[304] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            continue block26;
                        }
                    }
                    break;
                }
                this.jj_la1[305] = this.jj_gen;
                this.jj_consume_token(7);
                break;
            }
            case 40: {
                name = this.jj_consume_token(40);
                this.jj_consume_token(5);
                Token exceptionName = this.jj_consume_token(423);
                this.jj_consume_token(6);
                block16 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 18: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: {
                                this.jj_consume_token(18);
                                break block16;
                            }
                            case 9: {
                                this.jj_consume_token(9);
                                break block16;
                            }
                        }
                        this.jj_la1[306] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[307] = this.jj_gen;
                    }
                }
                Token errorNumber = this.numericLiteral();
                this.jj_consume_token(7);
                break;
            }
            case 145: {
                name = this.jj_consume_token(145);
                this.jj_consume_token(5);
                this.jj_consume_token(423);
                this.jj_consume_token(6);
                this.ID();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        this.numericLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[308] = this.jj_gen;
                    }
                }
                this.jj_consume_token(7);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 177: 
            case 180: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 431: {
                string = this.qualifiedName();
                this.jj_consume_token(5);
                this.readPastNextOccurrence(")");
                break;
            }
            default: {
                this.jj_la1[309] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(4);
        if (this.m_out != null && isPackageLevel) {
            tags = this.processMemberComment(start, start.toString().toUpperCase(), null != name ? name.toString() : string);
            this.m_out.endElement("PRAGMA");
        }
    }

    public final void exceptionDeclaration(boolean isPackageLevel) throws ParseException, SAXException {
        Hashtable tags = null;
        Token exception_name = this.ID();
        this.jj_consume_token(107);
        this.jj_consume_token(4);
        if (this.m_out != null && isPackageLevel) {
            tags = this.processMemberComment(exception_name, "EXCEPTION", exception_name.toString());
            this.m_out.endElement("EXCEPTION");
        }
    }

    public final void parallel_clause() throws ParseException, SAXException {
        this.jj_consume_token(5);
        this.jj_consume_token(208);
        this.ID();
        this.jj_consume_token(62);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 129: 
            case 223: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 129: {
                        this.jj_consume_token(129);
                        break;
                    }
                    case 223: {
                        this.jj_consume_token(223);
                        break;
                    }
                    default: {
                        this.jj_la1[310] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(5);
                this.ID();
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[311] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(6);
                    this.ID();
                }
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[312] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: 
            case 201: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 201: {
                        this.jj_consume_token(201);
                        break;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        break;
                    }
                    default: {
                        this.jj_la1[313] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(62);
                this.jj_consume_token(5);
                this.ID();
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[314] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(6);
                    this.ID();
                }
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[315] = this.jj_gen;
            }
        }
    }

    public final void table() throws ParseException, SAXException {
        Token schema = null;
        Token name = null;
        Token tokenCreate = null;
        Token tokenTable = null;
        tokenCreate = this.jj_consume_token(82);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 125: {
                this.jj_consume_token(125);
                this.jj_consume_token(269);
                break;
            }
            default: {
                this.jj_la1[316] = this.jj_gen;
            }
        }
        tokenTable = this.jj_consume_token(268);
        if (this.jj_2_64(2)) {
            schema = this.ID();
            this.jj_consume_token(3);
        }
        name = this.ID();
        String schemaString = "";
        if (schema != null) {
            schemaString = schema.toString();
        }
        this.m_out.pushAttribute("NAME", this.purifyIdentifier(name.toString()));
        this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString.toString()));
        this.m_out.startElement("TABLE");
        this.jj_consume_token(5);
        this.tableColumn();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[317] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(6);
            this.tableColumn();
        }
        this.jj_consume_token(7);
        if (this.jj_2_65(2)) {
            this.jj_consume_token(195);
            this.jj_consume_token(75);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 92: {
                    this.jj_consume_token(92);
                    break;
                }
                case 216: {
                    this.jj_consume_token(216);
                    break;
                }
                default: {
                    this.jj_la1[318] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(240);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            default: {
                this.jj_la1[319] = this.jj_gen;
            }
        }
        this.m_out.endElement("TABLE");
    }

    public final void tableColumn() throws ParseException, SAXException {
        Token column = null;
        String datatype = null;
        String constraint = null;
        column = this.ID();
        datatype = this.datatype();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[320] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: 
            case 183: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        constraint = "NOT NULL";
                        break;
                    }
                    default: {
                        this.jj_la1[321] = this.jj_gen;
                    }
                }
                this.jj_consume_token(183);
                break;
            }
            default: {
                this.jj_la1[322] = this.jj_gen;
            }
        }
        this.m_out.pushAttribute("NAME", String.valueOf(column));
        this.m_out.pushAttribute("TYPE", datatype);
        if (constraint != null) {
            this.m_out.pushAttribute("CONSTRAINT", constraint);
        }
        this.m_out.element("COLUMN");
    }

    public final void view() throws ParseException, SAXException {
        Token schema = null;
        Token name = null;
        Token tokenCreate = null;
        Token tokenView = null;
        tokenCreate = this.jj_consume_token(82);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 200: {
                this.jj_consume_token(200);
                this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[323] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: 
            case 177: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 177: {
                        this.jj_consume_token(177);
                        break;
                    }
                    default: {
                        this.jj_la1[324] = this.jj_gen;
                    }
                }
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[325] = this.jj_gen;
            }
        }
        tokenView = this.jj_consume_token(325);
        if (this.jj_2_66(2)) {
            schema = this.ID();
            this.jj_consume_token(3);
        }
        name = this.ID();
        String schemaString = "";
        if (schema != null) {
            schemaString = schema.toString();
        }
        this.m_out.pushAttribute("NAME", this.purifyIdentifier(name.toString()));
        this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString.toString()));
        this.m_out.startElement("VIEW");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                this.viewColumn();
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[326] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(6);
                    this.viewColumn();
                }
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[327] = this.jj_gen;
            }
        }
        this.jj_consume_token(50);
        this.statement();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[328] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.m_out.endElement("VIEW");
    }

    public final void Synonym() throws ParseException {
        this.jj_consume_token(82);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 200: {
                this.jj_consume_token(200);
                this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[329] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[330] = this.jj_gen;
            }
        }
        this.jj_consume_token(265);
        this.ObjectNameDeclaration();
        this.jj_consume_token(120);
        this.ObjectNameDeclaration();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[331] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Directory() throws ParseException {
        this.jj_consume_token(82);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 200: {
                this.jj_consume_token(200);
                this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[332] = this.jj_gen;
            }
        }
        this.jj_consume_token(408);
        this.ObjectNameDeclaration();
        this.jj_consume_token(50);
        this.StringLiteral();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[333] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DatabaseLink() throws ParseException {
        this.jj_consume_token(82);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 407: {
                this.jj_consume_token(407);
                break;
            }
            default: {
                this.jj_la1[334] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[335] = this.jj_gen;
            }
        }
        this.jj_consume_token(345);
        this.jj_consume_token(406);
        this.ObjectNameDeclaration();
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(277);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: {
                        this.jj_consume_token(37);
                        break block6;
                    }
                    case 35: 
                    case 36: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 83: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 95: 
                    case 99: 
                    case 100: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 129: 
                    case 131: 
                    case 132: 
                    case 135: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 155: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 172: 
                    case 174: 
                    case 177: 
                    case 180: 
                    case 184: 
                    case 191: 
                    case 194: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 216: 
                    case 219: 
                    case 220: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 259: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 266: 
                    case 267: 
                    case 269: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 283: 
                    case 285: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: {
                        this.unqualifiedID();
                        this.jj_consume_token(133);
                        this.jj_consume_token(62);
                        this.unqualifiedID();
                        this.jj_consume_token(405);
                        this.jj_consume_token(62);
                        this.unqualifiedID();
                        this.jj_consume_token(133);
                        this.jj_consume_token(62);
                        this.unqualifiedID();
                        break block6;
                    }
                }
                this.jj_la1[336] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 95: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 106: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 131: 
            case 132: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 177: 
            case 180: 
            case 184: 
            case 191: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 216: 
            case 219: 
            case 220: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 248: 
            case 250: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 266: 
            case 267: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 290: 
            case 291: 
            case 293: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 323: 
            case 324: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 363: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 414: 
            case 415: 
            case 423: 
            case 431: {
                this.unqualifiedID();
                this.jj_consume_token(133);
                this.jj_consume_token(62);
                this.unqualifiedID();
                break;
            }
            default: {
                this.jj_la1[337] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 285: {
                this.jj_consume_token(285);
                this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[338] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[339] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DDLEvent() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 341: {
                this.jj_consume_token(341);
                break;
            }
            case 342: {
                this.jj_consume_token(342);
                this.jj_consume_token(360);
                break;
            }
            case 343: {
                this.jj_consume_token(343);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 348: {
                this.jj_consume_token(348);
                this.jj_consume_token(360);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 354: {
                this.jj_consume_token(354);
                break;
            }
            case 230: {
                this.jj_consume_token(230);
                break;
            }
            case 237: {
                this.jj_consume_token(237);
                break;
            }
            case 362: {
                this.jj_consume_token(362);
                break;
            }
            case 347: {
                this.jj_consume_token(347);
                break;
            }
            default: {
                this.jj_la1[340] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String ObjectNameDeclaration() throws ParseException {
        Token schemaName = null;
        Token objectName = null;
        if (this.jj_2_67(2)) {
            schemaName = this.ID();
            this.jj_consume_token(3);
        }
        objectName = this.ID();
        return null == schemaName ? objectName.toString() : schemaName.toString() + "." + objectName.toString();
    }

    public final void viewColumn() throws ParseException, SAXException {
        Token column = null;
        column = this.ID();
        this.m_out.pushAttribute("NAME", String.valueOf(column));
        this.m_out.element("COLUMN");
    }

    public final void comment() throws ParseException, SAXException {
        Node commentedObjectNode;
        Token schema = null;
        Token table = null;
        Token column = null;
        Token name = null;
        Token tokenComment = null;
        Token tokenOn = null;
        this.jj_consume_token(74);
        this.jj_consume_token(195);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 140: 
            case 198: 
            case 268: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 268: {
                        tokenOn = this.jj_consume_token(268);
                        break;
                    }
                    case 198: {
                        tokenOn = this.jj_consume_token(198);
                        break;
                    }
                    case 140: {
                        tokenOn = this.jj_consume_token(140);
                        break;
                    }
                    default: {
                        this.jj_la1[341] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.jj_2_68(2)) {
                    schema = this.ID();
                    this.jj_consume_token(3);
                }
                name = this.ID();
                break;
            }
            case 73: {
                tokenOn = this.jj_consume_token(73);
                if (this.jj_2_69(Integer.MAX_VALUE)) {
                    schema = this.ID();
                    this.jj_consume_token(3);
                }
                table = this.ID();
                this.jj_consume_token(3);
                column = this.ID();
                break;
            }
            default: {
                this.jj_la1[342] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String schemaString = "";
        if (schema != null) {
            schemaString = schema.toString();
        }
        if (name != null) {
            commentedObjectNode = this.m_out.findObjectNode(this.purifyIdentifier(schemaString), this.purifyIdentifier(name.toString()));
        } else {
            Node commentedTableObjectNode = this.m_out.findObjectNode(this.purifyIdentifier(schemaString), this.purifyIdentifier(table.toString()));
            commentedObjectNode = null;
            for (Node n = commentedTableObjectNode.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element e = (Element)n;
                if (!e.getTagName().equals("COLUMN") || !e.getAttribute("NAME").equalsIgnoreCase(this.purifyIdentifier(column.toString()))) continue;
                commentedObjectNode = e;
                break;
            }
        }
        Element commentElement = this.m_out.createElement("COMMENT");
        this.jj_consume_token(150);
        tokenComment = this.jj_consume_token(429);
        String commentString = tokenComment.toString();
        commentElement.appendChild(this.m_out.createCDATASection(commentString.substring(1, commentString.length() - 1)));
        if (commentedObjectNode != null) {
            commentedObjectNode.appendChild(commentElement);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            default: {
                this.jj_la1[343] = this.jj_gen;
            }
        }
    }

    public final void typeMethod(boolean isPackageLevel, int typeVersion, String alterTypeAction, Token objectStart) throws ParseException, SAXException {
        Hashtable tags;
        Token start;
        Token scope;
        Hashtable<String, String> attributes;
        String returnComment2;
        String type;
        String methodPrefix;
        String methodInheritance;
        String methodOrdering;
        String methodScope;
        String methodType;
        String methodName;
        Token startToken;
        Token mapOrderMethod;
        Token tokenIsAs;
        Token schemaName;
        block97: {
            schemaName = null;
            tokenIsAs = null;
            mapOrderMethod = null;
            Object inheritanceClause = null;
            startToken = null;
            Object returnToken = null;
            methodName = null;
            methodType = null;
            methodScope = null;
            methodOrdering = "";
            methodInheritance = "";
            methodPrefix = "";
            type = null;
            returnComment2 = null;
            attributes = new Hashtable<String, String>();
            startToken = this.getToken(1);
            block71: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: 
                    case 143: 
                    case 181: 
                    case 205: {
                        break;
                    }
                    default: {
                        this.jj_la1[344] = this.jj_gen;
                        break block97;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        break;
                    }
                    default: {
                        this.jj_la1[345] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 205: {
                        this.jj_consume_token(205);
                        continue block71;
                    }
                    case 143: {
                        this.jj_consume_token(143);
                        continue block71;
                    }
                    case 118: {
                        this.jj_consume_token(118);
                        continue block71;
                    }
                }
                break;
            }
            this.jj_la1[346] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 160: 
            case 201: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 160: {
                        mapOrderMethod = this.jj_consume_token(160);
                        break block11;
                    }
                    case 201: {
                        mapOrderMethod = this.jj_consume_token(201);
                        break block11;
                    }
                }
                this.jj_la1[347] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[348] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                scope = this.jj_consume_token(79);
                break;
            }
            case 162: {
                scope = this.jj_consume_token(162);
                break;
            }
            case 259: {
                scope = this.jj_consume_token(259);
                break;
            }
            default: {
                this.jj_la1[349] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: {
                start = this.jj_consume_token(124);
                break;
            }
            case 220: {
                start = this.jj_consume_token(220);
                break;
            }
            default: {
                this.jj_la1[350] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_70(2)) {
            schemaName = this.ID();
            this.jj_consume_token(3);
        }
        Token name = this.ID();
        if (this.m_out != null && isPackageLevel) {
            attributes = new Hashtable();
            attributes.put("VERSION", Integer.toString(typeVersion));
            Token p = startToken;
            if (null != mapOrderMethod) {
                while (p != mapOrderMethod) {
                    methodInheritance = methodInheritance + " " + p.image;
                    p = p.next;
                }
                methodOrdering = mapOrderMethod.toString();
            } else {
                while (p != scope) {
                    methodInheritance = methodInheritance + " " + p.image;
                    p = p.next;
                }
            }
            methodScope = scope.toString();
            if (null != methodInheritance && !"".equals(methodInheritance)) {
                attributes.put("INHERITANCE", this.purifyKeyword(methodInheritance));
            }
            if (null != methodOrdering && !"".equals(methodOrdering)) {
                attributes.put("ORDERING", this.purifyKeyword(methodOrdering));
            }
            if (null != methodScope && !"".equals(methodScope)) {
                attributes.put("SCOPE", this.purifyKeyword(methodScope));
            }
            methodType = this.purifyKeyword(start.toString());
            methodName = this.purifyKeyword(start.toString());
            tags = this.processMemberComment(startToken, methodName, name.toString(), attributes);
            methodPrefix = (this.purifyKeyword(methodInheritance + " " + methodOrdering + " " + methodScope) + " " + this.purifyIdentifier(methodType) + " ").replaceAll("  ", " ");
        } else {
            tags = new Hashtable();
        }
        block74: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[351] = this.jj_gen;
                    break block74;
                }
            }
            this.jj_consume_token(5);
            this.parameterDeclaration(tags, isPackageLevel);
            block75: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.jj_la1[352] = this.jj_gen;
                        break block75;
                    }
                }
                this.jj_consume_token(6);
                this.parameterDeclaration(tags, isPackageLevel);
            }
            this.jj_consume_token(7);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 234: {
                this.jj_consume_token(234);
                type = this.datatype();
                if (this.m_out == null || !isPackageLevel) break;
                Collection tagValues = (Collection)tags.get("@return");
                if (tagValues != null) {
                    for (String returnComment2 : tagValues) {
                    }
                }
                methodPrefix = methodPrefix + this.purifyIdentifier(type.toString());
                break;
            }
            default: {
                this.jj_la1[353] = this.jj_gen;
            }
        }
        if (null != methodPrefix) {
            this.m_out.pushAttribute("TYPE", methodPrefix.trim());
            this.m_out.startElement("RETURN");
            if (returnComment2 != null) {
                this.m_out.startElement("COMMENT");
                this.m_out.cdata(returnComment2);
                this.m_out.endElement("COMMENT");
            }
            this.m_out.endElement("RETURN");
        }
        if (this.m_out != null && isPackageLevel) {
            String throwsComment2 = null;
            String exceptionName = null;
            Collection tagValues = (Collection)tags.get("@throws");
            if (tagValues != null) {
                for (String throwsComment2 : tagValues) {
                    StringTokenizer st = new StringTokenizer(throwsComment2);
                    if (st.hasMoreTokens()) {
                        exceptionName = st.nextToken();
                    }
                    if (exceptionName == null) continue;
                    this.m_out.pushAttribute("NAME", this.purifyIdentifier(exceptionName));
                    this.m_out.startElement("THROWS");
                    if (throwsComment2 != null) {
                        this.m_out.startElement("COMMENT");
                        this.m_out.cdata(throwsComment2.substring(exceptionName.length()));
                        this.m_out.endElement("COMMENT");
                    }
                    this.m_out.endElement("THROWS");
                }
            }
        }
        if (this.m_out != null && isPackageLevel) {
            this.printCustomTags(tags);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[354] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 207: {
                this.jj_consume_token(207);
                break;
            }
            default: {
                this.jj_la1[355] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 211: {
                this.jj_consume_token(211);
                break;
            }
            default: {
                this.jj_la1[356] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 233: {
                this.jj_consume_token(233);
                break;
            }
            default: {
                this.jj_la1[357] = this.jj_gen;
            }
        }
        block48 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: 
            case 150: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 150: {
                        tokenIsAs = this.jj_consume_token(150);
                        break;
                    }
                    case 50: {
                        tokenIsAs = this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[358] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.m_out != null && isPackageLevel) {
                    this.processPackageComment(tokenIsAs);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: 
                    case 113: {
                        this.callSpecTail(true);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 4: {
                                this.jj_consume_token(4);
                                break block48;
                            }
                        }
                        this.jj_la1[359] = this.jj_gen;
                        break block48;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 258: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 327: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: 
                    case 432: 
                    case 433: 
                    case 434: 
                    case 435: {
                        this.declarativeSection(false, objectStart);
                        this.jj_consume_token(56);
                        block78: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 5: 
                                case 9: 
                                case 18: 
                                case 21: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 49: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 56: 
                                case 59: 
                                case 61: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 69: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 83: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 92: 
                                case 95: 
                                case 99: 
                                case 100: 
                                case 103: 
                                case 105: 
                                case 106: 
                                case 108: 
                                case 110: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 124: 
                                case 125: 
                                case 126: 
                                case 129: 
                                case 131: 
                                case 132: 
                                case 134: 
                                case 135: 
                                case 138: 
                                case 140: 
                                case 141: 
                                case 142: 
                                case 143: 
                                case 147: 
                                case 149: 
                                case 151: 
                                case 152: 
                                case 153: 
                                case 155: 
                                case 157: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 163: 
                                case 164: 
                                case 166: 
                                case 167: 
                                case 168: 
                                case 169: 
                                case 171: 
                                case 172: 
                                case 174: 
                                case 175: 
                                case 177: 
                                case 180: 
                                case 181: 
                                case 183: 
                                case 184: 
                                case 191: 
                                case 194: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 202: 
                                case 203: 
                                case 205: 
                                case 206: 
                                case 208: 
                                case 210: 
                                case 215: 
                                case 216: 
                                case 219: 
                                case 220: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 232: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 247: 
                                case 248: 
                                case 250: 
                                case 254: 
                                case 255: 
                                case 256: 
                                case 257: 
                                case 259: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 266: 
                                case 267: 
                                case 269: 
                                case 271: 
                                case 272: 
                                case 273: 
                                case 274: 
                                case 275: 
                                case 276: 
                                case 278: 
                                case 280: 
                                case 281: 
                                case 283: 
                                case 285: 
                                case 289: 
                                case 290: 
                                case 291: 
                                case 293: 
                                case 294: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 323: 
                                case 324: 
                                case 327: 
                                case 332: 
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 361: 
                                case 362: 
                                case 363: 
                                case 364: 
                                case 365: 
                                case 366: 
                                case 367: 
                                case 368: 
                                case 369: 
                                case 370: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: 
                                case 379: 
                                case 380: 
                                case 381: 
                                case 382: 
                                case 383: 
                                case 384: 
                                case 385: 
                                case 386: 
                                case 387: 
                                case 388: 
                                case 389: 
                                case 390: 
                                case 391: 
                                case 392: 
                                case 393: 
                                case 394: 
                                case 395: 
                                case 396: 
                                case 397: 
                                case 398: 
                                case 399: 
                                case 403: 
                                case 404: 
                                case 405: 
                                case 406: 
                                case 407: 
                                case 408: 
                                case 409: 
                                case 410: 
                                case 411: 
                                case 412: 
                                case 413: 
                                case 414: 
                                case 415: 
                                case 423: 
                                case 424: 
                                case 428: 
                                case 429: 
                                case 431: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[360] = this.jj_gen;
                                    break block78;
                                }
                            }
                            this.statement();
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 107: {
                                this.exceptionHandler();
                                break;
                            }
                            default: {
                                this.jj_la1[361] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(104);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                this.ID();
                                break;
                            }
                            default: {
                                this.jj_la1[362] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(4);
                        break block48;
                    }
                }
                this.jj_la1[363] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[364] = this.jj_gen;
            }
        }
        this.printSummary("Object Type Method", objectStart.beginLine, name, this.token);
        if (this.m_out != null && isPackageLevel) {
            this.m_out.endElement(this.purifyKeyword(start.toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void typeSpec() throws ParseException, SAXException {
        int typeVersion;
        Token tokenTypeTerminator;
        Token name;
        block138: {
            block139: {
                block137: {
                    Token schema = null;
                    name = null;
                    Token tokenCreate = null;
                    Token tokenType = null;
                    Token schemaSuperType = null;
                    Token nameSuperType = null;
                    Object tokenSuperType = null;
                    Token tokenIsAsUnder = null;
                    Token tokenSpecificationForm = null;
                    tokenTypeTerminator = null;
                    boolean isPackageLevel = true;
                    String collectionType = null;
                    String baseType = "";
                    typeVersion = 1;
                    block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 82: {
                            tokenCreate = this.jj_consume_token(82);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 200: {
                                    this.jj_consume_token(200);
                                    this.jj_consume_token(35);
                                    break;
                                }
                                default: {
                                    this.jj_la1[365] = this.jj_gen;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 99: 
                                case 180: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 99: {
                                            this.jj_consume_token(99);
                                            break block0;
                                        }
                                        case 180: {
                                            this.jj_consume_token(180);
                                            break block0;
                                        }
                                    }
                                    this.jj_la1[366] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_la1[367] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[368] = this.jj_gen;
                        }
                    }
                    tokenType = this.jj_consume_token(281);
                    if (this.jj_2_71(2)) {
                        schema = this.ID();
                        this.jj_consume_token(3);
                    }
                    name = this.ID();
                    if (this.m_out != null) {
                        String schemaString = this.schemaName;
                        if (schema != null) {
                            schemaString = schema.toString();
                        }
                        this.m_out.pushAttribute("NAME", this.purifyIdentifier(name.toString()));
                        this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString.toString()));
                        this.m_out.startElement("OBJECT_TYPE");
                    }
                    this.processPackageComment(tokenCreate);
                    this.processPackageComment(tokenType);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 122: {
                            tokenIsAsUnder = this.jj_consume_token(122);
                            this.processPackageComment(tokenIsAsUnder);
                            break;
                        }
                        default: {
                            this.jj_la1[369] = this.jj_gen;
                        }
                    }
                    if (this.jj_2_72(2)) {
                        tokenIsAsUnder = this.jj_consume_token(194);
                        this.jj_consume_token(429);
                        this.processPackageComment(tokenIsAsUnder);
                    }
                    if (this.jj_2_73(2)) {
                        tokenIsAsUnder = this.jj_consume_token(54);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 37: {
                                this.jj_consume_token(37);
                                break;
                            }
                            case 36: {
                                this.jj_consume_token(36);
                                break;
                            }
                            default: {
                                this.jj_la1[370] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.processPackageComment(tokenIsAsUnder);
                    }
                    if (this.jj_2_74(3)) {
                        tokenIsAsUnder = this.jj_consume_token(375);
                        this.jj_consume_token(62);
                        this.jj_consume_token(5);
                        block20 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 124: 
                            case 206: 
                            case 220: 
                            case 279: 
                            case 281: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 124: {
                                        this.jj_consume_token(124);
                                        break block20;
                                    }
                                    case 220: {
                                        this.jj_consume_token(220);
                                        break block20;
                                    }
                                    case 206: {
                                        this.jj_consume_token(206);
                                        break block20;
                                    }
                                    case 279: {
                                        this.jj_consume_token(279);
                                        break block20;
                                    }
                                    case 281: {
                                        this.jj_consume_token(281);
                                        break block20;
                                    }
                                }
                                this.jj_la1[371] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[372] = this.jj_gen;
                            }
                        }
                        this.qualifiedName();
                        block114: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[373] = this.jj_gen;
                                    break block114;
                                }
                            }
                            this.jj_consume_token(6);
                            this.qualifiedName();
                        }
                        this.jj_consume_token(7);
                        this.processPackageComment(tokenIsAsUnder);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 50: 
                        case 150: 
                        case 283: {
                            String schemaSuperTypeString;
                            block36 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 283: {
                                    tokenIsAsUnder = this.jj_consume_token(283);
                                    if (this.jj_2_75(2)) {
                                        schemaSuperType = this.ID();
                                        this.jj_consume_token(3);
                                    }
                                    nameSuperType = this.ID();
                                    break;
                                }
                                default: {
                                    this.jj_la1[380] = this.jj_gen;
                                    if (this.jj_2_76(2)) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 150: {
                                                tokenIsAsUnder = this.jj_consume_token(150);
                                                break;
                                            }
                                            case 50: {
                                                tokenIsAsUnder = this.jj_consume_token(50);
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[374] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        tokenSpecificationForm = this.jj_consume_token(191);
                                        break;
                                    }
                                    if (this.jj_2_77(2)) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 150: {
                                                tokenIsAsUnder = this.jj_consume_token(150);
                                                break;
                                            }
                                            case 50: {
                                                tokenIsAsUnder = this.jj_consume_token(50);
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[375] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        tokenSpecificationForm = this.jj_consume_token(196);
                                        this.jj_consume_token(308);
                                        this.jj_consume_token(24);
                                        this.jj_consume_token(285);
                                        this.jj_consume_token(364);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 423: {
                                                this.jj_consume_token(423);
                                                break;
                                            }
                                            case 431: {
                                                this.jj_consume_token(431);
                                                break;
                                            }
                                            case 429: {
                                                this.StringLiteral();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[376] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 3: {
                                                this.jj_consume_token(3);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 423: {
                                                        this.jj_consume_token(423);
                                                        break block36;
                                                    }
                                                    case 431: {
                                                        this.jj_consume_token(431);
                                                        break block36;
                                                    }
                                                    case 429: {
                                                        this.StringLiteral();
                                                        break block36;
                                                    }
                                                }
                                                this.jj_la1[377] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        this.jj_la1[378] = this.jj_gen;
                                        break;
                                    }
                                    if (!this.jj_2_78(2)) {
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 150: {
                                            tokenIsAsUnder = this.jj_consume_token(150);
                                            break;
                                        }
                                        case 50: {
                                            tokenIsAsUnder = this.jj_consume_token(50);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[379] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    collectionType = this.collection_type_name();
                                    this.jj_consume_token(193);
                                    baseType = this.datatype();
                                    break;
                                }
                            }
                            if (this.m_out != null && nameSuperType != null) {
                                this.processPackageComment(tokenIsAsUnder);
                                schemaSuperTypeString = nameSuperType.toString();
                                if (schemaSuperType != null) {
                                    schemaSuperTypeString = schemaSuperType.toString() + "." + nameSuperType.toString();
                                }
                                this.m_out.pushAttribute("NAME", this.purifyIdentifier(schemaSuperTypeString));
                                this.m_out.startElement("SUPERTYPE");
                                this.m_out.pushAttribute("TYPE", this.purifyIdentifier(schemaSuperTypeString));
                                this.m_out.startElement("RETURN");
                                this.m_out.endElement("RETURN");
                                this.m_out.endElement("SUPERTYPE");
                            }
                            if (this.m_out != null && collectionType != null) {
                                schemaSuperTypeString = "";
                                this.m_out.pushAttribute("NAME", this.purifyIdentifier(collectionType));
                                this.m_out.startElement("COLLECTIONTYPE");
                                this.m_out.endElement("COLLECTIONTYPE");
                                this.m_out.pushAttribute("NAME", this.purifyIdentifier(baseType));
                                this.m_out.startElement("SUPERTYPE");
                                this.m_out.pushAttribute("TYPE", this.purifyIdentifier(collectionType + " OF " + baseType));
                                this.m_out.pushAttribute("NAME", "COLLECTION");
                                this.m_out.pushAttribute("COLLECTIONTYPE", this.purifyIdentifier(collectionType));
                                this.m_out.pushAttribute("SUPERTYPE", this.purifyIdentifier(baseType));
                                this.m_out.startElement("RETURN");
                                this.m_out.startElement("COMMENT");
                                this.m_out.cdata("Collection Type : " + collectionType + " OF " + baseType);
                                this.m_out.endElement("COMMENT");
                                this.m_out.endElement("RETURN");
                                this.m_out.endElement("SUPERTYPE");
                            }
                            this.processPackageComment(tokenIsAsUnder);
                            if (null == tokenSpecificationForm) break;
                            this.processPackageComment(tokenSpecificationForm);
                            break;
                        }
                        default: {
                            this.jj_la1[381] = this.jj_gen;
                        }
                    }
                    if (this.jj_2_79(8)) {
                        tokenIsAsUnder = this.jj_consume_token(113);
                        this.jj_consume_token(423);
                        this.jj_consume_token(423);
                        this.jj_consume_token(42);
                        this.jj_consume_token(152);
                        this.jj_consume_token(285);
                        this.jj_consume_token(423);
                        this.processPackageComment(tokenIsAsUnder);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 363: {
                            this.wrappedObject();
                            break;
                        }
                        default: {
                            this.jj_la1[382] = this.jj_gen;
                        }
                    }
                    block67 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            tokenIsAsUnder = this.jj_consume_token(5);
                            this.processPackageComment(tokenIsAsUnder);
                            block115: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 38: 
                                    case 39: 
                                    case 40: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 45: 
                                    case 46: 
                                    case 47: 
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 57: 
                                    case 58: 
                                    case 59: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 82: 
                                    case 83: 
                                    case 84: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 90: 
                                    case 91: 
                                    case 92: 
                                    case 93: 
                                    case 95: 
                                    case 96: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: 
                                    case 103: 
                                    case 105: 
                                    case 106: 
                                    case 107: 
                                    case 108: 
                                    case 109: 
                                    case 110: 
                                    case 111: 
                                    case 112: 
                                    case 113: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 119: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 123: 
                                    case 124: 
                                    case 125: 
                                    case 126: 
                                    case 127: 
                                    case 129: 
                                    case 130: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 135: 
                                    case 136: 
                                    case 137: 
                                    case 138: 
                                    case 140: 
                                    case 141: 
                                    case 142: 
                                    case 143: 
                                    case 144: 
                                    case 145: 
                                    case 146: 
                                    case 147: 
                                    case 148: 
                                    case 149: 
                                    case 150: 
                                    case 151: 
                                    case 152: 
                                    case 153: 
                                    case 154: 
                                    case 155: 
                                    case 156: 
                                    case 157: 
                                    case 158: 
                                    case 159: 
                                    case 160: 
                                    case 161: 
                                    case 162: 
                                    case 163: 
                                    case 164: 
                                    case 165: 
                                    case 166: 
                                    case 167: 
                                    case 168: 
                                    case 169: 
                                    case 170: 
                                    case 171: 
                                    case 172: 
                                    case 173: 
                                    case 174: 
                                    case 176: 
                                    case 177: 
                                    case 179: 
                                    case 180: 
                                    case 181: 
                                    case 182: 
                                    case 183: 
                                    case 184: 
                                    case 185: 
                                    case 186: 
                                    case 187: 
                                    case 188: 
                                    case 189: 
                                    case 190: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 209: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 215: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 232: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 249: 
                                    case 250: 
                                    case 252: 
                                    case 253: 
                                    case 254: 
                                    case 255: 
                                    case 256: 
                                    case 257: 
                                    case 258: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 270: 
                                    case 271: 
                                    case 272: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 285: 
                                    case 289: 
                                    case 290: 
                                    case 291: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 323: 
                                    case 324: 
                                    case 341: 
                                    case 342: 
                                    case 343: 
                                    case 344: 
                                    case 345: 
                                    case 346: 
                                    case 347: 
                                    case 348: 
                                    case 349: 
                                    case 350: 
                                    case 351: 
                                    case 352: 
                                    case 353: 
                                    case 354: 
                                    case 355: 
                                    case 356: 
                                    case 357: 
                                    case 358: 
                                    case 359: 
                                    case 360: 
                                    case 361: 
                                    case 362: 
                                    case 363: 
                                    case 364: 
                                    case 365: 
                                    case 366: 
                                    case 367: 
                                    case 368: 
                                    case 369: 
                                    case 370: 
                                    case 371: 
                                    case 372: 
                                    case 373: 
                                    case 374: 
                                    case 375: 
                                    case 376: 
                                    case 377: 
                                    case 378: 
                                    case 379: 
                                    case 380: 
                                    case 381: 
                                    case 382: 
                                    case 383: 
                                    case 384: 
                                    case 385: 
                                    case 386: 
                                    case 387: 
                                    case 388: 
                                    case 389: 
                                    case 390: 
                                    case 391: 
                                    case 392: 
                                    case 393: 
                                    case 394: 
                                    case 395: 
                                    case 396: 
                                    case 397: 
                                    case 398: 
                                    case 399: 
                                    case 403: 
                                    case 404: 
                                    case 405: 
                                    case 406: 
                                    case 407: 
                                    case 408: 
                                    case 409: 
                                    case 410: 
                                    case 411: 
                                    case 412: 
                                    case 413: 
                                    case 414: 
                                    case 415: 
                                    case 423: 
                                    case 431: 
                                    case 432: 
                                    case 433: 
                                    case 434: 
                                    case 435: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[383] = this.jj_gen;
                                        break block67;
                                    }
                                }
                                if (this.jj_2_80(2)) {
                                    this.typeMethod(isPackageLevel, typeVersion, null, name);
                                    continue;
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 35: 
                                    case 36: 
                                    case 37: 
                                    case 38: 
                                    case 39: 
                                    case 40: 
                                    case 41: 
                                    case 42: 
                                    case 43: 
                                    case 44: 
                                    case 45: 
                                    case 46: 
                                    case 47: 
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 57: 
                                    case 58: 
                                    case 59: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 79: 
                                    case 80: 
                                    case 81: 
                                    case 82: 
                                    case 83: 
                                    case 84: 
                                    case 85: 
                                    case 86: 
                                    case 87: 
                                    case 88: 
                                    case 89: 
                                    case 90: 
                                    case 91: 
                                    case 92: 
                                    case 93: 
                                    case 95: 
                                    case 96: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: 
                                    case 103: 
                                    case 105: 
                                    case 106: 
                                    case 107: 
                                    case 108: 
                                    case 109: 
                                    case 110: 
                                    case 111: 
                                    case 112: 
                                    case 113: 
                                    case 114: 
                                    case 115: 
                                    case 116: 
                                    case 117: 
                                    case 118: 
                                    case 119: 
                                    case 120: 
                                    case 121: 
                                    case 122: 
                                    case 123: 
                                    case 124: 
                                    case 125: 
                                    case 126: 
                                    case 127: 
                                    case 129: 
                                    case 130: 
                                    case 131: 
                                    case 132: 
                                    case 134: 
                                    case 135: 
                                    case 136: 
                                    case 137: 
                                    case 138: 
                                    case 140: 
                                    case 141: 
                                    case 142: 
                                    case 143: 
                                    case 144: 
                                    case 145: 
                                    case 146: 
                                    case 147: 
                                    case 148: 
                                    case 149: 
                                    case 150: 
                                    case 151: 
                                    case 152: 
                                    case 153: 
                                    case 154: 
                                    case 155: 
                                    case 156: 
                                    case 157: 
                                    case 158: 
                                    case 159: 
                                    case 160: 
                                    case 161: 
                                    case 162: 
                                    case 163: 
                                    case 164: 
                                    case 165: 
                                    case 166: 
                                    case 167: 
                                    case 168: 
                                    case 169: 
                                    case 170: 
                                    case 171: 
                                    case 172: 
                                    case 173: 
                                    case 174: 
                                    case 176: 
                                    case 177: 
                                    case 179: 
                                    case 180: 
                                    case 181: 
                                    case 182: 
                                    case 183: 
                                    case 184: 
                                    case 185: 
                                    case 186: 
                                    case 187: 
                                    case 188: 
                                    case 189: 
                                    case 190: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 208: 
                                    case 209: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 232: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 249: 
                                    case 250: 
                                    case 252: 
                                    case 253: 
                                    case 254: 
                                    case 255: 
                                    case 256: 
                                    case 257: 
                                    case 258: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 270: 
                                    case 271: 
                                    case 272: 
                                    case 273: 
                                    case 274: 
                                    case 275: 
                                    case 276: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 285: 
                                    case 289: 
                                    case 290: 
                                    case 291: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 323: 
                                    case 324: 
                                    case 341: 
                                    case 342: 
                                    case 343: 
                                    case 344: 
                                    case 345: 
                                    case 346: 
                                    case 347: 
                                    case 348: 
                                    case 349: 
                                    case 350: 
                                    case 351: 
                                    case 352: 
                                    case 353: 
                                    case 354: 
                                    case 355: 
                                    case 356: 
                                    case 357: 
                                    case 358: 
                                    case 359: 
                                    case 360: 
                                    case 361: 
                                    case 362: 
                                    case 363: 
                                    case 364: 
                                    case 365: 
                                    case 366: 
                                    case 367: 
                                    case 368: 
                                    case 369: 
                                    case 370: 
                                    case 371: 
                                    case 372: 
                                    case 373: 
                                    case 374: 
                                    case 375: 
                                    case 376: 
                                    case 377: 
                                    case 378: 
                                    case 379: 
                                    case 380: 
                                    case 381: 
                                    case 382: 
                                    case 383: 
                                    case 384: 
                                    case 385: 
                                    case 386: 
                                    case 387: 
                                    case 388: 
                                    case 389: 
                                    case 390: 
                                    case 391: 
                                    case 392: 
                                    case 393: 
                                    case 394: 
                                    case 395: 
                                    case 396: 
                                    case 397: 
                                    case 398: 
                                    case 399: 
                                    case 403: 
                                    case 404: 
                                    case 405: 
                                    case 406: 
                                    case 407: 
                                    case 408: 
                                    case 409: 
                                    case 410: 
                                    case 411: 
                                    case 412: 
                                    case 413: 
                                    case 414: 
                                    case 415: 
                                    case 423: 
                                    case 431: 
                                    case 432: 
                                    case 433: 
                                    case 434: 
                                    case 435: {
                                        this.attributeDeclaration(typeVersion, null);
                                        continue block115;
                                    }
                                    case 215: {
                                        this.pragma_clause();
                                        continue block115;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[384] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[388] = this.jj_gen;
                            break block139;
                        }
                    }
                    block116: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                break;
                            }
                            default: {
                                this.jj_la1[385] = this.jj_gen;
                                break block137;
                            }
                        }
                        this.jj_consume_token(6);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 79: 
                            case 118: 
                            case 143: 
                            case 160: 
                            case 162: 
                            case 181: 
                            case 201: 
                            case 205: 
                            case 259: {
                                this.typeMethod(isPackageLevel, typeVersion, null, name);
                                continue block116;
                            }
                        }
                        this.jj_la1[386] = this.jj_gen;
                        if (this.jj_2_81(2)) {
                            this.attributeDeclaration(typeVersion, null);
                            continue;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 215: {
                                this.pragma_clause();
                                continue block116;
                            }
                        }
                        break;
                    }
                    this.jj_la1[387] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(7);
            }
            block117: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: 
                    case 143: 
                    case 181: 
                    case 183: {
                        break;
                    }
                    default: {
                        this.jj_la1[389] = this.jj_gen;
                        break block138;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        break;
                    }
                    default: {
                        this.jj_la1[390] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: {
                        this.jj_consume_token(118);
                        continue block117;
                    }
                    case 143: {
                        this.jj_consume_token(143);
                        continue block117;
                    }
                    case 183: {
                        this.jj_consume_token(183);
                        continue block117;
                    }
                }
                break;
            }
            this.jj_la1[391] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block118: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[392] = this.jj_gen;
                    break block118;
                }
            }
            this.alterTypeSpec(++typeVersion, name);
        }
        block100 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 4: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        tokenTypeTerminator = this.jj_consume_token(4);
                        break;
                    }
                    case 1: {
                        tokenTypeTerminator = this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[393] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.processPackageComment(tokenTypeTerminator);
                block119: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[394] = this.jj_gen;
                            break block100;
                        }
                    }
                    this.alterTypeSpec(++typeVersion, name);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block119;
                        }
                        case 4: {
                            this.jj_consume_token(4);
                            continue block119;
                        }
                    }
                    break;
                }
                this.jj_la1[395] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[396] = this.jj_gen;
            }
        }
        this.printSummary("Object Type Specification", name.beginLine, name, this.token);
        if (this.m_out != null) {
            this.m_out.endElement("OBJECT_TYPE");
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void alterTypeSpec(int typeVersion, Token objectStart) throws ParseException, SAXException {
        block141: {
            block140: {
                schema = null;
                name = null;
                tokenCreate = null;
                tokenType = null;
                schemaSuperType = null;
                nameSuperType = null;
                tokenSuperType = null;
                tokenIsAsUnder = null;
                tokenSpecificationForm = null;
                tokenAlterType = null;
                tokenCollectionSize = null;
                isPackageLevel = true;
                typeName = "";
                collectionType = null;
                collectionSize = "";
                baseType = "";
                exceptionsName = "";
                tokenAlterTypeString = null;
                tokenCreate = this.jj_consume_token(46);
                tokenType = this.jj_consume_token(281);
                typeName = this.qualifiedName();
                this.processPackageComment(tokenCreate);
                this.processPackageComment(tokenType);
                block118: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: 
                        case 43: 
                        case 98: 
                        case 168: {
                            break;
                        }
                        default: {
                            this.jj_la1[397] = this.jj_gen;
                            break block140;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: 
                        case 43: 
                        case 168: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    this.jj_consume_token(6);
                                    break;
                                }
                                default: {
                                    this.jj_la1[398] = this.jj_gen;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 43: {
                                    tokenAlterType = this.jj_consume_token(43);
                                    break;
                                }
                                case 168: {
                                    tokenAlterType = this.jj_consume_token(168);
                                    break;
                                }
                                default: {
                                    this.jj_la1[399] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            tokenAlterTypeString = tokenAlterType.toString().equals("ADD") != false ? "(+)" : "(m)";
                            block119: while (true) {
                                block14 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 79: 
                                    case 118: 
                                    case 143: 
                                    case 160: 
                                    case 162: 
                                    case 181: 
                                    case 201: 
                                    case 205: 
                                    case 259: {
                                        this.typeMethod(isPackageLevel, typeVersion, tokenAlterTypeString, objectStart);
                                        break;
                                    }
                                    case 53: {
                                        this.jj_consume_token(53);
                                        block120: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 5: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[400] = this.jj_gen;
                                                    break block120;
                                                }
                                            }
                                            this.jj_consume_token(5);
                                        }
                                        this.attributeDeclaration(typeVersion, tokenAlterTypeString);
                                        block121: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 6: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[401] = this.jj_gen;
                                                    break block121;
                                                }
                                            }
                                            this.jj_consume_token(6);
                                            this.attributeDeclaration(typeVersion, tokenAlterTypeString);
                                        }
                                        while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 7: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[402] = this.jj_gen;
                                                    break block14;
                                                }
                                            }
                                            this.jj_consume_token(7);
                                        }
                                    }
                                    case 155: {
                                        this.jj_consume_token(155);
                                        tokenCollectionSize = this.numericLiteral();
                                        break;
                                    }
                                    case 100: {
                                        this.jj_consume_token(100);
                                        this.jj_consume_token(281);
                                        baseType = this.datatype();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[403] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 53: 
                                    case 79: 
                                    case 100: 
                                    case 118: 
                                    case 143: 
                                    case 155: 
                                    case 160: 
                                    case 162: 
                                    case 181: 
                                    case 201: 
                                    case 205: 
                                    case 259: {
                                        continue block119;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[404] = this.jj_gen;
                            continue block118;
                        }
                        case 98: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    this.jj_consume_token(6);
                                    break;
                                }
                                default: {
                                    this.jj_la1[405] = this.jj_gen;
                                }
                            }
                            tokenAlterType = this.jj_consume_token(98);
                            tokenAlterTypeString = "(-)";
                            block123: while (true) {
                                block35 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 53: {
                                        this.jj_consume_token(53);
                                        block124: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 5: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[406] = this.jj_gen;
                                                    break block124;
                                                }
                                            }
                                            this.jj_consume_token(5);
                                        }
                                        this.attribute(typeVersion, tokenAlterTypeString);
                                        block125: while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 6: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[407] = this.jj_gen;
                                                    break block125;
                                                }
                                            }
                                            this.jj_consume_token(6);
                                            this.attribute(typeVersion, tokenAlterTypeString);
                                        }
                                        while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 7: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[408] = this.jj_gen;
                                                    break block35;
                                                }
                                            }
                                            this.jj_consume_token(7);
                                        }
                                    }
                                    case 79: 
                                    case 118: 
                                    case 143: 
                                    case 160: 
                                    case 162: 
                                    case 181: 
                                    case 201: 
                                    case 205: 
                                    case 259: {
                                        this.typeMethod(isPackageLevel, typeVersion, tokenAlterTypeString, objectStart);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[409] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 53: 
                                    case 79: 
                                    case 118: 
                                    case 143: 
                                    case 160: 
                                    case 162: 
                                    case 181: 
                                    case 201: 
                                    case 205: 
                                    case 259: {
                                        continue block123;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[410] = this.jj_gen;
                            continue block118;
                        }
                    }
                    break;
                }
                this.jj_la1[411] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    this.jj_consume_token(35);
                    tokenAlterTypeString = "(r)";
                    if (this.jj_2_82(2)) {
                        tokenIsAsUnder = this.jj_consume_token(54);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 37: {
                                this.jj_consume_token(37);
                                break;
                            }
                            case 36: {
                                this.jj_consume_token(36);
                                break;
                            }
                            default: {
                                this.jj_la1[412] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.processPackageComment(tokenIsAsUnder);
                    }
                    if (this.jj_2_83(3)) {
                        tokenIsAsUnder = this.jj_consume_token(375);
                        this.jj_consume_token(62);
                        this.jj_consume_token(5);
                        block58 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 124: 
                            case 206: 
                            case 220: 
                            case 279: 
                            case 281: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 124: {
                                        this.jj_consume_token(124);
                                        break block58;
                                    }
                                    case 220: {
                                        this.jj_consume_token(220);
                                        break block58;
                                    }
                                    case 206: {
                                        this.jj_consume_token(206);
                                        break block58;
                                    }
                                    case 279: {
                                        this.jj_consume_token(279);
                                        break block58;
                                    }
                                    case 281: {
                                        this.jj_consume_token(281);
                                        break block58;
                                    }
                                }
                                this.jj_la1[413] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[414] = this.jj_gen;
                            }
                        }
                        this.qualifiedName();
                        block127: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[415] = this.jj_gen;
                                    break block127;
                                }
                            }
                            this.jj_consume_token(6);
                            this.qualifiedName();
                        }
                        this.jj_consume_token(7);
                        this.processPackageComment(tokenIsAsUnder);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 150: {
                            tokenIsAsUnder = this.jj_consume_token(150);
                            break;
                        }
                        case 50: {
                            tokenIsAsUnder = this.jj_consume_token(50);
                            break;
                        }
                        default: {
                            this.jj_la1[416] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    tokenSpecificationForm = this.jj_consume_token(191);
                    if (this.m_out != null && nameSuperType != null) {
                        schemaSuperTypeString = nameSuperType.toString();
                        if (schemaSuperType != null) {
                            schemaSuperTypeString = schemaSuperType.toString() + "." + nameSuperType.toString();
                        }
                        this.m_out.pushAttribute("NAME", this.purifyIdentifier(schemaSuperTypeString));
                        this.m_out.startElement("SUPERTYPE");
                        this.m_out.startElement("RETURN");
                        this.m_out.pushAttribute("TYPE", this.purifyIdentifier(schemaSuperTypeString));
                        this.m_out.endElement("RETURN");
                        this.m_out.endElement("SUPERTYPE");
                    }
                    if (this.m_out != null && collectionType != null) {
                        schemaSuperTypeString = "";
                        this.m_out.pushAttribute("NAME", this.purifyIdentifier(baseType));
                        this.m_out.startElement("SUPERTYPE");
                        this.m_out.pushAttribute("TYPE", this.purifyIdentifier(collectionType + " OF " + baseType));
                        this.m_out.pushAttribute("NAME", "COLLECTION");
                        this.m_out.pushAttribute("COLLECTIONTYPE", this.purifyIdentifier(collectionType));
                        this.m_out.pushAttribute("SUPERTYPE", this.purifyIdentifier(baseType));
                        this.m_out.startElement("RETURN");
                        this.m_out.startElement("COMMENT");
                        this.m_out.cdata("Collection Type : " + collectionType + " OF " + baseType);
                        this.m_out.endElement("COMMENT");
                        this.m_out.endElement("RETURN");
                        this.m_out.endElement("SUPERTYPE");
                    }
                    this.processPackageComment(tokenIsAsUnder);
                    if (null != tokenSpecificationForm) {
                        this.processPackageComment(tokenSpecificationForm);
                    }
                    tokenIsAsUnder = this.jj_consume_token(5);
                    this.processPackageComment(tokenIsAsUnder);
                    if (this.jj_2_84(2)) {
                        this.typeMethod(isPackageLevel, typeVersion, tokenAlterTypeString, objectStart);
                    } else {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                this.attributeDeclaration(typeVersion, tokenAlterTypeString);
                                break;
                            }
                            default: {
                                this.jj_la1[417] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    block128: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                break;
                            }
                            default: {
                                this.jj_la1[418] = this.jj_gen;
                                ** GOTO lbl328
                            }
                        }
                        this.jj_consume_token(6);
                        if (this.jj_2_85(2)) {
                            this.typeMethod(isPackageLevel, typeVersion, tokenAlterTypeString, objectStart);
                            continue;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 123: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 127: 
                            case 129: 
                            case 130: 
                            case 131: 
                            case 132: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 140: 
                            case 141: 
                            case 142: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 150: 
                            case 151: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 169: 
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: 
                            case 174: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 182: 
                            case 183: 
                            case 184: 
                            case 185: 
                            case 186: 
                            case 187: 
                            case 188: 
                            case 189: 
                            case 190: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 232: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 257: 
                            case 258: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 274: 
                            case 275: 
                            case 276: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 323: 
                            case 324: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 364: 
                            case 365: 
                            case 366: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 379: 
                            case 380: 
                            case 381: 
                            case 382: 
                            case 383: 
                            case 384: 
                            case 385: 
                            case 386: 
                            case 387: 
                            case 388: 
                            case 389: 
                            case 390: 
                            case 391: 
                            case 392: 
                            case 393: 
                            case 394: 
                            case 395: 
                            case 396: 
                            case 397: 
                            case 398: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 405: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 413: 
                            case 414: 
                            case 415: 
                            case 423: 
                            case 431: 
                            case 432: 
                            case 433: 
                            case 434: 
                            case 435: {
                                this.attributeDeclaration(typeVersion, tokenAlterTypeString);
                                continue block128;
                            }
                        }
                        break;
                    }
                    this.jj_la1[419] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl328:
                    // 1 sources

                    this.jj_consume_token(7);
                    break;
                }
                default: {
                    this.jj_la1[420] = this.jj_gen;
                }
            }
            block129: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: 
                    case 143: 
                    case 181: 
                    case 183: {
                        break;
                    }
                    default: {
                        this.jj_la1[421] = this.jj_gen;
                        break block141;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: {
                        this.jj_consume_token(181);
                        break;
                    }
                    default: {
                        this.jj_la1[422] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 118: {
                        this.jj_consume_token(118);
                        continue block129;
                    }
                    case 143: {
                        this.jj_consume_token(143);
                        continue block129;
                    }
                    case 183: {
                        this.jj_consume_token(183);
                        continue block129;
                    }
                }
                break;
            }
            this.jj_la1[423] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block95 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: 
            case 149: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: {
                        this.jj_consume_token(149);
                        break block95;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        block130: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 81: 
                                case 139: 
                                case 181: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[424] = this.jj_gen;
                                    ** GOTO lbl410
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 139: 
                                case 181: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 181: {
                                            this.jj_consume_token(181);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[425] = this.jj_gen;
                                        }
                                    }
                                    this.jj_consume_token(139);
                                    this.jj_consume_token(268);
                                    this.jj_consume_token(86);
                                    continue block130;
                                }
                                case 81: {
                                    this.jj_consume_token(81);
                                    this.jj_consume_token(277);
                                    this.jj_consume_token(262);
                                    continue block130;
                                }
                            }
                            break;
                        }
                        this.jj_la1[426] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
lbl410:
                        // 1 sources

                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 108: 
                            case 122: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 122: {
                                        this.jj_consume_token(122);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[427] = this.jj_gen;
                                    }
                                }
                                this.jj_consume_token(108);
                                this.jj_consume_token(148);
                                exceptionsName = this.qualifiedName();
                                break block95;
                            }
                        }
                        this.jj_la1[428] = this.jj_gen;
                        break block95;
                    }
                }
                this.jj_la1[429] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[430] = this.jj_gen;
            }
        }
    }

    public final void attributeDeclaration(int typeVersion, String alterTypeAction) throws ParseException, SAXException {
        Token name = null;
        Hashtable tags = null;
        Hashtable<String, String> attributes = null;
        String elementName = "VARIABLE";
        name = this.ID();
        String type = this.datatype();
        if (this.m_out != null) {
            attributes = new Hashtable<String, String>();
            attributes.put("VERSION", Integer.toString(typeVersion));
            if (null != alterTypeAction) {
                attributes.put("ACTION", alterTypeAction);
            }
            tags = this.processMemberComment(name, elementName, name.toString(), attributes);
            this.m_out.pushAttribute("TYPE", this.purifyIdentifier(type));
            this.m_out.startElement("RETURN");
            this.m_out.endElement("RETURN");
            this.m_out.endElement(elementName);
        }
    }

    public final void attribute(int typeVersion, String alterTypeAction) throws ParseException, SAXException {
        Token name = null;
        Hashtable tags = null;
        String elementName = "VARIABLE";
        Hashtable<String, String> attributes = null;
        name = this.ID();
        if (this.m_out != null) {
            attributes = new Hashtable<String, String>();
            attributes.put("VERSION", Integer.toString(typeVersion));
            if (null != alterTypeAction) {
                attributes.put("ACTION", alterTypeAction);
            }
            tags = this.processMemberComment(name, elementName, name.toString(), attributes);
            this.m_out.pushAttribute("TYPE", "(dropped)");
            this.m_out.startElement("RETURN");
            this.m_out.endElement("RETURN");
            this.m_out.endElement(elementName);
        }
    }

    public final void pragma_clause() throws ParseException, SAXException {
        Object tags = null;
        Token start = this.jj_consume_token(215);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                Token name = this.jj_consume_token(38);
                break;
            }
            case 41: {
                Token name = this.jj_consume_token(41);
                break;
            }
            case 39: {
                Token name = this.jj_consume_token(39);
                this.jj_consume_token(5);
                Token functionName = this.ID();
                block21: while (true) {
                    this.jj_consume_token(6);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 173: 
                        case 174: 
                        case 176: 
                        case 177: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 208: 
                        case 209: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 232: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 257: 
                        case 258: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 270: 
                        case 271: 
                        case 272: 
                        case 273: 
                        case 274: 
                        case 275: 
                        case 276: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 323: 
                        case 324: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 364: 
                        case 365: 
                        case 366: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 376: 
                        case 377: 
                        case 378: 
                        case 379: 
                        case 380: 
                        case 381: 
                        case 382: 
                        case 383: 
                        case 384: 
                        case 385: 
                        case 386: 
                        case 387: 
                        case 388: 
                        case 389: 
                        case 390: 
                        case 391: 
                        case 392: 
                        case 393: 
                        case 394: 
                        case 395: 
                        case 396: 
                        case 397: 
                        case 398: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 423: 
                        case 431: 
                        case 432: 
                        case 433: 
                        case 434: 
                        case 435: {
                            this.ID();
                            break;
                        }
                        case 429: {
                            this.StringLiteral();
                            break;
                        }
                        default: {
                            this.jj_la1[431] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            continue block21;
                        }
                    }
                    break;
                }
                this.jj_la1[432] = this.jj_gen;
                this.jj_consume_token(7);
                break;
            }
            case 40: {
                Token name = this.jj_consume_token(40);
                this.jj_consume_token(5);
                Token exceptionName = this.jj_consume_token(423);
                this.jj_consume_token(6);
                block14 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 18: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: {
                                this.jj_consume_token(18);
                                break block14;
                            }
                            case 9: {
                                this.jj_consume_token(9);
                                break block14;
                            }
                        }
                        this.jj_la1[433] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[434] = this.jj_gen;
                    }
                }
                Token errorNumber = this.numericLiteral();
                this.jj_consume_token(7);
                break;
            }
            case 145: {
                Token name = this.jj_consume_token(145);
                this.jj_consume_token(5);
                this.jj_consume_token(423);
                this.jj_consume_token(6);
                this.jj_consume_token(423);
                this.jj_consume_token(6);
                this.numericLiteral();
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[435] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void triggerUnit() throws ParseException, SAXException {
        String tableName;
        String triggerName;
        String triggerLevel;
        String triggerType;
        Hashtable tags;
        StringBuffer declaration;
        Token nested_table_column;
        Token dec_end;
        Token dec_start;
        Token table;
        Token name;
        Token schema;
        Token node;
        Token start;
        block135: {
            start = null;
            node = null;
            schema = null;
            name = null;
            table = null;
            dec_start = null;
            dec_end = null;
            nested_table_column = null;
            declaration = new StringBuffer();
            tags = new Hashtable();
            triggerType = "SIMPLE";
            triggerLevel = "TABLE";
            triggerName = null;
            tableName = null;
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    start = this.jj_consume_token(82);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 200: {
                            this.jj_consume_token(200);
                            this.jj_consume_token(35);
                            break;
                        }
                        default: {
                            this.jj_la1[436] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 99: 
                        case 180: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 99: {
                                    this.jj_consume_token(99);
                                    break block0;
                                }
                                case 180: {
                                    this.jj_consume_token(180);
                                    break block0;
                                }
                            }
                            this.jj_la1[437] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[438] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[439] = this.jj_gen;
                }
            }
            node = this.jj_consume_token(279);
            if (this.jj_2_86(2)) {
                schema = this.ID();
                this.jj_consume_token(3);
            }
            name = this.ID();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 319: {
                    dec_start = this.jj_consume_token(319);
                    break;
                }
                case 318: {
                    dec_start = this.jj_consume_token(318);
                    break;
                }
                case 320: {
                    dec_start = this.jj_consume_token(320);
                    break;
                }
                case 120: {
                    dec_start = this.jj_consume_token(120);
                    triggerType = "COMPOUND";
                    break;
                }
                default: {
                    this.jj_la1[440] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 92: 
                case 142: 
                case 294: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 92: {
                            this.jj_consume_token(92);
                            break;
                        }
                        case 142: {
                            this.jj_consume_token(142);
                            break;
                        }
                        case 294: {
                            this.jj_consume_token(294);
                            break;
                        }
                        default: {
                            this.jj_la1[441] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (!this.jj_2_87(6)) break;
                    this.jj_consume_token(193);
                    this.ID();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                break;
                            }
                            default: {
                                this.jj_la1[442] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(6);
                        this.ID();
                    }
                }
                case 46: 
                case 74: 
                case 82: 
                case 98: 
                case 128: 
                case 230: 
                case 237: 
                case 341: 
                case 342: 
                case 343: 
                case 347: 
                case 348: 
                case 351: 
                case 352: 
                case 354: 
                case 356: 
                case 357: 
                case 358: 
                case 361: 
                case 362: {
                    this.non_dml_event();
                    triggerType = "NONDML";
                    break;
                }
                default: {
                    this.jj_la1[443] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block114: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 200: {
                        break;
                    }
                    default: {
                        this.jj_la1[444] = this.jj_gen;
                        break block135;
                    }
                }
                this.jj_consume_token(200);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 92: 
                    case 142: 
                    case 294: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 92: {
                                this.jj_consume_token(92);
                                break;
                            }
                            case 142: {
                                this.jj_consume_token(142);
                                break;
                            }
                            case 294: {
                                this.jj_consume_token(294);
                                break;
                            }
                            default: {
                                this.jj_la1[445] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (!this.jj_2_88(6)) continue block114;
                        this.jj_consume_token(193);
                        this.ID();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[446] = this.jj_gen;
                                    continue block114;
                                }
                            }
                            this.jj_consume_token(6);
                            this.ID();
                        }
                    }
                    case 46: 
                    case 74: 
                    case 82: 
                    case 98: 
                    case 128: 
                    case 230: 
                    case 237: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 347: 
                    case 348: 
                    case 351: 
                    case 352: 
                    case 354: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 361: 
                    case 362: {
                        this.non_dml_event();
                        continue block114;
                    }
                }
                break;
            }
            this.jj_la1[447] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        dec_end = this.jj_consume_token(195);
        block46 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 345: {
                schema = this.jj_consume_token(345);
                break;
            }
            default: {
                this.jj_la1[448] = this.jj_gen;
                if (this.jj_2_91(2)) {
                    this.jj_consume_token(353);
                    this.jj_consume_token(268);
                    nested_table_column = this.ID();
                    this.jj_consume_token(193);
                    if (this.jj_2_89(2)) {
                        schema = this.ID();
                        this.jj_consume_token(3);
                    }
                    table = this.ID();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 232: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 257: 
                    case 258: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 262: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 323: 
                    case 324: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 346: 
                    case 347: 
                    case 348: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 381: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 386: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 414: 
                    case 415: 
                    case 423: 
                    case 431: 
                    case 432: 
                    case 433: 
                    case 434: 
                    case 435: {
                        if (this.jj_2_90(2)) {
                            schema = this.ID();
                            this.jj_consume_token(3);
                        }
                        table = this.ID();
                        break block46;
                    }
                }
                this.jj_la1[449] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token runner = dec_start;
        while (runner != dec_end) {
            declaration.append(runner.image);
            declaration.append(" ");
            runner = runner.next;
        }
        if (this.m_out != null) {
            String fullname;
            String packageString = this.globalPackageName;
            String schemaString = this.schemaName;
            if (null != schema && schema.image.toUpperCase().equals("DATABASE")) {
                fullname = this.purifyIdentifier(schema.toString() + "." + name.toString());
                triggerLevel = "DATABASE";
                triggerName = name.toString();
            } else if (null != table && table.image.toUpperCase().equals("SCHEMA")) {
                fullname = this.purifyIdentifier(schema.toString() + "." + name.toString());
                triggerLevel = "SCHEMA";
                triggerName = name.toString();
            } else {
                fullname = this.purifyIdentifier(table.toString() + "." + name.toString());
                triggerLevel = "TABLE";
                triggerName = name.toString();
                tableName = table.toString();
            }
            if (null != schema) {
                schemaString = schema.toString();
                packageString = "_" + schemaString;
            }
            this.m_out.pushAttribute("NAME", this.purifyIdentifier(packageString));
            this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString));
            this.m_out.startElement("PACKAGE");
            this.m_out.pushAttribute("SCHEMA", this.purifyIdentifier(schemaString));
            this.m_out.pushAttribute("TYPE", this.purifyKeyword(triggerType));
            this.m_out.pushAttribute("LEVEL", this.purifyKeyword(triggerLevel));
            if (null != tableName) {
                this.m_out.pushAttribute("TABLE_NAME", this.purifyKeyword(tableName));
            }
            tags = this.processMemberComment(start, this.purifyKeyword(node.toString()), triggerName);
            tags.putAll(this.processMemberComment(node, null, null));
            tags.putAll(this.processMemberComment(name, null, null));
            tags.putAll(this.processMemberComment(dec_start, null, null));
            this.m_out.pushAttribute("TEXT", declaration.toString());
            this.m_out.startElement("DECLARATION");
            this.m_out.endElement("DECLARATION");
     