/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.pldoc.PLDoc;
import net.sourceforge.pldoc.Settings;
import net.sourceforge.pldoc.Utils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class PLDocTask
extends Task {
    private Settings settings;
    private boolean m_verbose = false;
    private File m_destdir = null;
    private String m_doctitle = null;
    private String m_stylesheet = null;
    private File m_overviewFile = null;
    private ArrayList m_filesets = new ArrayList();
    private char m_namesCase = (char)68;
    private String m_inEnc = null;
    private boolean m_exitOnError = false;
    private String m_dbUrl = null;
    private String m_dbUser = null;
    private String m_dbPassword = null;
    private String m_inputTypes = null;
    private String m_inputObjects = null;
    private boolean m_ignoreInformalComments = false;
    private boolean m_showSkippedPackages = false;
    private boolean m_plscope = false;
    private String m_driverName = null;
    private String m_getMetadataStatement = null;
    private Integer m_getMetadataStatementReturnType = null;
    private boolean m_savesourcecode = false;
    private String m_sourcestylesheet = null;

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setDestdir(File dir) {
        this.m_destdir = dir;
    }

    public void setDoctitle(String doctitle) {
        this.m_doctitle = doctitle;
    }

    public void setStylesheet(String stylesheet) {
        this.m_stylesheet = stylesheet;
    }

    public void setSourceStylesheet(String sourcestylesheet) {
        this.m_sourcestylesheet = sourcestylesheet;
    }

    public void setOverview(File file) {
        this.m_overviewFile = file;
    }

    public void addFileset(FileSet fset) {
        this.m_filesets.add(fset);
    }

    public void setInputEncoding(String enc) {
        this.m_inEnc = enc;
    }

    public void setExitOnError(boolean exitOnError) {
        this.m_exitOnError = exitOnError;
    }

    public void setDbUrl(String dbUrl) {
        this.m_dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.m_dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.m_dbPassword = dbPassword;
    }

    public void setInputObjects(String inputObjects) {
        this.m_inputObjects = inputObjects;
    }

    public void setInputTypes(String inputTypes) {
        this.m_inputTypes = inputTypes;
    }

    public void setShowSkippedPackages(boolean showSkippedPackages) {
        this.m_showSkippedPackages = showSkippedPackages;
    }

    public void setPlscope(boolean plscope) {
        this.m_plscope = plscope;
    }

    public void setSaveSourceCode(boolean savesourcecode) {
        this.m_savesourcecode = savesourcecode;
    }

    public void setIgnoreInformalComments(boolean ignoreInformalComments) {
        this.m_ignoreInformalComments = ignoreInformalComments;
    }

    public void setDriverName(String driverName) {
        this.m_driverName = driverName;
    }

    public void setGetMetadataStatement(String getMetadataStatement) {
        this.m_getMetadataStatement = getMetadataStatement;
    }

    public void setReturnType(Integer getMetadataStatementReturnType) {
        this.m_getMetadataStatementReturnType = getMetadataStatementReturnType;
    }

    public void setNamesCase(NamesCase namesCase) {
        this.m_namesCase = Character.toUpperCase(namesCase.getValue().charAt(0));
    }

    public void execute() throws BuildException {
        if (this.m_destdir == null) {
            throw new BuildException("Property \"destdir\" (destination directory) MUST be specified");
        }
        if (this.m_doctitle == null) {
            this.m_doctitle = "PL/SQL";
        }
        if (this.m_inEnc == null) {
            this.m_inEnc = System.getProperty("file.encoding");
        }
        try {
            this.settings = new Settings();
            this.settings.setOutputDirectory(this.m_destdir);
            this.settings.setApplicationName(this.m_doctitle);
            if (null != this.m_stylesheet) {
                this.settings.setStylesheetfile(this.m_stylesheet);
            }
            if (null != this.m_sourcestylesheet) {
                this.settings.setSourceStylesheetfile(this.m_sourcestylesheet);
            }
            if (null != this.m_overviewFile) {
                this.settings.setOverviewfile(this.m_overviewFile);
            }
            switch (this.m_namesCase) {
                case 'U': {
                    this.settings.setDefaultNamescase("upper");
                    this.settings.setNamesLowercase(false);
                    this.settings.setNamesUppercase(true);
                    this.settings.setNamesDefaultcase(true);
                    break;
                }
                case 'L': {
                    this.settings.setDefaultNamescase("lower");
                    this.settings.setNamesLowercase(true);
                    this.settings.setNamesUppercase(false);
                    this.settings.setNamesDefaultcase(true);
                    break;
                }
                case 'M': {
                    this.settings.setDefaultNamescase("mixed");
                    this.settings.setNamesLowercase(false);
                    this.settings.setNamesUppercase(false);
                    this.settings.setNamesDefaultcase(true);
                    break;
                }
                case 'D': {
                    this.settings.setDefaultNamescase("upper");
                    this.settings.setNamesLowercase(false);
                    this.settings.setNamesUppercase(false);
                    this.settings.setNamesDefaultcase(true);
                }
            }
            this.settings.setInputEncoding(this.m_inEnc);
            this.settings.setExitOnError(this.m_exitOnError);
            this.settings.setDbUrl(this.m_dbUrl);
            this.settings.setDbUser(this.m_dbUser);
            this.settings.setDbPassword(this.m_dbPassword);
            this.settings.setInputTypes(null == this.m_inputTypes ? new ArrayList() : Arrays.asList(this.m_inputTypes.split(",")));
            this.settings.setInputObjects(null == this.m_inputObjects ? new ArrayList() : Arrays.asList(this.m_inputObjects.split(",")));
            this.settings.setShowSkippedPackages(this.m_showSkippedPackages);
            this.settings.setPlscope(this.m_plscope);
            this.settings.setSaveSourceCode(this.m_savesourcecode);
            this.settings.setIgnoreInformalComments(this.m_ignoreInformalComments);
            if (null != this.m_driverName) {
                this.settings.setDriverName(this.m_driverName);
            }
            if (null != this.m_getMetadataStatement) {
                this.settings.setGetMetadataStatement(this.m_getMetadataStatement);
            }
            if (null != this.m_getMetadataStatementReturnType) {
                this.settings.setReturnType(this.m_getMetadataStatementReturnType);
            }
            ArrayList<String> inputPaths = new ArrayList<String>();
            for (int fsetI = 0; fsetI < this.m_filesets.size(); ++fsetI) {
                FileSet fset = (FileSet)this.m_filesets.get(fsetI);
                DirectoryScanner dirScan = fset.getDirectoryScanner(this.getProject());
                File srcDir = fset.getDir(this.getProject());
                String[] srcFiles = dirScan.getIncludedFiles();
                for (int fileI = 0; fileI < srcFiles.length; ++fileI) {
                    File inputFile = new File(srcDir, srcFiles[fileI]);
                    inputPaths.add(inputFile.getCanonicalPath());
                }
            }
            this.settings.setInputFiles(inputPaths);
            inputPaths = null;
            Collection inputFiles = this.settings.getInputFiles();
            Collection inputTypes = this.settings.getInputTypes();
            Collection inputObjects = this.settings.getInputObjects();
            if (inputFiles.isEmpty() && inputObjects.isEmpty() || !inputFiles.isEmpty() && !inputObjects.isEmpty()) {
                throw new BuildException("You must specify input file name(s) or object name(s)!");
            }
            if (!(inputObjects.isEmpty() || this.settings.getDbUrl() != null && this.settings.getDbUser() != null && this.settings.getDbPassword() != null)) {
                throw new BuildException("Database url, db schema and db password are mandatory when object name(s) are supplied!");
            }
            PLDoc pldoc = new PLDoc(this.settings);
            try {
                pldoc.run();
            }
            catch (Exception e) {
                throw new BuildException(e);
            }
        }
        catch (IOException ioEx) {
            throw new BuildException(ioEx);
        }
        catch (Exception otherEx) {
            throw new BuildException(otherEx);
        }
        this.m_verbose = false;
        this.m_destdir = null;
        this.m_doctitle = null;
        this.m_overviewFile = null;
        this.m_stylesheet = null;
        this.m_sourcestylesheet = null;
        this.m_namesCase = (char)48;
        this.m_inEnc = null;
        this.m_dbUrl = null;
        this.m_dbUser = null;
        this.m_dbPassword = null;
        this.m_inputTypes = null;
        this.m_inputObjects = null;
        this.m_showSkippedPackages = false;
        this.m_plscope = false;
        this.m_savesourcecode = false;
        this.m_ignoreInformalComments = false;
    }

    private BufferedReader getInputReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader(Utils.getBOMInputStream(new FileInputStream(file), this.m_inEnc), this.m_inEnc));
    }

    public static class NamesCase
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"upper", "lower", "mixed", "default"};
        }
    }
}

