/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.pldoc.DbmsMetadata;
import net.sourceforge.pldoc.ResourceLoader;
import net.sourceforge.pldoc.ResourceResolver;
import net.sourceforge.pldoc.Settings;
import net.sourceforge.pldoc.SourceCodeScraper;
import net.sourceforge.pldoc.SubstitutionReader;
import net.sourceforge.pldoc.Utils;
import net.sourceforge.pldoc.Version;
import net.sourceforge.pldoc.XMLWriter;
import net.sourceforge.pldoc.parser.PLSQLParser;
import net.sourceforge.pldoc.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLDoc {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static String programName = "PLDoc version: " + Version.id();
    private static HashMap hashMap = new HashMap();
    private static HashMap fileSuffixMap;
    private static HashMap<String, HashMap<String, String>> plscopeQueriesMap;
    public static final ResourceResolver resResolver;
    public static final ResourceLoader resLoader;
    private HashMap plscopeQueries = plscopeQueriesMap.get("DEFAULT");
    public Settings settings;

    public PLDoc(Settings settings) {
        this.settings = settings;
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("");
        System.out.println(programName);
        Settings settings = new Settings();
        settings.processCommandString(args);
        PLDoc pldoc = new PLDoc(settings);
        try {
            pldoc.run();
        }
        catch (SystemExitException e) {
            System.exit(-1);
        }
        long finishTime = System.currentTimeMillis();
        System.out.println("Done (" + (double)(finishTime - startTime) / 1000.0 + " seconds).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        long startTime = System.currentTimeMillis();
        HashMap<String, Integer> objectSchemas = new HashMap<String, Integer>();
        TreeMap<String, Throwable> skippedPackages = new TreeMap<String, Throwable>();
        File synonymsFile = new File(this.settings.getOutputDirectory(), "synonyms.xml");
        String synonymStatement = "SELECT owner, synonym_name, table_owner, table_name FROM dba_synonyms WHERE owner IN (?) AND   table_owner NOT in ('SYS','SYSTEM') ORDER BY  table_owner, table_name";
        long processedPackages = 0L;
        Connection conn = null;
        Statement pstmt = null;
        File outputDirectory = this.settings.getOutputDirectory();
        if (!this.settings.getOutputDirectory().exists()) {
            System.out.println("Directory \"" + this.settings.getOutputDirectory() + "\" does not exist, creating ...");
            this.settings.getOutputDirectory().mkdir();
        }
        File applicationFile = new File(this.settings.getOutputDirectory().getPath() + File.separator + "application.xml");
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(applicationFile);
            XMLWriter xmlOut = new XMLWriter(output);
            xmlOut.setMethod("xml");
            if (this.settings.getOutputEncoding() != null) {
                xmlOut.setEncoding(this.settings.getOutputEncoding());
            }
            xmlOut.setIndent(true);
            xmlOut.setDocType(null, "application.dtd");
            xmlOut.startDocument();
            xmlOut.pushAttribute("NAME", this.settings.getApplicationName());
            xmlOut.startElement("APPLICATION");
            if (this.settings.getOverviewFile() != null) {
                xmlOut.startElement("OVERVIEW");
                xmlOut.cdata(this.getOverviewFileContent(this.settings.getOverviewFile()));
                xmlOut.endElement("OVERVIEW");
            }
            Iterator it = this.settings.getInputFiles().iterator();
            while (it.hasNext()) {
                String inputFileName;
                String packagename = inputFileName = (String)it.next();
                if (this.settings.isVerbose()) {
                    System.out.println("Parsing file " + inputFileName + " ...");
                }
                try {
                    Throwable throwable;
                    String schemaName = this.settings.getDbUser();
                    InputStreamReader inputStreamReader = new InputStreamReader(Utils.getBOMInputStream(new FileInputStream(inputFileName), this.settings.getInputEncoding()), this.settings.getInputEncoding());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    if (this.settings.isVerbose()) {
                        System.out.println("Processing : " + inputFileName + " as inputEncoding=\"" + this.settings.getInputEncoding() + "\" via inputStreamReader encoding=\"" + inputStreamReader.getEncoding() + "\"");
                    }
                    if ((throwable = this.processPackage(bufferedReader, xmlOut, packagename, null == schemaName || schemaName.equals("") ? "" : schemaName, null == schemaName || schemaName.equals("") ? "_GLOBAL" : "_" + schemaName)) == null) {
                        ++processedPackages;
                        continue;
                    }
                    skippedPackages.put(packagename, throwable);
                }
                catch (FileNotFoundException e) {
                    System.err.println("File not found: " + inputFileName);
                    throw new SystemExitException(e);
                }
            }
            if (this.settings.getDbUrl() != null && this.settings.getDbUser() != null && this.settings.getDbPassword() != null) {
                Class.forName(this.settings.getDriverName());
                try {
                    String typeList = "";
                    Collection inputTypes = this.settings.getInputTypes();
                    if (null != inputTypes && !inputTypes.isEmpty()) {
                        for (String inputType : inputTypes) {
                            typeList = typeList + (0 == typeList.length() ? "" : ",") + "'" + inputType.toUpperCase() + "'";
                        }
                    }
                    if (typeList.equals("")) {
                        typeList = "'PACKAGE','TYPE','PROCEDURE','FUNCTION','TRIGGER','TABLE','VIEW'";
                    }
                    String sqlStatement = "SELECT  object_name, object_type FROM dba_objects WHERE owner = ? AND   object_name LIKE ? AND  object_type in (" + typeList + ")" + " ORDER BY " + " object_name";
                    if (this.settings.isVerbose()) {
                        System.out.println("Using \"" + sqlStatement + "\"");
                    }
                    if (this.settings.isVerbose()) {
                        System.out.println("Connecting ..");
                    }
                    conn = DriverManager.getConnection(this.settings.getDbUrl(), this.settings.getDbUser(), this.settings.getDbPassword());
                    if (this.settings.isVerbose()) {
                        System.out.println("Connected");
                    }
                    boolean dictionaryViewsHaveReverted = false;
                    pstmt = conn.prepareStatement(sqlStatement);
                    DbmsMetadata dbmsMetadata = new DbmsMetadata(conn, this.settings.getGetMetadataStatement(), this.settings.getReturnType());
                    it = this.settings.getInputObjects().iterator();
                    while (it.hasNext()) {
                        String[] input = ((String)it.next()).split("\\.");
                        if (input.length == 0 || input.length > 2) continue;
                        String inputSchemaName = input.length == 2 ? input[0] : this.settings.getDbUser();
                        String inputObjectName = input.length == 2 ? input[1] : input[0];
                        ResultSet rset = null;
                        try {
                            pstmt.setString(1, inputSchemaName);
                            pstmt.setString(2, inputObjectName);
                            try {
                                rset = pstmt.executeQuery();
                            }
                            catch (Exception e) {
                                if (dictionaryViewsHaveReverted) {
                                    throw e;
                                }
                                dictionaryViewsHaveReverted = true;
                                sqlStatement = sqlStatement.replaceFirst(" dba_", " all_");
                                this.plscopeQueries = plscopeQueriesMap.get("ALL_");
                                if (this.settings.isVerbose()) {
                                    System.out.println("Reverting to \"" + sqlStatement + "\"");
                                }
                                pstmt = conn.prepareStatement(sqlStatement);
                                pstmt.setString(1, inputSchemaName);
                                pstmt.setString(2, inputObjectName);
                                rset = pstmt.executeQuery();
                            }
                            if (!rset.next()) {
                                System.err.println("Object(s) like " + inputSchemaName + "." + inputObjectName + " do not exist or " + this.settings.getDbUser() + " does not have enough permissions (SELECT_CATALOG_ROLE role).");
                                continue;
                            }
                            if (!objectSchemas.containsKey(inputSchemaName)) {
                                objectSchemas.put(inputSchemaName, 0);
                            } else {
                                int schemaReferences = (Integer)objectSchemas.get(inputSchemaName);
                                objectSchemas.put(inputSchemaName, schemaReferences++);
                            }
                            do {
                                String dbmsMetadataObjectType;
                                String packagename = inputSchemaName + "." + rset.getString(1);
                                String objectType = rset.getString(2);
                                String string = dbmsMetadataObjectType = hashMap.containsKey(rset.getString(2)) ? (String)hashMap.get(objectType) : objectType;
                                if (this.settings.isVerbose()) {
                                    System.out.println("Parsing " + objectType + " name " + packagename + " ...");
                                }
                                if (this.settings.isVerbose()) {
                                    System.err.println("Extracting DBMS_METADATA DDL for (object_type,object_name,schema)=(" + dbmsMetadataObjectType + "," + rset.getString(1) + "," + inputSchemaName + ") ...");
                                }
                                File savedSchemaDirectory = new File(this.settings.getOutputDirectory(), inputSchemaName);
                                if (this.settings.isSaveSourceCode() && !savedSchemaDirectory.exists()) {
                                    savedSchemaDirectory.mkdir();
                                }
                                File savedObjectTypeDirectory = new File(savedSchemaDirectory, objectType.replace(' ', '_'));
                                if (this.settings.isSaveSourceCode()) {
                                    if (!savedObjectTypeDirectory.exists()) {
                                        savedObjectTypeDirectory.mkdir();
                                        Utils.copyStaticSourceDirectoryFiles(savedObjectTypeDirectory, "../../");
                                    } else if (startTime > savedObjectTypeDirectory.lastModified()) {
                                        Utils.copyStaticSourceDirectoryFiles(savedObjectTypeDirectory, "../../");
                                        if (this.settings.isVerbose()) {
                                            System.err.println("Refreshed static files in " + savedObjectTypeDirectory.getCanonicalPath());
                                        }
                                    }
                                }
                                File savedSourceFile = new File(savedObjectTypeDirectory, rset.getString(1).replace(' ', '_') + "." + fileSuffixMap.get(rset.getString(2)) + ".xml");
                                OutputStreamWriter savedSourceFileWriter = null;
                                BufferedReader bufferedReader = null;
                                try {
                                    if (this.settings.isSaveSourceCode()) {
                                        if (this.settings.isVerbose()) {
                                            System.err.println("Saving DDL for (object_type,object_name,schema)=(" + dbmsMetadataObjectType + "," + rset.getString(1) + "," + inputSchemaName + ") to " + savedSourceFile.getCanonicalPath());
                                        }
                                        savedSourceFileWriter = new FileWriter(savedSourceFile);
                                        bufferedReader = new BufferedReader(new SourceCodeScraper(dbmsMetadata.getDdl(dbmsMetadataObjectType, rset.getString(1), inputSchemaName, "COMPATIBLE", "ORACLE", "DDL"), (Writer)savedSourceFileWriter, false, "sourcecode.xsl"));
                                    } else {
                                        bufferedReader = new BufferedReader(dbmsMetadata.getDdl(dbmsMetadataObjectType, rset.getString(1), inputSchemaName, "COMPATIBLE", "ORACLE", "DDL"));
                                    }
                                    Throwable throwable = this.processPackage(bufferedReader, xmlOut, packagename, inputSchemaName, "_" + inputSchemaName);
                                    if (throwable == null) {
                                        ++processedPackages;
                                        continue;
                                    }
                                    skippedPackages.put(packagename, throwable);
                                }
                                catch (SQLException sqlE) {
                                    sqlE.printStackTrace(System.err);
                                    skippedPackages.put(packagename, sqlE);
                                }
                                finally {
                                    if (null != bufferedReader) {
                                        bufferedReader.close();
                                        bufferedReader = null;
                                    }
                                    if (null != savedSourceFileWriter) {
                                        savedSourceFileWriter.flush();
                                        savedSourceFileWriter.close();
                                        savedSourceFileWriter = null;
                                    }
                                }
                            } while (rset.next());
                        }
                        finally {
                            if (rset == null) continue;
                            rset.close();
                        }
                    }
                }
                finally {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
            }
            xmlOut.startElement("GENERATOR");
            xmlOut.startElement("OBJECTS");
            xmlOut.pushAttribute("COUNT", String.valueOf(processedPackages));
            xmlOut.startElement("PROCESSED");
            xmlOut.endElement("PROCESSED");
            xmlOut.pushAttribute("COUNT", String.valueOf(skippedPackages.size()));
            xmlOut.startElement("SKIPPED");
            if (this.settings.isShowSkippedPackages()) {
                for (String packagename : skippedPackages.keySet()) {
                    String error = ((Throwable)skippedPackages.get(packagename)).getLocalizedMessage();
                    xmlOut.pushAttribute("ERROR", error);
                    xmlOut.pushAttribute("NAME", packagename);
                    xmlOut.startElement("OBJECT");
                    xmlOut.endElement("OBJECT");
                }
            }
            xmlOut.endElement("SKIPPED");
            xmlOut.endElement("OBJECTS");
            Date date = new Date();
            String creationdate = DateFormat.getDateInstance(3).format(date);
            String creationtime = DateFormat.getTimeInstance(3).format(date);
            xmlOut.pushAttribute("DATE", creationdate);
            xmlOut.pushAttribute("TIME", creationtime);
            xmlOut.startElement("CREATED");
            xmlOut.endElement("CREATED");
            xmlOut.pushAttribute("VERBOSE", this.settings.isVerbose() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("SHOW_SKIPPED_PACKAGES", this.settings.isShowSkippedPackages() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("IGNORE_INFORMAL_COMMENTS", this.settings.isIgnoreInformalComments() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("INPUT_ENCODING", this.settings.getInputEncoding());
            xmlOut.pushAttribute("DEFAULT_NAMES_CASE", this.settings.getDefaultNamescase().toUpperCase());
            xmlOut.pushAttribute("DEFAULT_KEYWORDS_CASE", this.settings.getDefaultKeywordscase().toUpperCase());
            xmlOut.pushAttribute("NAMES_TO_DEFAULT_CASE", this.settings.isNamesDefaultcase() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("NAMES_TO_UPPER_CASE", this.settings.isNamesUppercase() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("NAMES_TO_LOWER_CASE", this.settings.isNamesLowercase() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("KEYWORDS_TO_DEFAULT_CASE", this.settings.isKeywordsDefaultcase() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("KEYWORDS_TO_UPPER_CASE", this.settings.isKeywordsUppercase() ? "TRUE" : "FALSE");
            xmlOut.pushAttribute("KEYWORDS_TO_LOWER_CASE", this.settings.isKeywordsLowercase() ? "TRUE" : "FALSE");
            xmlOut.startElement("SETTINGS");
            xmlOut.endElement("SETTINGS");
            xmlOut.endElement("GENERATOR");
            xmlOut.endElement("APPLICATION");
            this.collapseSimilarNodes(xmlOut.getDocument(), "PACKAGE", new String[]{"SCHEMA", "NAME"});
            xmlOut.endDocument();
        }
        catch (FileNotFoundException e) {
            System.err.println("File cannot be created: " + applicationFile);
            e.printStackTrace();
            throw new SystemExitException();
        }
        finally {
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
        this.copyStaticFiles(this.settings.getOutputDirectory());
        if (conn != null) {
            this.extractSynonyms(conn, synonymStatement, objectSchemas, synonymsFile);
        }
        if (conn != null && this.settings.isPlscope()) {
            try {
                File mergedFile = new File(this.settings.getOutputDirectory(), "application-plscope.xml");
                this.extractPLscope(conn, this.plscopeQueries, applicationFile, mergedFile);
                applicationFile = mergedFile;
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        this.generateHtml(applicationFile, synonymsFile);
        if (!skippedPackages.isEmpty()) {
            System.err.println("Following packages were skipped due to errors:");
            Iterator iter = skippedPackages.keySet().iterator();
            while (iter.hasNext()) {
                String packagename = (String)iter.next();
                System.err.print(packagename);
                if (!iter.hasNext()) continue;
                System.err.print(", ");
            }
            System.err.println();
            System.err.println(skippedPackages.size() + " packages skipped!");
        }
        System.out.println("" + processedPackages + " packages processed successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultSetToXml(ResultSet resultSet, OutputStream outputStream, String documentRootName, String rowElementName, String dtd) throws Exception {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            XMLWriter xmlOut = new XMLWriter(outputStream);
            xmlOut.setMethod("xml");
            if (this.settings.getOutputEncoding() != null) {
                xmlOut.setEncoding(this.settings.getOutputEncoding());
            }
            xmlOut.setIndent(true);
            if (null != dtd && !dtd.equals("")) {
                xmlOut.setDocType(null, dtd);
            }
            xmlOut.startDocument();
            xmlOut.startElement(documentRootName);
            int numberOfColumns = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                for (int i = 1; i <= numberOfColumns; ++i) {
                    xmlOut.pushAttribute(resultSetMetaData.getColumnName(i), resultSet.getString(i));
                }
                xmlOut.startElement(rowElementName);
                xmlOut.endElement(rowElementName);
            }
            xmlOut.endElement(documentRootName);
            xmlOut.endDocument();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable processPackage(BufferedReader packageSpec, XMLWriter xmlOut, String pPackageName, String pSchemaName, String pGlobalPackageName) throws SystemExitException {
        Throwable result = null;
        SubstitutionReader input = null;
        try {
            input = new SubstitutionReader(packageSpec, this.settings.getDefines());
            PLSQLParser parser = new PLSQLParser(input);
            XMLWriter outXML = new XMLWriter();
            outXML.startDocument();
            outXML.startElement("FILE");
            parser.setXMLWriter(outXML);
            parser.setIgnoreInformalComments(this.settings.isIgnoreInformalComments());
            parser.setDefaultNamescase(this.settings.getDefaultNamescase());
            parser.setDefaultKeywordscase(this.settings.getDefaultKeywordscase());
            parser.setNamesDefaultcase(this.settings.isNamesDefaultcase());
            parser.setNamesUppercase(this.settings.isNamesUppercase());
            parser.setNamesLowercase(this.settings.isNamesLowercase());
            parser.setKeywordsDefaultcase(this.settings.isKeywordsDefaultcase());
            parser.setKeywordsUppercase(this.settings.isKeywordsUppercase());
            parser.setKeywordsLowercase(this.settings.isKeywordsLowercase());
            if (null != pSchemaName) {
                parser.setSchemaName(pSchemaName);
            }
            if (null != pGlobalPackageName) {
                parser.setGlobalPackageName(pGlobalPackageName);
            }
            parser.input();
            outXML.endElement("FILE");
            outXML.endDocument();
            xmlOut.appendNodeChildren(outXML.getDocument().getDocumentElement());
        }
        catch (ParseException e) {
            System.err.println("ParseException at package <" + pPackageName + ">: " + e);
            System.err.println("Last consumed token: \"" + e.currentToken + "\"");
            e.printStackTrace(System.err);
            if (this.settings.isExitOnError()) {
                throw new SystemExitException(e);
            }
            System.err.println("Package " + pPackageName + " skipped.");
            result = e;
        }
        catch (Throwable t) {
            System.err.println("Throwable at package <" + pPackageName + ">: " + t);
            t.printStackTrace(System.err);
            if (this.settings.isExitOnError()) {
                throw new SystemExitException(t);
            }
            System.err.println("Package " + pPackageName + " skipped.");
            result = t;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioe) {
                System.err.println("Can't close input stream! Ignored!");
                System.err.println("IOException: " + ioe);
            }
        }
        return result;
    }

    public static InputStream getResourceStream(String path) throws IOException {
        return resLoader.getResourceStream(path);
    }

    public static URIResolver getResourceResolver() {
        return resResolver;
    }

    private String getOverviewFileContent(File overviewFile) throws IOException {
        int end;
        StringBuffer overview = new StringBuffer("");
        try {
            BufferedReader overviewReader = new BufferedReader(new InputStreamReader(Utils.getBOMInputStream(new FileInputStream(this.settings.getOverviewFile()), this.settings.getInputEncoding()), this.settings.getInputEncoding()));
            String line = null;
            while ((line = overviewReader.readLine()) != null) {
                overview.append(line);
                overview.append(lineSeparator);
            }
            overviewReader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + this.settings.getOverviewFile());
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.toString());
        }
        int start = overview.toString().toUpperCase().lastIndexOf("<BODY>");
        if (start != -1) {
            overview.delete(0, start + 6);
        }
        if ((end = overview.toString().toUpperCase().indexOf("</BODY>")) != -1) {
            overview.delete(end, overview.length());
        }
        return overview.toString();
    }

    private String getStringFromInputStream(InputStream inputStream) throws IOException {
        byte[] inputBuffer = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer(1024);
        while (inputStream.available() > 0) {
            int bytesRead = inputStream.read(inputBuffer);
            stringBuffer.append(new String(inputBuffer, 0, bytesRead));
        }
        if (this.settings.isVerbose()) {
            System.out.println("String derived from inputStream: \"" + stringBuffer + "\"");
        }
        return stringBuffer.toString();
    }

    private void extractPLscope(Connection conn, Map<String, String> plscopeQueries, File applicationFile, File mergedFile) throws FileNotFoundException, IOException, SQLException, TransformerConfigurationException, TransformerException, Exception {
        PreparedStatement pstmt = null;
        String signaturesQueryPath = plscopeQueries.get("SIGNATURES");
        String callsQueryPath = plscopeQueries.get("CALLS");
        String plscopeQuery = this.getStringFromInputStream(PLDoc.getResourceStream(signaturesQueryPath));
        pstmt = conn.prepareStatement(plscopeQuery);
        ResultSet resultSet = pstmt.executeQuery();
        FileOutputStream outputStream = new FileOutputStream(new File(this.settings.getOutputDirectory(), "plscope_identifiers.xml"));
        this.resultSetToXml(resultSet, outputStream, "PLSCOPE", "IDENTIFIER", null);
        plscopeQuery = this.getStringFromInputStream(PLDoc.getResourceStream(callsQueryPath));
        pstmt = conn.prepareStatement(plscopeQuery);
        resultSet = pstmt.executeQuery();
        outputStream = new FileOutputStream(new File(this.settings.getOutputDirectory(), "plscope.xml"));
        this.resultSetToXml(resultSet, outputStream, "PLSCOPE", "CALL", null);
        File signatureFile = new File(this.settings.getOutputDirectory(), "application-signatures.xml");
        System.out.println("Merging PLDoc and PL/Scope XML files ...");
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("xslt/pldoc_merge_plscope_signatures.xslt")));
        transformer.setParameter("targetFolder", this.settings.getOutputDirectory().getAbsolutePath() + File.separator);
        transformer.setParameter("plscopeDocument", new File(this.settings.getOutputDirectory(), "plscope_identifiers.xml"));
        transformer.setParameter("pldocDocument", applicationFile);
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(signatureFile)));
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("xslt/pldoc_merge_plscope_calls.xslt")));
        transformer.setParameter("targetFolder", this.settings.getOutputDirectory().getAbsolutePath() + File.separator);
        transformer.setParameter("plscopeDocument", new File(this.settings.getOutputDirectory(), "plscope.xml"));
        transformer.setParameter("pldocDocument", signatureFile);
        transformer.transform(new StreamSource(signatureFile), new StreamResult(new FileOutputStream(mergedFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractSynonyms(Connection conn, String synonymsQuery, Map<String, Integer> objectSchemas, File synonymsFile) throws FileNotFoundException, IOException, SQLException, Exception {
        String documentRootName = "SYNONYMS";
        String rowElementName = "SYNONYM";
        PreparedStatement pstmt = null;
        OutputStream outputStream = null;
        try {
            pstmt = conn.prepareStatement(synonymsQuery);
            outputStream = new FileOutputStream(synonymsFile);
            XMLWriter xmlOut = new XMLWriter(outputStream);
            xmlOut.setMethod("xml");
            if (this.settings.getOutputEncoding() != null) {
                xmlOut.setEncoding(this.settings.getOutputEncoding());
            }
            xmlOut.setIndent(true);
            xmlOut.startDocument();
            xmlOut.startElement("SYNONYMS");
            for (String objectSchema : objectSchemas.keySet()) {
                pstmt.setString(1, objectSchema);
                ResultSet resultSet = pstmt.executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int numberOfColumns = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    for (int i = 1; i <= numberOfColumns; ++i) {
                        xmlOut.pushAttribute(resultSetMetaData.getColumnName(i), resultSet.getString(i));
                    }
                    xmlOut.startElement("SYNONYM");
                    xmlOut.endElement("SYNONYM");
                }
            }
            xmlOut.endElement("SYNONYMS");
            xmlOut.endDocument();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void generateHtml(File applicationFile, File synonymsFile) throws Exception {
        System.out.println("Generating HTML files ...");
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setURIResolver(resResolver);
        System.out.println("Generating allschemas.html ...");
        Transformer transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("allschemas.xsl")));
        transformer.setParameter("targetFolder", this.settings.getOutputDirectory().getAbsolutePath() + File.separator);
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(new File(this.settings.getOutputDirectory(), "allschemas.html"))));
        System.out.println("Generating summary.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("summary.xsl")));
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(this.settings.getOutputDirectory().getPath() + File.separator + "summary.html")));
        System.out.println("Generating generator.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("generator.xsl")));
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(this.settings.getOutputDirectory().getPath() + File.separator + "generator.html")));
        System.out.println("Generating deprecated-list.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("deprecated-list.xsl")));
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(this.settings.getOutputDirectory().getPath() + File.separator + "deprecated-list.html")));
        System.out.println("Generating index-list.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("index-list.xsl")));
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(this.settings.getOutputDirectory().getPath() + File.separator + "index-list.html")));
        System.out.println("Generating allpackages.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("allpackages.xsl")));
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(this.settings.getOutputDirectory().getPath() + File.separator + "allpackages.html")));
        System.out.println("Generating index.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("index.xsl")));
        transformer.transform(new StreamSource(applicationFile), new StreamResult(new FileOutputStream(this.settings.getOutputDirectory().getPath() + File.separator + "index.html")));
        System.out.println("Generating <unit>.html ...");
        transformer = tFactory.newTransformer(new StreamSource(resLoader.getResourceStream("unit.xsl")));
        transformer.setParameter("targetFolder", this.settings.getOutputDirectory().getAbsolutePath() + File.separator);
        if (this.settings.isSaveSourceCode()) {
            transformer.setParameter("sourceRootFolder", Character.valueOf('.'));
        }
        if (null != synonymsFile && synonymsFile.exists()) {
            transformer.setParameter("synonymsFile", synonymsFile.getCanonicalPath());
        } else {
            transformer.setParameter("synonymsFile", "");
        }
        transformer.transform(new StreamSource(applicationFile), new DOMResult());
    }

    private void copyStaticFiles(File outputDirectory) throws Exception {
        try {
            Utils.CopyStreamToFile(this.settings.getStylesheetFile(), new File(outputDirectory.getPath() + File.separator + "stylesheet.css"));
            Utils.CopyStreamToFile(resLoader.getResourceStream("application.dtd"), new File(outputDirectory.getPath() + File.separator + "application.dtd"));
            Utils.CopyStreamToFile(this.settings.getSourceStylesheetFile(), new File(outputDirectory.getPath() + File.separator + "sourcestylesheet.css"));
            Utils.CopyStreamToFile(resLoader.getResourceStream("sourcecode.xsl"), new File(outputDirectory.getPath() + File.separator + "sourcecode.xsl"));
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found. ");
            e.printStackTrace();
            throw e;
        }
    }

    private void collapseSimilarNodes(Document pDocument, String pNodeName, String[] pAttributeNames) {
        for (HashMap<String, String> values : this.findEqualNodesOnAttributes(pDocument, pNodeName, pAttributeNames)) {
            System.out.println("Collapsing all nodes of type <" + pNodeName + "> on attribute set " + values + ".");
            this.collapseNodes(pDocument, pNodeName, values);
        }
    }

    private void collapseNodes(Document pDocument, String pNodeName, Map<String, String> pAttributes) {
        Node supernode = null;
        LinkedList<Node> remove = new LinkedList<Node>();
        NodeList nl = pDocument.getElementsByTagName(pNodeName);
        for (int index = 0; index < nl.getLength(); ++index) {
            Node node = nl.item(index);
            if (!node.hasAttributes()) continue;
            NamedNodeMap attributes = node.getAttributes();
            HashMap<String, String> nodeAttributes = new HashMap<String, String>();
            for (String attributeName : pAttributes.keySet()) {
                Node attribute = attributes.getNamedItem(attributeName);
                if (attribute == null) continue;
                nodeAttributes.put(attributeName, attribute.getNodeValue());
            }
            if (!pAttributes.equals(nodeAttributes)) continue;
            if (supernode == null) {
                supernode = node;
                continue;
            }
            if (node.hasChildNodes()) {
                NodeList childs = node.getChildNodes();
                for (int index2 = 0; index2 < childs.getLength(); ++index2) {
                    Node child = childs.item(index2);
                    Node clone = child.cloneNode(true);
                    supernode.appendChild(clone);
                }
            }
            remove.add(node);
        }
        if (!remove.isEmpty()) {
            for (Node node : remove) {
                node.getParentNode().removeChild(node);
            }
        }
    }

    private List<HashMap<String, String>> findEqualNodesOnAttributes(Document pDocument, String pNodeName, String[] pAttributes) {
        HashSet found = new HashSet();
        HashSet result = new HashSet();
        NodeList nl = pDocument.getElementsByTagName(pNodeName);
        for (int index = 0; index < nl.getLength(); ++index) {
            Node node = nl.item(index);
            if (!node.hasAttributes()) continue;
            NamedNodeMap attributes = node.getAttributes();
            HashMap<String, String> nodeAttributes = new HashMap<String, String>();
            for (int a = 0; a < pAttributes.length; ++a) {
                Node attribute = attributes.getNamedItem(pAttributes[a]);
                if (attribute == null) continue;
                nodeAttributes.put(pAttributes[a], attribute.getNodeValue());
            }
            if (nodeAttributes == null) continue;
            if (found.contains(nodeAttributes)) {
                result.add(nodeAttributes);
                continue;
            }
            found.add(nodeAttributes);
        }
        return new ArrayList<HashMap<String, String>>(result);
    }

    static {
        hashMap.put("PACKAGE", "PACKAGE_SPEC");
        hashMap.put("TYPE", "TYPE_SPEC");
        hashMap.put("PACKAGE BODY", "PACKAGE_BODY");
        hashMap.put("TYPE BODY", "TYPE_BODY");
        hashMap.put("JAVA SOURCE", "JAVA_SOURCE");
        fileSuffixMap = new HashMap();
        fileSuffixMap.put("PROCEDURE", "prc");
        fileSuffixMap.put("FUNCTION", "fns");
        fileSuffixMap.put("TRIGGER", "trg");
        fileSuffixMap.put("PACKAGE", "pks");
        fileSuffixMap.put("TYPE", "tps");
        fileSuffixMap.put("PACKAGE BODY", "pkb");
        fileSuffixMap.put("TYPE BODY", "tpb");
        fileSuffixMap.put("JAVA SOURCE", "java");
        plscopeQueriesMap = new HashMap();
        plscopeQueriesMap.put("DEFAULT", new HashMap());
        plscopeQueriesMap.get("DEFAULT").put("SIGNATURES", "plscope/plscope_signatures.sql");
        plscopeQueriesMap.get("DEFAULT").put("CALLS", "plscope/plscope_call.sql");
        plscopeQueriesMap.put("ALL_", new HashMap());
        plscopeQueriesMap.get("ALL_").put("SIGNATURES", "plscope/plscope_signatures_all.sql");
        plscopeQueriesMap.get("ALL_").put("CALLS", "plscope/plscope_call_all.sql");
        resResolver = new ResourceResolver();
        resLoader = new ResourceLoader();
    }

    private static class SystemExitException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        SystemExitException() {
        }

        SystemExitException(Throwable t) {
            super(t);
        }
    }
}

