/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.mojo;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sourceforge.pldoc.ant.PLDocTask;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class PLDoc
extends AbstractMojo
implements MavenReport {
    private String applicationTitle;
    private String destDir;
    protected File outputDirectory;
    private File reportOutputDirectory;
    private File sourceDirectory;
    private String includes;
    private String inputEncoding = System.getProperty("file.encoding");
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String inputTypes;
    private String inputObjects;
    private boolean showSkippedPackages;
    private MavenProject project;
    private String name;
    private String description;

    public void execute() throws MojoExecutionException {
        try {
            Sink sink = null;
            Locale locale = Locale.getDefault();
            this.generate(sink, locale);
        }
        catch (MavenReportException ex) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", (Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", (Exception)ex);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.outputDirectory = this.getReportOutputDirectory();
        this.getLog().debug((CharSequence)("outputDirectory=" + this.outputDirectory));
        this.getLog().debug((CharSequence)("destDir=" + this.destDir));
        this.getLog().debug((CharSequence)("reportOutputDirectory=" + this.reportOutputDirectory));
        this.getLog().debug((CharSequence)("applicationTitle=" + this.applicationTitle));
        this.getLog().debug((CharSequence)("sourceDirectory=" + this.sourceDirectory));
        this.getLog().debug((CharSequence)("includes=" + this.includes));
        this.getLog().debug((CharSequence)("inputEncoding=" + this.inputEncoding));
        this.getLog().debug((CharSequence)("dbUrl=" + this.dbUrl));
        this.getLog().debug((CharSequence)("dbUser=" + this.dbUser));
        this.getLog().debug((CharSequence)("dbPassword=" + (null == this.dbPassword ? "undefined" : "defined")));
        this.getLog().debug((CharSequence)("inputObjects=" + this.inputObjects));
        this.getLog().debug((CharSequence)("inputTypes=" + this.inputTypes));
        this.getLog().debug((CharSequence)("showSkippedPackages=" + this.showSkippedPackages));
        try {
            if (!this.outputDirectory.exists()) {
                this.getLog().info((CharSequence)("Creating directory " + this.outputDirectory.toString()));
                this.outputDirectory.mkdirs();
            }
            PLDocTask task = new PLDocTask();
            task.init();
            task.setDestdir(this.outputDirectory);
            task.setDoctitle(this.applicationTitle);
            task.setDbUrl(this.dbUrl);
            task.setDbUser(this.dbUser);
            task.setDbPassword(this.dbPassword);
            task.setInputObjects(this.inputObjects);
            task.setInputTypes(this.inputTypes);
            task.setInputEncoding(this.inputEncoding);
            task.setShowSkippedPackages(this.showSkippedPackages);
            if (null != this.sourceDirectory && null != this.includes) {
                FileSet fset = new FileSet();
                fset.setDir(this.sourceDirectory);
                fset.setIncludes(this.includes);
                task.addFileset(fset);
            }
            Project proj = new Project();
            proj.setBaseDir(this.outputDirectory);
            proj.setName(this.applicationTitle);
            task.setProject(proj);
            task.execute();
        }
        catch (BuildException ex) {
            throw new MavenReportException("Failed generating pldoc report", (Exception)((Object)ex));
        }
        catch (RuntimeException ex) {
            throw new MavenReportException("Failed generating pldoc report", (Exception)ex);
        }
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.pldoc.name");
        }
        return this.name;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.pldoc.description");
        }
        return this.description;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.getLog().debug((CharSequence)("setDestDir: param destDir=" + destDir));
        this.getLog().debug((CharSequence)("setDestDir: outputDirectory=" + this.outputDirectory));
        this.getLog().debug((CharSequence)("setDestDir: destDir=" + this.destDir));
        this.getLog().debug((CharSequence)("setDestDir: reportOutputDirectory=" + this.reportOutputDirectory));
        this.updateReportOutputDirectory(this.reportOutputDirectory, destDir);
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: param reportOutputDirectory=" + reportOutputDirectory));
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: outputDirectory=" + this.outputDirectory));
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: destDir=" + this.destDir));
        this.getLog().debug((CharSequence)("setReportOutPutDirectory: reportOutputDirectory=" + this.reportOutputDirectory));
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
        this.getLog().debug((CharSequence)("updateReportOutPutDirectory: reportOutputDirectory=" + this.reportOutputDirectory));
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pldoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

