/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class BoolVal
extends SimpleReturnFunction {
    private final List<String> trueValues = Arrays.asList("true", "1");
    private final List<String> falseValues = Arrays.asList("false", "0");

    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%boolval", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        String s = values.get(0).toString().toLowerCase();
        if (this.trueValues.contains(s)) {
            return TValue.fromBoolean(true);
        }
        if (this.falseValues.contains(s)) {
            return TValue.fromBoolean(false);
        }
        throw new EaterException("Cannot convert " + s + " to boolean.", location);
    }
}

