// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */

package zext.plantuml.com.google.zxing;

import java.util.Hashtable;

/**
 * Enumerates barcode formats known to this package.
 *
 * @author Sean Owen
 */
public final class BarcodeFormat {
	// ::remove folder when __HAXE__
	// ::remove folder when __CORE__
	// ::remove folder when __MIT__ or __EPL__ or __BSD__ or __ASL__ or __LGPL__

	// No, we can't use an enum here. J2ME doesn't support it.

	private static final Hashtable VALUES = new Hashtable();

	/** QR Code 2D barcode format. */
	public static final BarcodeFormat QR_CODE = new BarcodeFormat("QR_CODE");

	/** Data Matrix 2D barcode format. */
	public static final BarcodeFormat DATA_MATRIX = new BarcodeFormat("DATA_MATRIX");

	/** UPC-E 1D format. */
	public static final BarcodeFormat UPC_E = new BarcodeFormat("UPC_E");

	/** UPC-A 1D format. */
	public static final BarcodeFormat UPC_A = new BarcodeFormat("UPC_A");

	/** EAN-8 1D format. */
	public static final BarcodeFormat EAN_8 = new BarcodeFormat("EAN_8");

	/** EAN-13 1D format. */
	public static final BarcodeFormat EAN_13 = new BarcodeFormat("EAN_13");

	/** UPC/EAN extension format. Not a stand-alone format. */
	public static final BarcodeFormat UPC_EAN_EXTENSION = new BarcodeFormat("UPC_EAN_EXTENSION");

	/** Code 128 1D format. */
	public static final BarcodeFormat CODE_128 = new BarcodeFormat("CODE_128");

	/** Code 39 1D format. */
	public static final BarcodeFormat CODE_39 = new BarcodeFormat("CODE_39");

	/** Code 93 1D format. */
	public static final BarcodeFormat CODE_93 = new BarcodeFormat("CODE_93");

	/** CODABAR 1D format. */
	public static final BarcodeFormat CODABAR = new BarcodeFormat("CODABAR");

	/** ITF (Interleaved Two of Five) 1D format. */
	public static final BarcodeFormat ITF = new BarcodeFormat("ITF");

	/** RSS 14 */
	public static final BarcodeFormat RSS14 = new BarcodeFormat("RSS14");

	/** PDF417 format. */
	public static final BarcodeFormat PDF417 = new BarcodeFormat("PDF417");

	/** RSS EXPANDED */
	public static final BarcodeFormat RSS_EXPANDED = new BarcodeFormat("RSS_EXPANDED");

	private final String name;

	private BarcodeFormat(String name) {
		this.name = name;
		VALUES.put(name, this);
	}

	public String getName() {
		return name;
	}

	public String toString() {
		return name;
	}

	public static BarcodeFormat valueOf(String name) {
		if (name == null || name.length() == 0) {
			throw new IllegalArgumentException();
		}
		BarcodeFormat format = (BarcodeFormat) VALUES.get(name);
		if (format == null) {
			throw new IllegalArgumentException();
		}
		return format;
	}

}
