// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.xmi;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Element;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.klimt.creole.Display;

public class XmiDescriptionDiagramScript extends XmiDescriptionDiagramAbstract {

	public XmiDescriptionDiagramScript(DescriptionDiagram diagram) throws ParserConfigurationException {
		super(diagram);
	}

	@Override
	protected void addLink(Link link) {
		if (link.isHidden() || link.isInvis())
			return;
		if (!link.getType().getStyle().isNormal()) {
			// this is some kind of dashed line, which means it is a dependency
			Element dependency = createDependency(link);
			ownedElement.appendChild(dependency);
			return;
		}

		final String assId = "ass" + diagram.getUniqueSequence("");

		UMLAggregationKind aggregation = UMLAggregationKind.None;
		if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
			aggregation = UMLAggregationKind.Composite;
		}
		if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
			aggregation = UMLAggregationKind.Composite;
		}
		if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
			aggregation = UMLAggregationKind.Aggregation;
		}
		if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
			aggregation = UMLAggregationKind.Aggregation;
		}

		final Element association = document.createElement("UML:Association");
		association.setAttribute("xmi.id", assId);
		// association.setAttribute("namespace",
		// CucaDiagramXmiMaker.getModel(classDiagram));
		if (Display.isNull(link.getLabel()) == false)
			association.setAttribute("name", forXMI(link.getLabel()));

		final Element connection = document.createElement("UML:Association.connection");
		final Element end1 = createAssociationEnd(assId, link.getType().getDecor2(), link.getQuantifier1(),
				link.getEntity1(), aggregation);

		connection.appendChild(end1);
		final Element end2 = createAssociationEnd(assId, link.getType().getDecor1(), link.getQuantifier2(),
				link.getEntity2(), aggregation);
		connection.appendChild(end2);

		association.appendChild(connection);

		ownedElement.appendChild(association);
	}

	private Element createAssociationEnd(final String assId, final LinkDecor decor, final String quantifier,
			Entity entity, UMLAggregationKind aggregation) {
		final Element end = document.createElement("UML:AssociationEnd");
		end.setAttribute("xmi.id", "end" + diagram.getUniqueSequence(""));
		end.setAttribute("association", assId);

//		end1.setAttribute("type", link.getEntity1().getUid());
		if (quantifier != null)
			end.setAttribute("name", forXMI(quantifier));
		// TODO this is the multiplicity, handle that correctly

		end.setAttribute("participant", entity.getUid());

		if (aggregation != UMLAggregationKind.None)
			end.setAttribute("aggregation", aggregation.name);

		boolean navigable = decor != LinkDecor.NOT_NAVIGABLE && decor != LinkDecor.NONE;
		end.setAttribute("isNavigable", Boolean.toString(navigable));

		return end;
	}


	private Element createDependency(Link link) {
		// determine kind and direction
		if (link.isInverted()) {
			return createDependencyClientSupplier(link.getEntity2(), link.getEntity1());
		} else {
			return createDependencyClientSupplier(link.getEntity1(), link.getEntity2());
		}
	}

	private Element createRef(Entity entity) {
		Element ref = document.createElement("UML:Component");
		ref.setAttribute("xmi.idref", entity.getUid());
		return ref;

	}

	private Element createDependencyClientSupplier(Entity clientEntity, Entity supplierEntity) {
		String depID = diagram.getUniqueSequence("dep");
		Element dependency = document.createElement("UML:Dependency");
		dependency.setAttribute("xmi.id", depID);
		Element client = document.createElement("UML:Dependency.client");
		Element supplier = document.createElement("UML:Dependency.supplier");
		Element clientRef = createRef(clientEntity);
		if (clientRef != null)
			client.appendChild(clientRef);
		Element supplierRef = createRef(supplierEntity);
		if (supplierRef != null)
			supplier.appendChild(supplierRef);
		dependency.appendChild(client);
		dependency.appendChild(supplier);
		return dependency;
	}


}
