// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.TreeMap;

import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class Blotter implements UDrawable {

	private final XDimension2D dim;
	private final HColor defaultBackcolor;
	private final double round;
	private HColor last;
	private final SortedMap<Double, HColor> changes = new TreeMap<>();

	public Blotter(XDimension2D dim, HColor defaultBackcolor, double round) {
		if (defaultBackcolor == null)
			defaultBackcolor = HColors.transparent();
		this.round = round;
		this.dim = dim;
		this.defaultBackcolor = defaultBackcolor;
		this.last = defaultBackcolor;
	}

	@Override
	public String toString() {
		return "" + dim + " " + defaultBackcolor;
	}

	@Override
	public void drawU(UGraphic ug) {
		HColor current = defaultBackcolor;
		double y = 0;
		int i = 0;
		for (Entry<Double, HColor> ent : changes.entrySet()) {
			if (current.isTransparent() == false) {
				final UShape rect = getRectangleBackground(i, ent.getKey() - y);
				ug.apply(current).apply(current.bg()).apply(UTranslate.dy(y)).draw(rect);
			}
			y = ent.getKey();
			current = ent.getValue();
			i++;
		}
	}

	private UShape getRectangleBackground(int i, double height) {
		final double width = dim.getWidth();
		if (round == 0)
			return URectangle.build(width, height);

		if (changes.size() == 1)
			return URectangle.build(width, height).rounded(round);

		if (i == 0) {
			final UPath result = UPath.none();
			result.moveTo(round / 2, 0);
			result.lineTo(width - round / 2, 0);
			result.arcTo(round / 2, round / 2, 0, 0, 1, width, round / 2);
			result.lineTo(width, height);
			result.lineTo(0, height);
			result.lineTo(0, round / 2);
			result.arcTo(round / 2, round / 2, 0, 0, 1, round / 2, 0);
			result.closePath();
			return result;
		}
		if (i == changes.size() - 1) {
			final UPath result = UPath.none();
			result.moveTo(0, 0);
			result.lineTo(width, 0);
			result.lineTo(width, height - round / 2);
			result.arcTo(round / 2, round / 2, 0, 0, 1, width - round / 2, height);
			result.lineTo(round / 2, height);
			result.arcTo(round / 2, round / 2, 0, 0, 1, 0, height - round / 2);
			result.lineTo(0, 0);
			result.closePath();
			return result;

		}
		return URectangle.build(width, height);
	}

	public void closeChanges() {
		changes.put(dim.getHeight(), defaultBackcolor);
	}

	public void addChange(double ypos, HColor color) {
		if (color == null)
			color = HColors.transparent();
		if (color.equals(last))
			return;
		changes.put(ypos, color);
		last = color;
	}

}
