// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.klimt.creole;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class Sea {

	private double currentX;
	private final Map<Atom, Position> positions = new LinkedHashMap<Atom, Position>();
	private final StringBounder stringBounder;

	public Sea(StringBounder stringBounder) {
		this.stringBounder = Objects.requireNonNull(stringBounder);
	}

	public void add(Atom atom) {
		final XDimension2D dim = atom.calculateDimension(stringBounder);
		final double y = 0;
		final Position position = new Position(currentX, y, dim);
		positions.put(atom, position);
		currentX += dim.getWidth();
	}

	public Position getPosition(Atom atom) {
		return positions.get(atom);
	}

	public void doAlign() {
		for (Map.Entry<Atom, Position> ent : new HashMap<Atom, Position>(positions).entrySet()) {
			final Position pos = ent.getValue();
			final Atom atom = ent.getKey();
			final double height = atom.calculateDimension(stringBounder).getHeight();
			final Position newPos = pos.translateY(-height + atom.getStartingAltitude(stringBounder));
			positions.put(atom, newPos);
		}
	}

	public void translateMinYto(double newValue) {
		final double delta = newValue - getMinY();
		for (Map.Entry<Atom, Position> ent : new HashMap<Atom, Position>(positions).entrySet()) {
			final Position pos = ent.getValue();
			final Atom atom = ent.getKey();
			positions.put(atom, pos.translateY(delta));
		}
	}

	private AtomText findFirstAtomText() {
		for (Atom atom : positions.keySet()) {
			if (atom instanceof AtomText) {
				AtomText atomText = (AtomText) atom;
				String text = atomText.getText();
				if (text.trim().isEmpty()) {
					continue;
				}
				return (AtomText) atom;
			}
		}
		return null;
	}

	public void doAlignTikz() {
		// #1628, make non-text vertical center with text
		AtomText firstTextAtom = findFirstAtomText();
		if (firstTextAtom == null) {
			return;
		}
		Position firstTextPosition = positions.get(firstTextAtom);
		double firstTextHeight = firstTextAtom.getFontHeight(stringBounder);
		for (Map.Entry<Atom, Position> entry : new LinkedHashMap<>(positions).entrySet()) {
			final Atom atom = entry.getKey();
			if (atom instanceof AtomText) {
				continue;
			}
			Position position = entry.getValue();
			double targetY = firstTextPosition.getMinY() - (position.getHeight() - firstTextHeight) / 2;
			double delta = targetY - position.getMinY();
			if (delta != 0.0) {
				positions.put(atom, position.translateY(delta));
			}
		}
	}

	public void doAlignTikzBaseline() {
		// #1606, make text the same baseline
		AtomText firstTextAtom = findFirstAtomText();
		if (firstTextAtom == null) {
			return;
		}
		double firstTextHeight = firstTextAtom.getFontHeight(stringBounder);
		for (Map.Entry<Atom, Position> entry : new LinkedHashMap<>(positions).entrySet()) {
			final Atom atom = entry.getKey();
			if (!(atom instanceof AtomText)) {
				continue;
			}
			double delta = firstTextHeight - ((AtomText) atom).getFontHeight(stringBounder);
			if (delta != 0.0) {
				positions.put(atom, entry.getValue().translateY(delta));
			}
		}
	}

	public void exportAllPositions(Map<Atom, Position> destination) {
		destination.putAll(positions);
	}

	public double getMinY() {
		if (positions.size() == 0) {
			throw new IllegalStateException();
		}
		double result = Double.MAX_VALUE;
		for (Position pos : positions.values()) {
			if (result > pos.getMinY()) {
				result = pos.getMinY();
			}
		}
		return result;
	}

	public double getMaxY() {
		if (positions.size() == 0) {
			throw new IllegalStateException();
		}
		Atom atom = null;
		double result = -Double.MAX_VALUE;
		for (Map.Entry<Atom, Position> entry : positions.entrySet()) {
			Position pos = entry.getValue();
			if (result < pos.getMaxY()) {
				atom = entry.getKey();
				result = pos.getMaxY();
			}
		}
		if (!stringBounder.matchesProperty("TIKZ")) {
			return result;
		}
		// For TKIZ, make sure the strip has at least 1pt
		if (atom instanceof AtomText) {
			// the delta in AtomText should be larger than 1 already
			AtomText atomText = (AtomText) atom;
			UFont font = atomText.getFontConfiguration().getFont();
			String text = atomText.getText();
			double height = stringBounder.calculateDimension(font, text).getHeight();
			double delta = result - height;
			return result + Math.max(1 - delta, 0);
		} else {
			return result + 1;
		}
	}

	public double getHeight() {
		return getMaxY() - getMinY();
	}

	public MinMax update(MinMax minMax) {
		for (Position position : positions.values()) {
			minMax = position.update(minMax);
		}
		return minMax;
	}

	public final double getWidth() {
		return currentX;
	}

}
