// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;

public class TextSkin extends Rose {

	private final FileFormat fileFormat;

	public TextSkin(FileFormat fileFormat) {
		this.fileFormat = fileFormat;
	}

	@Override
	public ArrowComponent createComponentArrow(Style[] styles, ArrowConfiguration config, ISkinParam param,
			Display stringsToDisplay) {
		if (config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL
				|| config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE
				|| config.getArrowDirection() == ArrowDirection.BOTH_DIRECTION)
			return new ComponentTextArrow(ComponentType.ARROW, config, stringsToDisplay, fileFormat,
					param.maxAsciiMessageLength());

		if (config.isSelfArrow())
			return new ComponentTextSelfArrow(ComponentType.ARROW, config, stringsToDisplay, fileFormat);

		throw new UnsupportedOperationException();
	}

	@Override
	public Component createComponentNote(Style[] styles, ComponentType type, ISkinParam param, Display stringsToDisplay,
			Colors colors, NotePosition notePosition) {
		if (type == ComponentType.NOTE || type == ComponentType.NOTE_BOX || type == ComponentType.NOTE_HEXAGONAL)
			return new ComponentTextNote(type, stringsToDisplay, fileFormat);

		throw new UnsupportedOperationException(type.toString());
	}

	@Override
	public Component createComponentNote(Style[] styles, ComponentType type, ISkinParam param, Display stringsToDisplay,
			Colors colors) {
		return createComponentNote(styles, type, param, stringsToDisplay, colors, null);
	}

	@Override
	public Component createComponent(Style style[], ComponentType type, ArrowConfiguration config, ISkinParam param,
			Display stringsToDisplay) {
		if (type == ComponentType.ACTOR_HEAD || type == ComponentType.ACTOR_TAIL)
			return new ComponentTextActor(type, stringsToDisplay, fileFormat,
					fileFormat == FileFormat.UTXT ? AsciiShape.STICKMAN_UNICODE : AsciiShape.STICKMAN);

		if (type == ComponentType.BOUNDARY_HEAD || type == ComponentType.BOUNDARY_TAIL)
			return new ComponentTextShape(type, stringsToDisplay, AsciiShape.BOUNDARY);

		if (type == ComponentType.DATABASE_HEAD || type == ComponentType.DATABASE_TAIL)
			return new ComponentTextShape(type, stringsToDisplay, AsciiShape.DATABASE);

		if (type.name().endsWith("_HEAD") || type.name().endsWith("_TAIL"))
			return new ComponentTextParticipant(type, stringsToDisplay, fileFormat);

		if (type.isArrow() && (config.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL
				|| config.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE
				|| config.getArrowDirection() == ArrowDirection.BOTH_DIRECTION))
			return new ComponentTextArrow(type, config, stringsToDisplay, fileFormat, param.maxAsciiMessageLength());

		if (type.isArrow() && config.isSelfArrow())
			return new ComponentTextSelfArrow(type, config, stringsToDisplay, fileFormat);

		if (type == ComponentType.PARTICIPANT_LINE)
			return new ComponentTextLine(type, fileFormat);

		if (type == ComponentType.CONTINUE_LINE)
			return new ComponentTextLine(type, fileFormat);

		if (type == ComponentType.DELAY_LINE)
			return new ComponentTextLine(type, fileFormat);

		if (type == ComponentType.ALIVE_BOX_CLOSE_CLOSE)
			return new ComponentTextActiveLine(fileFormat);

		if (type == ComponentType.ALIVE_BOX_CLOSE_OPEN)
			return new ComponentTextActiveLine(fileFormat);

		if (type == ComponentType.ALIVE_BOX_OPEN_CLOSE)
			return new ComponentTextActiveLine(fileFormat);

		if (type == ComponentType.ALIVE_BOX_OPEN_OPEN)
			return new ComponentTextActiveLine(fileFormat);

		if (type == ComponentType.DIVIDER)
			return new ComponentTextDivider(type, stringsToDisplay, fileFormat);

		if (type == ComponentType.GROUPING_HEADER_LEGACY || type == ComponentType.GROUPING_HEADER_TEOZ)
			return new ComponentTextGroupingHeader(type, stringsToDisplay, fileFormat);

		if (type == ComponentType.GROUPING_SPACE)
			return new ComponentRoseGroupingSpace(1);

		if (type == ComponentType.GROUPING_ELSE_LEGACY || type == ComponentType.GROUPING_ELSE_TEOZ)
			return new ComponentTextGroupingElse(type, stringsToDisplay, fileFormat);

		if (type == ComponentType.DELAY_TEXT)
			return new ComponentTextDelay(type, stringsToDisplay, fileFormat);

		if (type == ComponentType.DESTROY)
			return new ComponentTextDestroy();

		if (type == ComponentType.REFERENCE)
			return new ComponentTextReference(stringsToDisplay, fileFormat);

		throw new UnsupportedOperationException(type.toString());
	}

	@Override
	public Component createComponentNewPage(ISkinParam param) {
		return new ComponentTextNewpage(fileFormat);
	}

}
