// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.argon2.model;

import static net.sourceforge.plantuml.argon2.Constants.ARGON2_BLOCK_SIZE;
import static net.sourceforge.plantuml.argon2.Constants.ARGON2_QWORDS_IN_BLOCK;

import java.util.Arrays;

import net.sourceforge.plantuml.argon2.Util;

public class Block {
    // ::remove folder when __HAXE__

	/* 128 * 8 Byte QWords */
	public long[] v;

	public Block() {
		v = new long[ARGON2_QWORDS_IN_BLOCK];
	}

	public void fromBytes(byte[] input) {
		assert (input.length == ARGON2_BLOCK_SIZE);

		for (int i = 0; i < v.length; i++) {
			byte[] slice = Arrays.copyOfRange(input, i * 8, (i + 1) * 8);
			v[i] = Util.littleEndianBytesToLong(slice);
		}
	}

	public byte[] toBytes() {
		byte[] result = new byte[ARGON2_BLOCK_SIZE];

		for (int i = 0; i < v.length; i++) {
			byte[] bytes = Util.longToLittleEndianBytes(v[i]);
			System.arraycopy(bytes, 0, result, i * bytes.length, bytes.length);
		}

		return result;
	}

	public void copyBlock(Block other) {
		System.arraycopy(other.v, 0, v, 0, v.length);
	}

	public void xor(Block b1, Block b2) {
		for (int i = 0; i < v.length; i++) {
			v[i] = b1.v[i] ^ b2.v[i];
		}
	}

	public void xor(Block b1, Block b2, Block b3) {
		for (int i = 0; i < v.length; i++) {
			v[i] = b1.v[i] ^ b2.v[i] ^ b3.v[i];
		}
	}

	public void xorWith(Block other) {
		for (int i = 0; i < v.length; i++) {
			v[i] = v[i] ^ other.v[i];
		}
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		for (long value : v) {
			result.append(Util.bytesToHexString(Util.longToLittleEndianBytes(value)));
		}

		return result.toString();
	}

	void clear() {
		Arrays.fill(v, 0);
	}
}
