// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileDecorateWelding;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileAssembly;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileEmpty;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;

public class InstructionList extends WithNote implements Instruction, InstructionCollection {

	private final List<Instruction> all = new ArrayList<>();
	private final Swimlane defaultSwimlane;

	@Override
	public boolean containsBreak() {
		for (Instruction ins : all)
			if (ins.containsBreak())
				return true;

		return false;
	}

	public static InstructionList empty() {
		return new InstructionList(null);
	}

	public InstructionList(Swimlane defaultSwimlane) {
		this.defaultSwimlane = defaultSwimlane;
	}

	public boolean isEmpty() {
		return all.isEmpty();
	}

	public boolean isOnlySingleStopOrSpot() {
		if (all.size() != 1)
			return false;

		if (getLast() instanceof InstructionSpot)
			return true;

		if (getLast() instanceof InstructionStop)
			return ((InstructionStop) getLast()).hasNotes() == false;

		if (getLast() instanceof InstructionEnd)
			return ((InstructionEnd) getLast()).hasNotes() == false;

		return false;
	}

	@Override
	public CommandExecutionResult add(Instruction ins) {
		all.add(ins);
		return CommandExecutionResult.ok();
	}

	// ::comment when __CORE__
	@Override
	public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
		if (all.size() == 0)
			return new GtileEmpty(stringBounder, skinParam, defaultSwimlane);

		Gtile result = null;
		for (Instruction ins : all) {
			final Gtile cur = ins.createGtile(skinParam, stringBounder);

			if (result == null)
				result = cur;
			else
				result = new GtileAssembly(result, cur, ins.getInLinkRendering());

		}
		return result;
	}

	@Override
	public Ftile createFtile(FtileFactory factory) {
		if (all.size() == 0) {
			Ftile result = new FtileEmpty(factory.skinParam(), defaultSwimlane);
			// Not a typo, in that case, we decide to decorate the entry link.
			if (outlinkRendering != null)
				result = factory.decorateIn(result, outlinkRendering);
			return result;
		}

		final List<WeldingPoint> breaks = new ArrayList<>();
		Ftile result = eventuallyAddNote(factory, null, getSwimlaneIn(), VerticalAlignment.CENTER);
		for (Instruction ins : all) {
			Ftile cur = ins.createFtile(factory);
			breaks.addAll(cur.getWeldingPoints());
			if (ins.getInLinkRendering().isNone() == false)
				cur = factory.decorateIn(cur, ins.getInLinkRendering());

			if (result == null)
				result = cur;
			else
				result = factory.assembly(result, cur);
		}

		if (outlinkRendering != null)
			result = factory.decorateOut(result, outlinkRendering);

		if (breaks.size() > 0)
			result = new FtileDecorateWelding(result, breaks);

		return result;
	}

	@Override
	final public boolean kill() {
		if (all.size() == 0)
			return false;

		return getLast().kill();
	}

	@Override
	public LinkRendering getInLinkRendering() {
		return all.iterator().next().getInLinkRendering();
	}

	@Override
	public Instruction getLast() {
		if (all.size() == 0)
			return null;

		return all.get(all.size() - 1);
	}

	@Override
	public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote, Stereotype stereotype) {
		if (getLast() == null)
			return super.addNote(note, position, type, colors, swimlaneNote, stereotype);

		return getLast().addNote(note, position, type, colors, swimlaneNote, stereotype);
	}

	@Override
	public Set<Swimlane> getSwimlanes() {
		return getSwimlanes2(all);
	}

	@Override
	public Swimlane getSwimlaneIn() {
		return defaultSwimlane;
	}

	@Override
	public Swimlane getSwimlaneOut() {
		final Set<Swimlane> swimlanes = getSwimlanes();
		if (swimlanes.size() == 0)
			return null;

		if (swimlanes.size() == 1)
			return swimlanes.iterator().next();

		return getLast().getSwimlaneOut();
	}

	public static Set<Swimlane> getSwimlanes2(List<? extends Instruction> list) {
		final Set<Swimlane> result = new HashSet<>();
		for (Instruction ins : list)
			result.addAll(ins.getSwimlanes());

		return Collections.unmodifiableSet(result);
	}

	private LinkRendering outlinkRendering;

	public void setOutRendering(LinkRendering outlinkRendering) {
		this.outlinkRendering = outlinkRendering;
	}

}
