// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class LatexManager implements AutoCloseable {

	private final Process process;
	private final PrintWriter writer;
	private final BufferedReader reader;

	private static final String TEMPLATE_PREFIX = "{\\sbox0{";
	private static final String TEMPLATE_SUFFIX = "}\\typeout{\\the\\wd0,\\the\\ht0,\\the\\dp0}}";
	private static final Pattern PATTERN = Pattern.compile("\\*?[\\d.]+pt,[\\d.]+pt,[\\d.]+pt");
	private final LruCache lruCache = new LruCache(128);

	public LatexManager(String system, String preamble) {
		String command = (system != null && !system.isEmpty()) ? system : "xelatex";
		if (!command.endsWith("latex")) {
			throw new IllegalArgumentException("command " + command + " is unsupported");
		}
		try {
			File tempDir = Files.createTempDirectory("plantuml-latex-").toFile();
			tempDir.deleteOnExit();
			this.process = new ProcessBuilder(command, "-halt-on-error")
							.directory(tempDir)
							.start();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		this.writer = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream()), true);
		this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
		this.writer.println("\\documentclass[tikz]{standalone}\n" +
						"\\usepackage{amsmath}\n" +
						((preamble != null && !preamble.isEmpty()) ? preamble + "\n" : "") +
						"\\begin{document}\n" +
						"\\typeout{latex_query_start}");
		String output = expect("*latex_query_start", null);
		if (!output.trim().endsWith("*latex_query_start")) {
			throw new IllegalArgumentException(command + " fail, message: " + output + System.lineSeparator()
							+ "please install " + command + ", and package `amsmath`, `tikz`");
		}
	}

	private String expect(String s, String end) {
		StringBuilder sb = new StringBuilder();
		while (true) {
			String line;
			try {
				line = this.reader.readLine();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
			if (line == null) {
				break;
			}
			sb.append(line);
			sb.append(System.lineSeparator());
			if ((end == null && line.startsWith(s)) || (end != null && line.endsWith(end))) {
				break;
			}
		}
		return sb.toString();
	}

	public double[] getWidthHeightDepth(String s) {
		double[] value = this.lruCache.get(s);
		if (value == null) {
			value = doGetWidthHeightDepth(s);
			this.lruCache.put(s, value);
		}
		return value;
	}

	protected double[] doGetWidthHeightDepth(String s) {
		this.writer.println(TEMPLATE_PREFIX + s + TEMPLATE_SUFFIX);
		String output = this.expect("*", "pt");
		String line = output.trim();
		int index = line.lastIndexOf(System.lineSeparator());
		if (index > 0) {
			line = line.substring(index + 1);
		}
		if (!PATTERN.matcher(line).matches()) {
			System.err.println("[error] cannot get width, height, depth, text: " + s + ", message: " + output.trim());
			throw new IllegalArgumentException("cannot get width, height, depth, text: " + s + ", message: " + output.trim());
		}
		if (!line.startsWith("*")) {
			System.err.println("[warning] cannot get width, height, depth, text: " + s + ", message: " + output.trim());
		}
		String[] pts = line.replace("*", "").split(",", 3);
		double width = Double.parseDouble(pts[0].replace("pt", ""));
		double height = Double.parseDouble(pts[1].replace("pt", ""));
		double depth = Double.parseDouble(pts[2].replace("pt", ""));
		return new double[] {width, height, depth};
	}

	public static String protectText(String text) {
		final String tempBackslash = "\uFFFF";
		return text.replace("\\", tempBackslash)
				.replace("#", "\\#")
				.replace("$", "\\$")
				.replace("%", "\\%")
				.replace("&", "\\&")
				.replace("_", "\\_")
				.replace("{", "\\{")
				.replace("}", "\\}")
				.replace("^", "\\^{}")
				.replace("~", "\\~{}")
				.replace("\u00AB", "\\guillemotleft{}")
				.replace("\u00BB", "\\guillemotright{}")
				.replace("\t", "~~~~~~~~") // #1016
				.replaceAll("^\\s+|\\s+$", "~")
				.replace(tempBackslash, "\\textbackslash{}");
	}

	@Override
	public void close() {
		this.process.destroy();
	}

	private static class LruCache extends LinkedHashMap<String, double[]> {

		private final int maxSize;

		public LruCache(int maxSize) {
			super(maxSize + 1, 1.0F, true);
			this.maxSize = maxSize;
		}

		@Override
		protected boolean removeEldestEntry(Map.Entry<String, double[]> eldest) {
			return this.size() >= this.maxSize;
		}

	}

}
