// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.graphic;

import java.awt.Color;

import jcckit.util.ConfigParameters;

/**
 *  Basic attributes for shapes.
 *
 *  @author Franz-Josef Elmer
 */
public class ShapeAttributes implements LineAttributes, FillAttributes {
  /** Configuration parameter key. */
  public static final String FILL_COLOR_KEY = "fillColor",
                             LINE_COLOR_KEY = "lineColor",
                             LINE_THICKNESS_KEY = "lineThickness",
                             LINE_PATTERN_KEY = "linePattern";

  private final Color _fillColor;
  private final Color _lineColor;
  private final double _lineThickness;
  private final double[] _linePattern;

  /**
   * Creates a new instance based on the specified configuration
   * parameters.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>fillColor = <i>no filling</i></tt></td><td><tt>Color</tt></td>
   *     <td>no</td><td>The fill color of the shape.</td></tr>
   * <tr><td><tt>lineColor = <i>no line</i></tt></td><td><tt>Color</tt></td>
   *     <td>no</td><td>The color of a line, a polygon, or the border of a shape.</td></tr>
   * <tr><td><tt>lineThickness = 0</tt></td><td><tt>double</tt></td>
   *     <td>no</td>
   *     <td>The thickness of a line. A thickness of zero means that
   *     the renderer will draw the thinest line possible.</td></tr>
   * <tr><td><tt>linePattern = </tt><i>solid line</i></td>
   *     <td><tt>double[]</tt></td><td>no</td>
   *     <td>A sequence of lengths where the pen is alternatively
   *     down or up. For example, <tt>0.1 0.1</tt> will lead to a dashed
   *     line whereas <tt>0.02 0.02</tt> is the pattern of a dotted
   *     line and <tt>0.02 0.02 0.1 0.02</tt> of a dashed-dotted
   *     line.</td></tr>
   * </table>
   */
  public ShapeAttributes(ConfigParameters config) {
    this(config.getColor(FILL_COLOR_KEY, null),
         config.getColor(LINE_COLOR_KEY, null),
         config.getDouble(LINE_THICKNESS_KEY, 0),
         config.getDoubleArray(LINE_PATTERN_KEY, null));
  }

  /**
   * Creates a new instance.
   * @param fillColor The fill color. May be <tt>null</tt>.
   * @param lineColor The line color. May be <tt>null</tt>.
   * @param lineThickness Thickness of the line.
   *        Negative numbers will be trimmed to zero.
   * @param linePattern Line pattern. May be <tt>null</tt>.
   */
  public ShapeAttributes(Color fillColor, Color lineColor,
                         double lineThickness, double[] linePattern) {
    _fillColor = fillColor;
    _lineColor = lineColor;
    _lineThickness = Math.max(0, lineThickness);
    _linePattern = linePattern;
  }

  public Color getFillColor() {
    return _fillColor;
  }

  public Color getLineColor() {
    return _lineColor;
  }

  public double getLineThickness() {
    return _lineThickness;
  }

  public double[] getLinePattern() {
    return _linePattern;
  }
}

