// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package gen.lib.cgraph;
import static gen.lib.cgraph.edge__c.agopp;
import static gen.lib.cgraph.obj__c.agraphof;
import static gen.lib.cgraph.refstr__c.agstrdup;
import static smetana.core.JUtils.strcmp;
import static smetana.core.Macro.AGDATA;
import static smetana.core.Macro.AGINEDGE;
import static smetana.core.Macro.AGNODE;
import static smetana.core.Macro.AGOUTEDGE;
import static smetana.core.Macro.AGRAPH;
import static smetana.core.debug.SmetanaDebug.ENTERING;
import static smetana.core.debug.SmetanaDebug.LEAVING;

import gen.annotation.Original;
import gen.annotation.Reviewed;
import h.ST_Agedge_s;
import h.ST_Agobj_s;
import h.ST_Agraph_s;
import h.ST_Agrec_s;
import h.ST_Agtag_s;
import smetana.core.CString;
import smetana.core.Globals;
import smetana.core.__ptr__;
import smetana.core.size_t;

public class rec__c {


@Original(version="2.38.0", path="lib/cgraph/rec.c", name="set_data", key="62z9z5vraa2as0c9t108j9xaf", definition = "static void set_data(Agobj_t * obj, Agrec_t * data, int mtflock)")
@Reviewed(when = "10/11/2020")
public static void set_data(ST_Agobj_s obj, ST_Agrec_s data, int mtflock) {
ENTERING("62z9z5vraa2as0c9t108j9xaf","set_data");
try {
    ST_Agedge_s e;
    obj.data = data;
    (obj.tag).mtflock = mtflock;
    if ((obj.tag.objtype == AGINEDGE) || (obj.tag.objtype == AGOUTEDGE)) {
	e = (ST_Agedge_s) agopp(obj);
	AGDATA(e, data);
	(e.base.tag).mtflock = mtflock;
    }
} finally {
LEAVING("62z9z5vraa2as0c9t108j9xaf","set_data");
}
}




@Original(version="2.38.0", path="lib/cgraph/rec.c", name="aggetrec", key="7p2ne3oknmyclvsw4lh3axtd8", definition = "Agrec_t *aggetrec(void *obj, char *name, int mtf)")
@Reviewed(when = "10/11/2020")
public static ST_Agrec_s aggetrec(__ptr__ obj, CString name, boolean mtf) {
ENTERING("7p2ne3oknmyclvsw4lh3axtd8","aggetrec");
try {
    ST_Agobj_s hdr;
    ST_Agrec_s d, first;
    hdr = (ST_Agobj_s) obj;
    first = d = (ST_Agrec_s) hdr.data;
    while (d!=null) {
	if (strcmp(name,d.name) == 0)
	    break;
	d = (ST_Agrec_s) d.next;
	if (d == first) {
	    d = null;
	    break;
	}
    }
    if (d!=null) {
	if (((ST_Agtag_s)hdr.tag).mtflock!=0) {
	    if (mtf && (hdr.data != d))
		System.err.println("move to front lock inconsistency");
	} else {
	    if ((d != first) || (mtf != ((((ST_Agtag_s)hdr.tag).mtflock)!=0)))
		set_data(hdr, d, mtf ? 1 : 0);	/* Always optimize */
	}
    }
    return d;
} finally {
LEAVING("7p2ne3oknmyclvsw4lh3axtd8","aggetrec");
}
}




@Original(version="2.38.0", path="lib/cgraph/rec.c", name="objputrec", key="7sk4k5ipm2jnd244556g1kr6", definition = "static void objputrec(Agraph_t * g, Agobj_t * obj, void *arg)")
@Reviewed(when = "10/11/2020")
private static void objputrec(ST_Agraph_s g, ST_Agobj_s obj, ST_Agrec_s arg) {
ENTERING("7sk4k5ipm2jnd244556g1kr6","objputrec");
try {
	ST_Agrec_s firstrec, newrec;
    newrec = arg;
    firstrec = obj.data;
    if (firstrec == null)
	newrec.next = newrec;	/* 0 elts */
    else {
	if (firstrec.next == firstrec) {
	    firstrec.next = newrec;	/* 1 elt */
	    newrec.next = firstrec;
	} else {
	    newrec.next = firstrec.next;
	    firstrec.next = newrec;
	}
    }
    if (((ST_Agtag_s)obj.tag).mtflock == 0)
	set_data(obj, newrec, (0));
} finally {
LEAVING("7sk4k5ipm2jnd244556g1kr6","objputrec");
}
}




@Original(version="2.38.0", path="lib/cgraph/rec.c", name="agbindrec", key="dmh5i83l15mnn1pnu6f5dfv8l", definition = "void *agbindrec(void *arg_obj, char *recname, unsigned int recsize, int mtf)")
@Reviewed(when = "10/11/2020")
public static __ptr__ agbindrec(Globals zz, __ptr__ arg_obj, CString recname, size_t recsize, boolean mtf) {
ENTERING("dmh5i83l15mnn1pnu6f5dfv8l","agbindrec");
try {
    ST_Agraph_s g;
    ST_Agobj_s obj;
    ST_Agrec_s rec;
    obj = (ST_Agobj_s) arg_obj;
    g = agraphof(obj);
    rec = aggetrec(obj, recname, false);
    if ((rec == null && recsize.isStrictPositive())) {
    rec = (ST_Agrec_s) ((__ptr__)recsize.malloc());
	// rec = (ST_Agrec_s) ((__ptr__)agalloc(g, recsize)).castTo(ST_Agrec_s.class);
    // rec = (Agrec_s) Memory.malloc(Agrec_s.class);
	rec.name = agstrdup(zz, g, recname);
	switch (((ST_Agtag_s)obj.tag).objtype) {
	case AGRAPH:
	    objputrec(g, obj, rec);
	    break;
	case AGNODE:
	    objputrec(g, obj, rec);
	    break;
	case AGINEDGE:
	case AGOUTEDGE:
	    objputrec(g, obj, rec);
	    break;
	}
    }
    if (mtf)
	aggetrec(arg_obj, recname, (true));
    return rec;
} finally {
LEAVING("dmh5i83l15mnn1pnu6f5dfv8l","agbindrec");
}
}


}
