/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cheneer.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.cheneer.ChenEerDiagram;
import net.sourceforge.plantuml.cheneer.command.CommandCreateEntity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateAttribute
extends SingleLineCommand2<ChenEerDiagram> {
    public CommandCreateAttribute() {
        super(CommandCreateAttribute.getRegexConcat());
    }

    protected static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateEntity.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("DISPLAY", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("CODE", "([%pLN%s_.:]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(<<.*>>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COMPOSITE", "(\\{)?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChenEerDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Entity owner = diagram.peekOwner();
        if (owner == null) {
            return CommandExecutionResult.error("Attribute must be inside an entity, relationship or another attribute");
        }
        LeafType type = LeafType.CHEN_ATTRIBUTE;
        String idShort = diagram.cleanId(arg.get("CODE", 0).trim());
        String id = owner.getName() + "/" + idShort;
        Quark<Entity> quark = diagram.quarkInContext(true, id);
        String displayText = arg.get("DISPLAY", 0);
        if (displayText == null) {
            displayText = idShort;
        }
        String stereo = arg.get("STEREO", 0);
        boolean composite = arg.get("COMPOSITE", 0) != null;
        Entity entity = quark.getData();
        if (entity != null) {
            return CommandExecutionResult.error("Attribute already exists");
        }
        Display display = Display.getWithNewlines(displayText);
        entity = diagram.reallyCreateLeaf(quark, display, type, null);
        if (stereo != null) {
            entity.setStereotype(Stereotype.build(stereo));
            entity.setStereostyle(stereo);
        }
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        Link link = new Link(diagram, diagram.getCurrentStyleBuilder(), entity, owner, linkType, LinkArg.build(Display.NULL, 2));
        diagram.addLink(link);
        if (composite) {
            diagram.pushOwner(entity);
        }
        return CommandExecutionResult.ok();
    }
}

