// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.util;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Cuts a string in words separated by white space. Quotes and square
 * brackets are recognized (that is, white space within is ignored).
 *
 * <p>&copy; 2002 Christian Treber, ct@ctreber.com
 * @author Christian Treber, ct@ctreber.com
 *
 */
public class StringParser
{
  public static List parse(String pLine)
  {
    final List lSections = new ArrayList();

    // True if within word.
    boolean lInSectionP = false;
    // Current char
    char lChar;
    // Wait for this character before switching back to normal parsing.
    char lSeparator = ' ';
    // Part count.
    int lSectionNo = 0;
    // Part start position
    int lSectionStart = 0;
    // Part end position
    int lSectionEnd = 0;

    final int lLen = pLine.length();
    for(int lCharNo = 0; lCharNo <= lLen; lCharNo++)
    {
      if(lCharNo < lLen)
      {
        lChar = pLine.charAt(lCharNo);
      } else
      {
        // This is a fictional last character.
        lChar = ' ';
      }

      if(lInSectionP)
      {
        // In section. Termination is by space or specific separator.
        if((lChar != ' ') || (lSeparator != ' '))
        {
          // It's not a space, or it is a space, but we wait for a special separator.
          if(lChar == lSeparator)
          {
            // We waited for this separator. Switch back to normal parsing.
            lSeparator = ' ';
            lSectionEnd = lCharNo - 1;
          } else
          {
            lSectionEnd = lCharNo;
          }
        } else
        {
          // Section has ended (with a space).
          lSections.add(pLine.substring(lSectionStart, lSectionEnd + 1));
          lSectionNo++;
          lInSectionP = false;
        }
      } else
      {
        // Not in a section, skipping white space.
        if(lChar != ' ')
        {
          // No white space: a section has started.
          if(lChar == '"')
          {
            // Special parsing "string"
            lSeparator = '"';
            lSectionStart = lCharNo + 1;
          } else if(lChar == '[')
          {
            // Special parsing "square brackets"
            lSeparator = ']';
            lSectionStart = lCharNo + 1;
          } else
          {
            // Use normal parsing.
            lSeparator = ' ';
            lSectionEnd = lSectionStart = lCharNo;
          }
          lInSectionP = true;
        } else
        {
          // More void...
        }
      }
    }

    return lSections;
  }
}
