// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.scanbit;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import zext.plantuml.com.ctreber.acearth.projection.Projection;
import zext.plantuml.com.ctreber.acearth.util.EdgeCrossing;
import zext.plantuml.com.ctreber.acearth.util.Point2D;
import zext.plantuml.com.ctreber.acearth.util.Point3D;
import zext.plantuml.com.ctreber.acearth.util.Polygon;
import zext.plantuml.com.ctreber.aclib.sort.CTSort;
import zext.plantuml.com.ctreber.aclib.sort.QuickSort;

/**
 * <p>
 * A BitGeneratorMap scans a map into ScanBits.
 * 
 * <p>
 * &copy; 2002 Christian Treber, ct@ctreber.com
 * 
 * @author Christian Treber, ct@ctreber.com
 * 
 */
public abstract class BitGeneratorMap extends ScanBitGenerator {
	// Types of pixels.
	public static final int PixTypeSpace = 0;
	public static final int PixTypeLand = 1;
	public static final int PixTypeWater = 2;
	public static final int PixTypeStar = 3;
	public static final int PixTypeGridLand = 4;
	public static final int PixTypeGridWater = 5;

	// Parameters influencing generateScanBits buffer genertion.
	private Polygon[] fMapData;
	Projection fProjection;
	private List fScanbitsVector = new ArrayList();
	// Created by scanPolygon
	List fEdgeCrossings;

	abstract protected ScanBuf scanOutline();

	abstract protected void handleCrossings(ScanBuf pScanBuf, EdgeCrossing[] pEdgeCrossings);

	abstract protected Comparator getEdgeXingComparator();

	abstract protected void scanPolygon(ScanBuf pScanBuf, Point3D[] pPoints3D, Point2D[] pPoints2D, int pIndex);

	public BitGeneratorMap(Projection pProjection) {
		fProjection = pProjection;
	}

	/**
	 * <p>
	 * Create outline for the map, scan all polygons.
	 */
	public void generateScanBits() {
		// Prepare data.
		fScanbitsVector = new ArrayList();
		fProjection.setImageWidth(fImageWidth);
		fProjection.setImageHeight(fImageHeight);
		fProjection.initTransformTable();

		// Trace outling and polygons.
		final ScanBuf lScanBuf = scanOutline();
		fScanbitsVector.addAll(lScanBuf.getScanbits(64));
		scanPolygons();

		// Dress results.
		final CTSort lSort = new QuickSort();
		fScanBitsArray = (ScanBit[]) fScanbitsVector.toArray(new ScanBit[0]);
		lSort.sort(fScanBitsArray);
	}

	private void scanPolygons() {
		for (int lPolyNo = 0; lPolyNo < fMapData.length; lPolyNo++) {
			Polygon lPolygon = fMapData[lPolyNo];

			Point3D[] lPoints3D = new Point3D[lPolygon.getSize()];
			Point2D[] lPoints2D = new Point2D[lPolygon.getSize()];
			transformPolygonPoints(lPolygon, lPoints3D, lPoints2D);

			// For all points in polygon...
			fEdgeCrossings = new ArrayList();
			ScanBuf lScanBuf = new ScanBuf(fImageHeight, fImageWidth);
			for (int i = 0; i < lPoints2D.length; i++) {
				scanPolygon(lScanBuf, lPoints3D, lPoints2D, i);
			}

			if (fEdgeCrossings.size() > 0) {
				// Edge crossings have been generated, deal with them.
				final EdgeCrossing[] xings = (EdgeCrossing[]) fEdgeCrossings.toArray(new EdgeCrossing[0]);
				final CTSort lSort = new QuickSort();
				lSort.sort(xings, getEdgeXingComparator());
				handleCrossings(lScanBuf, xings);
			}

			if (lScanBuf.containsPoints()) {
				// Scan lines have been generated, transform them into ScanBit.
				fScanbitsVector.addAll(lScanBuf.getScanbits(lPolygon.getType()));
			}
		}
	}

	/**
	 * The transformation rotates 3D and projects 2D points from it
	 */
	private void transformPolygonPoints(Polygon pPolygon, Point3D[] pPoints3D, Point2D[] pPoints2D) {
		for (int i = 0; i < pPolygon.getPoints().length; i++) {
			Point3D lPoint = pPolygon.getPoints()[i];

			Point3D lPointRotated = fProjection.rotate(lPoint);
			pPoints3D[i] = lPointRotated;
			pPoints2D[i] = fProjection.project2D(lPointRotated);
		}
	}

	public void setMapData(Polygon[] pMapData) {
		fMapData = pMapData;
	}

	protected void addEdgeXing(EdgeCrossing pEdgeXing) {
		fEdgeCrossings.add(pEdgeXing);
	}
}
