// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import zext.plantuml.com.ctreber.acearth.util.Point3D;
import zext.plantuml.com.ctreber.acearth.util.Polygon;

/**
 * The map data file is a big array of short (16-bit) ints, as follows: - it is
 * a sequence of closed curves - the first value in a curve is the number of
 * points in the curve - the second value in a curve indicates land/water (1 or
 * -1, respectively) - this is followed by an [x,y,z] triple that indicates a
 * point on the unit sphere (each of x, y, and z has been scaled by 30000),
 * where the x axis points "to the right" (towards 0 N 90 E), the y axis points
 * "up" (towards the north pole), and the z axis points "out of the screen"
 * (towards 0 N 0 E). this is the starting point of the curve. - this is
 * followed by (one less than the number of points in the curve) triples
 * [dx,dy,dz]; the [x,y,z] triple for each successive point in the curve is
 * obtained by adding [dx,dy,dz] onto the previous [x,y,z] values. - the curves
 * are [must be!] non-self-intersecting and traced in a counter-clockwise
 * direction
 *
 * the curves are sampled at a (roughly) a 20 mile resolution.
 *
 * <p>
 * &copy; 2002 Christian Treber, ct@ctreber.com
 *
 * @author Christian Treber, ct@ctreber.com
 *
 */
public class MapDataReader {
	/** Point value scale (devide value by this number). */
	private static final double MAP_DATA_SCALE = 30000.0;

	private static List fData;
	private static List fPolygons;
	private static int fIndex;

	/**
	 * <p>
	 * Read map data.
	 *
	 * @return Array of map polygons.
	 * @throws IOException
	 */
	public static Polygon[] readMapData() throws IOException {
		final List lines = new MapData().getLines();

		fData = new ArrayList();
		for (Iterator it = lines.iterator(); it.hasNext(); ) {
			String lLine = (String) it.next();
			if (lLine.contains("/*")) {
				// Filter out comments.
				continue;
			}

			StringTokenizer lST = new StringTokenizer(lLine, ", ");
			while (lST.hasMoreTokens()) {
				String lToken = lST.nextToken();
				final Integer lValue = Integer.valueOf(lToken);
				fData.add(lValue);
			}
		}

		fPolygons = new ArrayList();
		fIndex = 0;
		while (getValue(fIndex) != 0) {
			processCurve();
		}

		return (Polygon[]) fPolygons.toArray(new Polygon[0]);
	}

	private static void processCurve() {
		final int lNPoint = getValue(fIndex++);
		final int lType = getValue(fIndex++);

		final Point3D[] lPoints = new Point3D[lNPoint];
		final Point3D lPoint3D = new Point3D(getValue(fIndex++) / MAP_DATA_SCALE, getValue(fIndex++) / MAP_DATA_SCALE,
				getValue(fIndex++) / MAP_DATA_SCALE);

		lPoints[0] = lPoint3D;
		for (int i = 1; i < lNPoint; i++) {
			lPoints[i] = new Point3D(lPoints[i - 1].getX() + getValue(fIndex++) / MAP_DATA_SCALE, lPoints[i - 1].getY()
					+ getValue(fIndex++) / MAP_DATA_SCALE, lPoints[i - 1].getZ() + getValue(fIndex++) / MAP_DATA_SCALE);
		}

		final Polygon lPolygon = new Polygon(lType, lPoints);
		fPolygons.add(lPolygon);
	}

	/**
	 * <p>
	 * Get value of raw data at specified point.
	 *
	 * @param pIndex
	 *            Index of value.
	 * @return Value of raw data at specified point.
	 */
	private static int getValue(int pIndex) {
		return ((Integer) fData.get(pIndex)).intValue();
	}

}
