// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;

import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.utils.Log;

public class TMemoryLocal extends ExecutionContexts implements TMemory {

	private final TMemoryGlobal memoryGlobal;
	private TrieImpl overridenVariables00;
	private final Map<String, TValue> overridenVariables01 = new HashMap<String, TValue>();
	private final TrieImpl localVariables00 = new TrieImpl();
	private final Map<String, TValue> localVariables01 = new HashMap<String, TValue>();

	public TMemoryLocal(TMemoryGlobal global, Map<String, TValue> input) {
		this.memoryGlobal = global;
		this.overridenVariables01.putAll(input);
	}

	public void dumpDebug(String message) {
		Log.error("[MemLocal] Start of memory_dump " + message);
		memoryGlobal.dumpMemoryInternal();
		final TreeMap<String, TValue> over = new TreeMap<String, TValue>(overridenVariables01);
		Log.error("[MemLocal] Number of overriden variable(s) : " + over.size());
		for (Entry<String, TValue> ent : over.entrySet()) {
			final String name = ent.getKey();
			final TValue value = ent.getValue();
			Log.error("[MemLocal] " + name + " = " + value);
		}
		final TreeMap<String, TValue> local = new TreeMap<String, TValue>(localVariables01);
		Log.error("[MemLocal] Number of local variable(s) : " + local.size());
		for (Entry<String, TValue> ent : local.entrySet()) {
			final String name = ent.getKey();
			final TValue value = ent.getValue();
			Log.error("[MemLocal] " + name + " = " + value);
		}
		Log.error("[MemGlobal] End of memory_dump");
	}

	@Override
	public void putVariable(String varname, TValue value, TVariableScope scope, StringLocated location)
			throws EaterException {
		if (scope == TVariableScope.GLOBAL) {
			memoryGlobal.putVariable(varname, value, scope, location);
			return;
		}
		if (scope == TVariableScope.LOCAL || overridenVariables01.containsKey(varname)) {
			this.overridenVariables01.put(varname, value);
			if (this.overridenVariables00 != null)
				this.overridenVariables00.add(varname);

			Log.info("[MemLocal/overrriden] Setting " + varname);
		} else if (memoryGlobal.getVariable(varname) != null) {
			memoryGlobal.putVariable(varname, value, scope, location);
		} else {
			this.localVariables01.put(varname, value);
			this.localVariables00.add(varname);
			Log.info("[MemLocal/local] Setting " + varname);
		}
	}

	@Override
	public void removeVariable(String varname) {
		if (overridenVariables01.containsKey(varname)) {
			this.overridenVariables01.remove(varname);
			if (this.overridenVariables00 != null)
				this.overridenVariables00.remove(varname);

		} else if (memoryGlobal.getVariable(varname) != null) {
			memoryGlobal.removeVariable(varname);
		} else {
			this.localVariables01.remove(varname);
			this.localVariables00.remove(varname);
		}
	}

	@Override
	public TValue getVariable(String varname) {
		TValue result = overridenVariables01.get(varname);
		if (result != null)
			return result;

		result = memoryGlobal.getVariable(varname);
		if (result != null)
			return result;

		result = localVariables01.get(varname);
		return result;
	}

	@Override
	public Trie variablesNames3() {
		if (overridenVariables00 == null) {
			overridenVariables00 = new TrieImpl();
			for (String name : overridenVariables01.keySet())
				overridenVariables00.add(name);

		}
		return new Trie() {
			public void add(String s) {
				throw new UnsupportedOperationException();
			}

			public String getLonguestMatchStartingIn(String s, int pos) {
				final String s1 = memoryGlobal.variablesNames3().getLonguestMatchStartingIn(s, pos);
				final String s2 = overridenVariables00.getLonguestMatchStartingIn(s, pos);
				final String s3 = localVariables00.getLonguestMatchStartingIn(s, pos);

				if (s1.length() >= s2.length() && s1.length() >= s3.length())
					return s1;

				if (s2.length() >= s3.length() && s2.length() >= s1.length())
					return s2;

				return s3;
			}
		};
		// final Trie result = new TrieImpl();
		// for (String name : overridenVariables.keySet()) {
		// result.add(name);
		// }
		// for (String name : memoryGlobal.variablesNames()) {
		// result.add(name);
		// }
		// for (String name : localVariables.keySet()) {
		// result.add(name);
		// }
		// return result;
	}

	@Override
	public boolean isEmpty() {
		return memoryGlobal.isEmpty() && localVariables01.isEmpty() && overridenVariables01.isEmpty();
	}

	@Override
	public Set<String> variablesNames() {
		throw new UnsupportedOperationException();
	}

	@Override
	public TMemory forkFromGlobal(Map<String, TValue> input) {
		return new TMemoryLocal(memoryGlobal, input);
	}

	// public final TMemoryGlobal getGlobalForInternalUseOnly() {
	// return memoryGlobal;
	// }

}
