// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.svek;

import java.util.Collection;

import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.decoration.symbol.USymbolInterface;
import net.sourceforge.plantuml.descdiagram.EntityImageDesignedDomain;
import net.sourceforge.plantuml.descdiagram.EntityImageDomain;
import net.sourceforge.plantuml.descdiagram.EntityImageMachine;
import net.sourceforge.plantuml.descdiagram.EntityImageRequirement;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.dot.Neighborhood;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.svek.image.EntityImageActivity;
import net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.image.EntityImageBranch;
import net.sourceforge.plantuml.svek.image.EntityImageChenAttribute;
import net.sourceforge.plantuml.svek.image.EntityImageChenCircle;
import net.sourceforge.plantuml.svek.image.EntityImageChenEntity;
import net.sourceforge.plantuml.svek.image.EntityImageChenRelationship;
import net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageDeepHistory;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage;
import net.sourceforge.plantuml.svek.image.EntityImageGroup;
import net.sourceforge.plantuml.svek.image.EntityImageJson;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterfaceEye1;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterfaceEye2;
import net.sourceforge.plantuml.svek.image.EntityImageMap;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageObject;
import net.sourceforge.plantuml.svek.image.EntityImagePort;
import net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageState2;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.image.EntityImageTips;
import net.sourceforge.plantuml.svek.image.EntityImageUseCase;
import net.sourceforge.plantuml.text.Guillemet;

public final class GeneralImageBuilder {

	public static IEntityImage createEntityImageBlock(Entity leaf, ISkinParam skinParam,
			boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon,
			GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> links) {
		final IEntityImage result = createEntityImageBlockInternal(leaf, skinParam, isHideEmptyDescriptionForState,
				portionShower, bibliotekon, graphvizVersion, umlDiagramType, links);
		// System.err.println("leaf " + leaf + " " + result.getClass());
		return result;
	}

	private static IEntityImage createEntityImageBlockInternal(Entity leaf, ISkinParam skinParam,
			boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon,
			GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> links) {
		if (leaf.isRemoved())
			throw new IllegalStateException();

		if (leaf.getLeafType().isLikeClass()) {
			final EntityImageClass entityImageClass = new EntityImageClass((Entity) leaf, skinParam, portionShower);
			final Neighborhood neighborhood = leaf.getNeighborhood();
			if (neighborhood != null)
				return new EntityImageProtected(entityImageClass, 20, neighborhood, bibliotekon);

			return entityImageClass;
		}
		if (leaf.getLeafType() == LeafType.NOTE)
			return new EntityImageNote(leaf, skinParam, umlDiagramType);

		if (leaf.getLeafType() == LeafType.ACTIVITY)
			return new EntityImageActivity(leaf, skinParam, bibliotekon);

		if (/* (leaf.getLeafType() == LeafType.PORT) || */leaf.getLeafType() == LeafType.PORTIN
				|| leaf.getLeafType() == LeafType.PORTOUT) {
			final Cluster parent = bibliotekon.getCluster(leaf.getParentContainer());
			return new EntityImagePort(leaf, skinParam, parent, bibliotekon, umlDiagramType.getStyleName());
		}

		if (leaf.getLeafType() == LeafType.STATE) {
			if (leaf.getEntityPosition() != EntityPosition.NORMAL) {
				final Cluster stateParent = bibliotekon.getCluster(leaf.getParentContainer());
				return new EntityImageStateBorder(leaf, skinParam, stateParent, bibliotekon,
						umlDiagramType.getStyleName());
			}
			if (isHideEmptyDescriptionForState && leaf.getBodier().getRawBody().size() == 0)
				return new EntityImageStateEmptyDescription(leaf, skinParam);

			if (leaf.getStereotype() != null
					&& "<<sdlreceive>>".equals(leaf.getStereotype().getLabel(Guillemet.DOUBLE_COMPARATOR)))
				return new EntityImageState2(leaf, skinParam, umlDiagramType.getStyleName());

			return new EntityImageState(leaf, skinParam);

		}
		if (leaf.getLeafType() == LeafType.CIRCLE_START)
			return new EntityImageCircleStart(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.CIRCLE_END)
			return new EntityImageCircleEnd(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.BRANCH || leaf.getLeafType() == LeafType.STATE_CHOICE)
			return new EntityImageBranch(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.LOLLIPOP_FULL || leaf.getLeafType() == LeafType.LOLLIPOP_HALF)
			return new EntityImageLollipopInterface(leaf, skinParam, umlDiagramType.getStyleName());

		if (leaf.getLeafType() == LeafType.CIRCLE)
			return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(),
					bibliotekon);

		if (leaf.getLeafType() == LeafType.DESCRIPTION) {
			if (OptionFlags.USE_INTERFACE_EYE1 && leaf.getUSymbol() instanceof USymbolInterface) {
				return new EntityImageLollipopInterfaceEye1(leaf, skinParam, bibliotekon);
			} else if (OptionFlags.USE_INTERFACE_EYE2 && leaf.getUSymbol() instanceof USymbolInterface) {
				return new EntityImageLollipopInterfaceEye2(leaf, skinParam, portionShower);
			} else {
				return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(),
						bibliotekon);
			}
		}
		if (leaf.getLeafType() == LeafType.USECASE)
			return new EntityImageUseCase(leaf, skinParam, portionShower);

		if (leaf.getLeafType() == LeafType.USECASE_BUSINESS)
			return new EntityImageUseCase(leaf, skinParam, portionShower);

		// if (leaf.getEntityType() == LeafType.CIRCLE_INTERFACE) {
		// return new EntityImageCircleInterface(leaf, skinParam);
		// }
		if (leaf.getLeafType() == LeafType.OBJECT)
			return new EntityImageObject(leaf, skinParam, portionShower);

		if (leaf.getLeafType() == LeafType.MAP)
			return new EntityImageMap(leaf, skinParam, portionShower);

		if (leaf.getLeafType() == LeafType.JSON)
			return new EntityImageJson(leaf, skinParam, portionShower);

		if (leaf.getLeafType() == LeafType.SYNCHRO_BAR || leaf.getLeafType() == LeafType.STATE_FORK_JOIN)
			return new EntityImageSynchroBar(leaf, skinParam, umlDiagramType.getStyleName());

		if (leaf.getLeafType() == LeafType.ARC_CIRCLE)
			return new EntityImageArcCircle(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.POINT_FOR_ASSOCIATION)
			return new EntityImageAssociationPoint(leaf, skinParam);

		if (leaf.isGroup())
			return new EntityImageGroup(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.EMPTY_PACKAGE) {
			if (leaf.getUSymbol() != null)
				return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(),
						bibliotekon);

			return new EntityImageEmptyPackage(leaf, skinParam, portionShower, umlDiagramType.getStyleName());
		}
		if (leaf.getLeafType() == LeafType.ASSOCIATION)
			return new EntityImageAssociation(leaf, skinParam, umlDiagramType.getStyleName());

		if (leaf.getLeafType() == LeafType.PSEUDO_STATE)
			return new EntityImagePseudoState(leaf, skinParam, umlDiagramType.getStyleName());

		if (leaf.getLeafType() == LeafType.DEEP_HISTORY)
			return new EntityImageDeepHistory(leaf, skinParam, umlDiagramType.getStyleName());

		if (leaf.getLeafType() == LeafType.TIPS)
			return new EntityImageTips(leaf, skinParam, bibliotekon, umlDiagramType);

		if (leaf.getLeafType() == LeafType.CHEN_ENTITY)
			return new EntityImageChenEntity(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.CHEN_RELATIONSHIP)
			return new EntityImageChenRelationship(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.CHEN_ATTRIBUTE)
			return new EntityImageChenAttribute(leaf, skinParam);

		if (leaf.getLeafType() == LeafType.CHEN_CIRCLE)
			return new EntityImageChenCircle(leaf, skinParam);

		// TODO Clean
		if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null
				&& leaf.getStereotype().isMachineOrSpecification())
			return new EntityImageMachine(leaf, skinParam);
		else if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null
				&& leaf.getStereotype().isDesignedOrSolved())
			return new EntityImageDesignedDomain(leaf, skinParam);
		else if (leaf.getLeafType() == LeafType.REQUIREMENT)
			return new EntityImageRequirement(leaf, skinParam);
		else if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null
				&& leaf.getStereotype().isLexicalOrGiven())
			return new EntityImageDomain(leaf, skinParam, 'X');
		else if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null
				&& leaf.getStereotype().isCausal())
			return new EntityImageDomain(leaf, skinParam, 'C');
		else if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null
				&& leaf.getStereotype().isBiddableOrUncertain())
			return new EntityImageDomain(leaf, skinParam, 'B');
		else if (leaf.getLeafType() == LeafType.DOMAIN)
			return new EntityImageDomain(leaf, skinParam, 'P');
		else
			throw new UnsupportedOperationException(leaf.getLeafType().toString());
	}

	public static UStroke getForcedStroke(Stereotype stereotype, ISkinParam skinParam) {
		UStroke stroke = skinParam.getThickness(LineParam.packageBorder, stereotype);
		if (stroke == null)
			stroke = UStroke.withThickness(1.5);

		return stroke;
	}

}
